/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.ivt.EarnTypeEnum;
import com.kingdee.eas.fm.ivt.FinancingAccountApplyFactory;
import com.kingdee.eas.fm.ivt.FinancingAccountApplyInfo;
import com.kingdee.eas.fm.ivt.FinancingAccountCollection;
import com.kingdee.eas.fm.ivt.FinancingAccountException;
import com.kingdee.eas.fm.ivt.FinancingAccountFactory;
import com.kingdee.eas.fm.ivt.FinancingAccountInfo;
import com.kingdee.eas.fm.ivt.FinancingStateEnum;
import com.kingdee.eas.fm.ivt.IFinancingAccount;
import com.kingdee.eas.fm.ivt.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.ivt.client.AbstractFinancingAccountEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class FinancingAccountEditUI
extends AbstractFinancingAccountEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FinancingAccountEditUI.class);
    private IContextHelper contextHelp = ContextHelperFactory.getRemoteInstance();
    private boolean isCopy = false;
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    protected static final String IVT_RES = "com.kingdee.eas.fm.ivt.IVTFINANCINGResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FinancingAccountFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionAuditResult.setVisible(false);
        this.btnAuditResult.setVisible(false);
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.actionDelVoucher.setVisible(false);
            this.actionVoucher.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionRemove.setVisible(false);
            this.actionViewBdgBalance.setVisible(false);
            this.actionAttachment.setVisible(false);
            this.actionAuditResult.setVisible(false);
            this.actionAddNew.setVisible(false);
            this.actionCopy.setVisible(false);
        }
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        this.handleInfo((FinancingAccountInfo)dataObject);
        super.setDataObject(dataObject);
    }

    private void handleInfo(FinancingAccountInfo dataObject) {
        String oprtState = this.getOprtState();
        if ("ADDNEW".equals(oprtState)) {
            dataObject.setCompany(this.currentCompany);
            dataObject.setCreator(this.contextHelp.getCurrentUser());
            dataObject.setBizDate(new Date());
        }
        if (dataObject.getId() != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("state");
            sic.add("company.*");
            sic.add("creator.*");
            try {
                FinancingAccountInfo finfo = FinancingAccountFactory.getRemoteInstance().getFinancingAccountInfo((IObjectPK)new ObjectUuidPK(dataObject.getId().toString()), sic);
                dataObject.setState(finfo.getState());
                dataObject.setCompany(finfo.getCompany());
                dataObject.setCreator(finfo.getCreator());
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        try {
            if (dataObject.getSourceBillId() != null) {
                FinancingAccountApplyInfo applyInfo = FinancingAccountApplyFactory.getRemoteInstance().getFinancingAccountApplyInfo((IObjectPK)new ObjectUuidPK(dataObject.getSourceBillId().toString()));
                dataObject.setIntRateTypeExpression(applyInfo.getIntRateTypeExpression());
                dataObject.setBalance(applyInfo.getFinanceAmount());
                dataObject.setDays(applyInfo.getDays());
                dataObject.setIsNoOut(applyInfo.isIsNoOut());
                dataObject.setPredictWinLocAmount(applyInfo.getPredictWinLocAmount());
                dataObject.setFinanceLocAmount(applyInfo.getFinanceLocAmount());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void initUIProp() throws Exception {
        super.initUIProp();
        FMClientHelper.initCurrency((KDComboBox)this.cboCurrency);
        this.txtSaleSize.setHorizontalAlignment(4);
        this.txtSaleSize.setPrecision(2);
        this.txtSaleSize.setRemoveingZeroInDispaly(false);
        this.txtSaleSize.setMinimumValue((Comparable)new BigDecimal("0.0"));
        this.txtSaleSize.setRequired(false);
        this.txtFinanceAmount.setHorizontalAlignment(4);
        this.txtFinanceAmount.setPrecision(2);
        this.txtFinanceAmount.setRemoveingZeroInDispaly(false);
        this.txtFinanceAmount.setMinimumValue((Comparable)new BigDecimal("0.0"));
        this.txtbalance.setHorizontalAlignment(4);
        this.txtbalance.setPrecision(2);
        this.txtbalance.setRemoveingZeroInDispaly(false);
        this.txtbalance.setMinimumValue((Comparable)new BigDecimal("0.0"));
        this.txtPredictWinAmount.setHorizontalAlignment(4);
        this.txtPredictWinAmount.setPrecision(2);
        this.txtPredictWinAmount.setRemoveingZeroInDispaly(false);
        this.txtPredictWinAmount.setMinimumValue((Comparable)new BigDecimal("0.0"));
        this.txtpredictWinLocAmount.setHorizontalAlignment(4);
        this.txtpredictWinLocAmount.setPrecision(2);
        this.txtpredictWinLocAmount.setRemoveingZeroInDispaly(false);
        this.txtpredictWinLocAmount.setMinimumValue((Comparable)new BigDecimal("0.0"));
        this.txtpracticalWinLocAmount.setHorizontalAlignment(4);
        this.txtpracticalWinLocAmount.setPrecision(2);
        this.txtpracticalWinLocAmount.setRemoveingZeroInDispaly(false);
        this.txtpracticalWinAmount.setHorizontalAlignment(4);
        this.txtpracticalWinAmount.setPrecision(2);
        this.txtpracticalWinAmount.setRemoveingZeroInDispaly(false);
        this.txtTerm.setHorizontalAlignment(4);
        this.txtfinanceLocAmount.setHorizontalAlignment(4);
        this.txtfinanceLocAmount.setRemoveingZeroInDispaly(false);
        this.txtExchangeRate.setDataType(1);
        this.txtExchangeRate.setRemoveingZeroInDispaly(false);
        this.txtPredictYield.setHorizontalAlignment(4);
        F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtBank);
        this.txtExchangeRate.setMinimumValue((Comparable)new BigDecimal("0.0"));
        this.initF7Bank();
        this.initF7AccountBank();
        FMClientHelper.initSpComponents((KDComboBox)this.cboCurrency, (KDFormattedTextField)this.txtbalance, (KDFormattedTextField)this.txtExchangeRate, null, (CurrencyInfo)this.baseCurrency, (KDDatePicker)this.pkBizDate, (CompanyOrgUnitInfo)this.currentCompany);
        FMClientHelper.initSpComponents((KDComboBox)this.cboCurrency, (KDFormattedTextField)this.txtFinanceAmount, (KDFormattedTextField)this.txtExchangeRate, null, (CurrencyInfo)this.baseCurrency, (KDDatePicker)this.pkBizDate, (CompanyOrgUnitInfo)this.currentCompany);
        FMClientHelper.initSpComponents((KDComboBox)this.cboCurrency, (KDFormattedTextField)this.txtSaleSize, (KDFormattedTextField)this.txtExchangeRate, null, (CurrencyInfo)this.baseCurrency, (KDDatePicker)this.pkBizDate, (CompanyOrgUnitInfo)this.currentCompany);
        FMClientHelper.initSpComponents((KDComboBox)this.cboCurrency, (KDFormattedTextField)this.txtPredictWinAmount, (KDFormattedTextField)this.txtExchangeRate, null, (CurrencyInfo)this.baseCurrency, (KDDatePicker)this.pkBizDate, (CompanyOrgUnitInfo)this.currentCompany);
        FMClientHelper.initSpComponents((KDComboBox)this.cboCurrency, (KDFormattedTextField)this.txtpredictWinLocAmount, (KDFormattedTextField)this.txtExchangeRate, null, (CurrencyInfo)this.baseCurrency, (KDDatePicker)this.pkBizDate, (CompanyOrgUnitInfo)this.currentCompany);
        FMClientHelper.initSpComponents((KDComboBox)this.cboCurrency, (KDFormattedTextField)this.txtfinanceLocAmount, (KDFormattedTextField)this.txtExchangeRate, null, (CurrencyInfo)this.baseCurrency, (KDDatePicker)this.pkBizDate, (CompanyOrgUnitInfo)this.currentCompany);
        FMClientHelper.initSpComponents((KDComboBox)this.cboCurrency, (KDFormattedTextField)this.txtpracticalWinLocAmount, (KDFormattedTextField)this.txtExchangeRate, null, (CurrencyInfo)this.baseCurrency, (KDDatePicker)this.pkBizDate, (CompanyOrgUnitInfo)this.currentCompany);
        FMClientHelper.initSpComponents((KDComboBox)this.cboCurrency, (KDFormattedTextField)this.txtpracticalWinAmount, (KDFormattedTextField)this.txtExchangeRate, null, (CurrencyInfo)this.baseCurrency, (KDDatePicker)this.pkBizDate, (CompanyOrgUnitInfo)this.currentCompany);
        this.pkBeginDate.setSupportedEmpty(false);
        this.pkEndDate.setMinimumDate((Date)this.pkBeginDate.getValue());
        this.txtTerm.setNegatived(false);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        String oprtState = this.getOprtState();
        FinancingAccountInfo info = (FinancingAccountInfo)this.getDataObject();
        if ("VIEW".equals(oprtState)) {
            try {
                FinancingAccountInfo accountInfo = FinancingAccountFactory.getRemoteInstance().getFinancingAccountInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()));
                boolean isAudit = accountInfo.getState() != FinancingStateEnum.AUDIT;
                BigDecimal balance = accountInfo.getBalance();
                Boolean flg = balance.compareTo(Constants.ZERO) == 0;
                this.actionEdit.setEnabled(isAudit && flg == false);
                this.actionRemove.setEnabled(isAudit);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (oprtState.equals(OprtState.EDIT) && info.getState() != FinancingStateEnum.SAVE) {
            this.actionSave.setEnabled(false);
        }
        this.actionCreateTo.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.actionCreateFrom.setVisible(true);
        this.actionAddLine.setVisible(false);
        this.actionRemoveLine.setVisible(false);
        this.actionInsertLine.setVisible(false);
        this.actionMultiapprove.setVisible(false);
        this.actionNextPerson.setVisible(false);
        this.menuWorkflow.setVisible(false);
        this.actionCopy.setVisible(true);
        this.actionCopyFrom.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionPrint.setVisible(false);
    }

    @Override
    public void loadFields() {
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        super.loadFields();
        if (this.getBOTPViewStatus() != 1) {
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)this.editData.getCurrency());
            FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.editData.getCompany().getId().toString());
            if (this.editData.getExchangeRate() != null) {
                this.txtExchangeRate.setValue((Object)this.editData.getExchangeRate());
            }
            if ("ADDNEW".equals(this.getOprtState())) {
                this.txtNumber.setEnabled(true);
            } else {
                this.txtNumber.setEnabled(false);
            }
            if (!("ADDNEW".equals(this.oprtState) || this.editData.getId() == null && this.getUIContext().get("ids") == null)) {
                String id = "";
                FinancingAccountInfo info = new FinancingAccountInfo();
                try {
                    id = this.editData.getId() != null ? this.editData.getId().toString() : this.getUIContext().get("ids").toString();
                    info = (FinancingAccountInfo)((IFinancingAccount)this.getBizInterface()).getValue((IObjectPK)new ObjectUuidPK(id));
                }
                catch (EASBizException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                if (info.getState() == FinancingStateEnum.AUDIT || info.getState() == FinancingStateEnum.CLOSE) {
                    this.actionEdit.setEnabled(false);
                    this.actionRemove.setEnabled(false);
                    this.txtFinancingProName.setEnabled(false);
                    this.prmtFinanceFinancing.setEnabled(false);
                    this.pkBizDate.setEnabled(false);
                    this.cboCurrency.setEnabled(false);
                    this.txtFinanceAmount.setEnabled(false);
                    this.pkBeginDate.setEnabled(false);
                    this.pkEndDate.setEnabled(false);
                    this.txtTerm.setEnabled(false);
                    this.pkChangeDate.setEnabled(false);
                    this.txtPredictYield.setEnabled(false);
                    this.txtPredictWinAmount.setEnabled(false);
                    this.chkIsNoOut.setEnabled(false);
                    this.comboEarnType.setEnabled(false);
                    this.prmtBank.setEnabled(false);
                    this.prmtAccountBank.setEnabled(false);
                    this.txtSaleSize.setEnabled(false);
                    this.txtFinancingProNumber.setEnabled(false);
                    this.txtRemark.setEnabled(true);
                    this.txtNumber.setEnabled(false);
                    this.intRateTypeExpression.setEnabled(false);
                    this.txtdays.setEnabled(false);
                }
                if (FinancingStateEnum.AUDIT.equals((Object)info.getState()) && info.getBalance().compareTo(Constants.ZERO) > 0) {
                    this.comboEarnType.setEnabled(true);
                    this.txtPredictYield.setEnabled(true);
                    this.chkIsNoOut.setEnabled(true);
                    this.txtPredictWinAmount.setEnabled(true);
                }
            } else {
                this.txtFinancingProName.setEnabled(true);
                this.prmtFinanceFinancing.setEnabled(true);
                this.pkBizDate.setEnabled(true);
                this.cboCurrency.setEnabled(true);
                this.txtFinanceAmount.setEnabled(true);
                this.pkBeginDate.setEnabled(true);
                this.pkEndDate.setEnabled(true);
                this.txtTerm.setEnabled(true);
                this.pkChangeDate.setEnabled(false);
                this.txtPredictYield.setEnabled(true);
                this.txtPredictWinAmount.setEnabled(true);
                this.chkIsNoOut.setEnabled(true);
                this.comboEarnType.setEnabled(true);
                this.prmtBank.setEnabled(true);
                this.prmtAccountBank.setEnabled(true);
                this.txtSaleSize.setEnabled(true);
                this.txtFinancingProNumber.setEnabled(true);
                this.txtRemark.setEnabled(true);
            }
        } else {
            FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)this.editData.getCurrency());
        }
        this.txtPredictWinAmount.setValue((Object)this.editData.getPredictWinAmount());
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        FinancingAccountCollection bd;
        super.verifyInput(e);
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        FMClientHelper.verifyNotNegtive((CoreUIObject)this, (KDFormattedTextField)this.txtSaleSize);
        FMClientHelper.verifyNotNegtive((CoreUIObject)this, (KDFormattedTextField)this.txtFinanceAmount);
        FMClientHelper.verifyNotNegtive((CoreUIObject)this, (KDFormattedTextField)this.txtExchangeRate);
        if (this.editData.getFinanceAmount().compareTo(new BigDecimal("0")) <= 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"79_txtTermtxtTerm"));
            SysUtil.abort();
        }
        if (this.editData.getExchangeRate().compareTo(new BigDecimal("0")) <= 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"80_FinancingAccountEditUI"));
            SysUtil.abort();
        }
        if ("ADDNEW".equals(this.getOprtState()) && null != (bd = FinancingAccountFactory.getRemoteInstance().getFinancingAccountCollection("select * where number = '" + this.editData.getNumber() + "'")) && bd.size() > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"81_FinancingAccountEditUI"));
            this.txtNumber.requestFocus();
            SysUtil.abort();
        }
        if (this.editData.getEndDate() != null && this.editData.getEndDate().compareTo(this.editData.getBeginDate()) < 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"82_FinancingAccountEditUI"));
            SysUtil.abort();
        }
    }

    private void initF7Bank() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        this.prmtBank.setEntityViewInfo(evi);
    }

    private void initF7AccountBank() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId()));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Constants.FALSE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtAccountBank.setEntityViewInfo(evi);
    }

    @Override
    protected IObjectValue createNewData() {
        FinancingAccountInfo fai = null;
        Map map = this.getUIContext();
        String action = (String)map.get("COPY");
        String id = null;
        if (map.get("ID") != null) {
            id = map.get("ID").toString();
        }
        if (action != null && id != null && action.equals("COPY")) {
            fai = new FinancingAccountInfo();
            try {
                FinancingAccountInfo oldInfo = (FinancingAccountInfo)this.getValue((IObjectPK)new ObjectUuidPK(id));
                fai = oldInfo.copy();
                this.isCopy = true;
                map.remove("COPY");
            }
            catch (Exception e) {
                logger.error((Object)e);
                this.handUIExceptionAndAbort(e);
            }
        } else {
            fai = new FinancingAccountInfo();
            fai.setBizDate(DateUtil.getDayBegin());
            fai.setSaleSize(new BigDecimal("0.00"));
            fai.setCurrency(this.baseCurrency);
            fai.setExchangeRate(new BigDecimal("1"));
            fai.setFinanceAmount(new BigDecimal("0.00"));
            fai.setBalance(new BigDecimal("0.00"));
            fai.setBeginDate(DateUtil.getDayBegin());
            fai.setEndDate(null);
            fai.setChangeDate(null);
            fai.setIsNoOut(true);
            fai.setEarnType(EarnTypeEnum.DRIFT);
            fai.setCreator(this.contextHelp.getCurrentUser());
            fai.setCompany(this.currentCompany);
            fai.setPredictWinAmount(new BigDecimal("0"));
            fai.setPracticalWinAmount(new BigDecimal("0"));
            fai.setPredictWinLocAmount(new BigDecimal("0"));
            fai.setDays(360);
            fai.setCU(this.currentCompany.getCU());
            fai.setIntRateTypeExpression(IntRateTypeExpressionEnum.YEAR);
            fai.setPracticalWinLocAmount(new BigDecimal("0"));
        }
        return fai;
    }

    @Override
    protected void applyDefaultValue(IObjectValue vo) {
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        FinancingAccountInfo fai = FinancingAccountFactory.getRemoteInstance().getFinancingAccountInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        if (fai.getState() == FinancingStateEnum.CLOSE) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"83_FinancingAccountEditUI"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
        if (this.editData.getExchangeRate() != null) {
            this.txtExchangeRate.setValue((Object)this.editData.getExchangeRate());
        }
        this.cboCurrency.setEnabled(false);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkbillStatusChanged();
        FinancingAccountInfo fai = FinancingAccountFactory.getRemoteInstance().getFinancingAccountInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.checkbillStatusChanged();
        if (fai.getState() == FinancingStateEnum.CLOSE) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"84_FinancingAccountEditUI"));
            SysUtil.abort();
        }
        if (fai.getState() == FinancingStateEnum.AUDIT) {
            MsgBox.showWarning((String)EASResource.getString((String)IVT_RES, (String)"048_DELETE_ERROR"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkbillStatusChanged();
        this.storeFields();
        this.verifyInfo();
        super.actionSubmit_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkbillStatusChanged();
        this.storeFields();
        this.verifyInfo();
        super.actionSave_actionPerformed(e);
    }

    private void verifyInfo() throws EASBizException {
        if (this.editData.getFinanceAmount() != null && this.editData.getFinanceAmount().compareTo(Constants.ZERO) == 0) {
            throw new FinancingAccountException(FinancingAccountException.NOTZEOR);
        }
        if (this.editData.getTerm() != null && new BigDecimal(this.editData.getTerm()).compareTo(Constants.ZERO) == 0) {
            throw new FinancingAccountException(FinancingAccountException.TERMNOTZEOR);
        }
    }

    private void checkbillStatusChanged() {
        try {
            if (this.editData.getId() != null) {
                FinancingAccountInfo accountInfo;
                IFinancingAccount account = FinancingAccountFactory.getRemoteInstance();
                FinancingAccountCollection accountCollection = null;
                EntityViewInfo query = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                query.setFilter(filter);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("state");
                query.setSelector(sic);
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString()));
                accountCollection = account.getFinancingAccountCollection(query);
                if (accountCollection != null && accountCollection.size() == 1 && (accountInfo = accountCollection.get(0)).getState() != this.editData.getState()) {
                    MsgBox.showWarning((String)EASResource.getString((String)IVT_RES, (String)"055_ADD_ERROR"));
                    SysUtil.abort();
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void pkBeginDate_dataChanged(DataChangeEvent e) throws Exception {
        this.vieryDate();
        this.setPredictWinAmount();
        super.pkBeginDate_dataChanged(e);
    }

    private void vieryDate() throws Exception {
        this.pkEndDate.setMinimumDate((Date)this.pkBeginDate.getValue());
        Date beginDate = (Date)this.pkBeginDate.getValue();
        Date enddate = (Date)this.pkEndDate.getValue();
        if (enddate != null && enddate.compareTo(beginDate) != 1) {
            this.pkEndDate.setValue(null);
        } else {
            this.setTerm();
        }
    }

    @Override
    protected void pkEndDate_dataChanged(DataChangeEvent e) throws Exception {
        this.vieryDate();
        this.setPredictWinAmount();
        super.pkEndDate_dataChanged(e);
    }

    @Override
    protected void txtFinanceAmount_dataChanged(DataChangeEvent e) throws Exception {
        this.setPredictWinAmount();
        this.txtbalance.setValue((Object)this.txtFinanceAmount.getBigDecimalValue());
        this.calcAmt();
        super.txtFinanceAmount_dataChanged(e);
    }

    @Override
    protected void txtPredictYield_dataChanged(DataChangeEvent e) throws Exception {
        this.setPredictWinAmount();
        super.txtPredictYield_dataChanged(e);
    }

    @Override
    protected void txtTerm_dataChanged(DataChangeEvent e) throws Exception {
        this.setPredictWinAmount();
        super.txtTerm_dataChanged(e);
    }

    @Override
    protected void txtdays_dataChanged(DataChangeEvent e) throws Exception {
        this.setPredictWinAmount();
        super.txtdays_dataChanged(e);
    }

    @Override
    protected void prmtAccountBank_dataChanged(DataChangeEvent e) throws Exception {
        AccountBankInfo accountbank = (AccountBankInfo)e.getNewValue();
        if (accountbank != null) {
            CurrencyInfo currencyInfo;
            if (accountbank.getCurrency() != null) {
                currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(accountbank.getCurrency().getId()));
                this.cboCurrency.setSelectedItem((Object)currencyInfo);
                this.cboCurrency.setEnabled(false);
            }
            if (!accountbank.isIsByCurrency()) {
                currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId()));
                this.cboCurrency.setSelectedItem((Object)currencyInfo);
                this.cboCurrency.setEnabled(true);
            }
        }
        super.prmtAccountBank_dataChanged(e);
    }

    private void setPredictWinAmount() throws Exception {
        BigDecimal FinanceAmount = Constants.ZERO;
        BigDecimal PredictYield = Constants.ZERO;
        BigDecimal term = Constants.ZERO;
        BigDecimal days = Constants.ZERO;
        if (this.txtFinanceAmount.getBigDecimalValue() == null) {
            return;
        }
        FinanceAmount = this.txtFinanceAmount.getBigDecimalValue();
        if (this.txtPredictYield.getBigDecimalValue() == null) {
            return;
        }
        PredictYield = this.txtPredictYield.getBigDecimalValue();
        if (this.txtdays.getBigDecimalValue() == null || this.txtdays.getBigDecimalValue() == Constants.ZERO) {
            return;
        }
        days = this.txtdays.getBigDecimalValue();
        if (this.txtTerm.getText().equals("")) {
            return;
        }
        term = new BigDecimal(this.txtTerm.getText());
        if (days.compareTo(Constants.ZERO) != 0) {
            if (this.intRateTypeExpression.getSelectedItem() == IntRateTypeExpressionEnum.YEAR) {
                BigDecimal PredictWinAmount = FinHelper.calcBigDecimalExprs((String)"{0}*({1}/{2})/{3}*{4}", (BigDecimal[])new BigDecimal[]{FinanceAmount, PredictYield, new BigDecimal("100"), days, term});
                this.txtPredictWinAmount.setValue((Object)PredictWinAmount);
            } else {
                BigDecimal PredictWinAmount = FinHelper.calcBigDecimalExprs((String)"{0}*({1}/{2})/{3}*{4}", (BigDecimal[])new BigDecimal[]{FinanceAmount, PredictYield, new BigDecimal("1000"), days, term});
                this.txtPredictWinAmount.setValue((Object)PredictWinAmount);
            }
        }
    }

    public void setTerm() throws Exception {
        Date beginDate = (Date)this.pkBeginDate.getValue();
        Date endDate = (Date)this.pkEndDate.getValue();
        if (beginDate != null && endDate != null) {
            int days = DateUtil.getDiffDays((Date)beginDate, (Date)endDate) - 1;
            if (days > 0) {
                this.txtTerm.setText(days + "");
            }
            this.editData.setTerm(String.valueOf(days));
        } else {
            this.txtTerm.setText(null);
            this.editData.setTerm(null);
        }
    }

    public int getBtpCreateFromType() {
        return 0;
    }

    @Override
    protected void intRateTypeExpression_itemStateChanged(ItemEvent e) throws Exception {
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = (IntRateTypeExpressionEnum)((Object)this.intRateTypeExpression.getShowSelectedItem());
        if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.YEAR) {
            this.txtdays.setValue((Object)new Integer(360));
            this.contPredictYield.setBoundLabelText(EASResource.getString((String)IVT_RES, (String)"081_PredictYield"));
        } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.MONTH) {
            this.txtdays.setValue((Object)new Integer(30));
            this.contPredictYield.setBoundLabelText(EASResource.getString((String)IVT_RES, (String)"082_PredictYield"));
        } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.DAY) {
            this.txtdays.setValue((Object)new Integer(1));
            this.contPredictYield.setBoundLabelText(EASResource.getString((String)IVT_RES, (String)"082_PredictYield"));
        }
        this.setPredictWinAmount();
    }

    @Override
    protected void txtExchangeRate_dataChanged(DataChangeEvent e) throws Exception {
        this.calcAmt();
    }

    private void calcAmt() {
        BigDecimal rate = this.txtExchangeRate.getBigDecimalValue();
        BigDecimal applyAmt = this.txtFinanceAmount.getBigDecimalValue();
        if (rate != null && applyAmt != null) {
            this.txtfinanceLocAmount.setValue((Object)applyAmt.multiply(rate));
        }
        BigDecimal predictWinAmount = this.txtPredictWinAmount.getBigDecimalValue();
        if (rate != null && predictWinAmount != null) {
            this.txtpredictWinLocAmount.setValue((Object)predictWinAmount.multiply(rate));
        }
    }

    @Override
    protected void txtPredictWinAmount_dataChanged(DataChangeEvent e) throws Exception {
        BigDecimal rate = this.txtExchangeRate.getBigDecimalValue();
        BigDecimal applyAmt = this.txtPredictWinAmount.getBigDecimalValue();
        if (rate != null && applyAmt != null) {
            this.txtpredictWinLocAmount.setValue((Object)applyAmt.multiply(rate));
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.isCopy = true;
        this.checkModified();
        if (this.editData != null) {
            FinancingAccountInfo newEditData = this.editData.copy();
            newEditData.setBeginDate(DateTimeUtils.truncateDate((Date)new Date()));
            this.unLockUI();
            this.setOprtState("ADDNEW");
            this.setDataObject((IObjectValue)newEditData);
            newEditData.setId(BOSUuid.create((BOSObjectType)newEditData.getBOSType()));
            this.loadFields();
            this.showCopyAddNew();
            this.actionCopy.setEnabled(false);
        }
    }

    @Override
    protected void prmtOppAccount_willShow(SelectorEvent e) throws Exception {
        this.setOppAcctView(this.prmtOppAccount);
    }

    @Override
    protected void prmtOppAccount_willCommit(CommitEvent e) throws Exception {
        this.setOppAcctView(this.prmtOppAccount);
    }

    private void setOppAcctView(KDBizPromptBox prmtOppAccount) throws EASBizException, BOSException {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        String currencyId = currencyInfo.getId().toString();
        String companyId = this.currentCompany.getId().toString();
        String cuId = this.currentCompany.getCU().getId().toString();
        prmtOppAccount.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo treeevi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)companyId, (String)currencyId, (boolean)false);
        AccountPromptBox opseelect = new AccountPromptBox((IUIObject)this, this.currentCompany, treeevi.getFilter(), false, true);
        prmtOppAccount.setSelector((KDPromptSelector)opseelect);
        EntityViewInfo evi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)companyId, (String)currencyId, (boolean)true);
        prmtOppAccount.setEntityViewInfo(evi);
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.FIN_MANAGE;
    }

    protected String getDateField() {
        return "beginDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionSave", "actionSubmit", "actionUnAudit"};
    }
}

