/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.ivt.BillStateEnum;
import com.kingdee.eas.fm.ivt.FinancingAccountFactory;
import com.kingdee.eas.fm.ivt.FinancingAccountInfo;
import com.kingdee.eas.fm.ivt.FinancingRedeemCollection;
import com.kingdee.eas.fm.ivt.FinancingRedeemFactory;
import com.kingdee.eas.fm.ivt.FinancingRedeemInfo;
import com.kingdee.eas.fm.ivt.IFinancingRedeem;
import com.kingdee.eas.fm.ivt.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.ivt.client.AbstractFinancingRedeemEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class FinancingRedeemEditUI
extends AbstractFinancingRedeemEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FinancingRedeemEditUI.class);
    private Date bigenDate = new Date();
    private BigDecimal days = Constants.ZERO;
    private CurrencyInfo baseCurrency;
    private BigDecimal redeemSumAmount = Constants.ZERO;
    private BigDecimal balance = Constants.ZERO;
    private int persion;
    protected static final String IVT_RES = "com.kingdee.eas.fm.ivt.IVTFINANCINGResource";

    public FinancingRedeemEditUI() throws Exception {
        this.baseCurrency = this.currentCompany.getBaseCurrency();
        this.baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.baseCurrency.getId()));
        this.persion = this.baseCurrency.getPrecision();
    }

    @Override
    public void loadFields() {
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtnumber, (String)this.currentCompany.getId().toString());
        Map listenerMap = null;
        try {
            listenerMap = FMClientHelper.removeCompListeners((CoreUI)this);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        super.loadFields();
        try {
            FMClientHelper.addCompListeners((CoreUI)this, (Map)listenerMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initComponent();
        this.initF7AccountBank();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.actionAddNew.setVisible(false);
        }
    }

    private void initComponent() {
        this.actionCopy.setVisible(false);
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtnumber, (String)this.currentCompany.getId().toString());
        this.txtexchangeRate.setHorizontalAlignment(4);
        this.txtredeemAmount.setHorizontalAlignment(4);
        this.txtredeemLocAmount.setHorizontalAlignment(4);
        this.txtredeemSumAmount.setHorizontalAlignment(4);
        this.txtchargeAmount.setHorizontalAlignment(4);
        this.txtpredictWinAmount.setHorizontalAlignment(4);
        this.txtpredictYield.setHorizontalAlignment(4);
        this.txtpracticalYield.setHorizontalAlignment(4);
        this.txtpracticalWinAmount.setHorizontalAlignment(4);
        this.txtpracticalWinLocAmount.setHorizontalAlignment(4);
        this.txtdifferenceAmount.setHorizontalAlignment(4);
        this.txtexchangeRate.setRemoveingZeroInDispaly(false);
        this.txtredeemAmount.setRemoveingZeroInDispaly(false);
        this.txtredeemLocAmount.setRemoveingZeroInDispaly(false);
        this.txtredeemSumAmount.setRemoveingZeroInDispaly(false);
        this.txtchargeAmount.setRemoveingZeroInDispaly(false);
        this.txtpredictWinAmount.setRemoveingZeroInDispaly(false);
        this.txtpredictYield.setRemoveingZeroInDispaly(false);
        this.txtpracticalYield.setRemoveingZeroInDispaly(false);
        this.txtpracticalWinAmount.setRemoveingZeroInDispaly(false);
        this.txtpracticalWinLocAmount.setRemoveingZeroInDispaly(false);
        this.txtdifferenceAmount.setRemoveingZeroInDispaly(false);
        if (this.prmtcurrency.getValue().equals(this.currentCompany.getBaseCurrency())) {
            this.txtexchangeRate.setEnabled(false);
        }
        if (!("VIEW".equals(this.getOprtState()) || this.getBOTPViewStatus() != 1 && this.editData.getSourceBillId() == null)) {
            this.actionSave.setEnabled(true);
            this.actionSubmit.setEnabled(true);
            this.actionRemove.setEnabled(true);
        } else {
            this.actionSave.setEnabled(false);
            this.actionSubmit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        }
    }

    protected void initDataStatus() {
        this.actionCopy.setVisible(false);
        String oprtState = this.getOprtState();
        FinancingRedeemInfo info = (FinancingRedeemInfo)this.getDataObject();
        try {
            if ("VIEW".equals(oprtState) && info != null) {
                FinancingRedeemInfo redeemInfo = FinancingRedeemFactory.getRemoteInstance().getFinancingRedeemInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()));
                boolean isAudit = redeemInfo.getState() != BillStateEnum.AUDITED;
                this.actionEdit.setEnabled(isAudit);
                this.actionRemove.setEnabled(isAudit);
                this.actionSave.setEnabled(false);
                this.btnSave.setEnabled(false);
            } else if ("EDIT".equals(oprtState) && info != null) {
                FinancingRedeemInfo redeemInfo = FinancingRedeemFactory.getRemoteInstance().getFinancingRedeemInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()));
                boolean isSave = redeemInfo.getState() == BillStateEnum.SAVED;
                this.actionSave.setEnabled(isSave);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public int getBtpCreateFromType() {
        return 0;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FinancingRedeemFactory.getRemoteInstance();
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        this.handleInfo(this.editData);
    }

    private void handleInfo(FinancingRedeemInfo info) {
        if ("ADDNEW".equals(this.oprtState)) {
            info.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
            info.setRedeemDate(new Date());
            info.setBizDate(new Date());
            info.setCU(this.currentCompany.getCU());
        }
        this.chkIsInvertedRate.setSelected(info.isIsInvertedRate());
        if (info.isIsInvertedRate()) {
            this.txtpracticalYield.setEditable(false);
            this.txtpracticalWinAmount.setEnabled(true);
        } else {
            this.txtpracticalYield.setEditable(true);
            this.txtpracticalWinAmount.setEnabled(false);
        }
        this.calcAmt(this.txtredeemAmount, this.txtredeemLocAmount);
        try {
            if (info.getSourceBillId() != null) {
                FinancingRedeemCollection collection = FinancingRedeemFactory.getRemoteInstance().getFinancingRedeemCollection("where SourceBillID='" + info.getSourceBillId().toString() + "'");
                FinancingAccountInfo accountInfo = FinancingAccountFactory.getRemoteInstance().getFinancingAccountInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()), this.getaccountSelect());
                if ("ADDNEW".equals(this.oprtState)) {
                    info.setRedeemAmount(accountInfo.getBalance());
                    info.setRedeemLocAmount(info.getRedeemAmount().multiply(info.getExchangeRate()));
                    info.setPracticalYield(accountInfo.getPredictYield());
                    info.setRedeemSumAmount(accountInfo.getFinanceAmount());
                    this.redeemSumAmount = accountInfo.getFinanceAmount().subtract(accountInfo.getBalance());
                    this.balance = accountInfo.getBalance();
                    info.setSeq(collection.size() + 1);
                    info.setChargeAmount(Constants.ZERO);
                    info.setDifferenceAmount(Constants.ZERO);
                    info.setEndDate(accountInfo.getEndDate());
                    info.setPredictYield(accountInfo.getPredictYield());
                    info.setIsNoOut(accountInfo.isIsNoOut());
                    info.setEarnType(accountInfo.getEarnType());
                    info.setIntRateTypeExpression(accountInfo.getIntRateTypeExpression());
                    info.setPredictWinAmount(Constants.ZERO);
                    info.setPracticalWinAmount(Constants.ZERO);
                    info.setPracticalWinLocAmount(Constants.ZERO);
                    this.txtredeemAmount.setMinimumValue((Comparable)new BigDecimal("0.0"));
                    this.txtredeemAmount.setMaximumValue((Comparable)accountInfo.getBalance());
                    if (accountInfo.getPredictWinAmount() != null) {
                        info.setPredictWinAmount(accountInfo.getPredictWinAmount());
                    }
                    if (info.getBankAccount() != null && info.getBankAccount().getId() != null) {
                        AccountBankInfo bankInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(info.getBankAccount().getId()));
                        info.setBankAccount(bankInfo);
                    }
                } else {
                    this.redeemSumAmount = accountInfo.getSumRedeemAmount().subtract(info.getRedeemAmount());
                    if (info.getChargeAmount() == null) {
                        info.setChargeAmount(Constants.ZERO);
                    }
                    this.balance = info.getChargeAmount().add(info.getRedeemAmount());
                    info.setCompany(accountInfo.getCompany());
                }
                this.bigenDate = accountInfo.getBeginDate();
                this.days = new BigDecimal(accountInfo.getDays());
                this.persion = accountInfo.getCurrency().getPrecision();
                if ("ADDNEW".equals(this.oprtState)) {
                    this.setpracticalWinAmount();
                }
                this.setPersion();
                FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtexchangeRate, (CompanyOrgUnitInfo)this.currentCompany, (CurrencyInfo)info.getCurrency(), (CurrencyInfo)this.baseCurrency, (Date)new Date(), null);
            } else {
                info.setSeq(1);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        info.getSourceBillId();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    private SelectorItemCollection getaccountSelect() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("balance"));
        sic.add(new SelectorItemInfo("predictYield"));
        sic.add(new SelectorItemInfo("financeAmount"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("intRateTypeExpression"));
        sic.add(new SelectorItemInfo("beginDate"));
        sic.add(new SelectorItemInfo("days"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("earnType"));
        sic.add(new SelectorItemInfo("isNoOut"));
        sic.add(new SelectorItemInfo("predictWinAmount"));
        sic.add(new SelectorItemInfo("practicalWinAmount"));
        sic.add(new SelectorItemInfo("predictWinLocAmount"));
        sic.add(new SelectorItemInfo("SumRedeemAmount"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        return sic;
    }

    private void setPersion() {
        this.txtredeemAmount.setPrecision(this.persion);
        this.txtpracticalWinAmount.setPrecision(this.persion);
        this.txtpracticalWinLocAmount.setPrecision(this.persion);
        this.txtdifferenceAmount.setPrecision(this.persion);
        this.txtpredictWinAmount.setPrecision(this.persion);
        this.txtexchangeRate.setPrecision(this.persion);
    }

    @Override
    protected void txtexchangeRate_dataChanged(DataChangeEvent e) throws Exception {
        this.calcAmt(this.txtredeemAmount, this.txtredeemLocAmount);
        this.calcAmt(this.txtpracticalWinAmount, this.txtpracticalWinLocAmount);
    }

    @Override
    protected void txtpracticalWinAmount_dataChanged(DataChangeEvent e) throws Exception {
        this.calcAmt(this.txtpracticalWinAmount, this.txtpracticalWinLocAmount);
        this.txtpracticalWinAmount.setPrecision(this.persion);
        if (this.txtpracticalWinAmount.getBigDecimalValue() != null) {
            this.editData.setPracticalWinAmount(this.txtpracticalWinAmount.getBigDecimalValue());
            this.editData.setPracticalWinLocAmount(this.txtpracticalWinAmount.getBigDecimalValue().multiply(this.editData.getExchangeRate()));
            if (this.txtpredictWinAmount.getBigDecimalValue() != null) {
                this.txtdifferenceAmount.setValue((Object)this.txtpredictWinAmount.getBigDecimalValue().subtract(this.txtpracticalWinAmount.getBigDecimalValue()));
                this.editData.setDifferenceAmount(this.txtpredictWinAmount.getBigDecimalValue().subtract(this.txtpracticalWinAmount.getBigDecimalValue()));
            }
        }
        if (this.chkIsInvertedRate.isSelected()) {
            this.calcAmt(this.txtredeemAmount, this.txtredeemLocAmount);
            this.setSumAmount();
            this.setpracticalWinAmount();
        }
    }

    private void setpracticalWinAmount() throws Exception {
        BigDecimal RedeemAmount = Constants.ZERO;
        BigDecimal PracticalYield = Constants.ZERO;
        BigDecimal term = Constants.ZERO;
        BigDecimal predictYield = Constants.ZERO;
        BigDecimal practicalWinAmount = Constants.ZERO;
        BigDecimal predictWinAmount = Constants.ZERO;
        Date redeemDate = new Date();
        RedeemAmount = this.txtredeemAmount.getBigDecimalValue() != null && this.txtredeemAmount.getBigDecimalValue().compareTo(Constants.ZERO) != 0 ? this.txtredeemAmount.getBigDecimalValue() : (this.editData.getRedeemAmount() != null && this.editData.getRedeemAmount().compareTo(Constants.ZERO) != 0 ? this.editData.getRedeemAmount() : Constants.ZERO);
        practicalWinAmount = this.txtpracticalWinAmount.getBigDecimalValue() != null && this.txtpracticalWinAmount.getBigDecimalValue().compareTo(Constants.ZERO) != 0 ? this.txtpracticalWinAmount.getBigDecimalValue() : (this.editData.getPracticalWinAmount() != null && this.editData.getPracticalWinAmount().compareTo(Constants.ZERO) != 0 ? this.editData.getPracticalWinAmount() : Constants.ZERO);
        predictWinAmount = this.txtpredictWinAmount.getBigDecimalValue() != null && this.txtpredictWinAmount.getBigDecimalValue().compareTo(Constants.ZERO) != 0 ? this.txtpredictWinAmount.getBigDecimalValue() : (this.editData.getPracticalWinAmount() != null && this.editData.getPracticalWinAmount().compareTo(Constants.ZERO) != 0 ? this.editData.getPracticalWinAmount() : Constants.ZERO);
        PracticalYield = this.txtpracticalYield.getBigDecimalValue() != null && this.txtpracticalYield.getBigDecimalValue().compareTo(Constants.ZERO) != 0 ? this.txtpracticalYield.getBigDecimalValue() : (this.editData.getPracticalYield() != null && this.editData.getPracticalYield().compareTo(Constants.ZERO) != 0 ? this.editData.getPracticalYield() : Constants.ZERO);
        redeemDate = this.pkredeemDate.getValue() != null ? (Date)this.pkredeemDate.getValue() : this.editData.getRedeemDate();
        if (DateUtil.getNextDay((Date)this.bigenDate).before(redeemDate)) {
            term = new BigDecimal(DateUtil.getDiffDays((Date)this.bigenDate, (Date)((Date)this.pkredeemDate.getValue())) - 1);
        } else if (DateUtil.getNextDay((Date)this.bigenDate).equals(redeemDate)) {
            term = BigDecimal.ONE;
        } else {
            return;
        }
        predictYield = this.editData.getPredictYield() != null && this.editData.getPredictYield().compareTo(Constants.ZERO) != 0 ? this.editData.getPredictYield() : Constants.ZERO;
        if (this.days.compareTo(Constants.ZERO) != 0) {
            BigDecimal intRateTypeExp = this.editData.getIntRateTypeExpression() == IntRateTypeExpressionEnum.YEAR || this.intRateTypeExpression.getSelectedItem() == IntRateTypeExpressionEnum.YEAR ? new BigDecimal("100") : new BigDecimal("1000");
            if (!this.chkIsInvertedRate.isSelected()) {
                practicalWinAmount = FinHelper.calcBigDecimalExprs((String)"{0}*({1}/{2})/{3}*{4}", (BigDecimal[])new BigDecimal[]{RedeemAmount, PracticalYield, intRateTypeExp, this.days, term}).setScale(this.persion, 4);
                this.txtpracticalWinAmount.setValue((Object)practicalWinAmount);
                this.editData.setPracticalWinAmount(practicalWinAmount);
                this.editData.setPracticalWinLocAmount(practicalWinAmount.multiply(this.editData.getExchangeRate()));
                predictWinAmount = FinHelper.calcBigDecimalExprs((String)"{0}*({1}/{2})/{3}*{4}", (BigDecimal[])new BigDecimal[]{RedeemAmount, predictYield, intRateTypeExp, this.days, term}).setScale(this.persion, 4);
                this.txtpredictWinAmount.setValue((Object)predictWinAmount);
                this.editData.setPredictWinAmount(predictWinAmount);
                this.txtdifferenceAmount.setValue((Object)predictWinAmount.subtract(practicalWinAmount));
                this.editData.setDifferenceAmount(predictWinAmount.subtract(practicalWinAmount));
            } else {
                if (RedeemAmount.compareTo(BigDecimal.ZERO) == 0) {
                    return;
                }
                PracticalYield = FinHelper.calcBigDecimalExprs((String)"{0}/{1}/{2}*{3}*{4}", (BigDecimal[])new BigDecimal[]{practicalWinAmount, RedeemAmount, term, this.days, intRateTypeExp}).setScale(this.persion, 4);
                this.txtpracticalYield.setValue((Object)PracticalYield);
                this.editData.setPracticalYield(PracticalYield);
                this.txtdifferenceAmount.setValue((Object)predictWinAmount.subtract(practicalWinAmount));
                this.editData.setDifferenceAmount(predictWinAmount.subtract(practicalWinAmount));
            }
        }
        this.txtpracticalWinAmount.setPrecision(this.persion);
    }

    @Override
    protected void txtredeemAmount_dataChanged(DataChangeEvent e) throws Exception {
        this.calcAmt(this.txtredeemAmount, this.txtredeemLocAmount);
        this.setSumAmount();
        this.setpracticalWinAmount();
    }

    private void setSumAmount() {
        BigDecimal redeamount = this.txtredeemAmount.getBigDecimalValue();
        if (redeamount != null) {
            this.txtredeemSumAmount.setValue((Object)redeamount.add(this.redeemSumAmount));
            this.txtchargeAmount.setValue((Object)this.balance.subtract(redeamount));
        }
    }

    @Override
    protected void chkIsInvertedRate_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setIsInvertedRate(this.chkIsInvertedRate.isSelected());
        if (this.chkIsInvertedRate.isSelected()) {
            this.txtpracticalYield.setEditable(false);
            this.txtpracticalWinAmount.setEnabled(true);
        } else {
            this.txtpracticalYield.setEditable(true);
            this.txtpracticalWinAmount.setEnabled(false);
        }
        this.calcAmt(this.txtredeemAmount, this.txtredeemLocAmount);
        this.setSumAmount();
        this.setpracticalWinAmount();
    }

    private void calcAmt(KDFormattedTextField txtAmount, KDFormattedTextField txtLocAmount) {
        BigDecimal rate = this.txtexchangeRate.getBigDecimalValue();
        BigDecimal applyAmt = txtAmount.getBigDecimalValue();
        if (rate != null && applyAmt != null) {
            txtLocAmount.setValue((Object)applyAmt.multiply(rate));
        }
    }

    @Override
    protected IObjectValue createNewData() {
        FinancingRedeemInfo info = new FinancingRedeemInfo();
        info.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        info.setCompany(this.currentCompany);
        info.setCU(this.currentCompany.getCU());
        if ("ADDNEW".equals(this.oprtState)) {
            info.setBizDate(new Date());
            info.setRedeemDate(new Date());
        }
        info.setCurrency(this.baseCurrency);
        info.setRedeemAmount(Constants.ZERO);
        info.setExchangeRate(Constants.ONE);
        info.setPracticalWinAmount(Constants.ZERO);
        info.setPracticalWinLocAmount(Constants.ZERO);
        info.setRedeemLocAmount(Constants.ZERO);
        info.setRedeemSumAmount(Constants.ZERO);
        info.setPracticalYield(Constants.ZERO);
        info.setPredictYield(Constants.ZERO);
        info.setChargeAmount(Constants.ZERO);
        info.setDifferenceAmount(Constants.ZERO);
        info.setPredictWinAmount(Constants.ZERO);
        return info;
    }

    private void initF7AccountBank() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId()));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Constants.FALSE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtbankAccount.setEntityViewInfo(evi);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
    }

    @Override
    protected void pkredeemDate_dataChanged(DataChangeEvent e) throws Exception {
        this.setpracticalWinAmount();
    }

    @Override
    protected void txtpracticalYield_dataChanged(DataChangeEvent e) throws Exception {
        this.setpracticalWinAmount();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkbillStatusChanged();
        super.actionSave_actionPerformed(e);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkbillStatusChanged();
        super.actionSubmit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkbillStatusChanged();
        super.actionRemove_actionPerformed(e);
    }

    private void checkbillStatusChanged() {
        try {
            FinancingRedeemInfo info = (FinancingRedeemInfo)this.getDataObject();
            if (this.editData.getId() != null) {
                FinancingRedeemInfo accountInfo;
                IFinancingRedeem account = FinancingRedeemFactory.getRemoteInstance();
                FinancingRedeemCollection accountCollection = null;
                EntityViewInfo query = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                query.setFilter(filter);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("state");
                query.setSelector(sic);
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString()));
                accountCollection = account.getFinancingRedeemCollection(query);
                if (accountCollection != null && accountCollection.size() == 1 && (accountInfo = accountCollection.get(0)).getState() != info.getState()) {
                    MsgBox.showWarning((String)EASResource.getString((String)IVT_RES, (String)"055_ADD_ERROR"));
                    SysUtil.abort();
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void prmtInterestAccount_willShow(SelectorEvent e) throws Exception {
        this.setInterestAccountView(this.prmtInterestAccount);
    }

    @Override
    protected void prmtInterestAccount_willCommit(CommitEvent e) throws Exception {
        this.setInterestAccountView(this.prmtInterestAccount);
    }

    private void setInterestAccountView(KDBizPromptBox prmtOppAccount) throws EASBizException, BOSException {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.prmtcurrency.getData();
        String currencyId = currencyInfo.getId().toString();
        String companyId = this.currentCompany.getId().toString();
        String cuId = this.currentCompany.getCU().getId().toString();
        prmtOppAccount.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo treeevi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)companyId, (String)currencyId, (boolean)false);
        AccountPromptBox opseelect = new AccountPromptBox((IUIObject)this, this.currentCompany, treeevi.getFilter(), false, true);
        prmtOppAccount.setSelector((KDPromptSelector)opseelect);
        EntityViewInfo evi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)companyId, (String)currencyId, (boolean)true);
        prmtOppAccount.setEntityViewInfo(evi);
    }
}

