/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.ivt.BillStateEnum;
import com.kingdee.eas.fm.ivt.EarnTypeEnum;
import com.kingdee.eas.fm.ivt.client.AbstractFinancingRedeemFilterUI;
import com.kingdee.eas.fm.ivt.client.FinancingRedeemFilterParam;
import com.kingdee.eas.fm.ivt.isNoOutEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class FinancingRedeemFilterUI
extends AbstractFinancingRedeemFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(FinancingRedeemFilterUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void init() throws Exception {
        super.init();
        this.pkRedeemFrom.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.pkRedmeeTo.setValue((Object)new Date());
        this.combostate.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.combostate.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.comoNoOutEnmu.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.comoNoOutEnmu.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.cobearnType.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.cobearnType.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    public Object getParam() {
        Set bankIds;
        FinancingRedeemFilterParam filterParam = new FinancingRedeemFilterParam();
        if (this.pkRedeemFrom.getValue() != null) {
            filterParam.setFrom((Date)this.pkRedeemFrom.getValue());
        }
        if (this.pkRedmeeTo.getValue() != null) {
            filterParam.setTo((Date)this.pkRedmeeTo.getValue());
        }
        if ((bankIds = this.getIdSetFromF7(this.prmtBank)) != null && bankIds.size() > 0) {
            filterParam.setBankIds(bankIds);
        }
        if (!(this.combostate.getSelectedItem() instanceof FMSysDefinedEnum)) {
            filterParam.setState((BillStateEnum)((Object)this.combostate.getSelectedItem()));
        } else {
            filterParam.setState(null);
        }
        if (!(this.comoNoOutEnmu.getSelectedItem() instanceof FMSysDefinedEnum)) {
            filterParam.setBreakType((isNoOutEnum)((Object)this.comoNoOutEnmu.getSelectedItem()));
        } else {
            filterParam.setBreakType(null);
        }
        if (!(this.cobearnType.getSelectedItem() instanceof FMSysDefinedEnum)) {
            filterParam.setEarnType((EarnTypeEnum)((Object)this.cobearnType.getSelectedItem()));
        } else {
            filterParam.setEarnType(null);
        }
        if (this.getCompanyIdSet() != null) {
            filterParam.setCompanyIdSet(this.getCompanyIdSet());
        }
        return filterParam;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        FinancingRedeemFilterParam filterParam = (FinancingRedeemFilterParam)((Object)param);
        this.pkRedeemFrom.setValue((Object)filterParam.getFrom());
        this.pkRedmeeTo.setValue((Object)filterParam.getTo());
        if (filterParam.getState() == null) {
            this.combostate.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.combostate.setSelectedItem((Object)filterParam.getState());
        }
        if (filterParam.getBreakType() == null) {
            this.comoNoOutEnmu.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.comoNoOutEnmu.setSelectedItem((Object)filterParam.getBreakType());
        }
        if (filterParam.getEarnType() == null) {
            this.cobearnType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.cobearnType.setSelectedItem((Object)filterParam.getEarnType());
        }
        try {
            this.prmtBank.setData((Object)this.getBaseInfoFromIdSet(filterParam.getBankIds()));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.setCompanyIdSet(filterParam.getCompanyIdSet());
    }

    protected Class getParamClass() {
        return FinancingRedeemFilterParam.class;
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.pkRedeemFrom.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.pkRedmeeTo.setValue((Object)new Date());
        this.combostate.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.comoNoOutEnmu.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.cobearnType.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    public boolean verify() {
        java.sql.Date startDate = this.pkRedeemFrom.getSqlDate();
        java.sql.Date endDate = this.pkRedmeeTo.getSqlDate();
        if (startDate != null && endDate != null && startDate.after(endDate)) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"134_FinancingRedeemFilterUI");
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return false;
        }
        return super.verify();
    }
}

