/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ivt.ChLoanHelper;
import com.kingdee.eas.fm.ivt.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.ivt.PenAccrualTypeEnum;
import com.kingdee.eas.fm.ivt.client.ChLoanDataAdapter;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.sql.SQLException;
import java.util.List;

public class LoanInterestBillDataProvider
extends ChLoanDataAdapter {
    private static final String queryPK = "com.kingdee.eas.fm.ivt.app.LoanInterestTDQuery";

    public LoanInterestBillDataProvider(List idList) {
        this.ids = FMHelper.list2Set((List)idList);
        this.setQueryPKStr(queryPK);
    }

    @Override
    protected void processBillEntries(IRowSet rowSet, int precision) throws SQLException {
        if (rowSet.getDate("entrys.beginDate") != null) {
            rowSet.updateDate("entrys.beginDate", DateUtil.truncateSqlDate((Date)rowSet.getDate("entrys.beginDate")));
        }
        if (rowSet.getDate("entrys.endDate") != null) {
            rowSet.updateDate("entrys.endDate", DateUtil.truncateSqlDate((Date)rowSet.getDate("entrys.endDate")));
        }
        rowSet.updateBigDecimal("entrys.amount", rowSet.getBigDecimal("entrys.amount").setScale(precision, 4));
        rowSet.updateBigDecimal("entrys.interest", rowSet.getBigDecimal("entrys.interest").setScale(precision, 4));
        rowSet.updateBigDecimal("entrys.punishInterest", rowSet.getBigDecimal("entrys.punishInterest").setScale(precision, 4));
        String rateExpressionStr = rowSet.getString("entrys.intRateTypeExpression");
        String tmpYearRate = "";
        tmpYearRate = rateExpressionStr.equals(IntRateTypeExpressionEnum.YEAR.getAlias()) ? rowSet.getBigDecimal("entrys.yearIntRate").toString() + "%" : rowSet.getBigDecimal("entrys.yearIntRate").toString() + "\u2030";
        tmpYearRate = tmpYearRate.indexOf("%") != -1 ? ChLoanHelper.getInstance().trimZero(tmpYearRate, "%") : ChLoanHelper.getInstance().trimZero(tmpYearRate, "\u2030");
        rowSet.updateString("entrys.yearIntRateDis", tmpYearRate);
    }

    @Override
    protected void processBillBody(IRowSet rowSet, int precision) throws SQLException {
        rowSet.updateBigDecimal("interest", rowSet.getBigDecimal("interest").setScale(precision, 4));
        rowSet.updateBigDecimal("punishInterest", rowSet.getBigDecimal("punishInterest").setScale(precision, 4));
        rowSet.updateBigDecimal("interestToPay", rowSet.getBigDecimal("interestToPay").setScale(precision, 4));
        rowSet.updateBigDecimal("punishInterestActual", rowSet.getBigDecimal("punishInterestActual").setScale(precision, 4));
        rowSet.updateBigDecimal("interestAcctual", rowSet.getBigDecimal("interestAcctual").setScale(precision, 4));
        rowSet.updateBigDecimal("interestActual", rowSet.getBigDecimal("interestActual").setScale(precision, 4));
        rowSet.updateBigDecimal("strikeAmount", rowSet.getBigDecimal("strikeAmount").setScale(precision, 4));
        rowSet.updateBigDecimal("unVerifyAmount", rowSet.getBigDecimal("unVerifyAmount").setScale(precision, 4));
        if (rowSet.getDate("beginDate") != null) {
            rowSet.updateDate("beginDate", DateUtil.truncateSqlDate((Date)rowSet.getDate("beginDate")));
        }
        if (rowSet.getDate("endDate") != null) {
            rowSet.updateDate("endDate", DateUtil.truncateSqlDate((Date)rowSet.getDate("endDate")));
        }
        String printeExcutor = ContextHelperFactory.getRemoteInstance().getCurrentUser().getName();
        rowSet.updateString("printeExcutor", printeExcutor);
        String rateExpressionStr = rowSet.getString("intRateTypeExpression");
        String tmpYearRate = "";
        String tmpPenaRate = "";
        if (rateExpressionStr.equals(IntRateTypeExpressionEnum.YEAR.getAlias())) {
            tmpYearRate = rowSet.getBigDecimal("yearIntRate").toString() + "%";
            tmpYearRate = ChLoanHelper.getInstance().trimZero(tmpYearRate, "%");
        } else {
            tmpYearRate = rowSet.getBigDecimal("yearIntRate").toString() + "\u2030";
            tmpYearRate = ChLoanHelper.getInstance().trimZero(tmpYearRate, "\u2030");
        }
        String penaType = rowSet.getString("punishIntType");
        if (penaType.equals(PenAccrualTypeEnum.ADD_PERCENT.getAlias())) {
            tmpPenaRate = rowSet.getBigDecimal("punishIntRate").toString() + "%";
            tmpPenaRate = ChLoanHelper.getInstance().trimZero(tmpPenaRate, "%");
        } else {
            tmpPenaRate = rowSet.getBigDecimal("punishIntRate").toString() + "\u2030";
            tmpPenaRate = ChLoanHelper.getInstance().trimZero(tmpPenaRate, "\u2030");
        }
        rowSet.updateString("yearIntRateDis", tmpYearRate);
        rowSet.updateString("punishIntRateDis", tmpPenaRate);
    }
}

