/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyFactory;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.OverdraftCtrlEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IvtModualUtils;
import com.kingdee.eas.fm.common.SumBillEnum;
import com.kingdee.eas.fm.common.SumFiledsInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.erec.client.EReceiptInnerClientHelper;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.ivt.CHLoanException;
import com.kingdee.eas.fm.ivt.ChLoanHelper;
import com.kingdee.eas.fm.ivt.ILoanInterestBill;
import com.kingdee.eas.fm.ivt.IntCalTypeEnum;
import com.kingdee.eas.fm.ivt.IvtBillStatusEnum;
import com.kingdee.eas.fm.ivt.LoanIntPartInfo;
import com.kingdee.eas.fm.ivt.LoanInterestBillCollection;
import com.kingdee.eas.fm.ivt.LoanInterestBillFactory;
import com.kingdee.eas.fm.ivt.LoanInterestBillInfo;
import com.kingdee.eas.fm.ivt.StrikeEnum;
import com.kingdee.eas.fm.ivt.client.AbstractLoanInterestBillListUI;
import com.kingdee.eas.fm.ivt.client.ChLoanIntBillQueryProcessor;
import com.kingdee.eas.fm.ivt.client.LoanInterestBillEditUI;
import com.kingdee.eas.fm.ivt.client.LoanInterestBillFilterParam;
import com.kingdee.eas.fm.ivt.client.LoanInterestBillFilterUI;
import com.kingdee.eas.fm.ivt.client.PreIntScopeChooserUI;
import com.kingdee.eas.fm.ivt.client.RecIntScopeChooserUI;
import com.kingdee.eas.fm.nt.NTBookHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.service.LicenseService;
import com.kingdee.eas.framework.util.StringUtility;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class LoanInterestBillListUI
extends AbstractLoanInterestBillListUI {
    private static final Integer PREINT = new Integer(0);
    private static final Logger logger = CoreUIObject.getLogger(LoanInterestBillListUI.class);
    private Set setIDs;
    private String uiParam;
    private LicenseService licenseService = new LicenseService((IUIObject)this);
    private String LOANINTBILL_FILENAME = "/FM/IVT/LOANINTR";
    private CompanyOrgUnitInfo currentCompany;
    private static final Integer REC_INT = new Integer(1);
    private String msg = null;
    private Map hm = null;
    private LoanInterestBillFilterUI filterUI;
    private LoanIntPartInfo loanIntPartInfo;
    boolean isEnterByPreInt = false;
    public static final String PAYMENTBILL_FILENAME = "/FM/IM/LOANINTR";
    FillListener fillListener = new FillListener();
    private Map columnMap = new HashMap();

    public LoanInterestBillListUI() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    }

    public void onLoad() throws Exception {
        if (this.getOprtState() == null) {
            FSClientHelper.checkClearingHouseCompany();
            ChLoanHelper.checkClearingHouseUsed(this.currentCompany);
        } else if (!this.getOprtState().equals("FINDVIEW")) {
            FSClientHelper.checkClearingHouseCompany();
            ChLoanHelper.checkClearingHouseUsed(this.currentCompany);
        }
        this.uiParam = (String)this.getUIContext().get("UIClassParam");
        if (this.getBOTPViewStatus() != 1) {
            this.licenseService.checkLicence();
            if (this.uiParam.equals("DBCKICKFROMRECINT")) {
                this.hm = RecIntScopeChooserUI.showRecIntScopeChooserUI((CoreUI)this);
                this.setIDs = (Set)this.hm.get("createdID");
                this.isEnterByPreInt = true;
                if (this.setIDs == null || this.setIDs.size() == 0) {
                    this.isEnterByPreInt = false;
                    SysUtil.abort();
                }
            } else if (this.uiParam.equals("DBCLICKPREINT")) {
                this.hm = PreIntScopeChooserUI.showPreIntScopeChooserUI((CoreUI)this);
                this.setIDs = (Set)this.hm.get("createdID");
                this.isEnterByPreInt = true;
                if (this.setIDs == null || this.setIDs.size() == 0) {
                    this.isEnterByPreInt = false;
                    SysUtil.abort();
                }
            }
        }
        super.onLoad();
        this.actionCancelBill.setEnabled(false);
        this.actionUnCancelBill.setEnabled(false);
        this.actionTDPrint.setVisible(true);
        this.actionTDPrintPreview.setVisible(true);
        this.actionAuditResult.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.actionViewDoProccess.setEnabled(false);
        this.actionViewDoProccess.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnTDPrint.setVisible(false);
        this.btnTDPrePrint.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnCancelBook.setVisible(false);
        this.initTable();
    }

    private void checkHasNumber() {
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            codingRuleManager.readNumber((IObjectValue)new LoanInterestBillInfo(), this.currentCompany.getId().toString());
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)e.getMessage());
            SysUtil.abort();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected String getEditUIName() {
        return LoanInterestBillEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return LoanInterestBillFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        LoanInterestBillInfo objectValue = new LoanInterestBillInfo();
        return objectValue;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new LoanInterestBillFilterUI();
        }
        return this.filterUI;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.isEnterByPreInt = false;
        super.actionQuery_actionPerformed(e);
    }

    @Override
    public void actionPreInt_actionPerformed(ActionEvent e) throws Exception {
        if (this.isEnterByPreInt) {
            boolean hasSavedBill;
            FilterInfo filte = new FilterInfo();
            filte.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(1)));
            this.mainQuery.getFilter().mergeFilter(filte, "AND");
            LoanInterestBillCollection col = LoanInterestBillFactory.getRemoteInstance().getLoanInterestBillCollection(this.mainQuery);
            boolean bl = hasSavedBill = col.size() > 0;
            if (hasSavedBill) {
                boolean isSave;
                int result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"93_LoanInterestBillListUI"));
                boolean bl2 = isSave = result == 1;
                if (isSave) {
                    return;
                }
                FilterInfo f = new FilterInfo();
                f.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(1)));
                this.mainQuery.getFilter().mergeFilter(f, "AND");
                LoanInterestBillFactory.getRemoteInstance().delete(this.mainQuery.getFilter());
                this.refreshList();
                this.isEnterByPreInt = true;
            }
        }
        this.hm = PreIntScopeChooserUI.showPreIntScopeChooserUI((CoreUI)this);
        this.setIDs = (Set)this.hm.get("createdID");
        if (this.setIDs != null) {
            String includeValue = this.parseValue(this.setIDs);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)includeValue, CompareType.INCLUDE));
            this.mainQuery.setFilter(filter);
            this.refresh(e);
        }
        this.isEnterByPreInt = true;
    }

    @Override
    public void actionReceiveInt_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"INTCALTYPE", (Object)"intCalType");
        if (this.isEnterByPreInt) {
            boolean hasSavedBill;
            FilterInfo filte = new FilterInfo();
            filte.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(1)));
            this.mainQuery.getFilter().mergeFilter(filte, "AND");
            LoanInterestBillCollection col = LoanInterestBillFactory.getRemoteInstance().getLoanInterestBillCollection(this.mainQuery);
            boolean bl = hasSavedBill = col.size() > 0;
            if (hasSavedBill) {
                boolean isSave;
                int result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"93_LoanInterestBillListUI"));
                boolean bl2 = isSave = result == 1;
                if (isSave) {
                    return;
                }
                FilterInfo f = new FilterInfo();
                f.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(1)));
                this.mainQuery.getFilter().mergeFilter(f, "AND");
                LoanInterestBillFactory.getRemoteInstance().delete(this.mainQuery.getFilter());
                this.refreshList();
                this.isEnterByPreInt = true;
            }
        }
        this.hm = RecIntScopeChooserUI.showRecIntScopeChooserUI((CoreUI)this);
        this.setIDs = (Set)this.hm.get("createdID");
        if (this.setIDs != null) {
            String includeValue = this.parseValue(this.setIDs);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)includeValue, CompareType.INCLUDE));
            this.mainQuery.setFilter(filter);
            try {
                boolean isSubmit = IvtModualUtils.getSysParam(null, (String)"IVT003");
                boolean isBgCtrl = FmMbgHelper.isCtrl(null, (BOSObjectType)new LoanInterestBillInfo().getBOSType());
                if (isSubmit && !isBgCtrl) {
                    LoanInterestBillFactory.getRemoteInstance().book(this.setIDs);
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"operSucess_book"));
                }
            }
            catch (Exception ex) {
                MsgBox.showInfo((String)ex.getMessage());
                SysUtil.abort();
            }
            this.refresh(e);
        }
    }

    protected void execQuery() {
        if (this.setIDs != null) {
            String includeValue = this.parseValue(this.setIDs);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)includeValue, CompareType.INCLUDE));
            this.mainQuery.setFilter(filter);
        }
        super.execQuery();
        this.formatFootRow();
        this.setIDs = null;
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    private void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            LoanInterestBillFilterParam param = (LoanInterestBillFilterParam)this.getFilterUI().getParam();
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrencyInfo() == null ? company.getBaseCurrency().getId().toString() : AccessHelper.getId((Object)param.getCurrencyInfo());
            String[] columns = new SumFiledsInfo(SumBillEnum.LoanInt).getSumFileds();
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = null;
        if (this.setIDs == null) {
            filter = super.getDefaultFilterForQuery();
        } else {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.parseValue(this.setIDs), CompareType.INCLUDE));
        }
        return filter;
    }

    private String parseValue(Set setIDs) {
        StringBuffer returnSb = new StringBuffer();
        Object[] ids = setIDs.toArray();
        for (int i = 0; i < ids.length; ++i) {
            if (i == ids.length - 1) {
                returnSb.append(ids[i].toString());
                continue;
            }
            returnSb.append(ids[i].toString()).append(",");
        }
        return returnSb.toString();
    }

    @Override
    public void actionSubmitBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        StringBuffer sb = new StringBuffer("select fid from t_ivt_loaninterestbill where 1=1 and  ");
        sb.append(FMHelper.buildIn((String)"fid", (Object[])ids.toArray()));
        sb.append("and  FBillStatus = 1");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sb.toString()).executeSQL();
        HashSet<String> IDs = new HashSet<String>();
        while (rs.next()) {
            IDs.add(rs.getString(1));
        }
        if (IDs == null || IDs.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"94_LoanInterestBillListUI"));
            return;
        }
        LoanInterestBillFactory.getRemoteInstance().batchSubmit(IDs);
        this.refreshList();
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanbEdit();
        super.actionEdit_actionPerformed(e);
    }

    private void checkCanbEdit() throws Exception {
        this.checkSelected();
        LoanInterestBillInfo info = LoanInterestBillFactory.getRemoteInstance().getLoanInterestBillInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        if (info.getIntCalType() != IntCalTypeEnum.PRE_INT && info.getBillStatus() == IvtBillStatusEnum.BOOK) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"95_LoanInterestBillListUI"));
            SysUtil.abort();
        }
        if (info.isFivouchered()) {
            throw new CHLoanException(CHLoanException.LOANINTBILL_EDIT_ERROR1);
        }
        if (info.getStrikeStatus() == StrikeEnum.STRIKED) {
            throw new CHLoanException(CHLoanException.LOANINTBILL_EDIT_ERROR2);
        }
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        Set idSet = FMHelper.list2Set((List)idList);
        IMetaDataPK headPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.ivt.app.LoanInterestBillHeaderTDQuery");
        DefaultNoteDataProvider dataProvider = new DefaultNoteDataProvider(idSet, headPK);
        String mainDsName = "LoanInterestBillHeaderTDQuery";
        dataProvider.addMetaDataPK(mainDsName, headPK);
        dataProvider.addCustomFilterMaker(mainDsName, (DefaultNoteDataProvider.ICustomFilterMaker)new DefaultNoteDataProvider.DefaultIdFilterMaker(idSet));
        String entryDsName = "LoanInterestBillEntryTDQuery";
        IMetaDataPK entryPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.ivt.app.LoanInterestBillEntryTDQuery");
        dataProvider.addMetaDataPK(entryDsName, entryPK);
        dataProvider.addForeignKey((Object)entryDsName, "parentId");
        dataProvider.setBatchSupported(true);
        dataProvider.setNumberOfEachBatch(100);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(PAYMENTBILL_FILENAME, (Object)dataProvider, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        Set idSet = FMHelper.list2Set((List)idList);
        IMetaDataPK headPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.ivt.app.LoanInterestBillHeaderTDQuery");
        DefaultNoteDataProvider dataProvider = new DefaultNoteDataProvider(idSet, headPK);
        String mainDsName = "LoanInterestBillHeaderTDQuery";
        dataProvider.addMetaDataPK(mainDsName, headPK);
        dataProvider.addCustomFilterMaker(mainDsName, (DefaultNoteDataProvider.ICustomFilterMaker)new DefaultNoteDataProvider.DefaultIdFilterMaker(idSet));
        String entryDsName = "LoanInterestBillEntryTDQuery";
        IMetaDataPK entryPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.ivt.app.LoanInterestBillEntryTDQuery");
        dataProvider.addMetaDataPK(entryDsName, entryPK);
        dataProvider.addForeignKey((Object)entryDsName, "parentId");
        dataProvider.setBatchSupported(true);
        dataProvider.setNumberOfEachBatch(100);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(PAYMENTBILL_FILENAME, (Object)dataProvider, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionSubmitBill.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionPreInt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_autocount"));
        this.actionReceiveInt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_releasebymodule"));
        this.actionExitCurrent.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_quit"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dysz"));
        this.actionCancelBill.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_cancelverification"));
        this.actionUnCancelBill.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fcancelverification"));
        this.actionBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_post"));
        this.actionCancelBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_versapost"));
        this.actionNavInnerEreceipt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
    }

    @Override
    public String[] getMergeColumnKeys() {
        this.tblMain.checkParsed();
        int size = 2;
        String[] keys = new String[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = this.tblMain.getColumn(i).getKey();
        }
        return keys;
    }

    protected boolean showViewBdgBalanceBtn() {
        return true;
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (id != null) {
            SelectorItemCollection select = new SelectorItemCollection();
            select.add("*");
            select.add("fpItem.id");
            select.add("fpItem.name");
            select.add("fpItem.number");
            select.add("currency.id");
            select.add("currency.number");
            select.add("currency.name");
            select.add("company.*");
            select.add("fundFlowItem.*");
            LoanInterestBillInfo info = ((ILoanInterestBill)this.getBizInterface()).getLoanInterestBillInfo((IObjectPK)new ObjectUuidPK(id), select);
            FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.ivt.app.LoanInterestBill", null, (IObjectValue)info);
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
    }

    @Override
    protected boolean isFootVisible() {
        return true;
    }

    private void appendFootRowFromKDTabel() {
        String[] fieldsArray = this.getFieldSumListCustomer();
        for (int j = 0; j < fieldsArray.length; ++j) {
            BigDecimal dbSum = new BigDecimal("0");
            for (int i = 0; i <= this.tblMain.getRowCount() - 1; ++i) {
                ICell cell = this.tblMain.getRow(i).getCell(fieldsArray[j]);
                if (cell == null) continue;
                String cellValue = this.tblMain.getCellDisplayText(cell);
                if (cellValue != null) {
                    cellValue = cellValue.toString().replaceAll(",", "");
                }
                if (!StringUtility.isNumber((String)cellValue)) {
                    Object cellObj = cell.getValue();
                    if (cellObj != null) {
                        cellValue = cellObj.toString();
                    }
                    if (!StringUtility.isNumber((String)cellValue)) continue;
                }
                BigDecimal bigdem = new BigDecimal(String.valueOf(cellValue).trim());
                dbSum = dbSum.add(bigdem);
            }
            String strSum = dbSum.toString();
            this.columnMap.put(fieldsArray[j], strSum);
        }
        IRow footRow = null;
        KDTFootManager footRowManager = this.tblMain.getFootManager();
        if (footRowManager == null) {
            footRowManager = new KDTFootManager(this.tblMain);
            footRowManager.addFootView();
            this.tblMain.setFootManager(footRowManager);
        }
        if ((footRow = footRowManager.getFootRow(0)) == null) {
            String colFormat = "%{0.##########}f";
            String colName = "";
            footRow = footRowManager.addFootRow(0);
            String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
            this.tblMain.getIndexColumn().setWidthAdjustMode((short)1);
            this.tblMain.getIndexColumn().setWidth(30);
            footRowManager.addIndexText(0, total);
            footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
            for (Map.Entry colEntry : this.columnMap.entrySet()) {
                if (colEntry.getKey() == null) continue;
                String[] colArray = String.valueOf(colEntry.getKey()).split("@");
                colName = colArray[0];
                if (colArray.length > 1) {
                    colFormat = colArray[1];
                }
                if (footRow.getCell(colName) == null) continue;
                footRow.getCell(colName).getStyleAttributes().setNumberFormat(colFormat);
                footRow.getCell(colName).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                footRow.getCell(colName).getStyleAttributes().setFontColor(Color.BLACK);
            }
        }
        for (Map.Entry colEntry : this.columnMap.entrySet()) {
            if (colEntry.getKey() == null) continue;
            String colName = String.valueOf(colEntry.getKey());
            String colValue = (String)colEntry.getValue();
            if (footRow.getCell(colName) == null) continue;
            footRow.getCell(colName).setValue((Object)colValue);
        }
    }

    private String[] getFieldSumListCustomer() {
        return new String[]{"intTotalAmt", "yingjiInt", "shijiInt", "yingjiPenInt", "shijiPenInt", "chongzhangAMT", "unVerifyAmt"};
    }

    @Override
    public void actionBook_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.doBook();
        this.refresh(e);
    }

    private void doBook() throws Exception {
        int result;
        HashSet allSelected = new HashSet(this.getSelectedIdValues());
        Set toBeBooked = this.getToBeBookedIdSet(allSelected);
        if (toBeBooked.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"63_ChLoanListUI"));
            SysUtil.abort();
        }
        if (toBeBooked.size() > allSelected.size()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"unkownerror"));
            SysUtil.abort();
        } else if (toBeBooked.size() == allSelected.size()) {
            Object[] ids = toBeBooked.toArray();
            int count = 0;
            StringBuffer msgDetail = new StringBuffer();
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            for (int i = 0; i < ids.length; ++i) {
                LoanInterestBillInfo intInfo = LoanInterestBillFactory.getRemoteInstance().getLoanInterestBillInfo((IObjectPK)new ObjectUuidPK(ids[i].toString()), this.getSelectors());
                BigDecimal interestActual = FMHelper.add((BigDecimal)intInfo.getInterestAcctual(), (BigDecimal)intInfo.getPunishInterestActual());
                InnerAccountInfo innerAccountInfo = InnerAccountFactory.getRemoteInstance().getInnerAccountInfo((IObjectPK)new ObjectUuidPK(intInfo.getIntAccount().getId()));
                BigDecimal payeeInnerAcctBalance = FMHelper.getBalanceValue(null, (CurrencyInfo)((CurrencyInfo)intInfo.get("currency")), (InnerAccountInfo)intInfo.getIntAccount());
                AccountMgrStrategyInfo accountMgrStrategyInfo = innerAccountInfo.getCtrlParam();
                accountMgrStrategyInfo = AccountMgrStrategyFactory.getRemoteInstance().getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(accountMgrStrategyInfo.getId()), this.getAccountMgrStrategySelector());
                OverdraftCtrlEnum overdraftCtrl = accountMgrStrategyInfo.getOverdraftCtrl();
                if (!overdraftCtrl.equals((Object)OverdraftCtrlEnum.NOTCONTROL) || !accountMgrStrategyInfo.isRemind() || interestActual.compareTo(payeeInnerAcctBalance) <= 0) continue;
                ++count;
                numberFormat.setMaximumFractionDigits(intInfo.getCurrency().getPrecision());
                numberFormat.setMinimumFractionDigits(intInfo.getCurrency().getPrecision());
                String tmp = FMHelper.formatMessage(null, (String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"DraftDetail", (Object[])new String[]{intInfo.getLoanBill().getNumber(), intInfo.getIntAccount().getName(), numberFormat.format(payeeInnerAcctBalance), numberFormat.format(FMHelper.subtract((BigDecimal)interestActual, (BigDecimal)payeeInnerAcctBalance))});
                msgDetail.append(tmp + "\n");
            }
            int result2 = 0;
            if (count > 0) {
                result2 = MsgBox.showConfirm4a((String)FMHelper.formatMessage(null, (String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"DraftMain", (Object[])new String[]{String.valueOf(ids.length), String.valueOf(count)}), (String)msgDetail.toString());
            }
            if (result2 != 0) {
                SysUtil.abort();
            }
            for (int i = 0; i < ids.length; ++i) {
                LoanInterestBillInfo info = LoanInterestBillFactory.getRemoteInstance().getLoanInterestBillInfo((IObjectPK)new ObjectUuidPK(ids[i].toString()));
                String billId = info.getId().toString();
                String innerAccountID = info.getIntAccount().getId().toString();
                String currencyID = info.getCurrency().getId().toString();
                InnerAccountInfo innerAccountInfo = InnerAccountFactory.getRemoteInstance().getInnerAccountInfo((IObjectPK)new ObjectUuidPK(innerAccountID));
                CurrencyInfo currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID));
                info.setIntAccount(innerAccountInfo);
                info.setCurrency(currencyInfo);
                SubsidiaryLedgerInfo subsidiaryLedgerInfo = NTBookHelper.getLastBookSubsidiaryLedgerInfo(null, (String)billId);
            }
            LoanInterestBillFactory.getRemoteInstance().book(toBeBooked);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"operSucess_book"));
        } else if (toBeBooked.size() < allSelected.size() && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"bookoption"))) == 0) {
            try {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)toBeBooked, CompareType.INCLUDE));
                view.setFilter(filter);
                view.setSelector(this.getLoanInterestBillSelectors());
                LoanInterestBillCollection coll = LoanInterestBillFactory.getRemoteInstance().getLoanInterestBillCollection(view);
                for (int i = 0; i < coll.size(); ++i) {
                    LoanInterestBillInfo info = coll.get(i);
                    String billId = info.getId().toString();
                    String innerAccountID = info.getIntAccount().getId().toString();
                    String currencyID = info.getCurrency().getId().toString();
                    InnerAccountInfo innerAccountInfo = InnerAccountFactory.getRemoteInstance().getInnerAccountInfo((IObjectPK)new ObjectUuidPK(innerAccountID));
                    CurrencyInfo currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID));
                    info.setIntAccount(innerAccountInfo);
                    info.setCurrency(currencyInfo);
                    SubsidiaryLedgerInfo subInfo = NTBookHelper.getLastBookSubsidiaryLedgerInfo(null, (String)billId);
                    FMHelper.getBalanceValue(null, (CurrencyInfo)info.getCurrency(), (InnerAccountInfo)info.getIntAccount());
                }
                LoanInterestBillFactory.getRemoteInstance().book(toBeBooked);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"operSucess_book"));
            }
            catch (Exception ex) {
                MsgBox.showInfo((String)ex.getMessage());
                SysUtil.abort();
            }
        }
    }

    private Set getToBeBookedIdSet(Set allSelected) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", (Object)allSelected, CompareType.INCLUDE));
        f.getFilterItems().add(new FilterItemInfo("billStatus", (Object)IvtModualUtils.SUBMIT));
        f.getFilterItems().add(new FilterItemInfo("intCalType", (Object)PREINT, CompareType.NOTEQUALS));
        evi.setFilter(f);
        LoanInterestBillCollection toBeBooked = LoanInterestBillFactory.getRemoteInstance().getLoanInterestBillCollection(evi);
        HashSet<String> toBeBookIDSet = new HashSet<String>();
        int size = toBeBooked.size();
        if (toBeBooked != null && size > 0) {
            for (int i = 0; i < size; ++i) {
                toBeBookIDSet.add(toBeBooked.get(i).getId().toString());
            }
        }
        return toBeBookIDSet;
    }

    @Override
    public void actionCancelBook_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.doCancelBook();
        this.refresh(e);
    }

    private void doCancelBook() throws Exception {
        int result;
        HashSet allSelected;
        Set toBeBooked;
        String pk = this.getSelectedKeyValue();
        LoanInterestBillInfo info = LoanInterestBillFactory.getRemoteInstance().getLoanInterestBillInfo((IObjectPK)new ObjectUuidPK(pk));
        if (info.isIsCancel()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"96_LoanInterestBillListUI"));
            SysUtil.abort();
        }
        if ((toBeBooked = this.getToBeCancelBookedIdSet(allSelected = new HashSet(this.getSelectedIdValues()))).size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"63_ChLoanListUI"));
            SysUtil.abort();
        }
        if (toBeBooked.size() > allSelected.size()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"unkownerror"));
            SysUtil.abort();
        } else if (toBeBooked.size() == allSelected.size()) {
            LoanInterestBillFactory.getRemoteInstance().cancelBook(toBeBooked);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"operSucess_cancelbook"));
        } else if (toBeBooked.size() < allSelected.size() && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"cancelbookoption"))) == 0) {
            LoanInterestBillFactory.getRemoteInstance().cancelBook(toBeBooked);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"operSucess_cancelbook"));
        }
    }

    protected Set getToBeCancelBookedIdSet(Set allSelected) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", (Object)allSelected, CompareType.INCLUDE));
        f.getFilterItems().add(new FilterItemInfo("billStatus", (Object)IvtModualUtils.BOOK));
        f.getFilterItems().add(new FilterItemInfo("intCalType", (Object)IntCalTypeEnum.PRE_INT, CompareType.NOTEQUALS));
        f.getFilterItems().add(new FilterItemInfo("isDownLoaded", (Object)Boolean.FALSE, CompareType.EQUALS));
        evi.setFilter(f);
        LoanInterestBillCollection toBeBooked = LoanInterestBillFactory.getRemoteInstance().getLoanInterestBillCollection(evi);
        HashSet<String> toBeCancelBookIDSet = new HashSet<String>();
        int size = toBeBooked.size();
        if (toBeBooked != null && size > 0) {
            for (int i = 0; i < size; ++i) {
                toBeCancelBookIDSet.add(toBeBooked.get(i).getId().toString());
            }
        }
        return toBeCancelBookIDSet;
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkVoucher(e);
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkDelVoucher();
        super.actionDelVoucher_actionPerformed(e);
    }

    private void checkDelVoucher() throws EASBizException, BOSException {
        LoanInterestBillInfo info;
        this.checkSelected();
        if (IvtModualUtils.getSysParam(null, (String)"IVT009") && (info = LoanInterestBillFactory.getRemoteInstance().getLoanInterestBillInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()))).getIntCalType() == IntCalTypeEnum.REPAY_INT) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"97_LoanInterestBillListUI"));
            SysUtil.abort();
        }
    }

    private void checkVoucher(ActionEvent e) throws Exception {
        this.checkSelected();
        LoanInterestBillInfo info = LoanInterestBillFactory.getRemoteInstance().getLoanInterestBillInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        if (info.getIntCalType() != IntCalTypeEnum.PRE_INT && info.getBillStatus() != IvtBillStatusEnum.BOOK) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"98_LoanInterestBillListUI"));
            SysUtil.abort();
        }
        if (IvtModualUtils.getSysParam(null, (String)"IVT009") && info.getIntCalType() == IntCalTypeEnum.REPAY_INT) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"97_LoanInterestBillListUI"));
            SysUtil.abort();
        }
    }

    public boolean destroyWindow() {
        try {
            this.licenseService.releaseLicense();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            if (this.isEnterByPreInt) {
                boolean hasSavedBill;
                FilterInfo filte = new FilterInfo();
                filte.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(1)));
                this.mainQuery.getFilter().mergeFilter(filte, "AND");
                LoanInterestBillCollection col = LoanInterestBillFactory.getRemoteInstance().getLoanInterestBillCollection(this.mainQuery);
                boolean bl = hasSavedBill = col.size() > 0;
                if (hasSavedBill) {
                    boolean isSave;
                    int result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"93_LoanInterestBillListUI"));
                    boolean bl2 = isSave = result == 1;
                    if (isSave) {
                        return false;
                    }
                    this.isEnterByPreInt = false;
                    FilterInfo f = new FilterInfo();
                    f.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(1)));
                    this.mainQuery.getFilter().mergeFilter(f, "AND");
                    LoanInterestBillFactory.getRemoteInstance().delete(this.mainQuery.getFilter());
                }
            }
        }
        catch (Exception ex) {
            MsgBox.showWarning((Component)((Object)this), (String)ex.getMessage());
        }
        return super.destroyWindow();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return new ChLoanIntBillQueryProcessor();
    }

    @Override
    public void actionCancelBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkCancelBill();
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"VERIFY", (Object)"verify");
        uiCtx.put((Object)"ID", (Object)id);
        IUIWindow editUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(LoanInterestBillEditUI.class.getName(), (Map)uiCtx, null, OprtState.EDIT);
        editUI.show();
        this.refreshList();
    }

    @Override
    public void actionUnCancelBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkUnCancelBill();
        this.refreshList();
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.checkSelected();
        String pk = this.getSelectedKeyValue();
        LoanInterestBillInfo info = LoanInterestBillFactory.getRemoteInstance().getLoanInterestBillInfo((IObjectPK)new ObjectUuidPK(pk));
        this.actionUnCancelBill.setEnabled(false);
        this.actionCancelBill.setEnabled(false);
        BigDecimal maxPayAmount = Constants.ZERO;
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getIntAccount())) {
            String innerAccountID = info.getIntAccount().getId().toString();
            InnerAccountInfo innerAccountInfo = InnerAccountFactory.getRemoteInstance().getInnerAccountInfo((IObjectPK)new ObjectUuidPK(innerAccountID));
            info.setIntAccount(innerAccountInfo);
        }
        String currencyID = info.getCurrency().getId().toString();
        CurrencyInfo currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID));
        info.setCurrency(currencyInfo);
        maxPayAmount = FMHelper.getBalanceValue(null, (CurrencyInfo)info.getCurrency(), (InnerAccountInfo)info.getIntAccount());
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getIntAccount())) {
            AccountMgrStrategyInfo accountMgrStrategyInfo = info.getIntAccount().getCtrlParam();
            accountMgrStrategyInfo = AccountMgrStrategyFactory.getRemoteInstance().getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(accountMgrStrategyInfo.getId()), this.getAccountMgrStrategySelector());
            OverdraftCtrlEnum overdraftCtrl = accountMgrStrategyInfo.getOverdraftCtrl();
            if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.INLIMITCANOVERDRAFT)) {
                maxPayAmount = FMHelper.add((BigDecimal)maxPayAmount, (BigDecimal)accountMgrStrategyInfo.getOverDraftAmount());
            } else if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.LOWESTDEPOSITGUARANTEE)) {
                maxPayAmount = FMHelper.subtract((BigDecimal)maxPayAmount, (BigDecimal)accountMgrStrategyInfo.getLowestBalance());
            } else if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.NOTCONTROL)) {
                maxPayAmount = Constants.MAX_VALUE;
            } else if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.NOTALLOW)) {
                // empty if block
            }
        }
        if (info.getVerifySeq() > 0) {
            if (!info.isFivouchered()) {
                this.actionUnCancelBill.setEnabled(true);
            }
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionCancelBill.setEnabled(false);
            this.actionBook.setEnabled(false);
            this.actionCancelBook.setEnabled(false);
        } else {
            this.actionUnCancelBill.setEnabled(false);
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
            if (info.getUnVerifyAmount().compareTo(new BigDecimal("0")) == 1 && maxPayAmount.compareTo(Constants.ZERO) > 0 && info.getUnVerifyAmount().compareTo(Constants.ZERO) > 0) {
                this.actionCancelBill.setEnabled(true);
            }
            this.actionBook.setEnabled(true);
            this.actionCancelBook.setEnabled(true);
        }
    }

    private void checkCancelBill() throws EASBizException, BOSException {
        this.checkSelected();
        String pk = this.getSelectedKeyValue();
        LoanInterestBillInfo info = LoanInterestBillFactory.getRemoteInstance().getLoanInterestBillInfo((IObjectPK)new ObjectUuidPK(pk));
        String billId = info.getId().toString();
        BigDecimal maxPayAmount = Constants.ZERO;
        String innerAccountID = info.getIntAccount().getId().toString();
        String currencyID = info.getCurrency().getId().toString();
        InnerAccountInfo innerAccountInfo = InnerAccountFactory.getRemoteInstance().getInnerAccountInfo((IObjectPK)new ObjectUuidPK(innerAccountID));
        CurrencyInfo currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID));
        info.setIntAccount(innerAccountInfo);
        info.setCurrency(currencyInfo);
        maxPayAmount = FMHelper.getBalanceValue(null, (CurrencyInfo)info.getCurrency(), (InnerAccountInfo)info.getIntAccount());
        AccountMgrStrategyInfo accountMgrStrategyInfo = info.getIntAccount().getCtrlParam();
        accountMgrStrategyInfo = AccountMgrStrategyFactory.getRemoteInstance().getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(accountMgrStrategyInfo.getId()), this.getAccountMgrStrategySelector());
        OverdraftCtrlEnum overdraftCtrl = accountMgrStrategyInfo.getOverdraftCtrl();
        if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.INLIMITCANOVERDRAFT)) {
            maxPayAmount = FMHelper.add((BigDecimal)maxPayAmount, (BigDecimal)accountMgrStrategyInfo.getOverDraftAmount());
        } else if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.LOWESTDEPOSITGUARANTEE)) {
            maxPayAmount = FMHelper.subtract((BigDecimal)maxPayAmount, (BigDecimal)accountMgrStrategyInfo.getLowestBalance());
        } else if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.NOTCONTROL)) {
            maxPayAmount = Constants.MAX_VALUE;
        } else if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.NOTALLOW)) {
            // empty if block
        }
        if (maxPayAmount.compareTo(Constants.ZERO) <= 0 || info.getVerifySeq() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"99_LoanInterestBillListUI"));
            SysUtil.abort();
        }
    }

    private SelectorItemCollection getAccountMgrStrategySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("overdraftCtrl");
        sic.add("overDraftAmount");
        sic.add("lowestBalance");
        sic.add("remind");
        return sic;
    }

    private void checkUnCancelBill() throws EASBizException, BOSException {
        this.checkSelected();
        String pk = this.getSelectedKeyValue();
        LoanInterestBillFactory.getRemoteInstance().unCancelBill((IObjectPK)new ObjectUuidPK(pk));
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"100_LoanInterestBillListUI"));
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("intAccount.name"));
        sic.add(new SelectorItemInfo("intAccount.number"));
        sic.add(new SelectorItemInfo("intAccount.company"));
        sic.add(new SelectorItemInfo("loanBill.id"));
        sic.add(new SelectorItemInfo("loanBill.number"));
        sic.add(new SelectorItemInfo("fpItem.id"));
        sic.add(new SelectorItemInfo("fpItem.number"));
        sic.add(new SelectorItemInfo("fpItem.name"));
        sic.add(new SelectorItemInfo("fundFlowItem.*"));
        return sic;
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = this.getSelectors();
        sic.add("intAccount.*");
        return sic;
    }

    private void initTable() {
        this.tblMain.getColumn("bgItem").getStyleAttributes().setNumberFormat("@");
        this.tblMain.getColumn("startDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("endDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    protected BigDecimal getBalanceValue(CurrencyInfo currencyInfo, InnerAccountInfo innerAcctInfo) throws EASBizException, BOSException {
        if (currencyInfo == null || innerAcctInfo == null) {
            return Constants.ZERO;
        }
        String key = innerAcctInfo.getId().toString() + currencyInfo.getId().toString();
        ObjectUuidPK chCompanyPk = new ObjectUuidPK(innerAcctInfo.getCompany().getId());
        CompanyOrgUnitInfo chCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)chCompanyPk);
        BankInfo clearingHouse = BankFactory.getRemoteInstance().getClearingHouse(chCompany.getId().toString());
        Date unSettleDate = clearingHouse.getSettleDate();
        BigDecimal balance = InAcctFactory.getRemoteInstance().inAcct(chCompany.getNumber(), innerAcctInfo.getNumber(), currencyInfo.getNumber(), unSettleDate, unSettleDate, InAcctDataTypeEnum.K);
        if (balance == null) {
            return Constants.ZERO;
        }
        balance = balance.setScale(currencyInfo.getPrecision(), 4);
        return balance;
    }

    private SelectorItemCollection getLoanInterestBillSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("intAccount.name"));
        sic.add(new SelectorItemInfo("intAccount.number"));
        sic.add(new SelectorItemInfo("intAccount.company"));
        sic.add(new SelectorItemInfo("loanBill.id"));
        sic.add(new SelectorItemInfo("loanBill.number"));
        return sic;
    }

    @Override
    public void actionNavInnerEreceipt_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        EReceiptInnerClientHelper.viewInnerEreceiptByBillIdList((List)idList, (Component)((Object)this));
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(LoanInterestBillListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            String currencyId = null;
            String rateDisplay = "";
            String statusDisplay = "";
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                BizEnumValueDTO strikeStatus;
                row = tblMain.getRow(i);
                this.setRow(row, rateDisplay, statusDisplay);
                currencyId = (String)row.getCell("currencyID").getValue();
                if (currencyId != null) {
                    this.setAmtCellNumberFormat(row, currencyId);
                }
                if (EmptyUtil.isEmpty((Object)row.getCell("strikeStatus").getValue()) || !(strikeStatus = (BizEnumValueDTO)row.getCell("strikeStatus").getValue()).getValue().equals("null")) continue;
                row.getCell("strikeStatus").setValue((Object)"");
            }
        }

        private void setRow(IRow row, String rateDisplay, String statusDisplay) {
            BizEnumValueInfo exp = (BizEnumValueInfo)row.getCell("intRateExpression").getValue();
            BigDecimal rate = (BigDecimal)row.getCell("yearRate").getValue();
            row.getCell("rate").setValue((Object)rate);
            BigDecimal peneRate = (BigDecimal)row.getCell("peneRate").getValue();
            row.getCell("penaRateDispaly").setValue((Object)peneRate);
            Object enu = exp.getValue();
            if ("year".equalsIgnoreCase(enu.toString())) {
                row.getCell("rate").getStyleAttributes().setNumberFormat("#,##0.00000\\%");
            } else {
                row.getCell("rate").getStyleAttributes().setNumberFormat("#,##0.00000\\\u2030");
            }
            row.getCell("rate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            exp = (BizEnumValueInfo)row.getCell("peneWay").getValue();
            enu = exp.getValue();
            if ("addaccrual".equals(enu.toString())) {
                row.getCell("penaRateDispaly").getStyleAttributes().setNumberFormat("#,##0.00000\\\u2030");
            } else {
                row.getCell("penaRateDispaly").getStyleAttributes().setNumberFormat("#,##0.00000\\%");
            }
            row.getCell("penaRateDispaly").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("overDueDays").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }

        private void setAmtCellNumberFormat(IRow row, String currencyId) {
            FMClientHelper.setNumberFormat((IRow)row, (String)"intTotalAmt", (String)currencyId);
            FMClientHelper.setNumberFormat((IRow)row, (String)"yingjiInt", (String)currencyId);
            FMClientHelper.setNumberFormat((IRow)row, (String)"shijiInt", (String)currencyId);
            FMClientHelper.setNumberFormat((IRow)row, (String)"yingjiPenInt", (String)currencyId);
            FMClientHelper.setNumberFormat((IRow)row, (String)"shijiPenInt", (String)currencyId);
            FMClientHelper.setNumberFormat((IRow)row, (String)"chongzhangAMT", (String)currencyId);
            FMClientHelper.setNumberFormat((IRow)row, (String)"unVerifyAmt", (String)currencyId);
            FMClientHelper.setNumberFormat((IRow)row, (String)"verifyAmount", (String)currencyId);
        }
    }
}

