/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMDetailRptBaseHandler;
import com.kingdee.eas.fm.common.client.IFMDetailRptHandler;
import com.kingdee.eas.fm.ivt.ChLoanHelper;
import com.kingdee.eas.fm.ivt.LoanStatisticalUnitEnum;
import com.kingdee.eas.fm.ivt.client.RptChloanDetailFilterParam;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.awt.Color;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Locale;

public class RptChLoanDetailHandlerAdapter
extends FMDetailRptBaseHandler
implements IFMDetailRptHandler {
    private static String YES = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"Yes");
    private static String NO = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"No");
    private CompanyOrgUnitInfo currentCompany;
    private String queryType;
    private Date endDate;
    private LoanStatisticalUnitEnum amountUnit;
    private String[] currencyIDs;
    private String[] loanCompanyIDs;
    private boolean includeZero;
    private RptChloanDetailFilterParam params;
    private String unit = "1";
    private String orderByColumn;
    private String horizon;
    private String orderByFromSumMainUI;
    private String loanProID;
    private int precisionLocalCurrency = 2;

    public RptChLoanDetailHandlerAdapter(FilterInfo filterInfo, SorterItemCollection sorter, KDTable kdt) {
        super(filterInfo, sorter, kdt);
    }

    public RptChLoanDetailHandlerAdapter(KDTable tblMain, FilterInfo filterInfo) {
        super(filterInfo, tblMain);
    }

    protected void prepare() {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            CurrencyInfo baseCurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.currentCompany);
            this.precisionLocalCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrency.getId())).getPrecision();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.queryType = this.params.getQueryType();
        this.orderByColumn = "by_company".equals(this.queryType) ? " loanCompanyName" : ("by_loanProduct".equals(this.queryType) ? " finproName" : " fcurrencyName");
        this.endDate = this.params.getEndDate();
        this.amountUnit = this.params.getLoanStatisticalUnitEnum();
        this.currencyIDs = this.params.getCurrencyIDs();
        this.loanCompanyIDs = this.params.getLoanCompanyIDs();
        this.includeZero = this.params.getIsIncludeZero();
        this.horizon = this.params.getHorizon();
        this.loanProID = this.params.getLoanProductId();
        this.orderByFromSumMainUI = this.params.getOrderByFromSumMainUI();
        if (this.amountUnit.equals((Object)LoanStatisticalUnitEnum.THOUSAND)) {
            this.unit = "1000";
        } else if (this.amountUnit.equals((Object)LoanStatisticalUnitEnum.TEN_THOUSAND)) {
            this.unit = "10000";
        } else if (this.amountUnit.equals((Object)LoanStatisticalUnitEnum.MILLION)) {
            this.unit = "1000000";
        } else if (this.amountUnit.equals((Object)LoanStatisticalUnitEnum.HUNDRED_THOUSAND)) {
            this.unit = "10000000";
        } else if (this.amountUnit.equals((Object)LoanStatisticalUnitEnum.HUNDRED_MILLION)) {
            this.unit = "100000000";
        }
    }

    private String getValues(String[] currencyIDs) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < currencyIDs.length; ++i) {
            sb.append("'").append(currencyIDs[i]).append("'");
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb = sb.deleteCharAt(sb.length() - 1);
        }
        return "(" + sb.toString() + ")";
    }

    public void setChloanDetailFilterParam(RptChloanDetailFilterParam rptChloanDetailFilterParam) {
        this.params = rptChloanDetailFilterParam;
    }

    public void initHeader() {
        super.initHeader();
    }

    protected void initTable() {
        this.kdt.getGroupManager().setTotalize(true);
        this.initCustomHeader();
        this.initCommonColumn();
        IRow row = this.formatCommonHeadRow();
        this.formatCustomerHeadRow(row);
        IRow rowH = this.kdt.addHeadRow();
        this.kdt.getHeadMergeManager().mergeBlock(0, 0, 1, 0);
        this.kdt.getHeadMergeManager().mergeBlock(0, 1, 1, 1);
        this.kdt.getHeadMergeManager().mergeBlock(0, 2, 1, 2);
        this.kdt.getHeadMergeManager().mergeBlock(0, 3, 1, 3);
        this.kdt.getHeadMergeManager().mergeBlock(0, 4, 1, 4);
        this.kdt.getHeadMergeManager().mergeBlock(0, 5, 1, 5);
        this.kdt.getHeadMergeManager().mergeBlock(0, 6, 0, 7);
        rowH.getCell("loanAmt").setValue((Object)this.getResString("rpt_detail_header_loanamt"));
        rowH.getCell("loanAmtLocal").setValue((Object)this.getResString("rpt_detail_header_loanamt_local"));
        this.kdt.getHeadMergeManager().mergeBlock(0, 8, 0, 9);
        rowH.getCell("repayAmt").setValue((Object)this.getResString("rpt_detail_header_repayamt"));
        rowH.getCell("repayAmtLocal").setValue((Object)this.getResString("rpt_detail_header_repayamt_local"));
        this.kdt.getHeadMergeManager().mergeBlock(0, 10, 0, 11);
        rowH.getCell("balance").setValue((Object)this.getResString("rpt_detail_header_balance"));
        rowH.getCell("balanceLocal").setValue((Object)this.getResString("rpt_detail_header_balance_local"));
        this.kdt.getHeadMergeManager().mergeBlock(0, 12, 1, 12);
        this.kdt.getHeadMergeManager().mergeBlock(0, 13, 1, 13);
        this.kdt.getHeadMergeManager().mergeBlock(0, 14, 1, 14);
        this.kdt.getHeadMergeManager().mergeBlock(0, 15, 1, 15);
        this.kdt.getHeadMergeManager().mergeBlock(0, 16, 1, 16);
        this.kdt.getHeadMergeManager().mergeBlock(0, 17, 1, 17);
        this.kdt.getHeadMergeManager().mergeBlock(0, 18, 1, 18);
    }

    protected void initCustomHeader() {
    }

    protected void formatCustomerHeadRow(IRow row) {
    }

    protected IRow formatCommonHeadRow() {
        IRow headRow = this.kdt.addHeadRow();
        headRow.getCell("number").setValue((Object)this.getResString("rpt_detail_header_number"));
        headRow.getCell("exchangerate").setValue((Object)this.getResString("rpt_detail_header_exchangerate"));
        headRow.getCell("loanAmt").setValue((Object)this.getResString("rpt_detail_header_loanamt_title"));
        headRow.getCell("loanAmtLocal").setValue((Object)this.getResString("rpt_detail_header_loanamt_title"));
        headRow.getCell("repayAmt").setValue((Object)this.getResString("rpt_detail_header_repayamt_title"));
        headRow.getCell("repayAmtLocal").setValue((Object)this.getResString("rpt_detail_header_repayamt_title"));
        headRow.getCell("balance").setValue((Object)this.getResString("rpt_detail_header_balance_title"));
        headRow.getCell("balanceLocal").setValue((Object)this.getResString("rpt_detail_header_balance_title"));
        headRow.getCell("rateType").setValue((Object)this.getResString("rpt_detail_header_ratetype"));
        headRow.getCell("rateexpression").setValue((Object)this.getResString("rpt_detail_header_rateexpression"));
        headRow.getCell("yearType").setValue((Object)this.getResString("rpt_detail_header_yearrate"));
        headRow.getCell("startDate").setValue((Object)this.getResString("rpt_detail_header_startdate"));
        headRow.getCell("endDate").setValue((Object)this.getResString("rpt_detail_header_enddate"));
        headRow.getCell("isOverDue").setValue((Object)this.getResString("rpt_detail_header_isoverdue"));
        headRow.getCell("diggest").setValue((Object)this.getResString("rpt_detail_header_diggest"));
        return headRow;
    }

    protected String getResString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)key);
    }

    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        super.filldata(rs);
    }

    public void setTableStateRow() {
        this.queryType = this.params.getQueryType();
        if ("by_company".equals(this.queryType)) {
            this.kdt.getColumn("loanCompany").setStat(true);
        } else if ("by_loanProduct".equals(this.queryType)) {
            this.kdt.getColumn("loanProduct").setStat(true);
        } else {
            this.kdt.getColumn("currency").setStat(true);
        }
        this.kdt.getColumn("loanTerm").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        IRow rowLongTime = this.kdt.getGroupManager().getStatRowTemplate(1);
        rowLongTime.getCell(1).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"103_RptChLoanDetailHandlerAdapter"));
        rowLongTime.getCell(1).getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        rowLongTime.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        rowLongTime.getCell("loanAmtLocal").setExpressions("SUM");
        rowLongTime.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTime.getCell("loanAmtLocal").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        this.initDecimalCol(rowLongTime.getCell("loanAmtLocal"), this.precisionLocalCurrency);
        rowLongTime.getCell("repayAmtLocal").setExpressions("SUM");
        rowLongTime.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTime.getCell("repayAmtLocal").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        this.initDecimalCol(rowLongTime.getCell("repayAmtLocal"), this.precisionLocalCurrency);
        rowLongTime.getCell("balanceLocal").setExpressions("SUM");
        rowLongTime.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTime.getCell("balanceLocal").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        this.initDecimalCol(rowLongTime.getCell("balanceLocal"), this.precisionLocalCurrency);
        IRow rowLongTime0 = this.kdt.getGroupManager().getStatRowTemplate(-1);
        rowLongTime0.getCell("loanAmtLocal").setExpressions("SUM");
        this.initDecimalCol(rowLongTime0.getCell("loanAmtLocal"), this.precisionLocalCurrency);
        rowLongTime0.getCell("repayAmtLocal").setExpressions("SUM");
        this.initDecimalCol(rowLongTime0.getCell("repayAmtLocal"), this.precisionLocalCurrency);
        rowLongTime0.getCell("balanceLocal").setExpressions("SUM");
        this.initDecimalCol(rowLongTime0.getCell("balanceLocal"), this.precisionLocalCurrency);
        rowLongTime0.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"104_RptChLoanDetailHandlerAdapter"));
        rowLongTime0.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
    }

    private void initDecimalCell(ICell cell) {
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        cell.getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
    }

    public void endDataFill() {
        super.endDataFill();
        this.kdt.getSelectManager().setSelectMode(2);
    }

    public IRowSet getRowSet() throws BOSException {
        String sql = this.getDetailSQL();
        return SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
    }

    private String getDetailSQL() {
        String loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        StringBuffer sb = new StringBuffer();
        sb.append("select * from                                                                                                                \n");
        sb.append("(                                                                                                                            \n");
        sb.append("select detailtbl.*, (loanamttotal-balance) as repaytotalamt,                                                                 \n");
        sb.append("          (loanAmtLocal-balanceLocal) as repaytotalamtLocal from                                                              \n");
        sb.append("(                                                                                                                            \n");
        sb.append("  select chloan.ffinacingproductid as ffinacingproductid,chloan.fcurrencyid as fcurrencyid,                                  \n");
        sb.append("       chloan.floancompanyid as floancompanyid,isnull(fratetypeid,'10001') as fratetypeid,                                      \n");
        sb.append("       finpro.fname_").append(loc).append("  as finproName,cur.fname_").append(loc).append("  as fcurrencyName,                                                          \n");
        sb.append(EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"105_RptChLoanDetailHandlerAdapter"));
        sb.append("       chloan.fnumber as fnumber, chloan.fid as fid,                                                                         \n");
        sb.append(EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"106_RptChLoanDetailHandlerAdapter"));
        sb.append(EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"107_RptChLoanDetailHandlerAdapter"));
        sb.append("            end                                                                                                              \n");
        sb.append("       ) as fhorizon,                                                                                                        \n");
        sb.append("  (case when chloan.fhorizon<=12 or fhorizon is null then '[shorthorizon]'        ");
        sb.append("             else '[longhorizon]'     ");
        sb.append("  end  ");
        sb.append("       ) as fhorizonStr,  ");
        sb.append("       chloan.fstartdate as startdate,chloan.fenddate as enddate,                                                            \n");
        sb.append("       chloan.fisoverdue as isovedue,chloan.fdescription as diggest,                                                         \n");
        sb.append(" (                                                                                 \n");
        sb.append(" chloan.floantotalamt/" + this.unit + "\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sb.append(" ) as loanamttotal,                                                                \n");
        sb.append("                                                                                   \n");
        sb.append(" (                                                                                 \n");
        sb.append(" (chloan.floantotalamt*chloan.fexchangerate)/" + this.unit + "\t\t\t\t\t\t\t\n");
        sb.append(" ) as loanAmtLocal,                                                                \n");
        sb.append(" (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sb.append(" chloan.floanbalance/" + this.unit + " + (select isnull(sum(frepayamt)/" + this.unit + " ,0) \t\t\n");
        sb.append(" from t_ivt_entrepaymentbill where floanbillidid = chloan.fid and FRepayDate>={\t\n");
        sb.append(FMConstants.FORMAT_TIME.format(DateUtil.getAfterDay((java.util.Date)this.endDate)) + "})\t\t\t\t\t\t\t\t\t\t\t\n");
        sb.append(" ) as balance, \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sb.append(" (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sb.append(" chloan.floanbalance*chloan.fexchangerate/" + this.unit + " + (select isnull(sum(frepayamt)*chloan.fexchangerate/" + this.unit + " ,0) \t\t\t\t\t\t");
        sb.append(" from t_ivt_entrepaymentbill where floanbillidid = chloan.fid and FRepayDate>={\t\n");
        sb.append(FMConstants.FORMAT_TIME.format(DateUtil.getAfterDay((java.util.Date)this.endDate)) + "})\t\t\t\t\t\t\t\t\t\t\t\n");
        sb.append(" ) as balanceLocal,\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sb.append("  chloan.fexchangerate as exchangerate,                                                                 ");
        sb.append(" chloan.fintratetypeexpression, \n");
        sb.append("\t         (case chloan.fintratetypeexpression                                                           ");
        sb.append(EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"125_RptChLoanDetailHandlerAdapter"));
        sb.append(EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"126_RptChLoanDetailHandlerAdapter"));
        sb.append(EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"127_RptChLoanDetailHandlerAdapter"));
        sb.append("\t               end                                                                                     ");
        sb.append("\t         )  as  intratetypeexpression ,                                                                ");
        sb.append("\t               fyearrate  as  yearrate                                                                               ");
        sb.append("  from t_ivt_chloan chloan                                                                                                   \n");
        sb.append("  left outer join  t_org_company com on com.fid = chloan.floancompanyid                                                      \n");
        sb.append("  left outer join  t_bd_currency cur on cur.fid = chloan.fcurrencyid                                                         \n");
        sb.append("  left outer join  t_fin_financingproducts finpro on finpro.fid = chloan.ffinacingproductid                                  \n");
        sb.append("  left outer join  T_INT_IntRateType rateType on rateType.fid = chloan.fratetypeid                                           \n");
        sb.append(" where ").append(this.getCommonFilterToChLoan());
        sb.append(")  detailtbl                                                                                                                 \n");
        sb.append(")  as t \n");
        if (!this.includeZero) {
            if (this.horizon != null) {
                sb.append(" where fhorizonStr = '" + this.horizon + "' and balance>0 order by fhorizon,").append(this.orderByFromSumMainUI);
            } else {
                sb.append(" where balance>0 order by fhorizon,").append(this.orderByColumn);
            }
        } else if (this.horizon != null) {
            sb.append("  where fhorizonStr = '" + this.horizon + "' order by fhorizon,").append(this.orderByFromSumMainUI);
        } else {
            sb.append("  order by fhorizon,").append(this.orderByColumn);
        }
        return sb.toString();
    }

    private String getCommonFilterToChLoan() {
        StringBuffer sb = new StringBuffer();
        sb.append("( chloan.FEffectedStatus = 2 and chloan.fcompanyid = '").append(this.currentCompany.getId().toString()).append("' ");
        if (this.currencyIDs != null && this.currencyIDs.length > 0) {
            sb.append(" and chloan.fcurrencyid in ").append(this.getValues(this.currencyIDs));
        }
        if (this.loanCompanyIDs != null && this.loanCompanyIDs.length > 0) {
            sb.append(" and chloan.FLoanCompanyID in ").append(this.getValues(this.loanCompanyIDs));
        }
        if (this.endDate != null) {
            sb.append("and chloan.fbizDate <={").append(FMConstants.FORMAT_TIME.format(this.endDate)).append("} ");
        }
        if (this.loanProID != null) {
            sb.append(" and  chloan.ffinacingproductid = '").append(this.loanProID).append("' ");
        }
        sb.append(")");
        return sb.toString();
    }

    protected void initCommonColumn() {
        IColumn cNumber = this.kdt.addColumn();
        cNumber.setKey("number");
        IColumn cExchangeRate = this.kdt.addColumn();
        cExchangeRate.setKey("exchangerate");
        IColumn cLoanAmt = this.kdt.addColumn();
        cLoanAmt.setKey("loanAmt");
        IColumn cLoanAmtLocal = this.kdt.addColumn();
        cLoanAmtLocal.setKey("loanAmtLocal");
        IColumn cRepayAmt = this.kdt.addColumn();
        cRepayAmt.setKey("repayAmt");
        IColumn cRepayAmtLocal = this.kdt.addColumn();
        cRepayAmtLocal.setKey("repayAmtLocal");
        IColumn cBalance = this.kdt.addColumn();
        cBalance.setKey("balance");
        IColumn cBalanceLocal = this.kdt.addColumn();
        cBalanceLocal.setKey("balanceLocal");
        IColumn cRateType = this.kdt.addColumn();
        cRateType.setKey("rateType");
        IColumn cRateExpression = this.kdt.addColumn();
        cRateExpression.setKey("rateexpression");
        IColumn cYearRate = this.kdt.addColumn();
        cYearRate.setKey("yearType");
        IColumn cStartDate = this.kdt.addColumn();
        cStartDate.setKey("startDate");
        IColumn cEndDate = this.kdt.addColumn();
        cEndDate.setKey("endDate");
        IColumn cIsOverDue = this.kdt.addColumn();
        cIsOverDue.setKey("isOverDue");
        IColumn cDiggest = this.kdt.addColumn();
        cDiggest.setKey("diggest");
        IColumn cID = this.kdt.addColumn();
        cID.setKey("id");
        cID.getStyleAttributes().setHided(true);
        IColumn cCurrencyID = this.kdt.addColumn();
        cCurrencyID.setKey("currencyid");
        cCurrencyID.getStyleAttributes().setHided(true);
    }

    protected void setContentToCommonColumn(IRow row, IRowSet rs) throws SQLException {
        row.getCell("currencyid").setValue(rs.getObject("fcurrencyid"));
        String currencyID = (String)rs.getObject("fcurrencyid");
        int precision = 2;
        try {
            precision = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID)).getPrecision();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        row.getCell("number").setValue(rs.getObject("fnumber"));
        row.getCell("exchangerate").setValue(rs.getObject("exchangerate"));
        this.initDecimalCol(row.getCell("exchangerate"), "%r{#,##0.0000}f");
        row.getCell("loanAmt").setValue(rs.getObject("loanamttotal"));
        this.initDecimalCol(row.getCell("loanAmt"), precision);
        row.getCell("loanAmtLocal").setValue(rs.getObject("loanamtlocal"));
        this.initDecimalCol(row.getCell("loanAmtLocal"), this.precisionLocalCurrency);
        row.getCell("repayAmt").setValue(rs.getObject("repaytotalamt"));
        this.initDecimalCol(row.getCell("repayAmt"), precision);
        row.getCell("repayAmtLocal").setValue(rs.getObject("repaytotalamtlocal"));
        this.initDecimalCol(row.getCell("repayAmtLocal"), this.precisionLocalCurrency);
        row.getCell("balance").setValue(rs.getObject("balance"));
        this.initDecimalCol(row.getCell("balance"), precision);
        row.getCell("balanceLocal").setValue(rs.getObject("balancelocal"));
        this.initDecimalCol(row.getCell("balanceLocal"), this.precisionLocalCurrency);
        row.getCell("rateType").setValue(rs.getObject("ratetypename"));
        row.getCell("rateexpression").setValue(rs.getObject("intratetypeexpression"));
        row.getCell("yearType").setValue(rs.getObject("yearrate"));
        if (rs.getObject("fintratetypeexpression") != null && rs.getObject("fintratetypeexpression").toString().equals("year")) {
            row.getCell("yearType").getStyleAttributes().setNumberFormat("#,##0.00\\%");
        } else {
            row.getCell("yearType").getStyleAttributes().setNumberFormat("#,##0.00\\\u2030");
        }
        row.getCell("yearType").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("startDate").setValue((Object)rs.getDate("startdate"));
        row.getCell("endDate").setValue((Object)rs.getDate("enddate"));
        row.getCell("isOverDue").setValue((Object)(rs.getBoolean("isovedue") ? YES : NO));
        row.getCell("diggest").setValue(rs.getObject("diggest"));
        row.getCell("id").setValue(rs.getObject("fid"));
    }

    private void initDecimalCol(ICell cell, int precision) {
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        cell.getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)precision));
    }

    private void initDecimalCol(ICell cell, String format) {
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        cell.getStyleAttributes().setNumberFormat(format);
    }

    protected String getQueryPath() {
        return "";
    }

    private String formatYearRate(Object value) {
        String valueStr = "";
        if (value != null) {
            valueStr = value.toString();
            valueStr = ChLoanHelper.getInstance().trimZero(valueStr, valueStr.substring(valueStr.length() - 1, valueStr.length()));
        }
        return valueStr;
    }
}

