/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.ivt.LoanStatisticalUnitEnum;
import com.kingdee.eas.fm.ivt.client.AbstractRptChloanDetailFilterUI;
import com.kingdee.eas.fm.ivt.client.RptChloanDetailFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;

public class RptChloanDetailFilterUI
extends AbstractRptChloanDetailFilterUI {
    protected void init() throws Exception {
        super.init();
        this.dpEndDate.setSupportedEmpty(false);
        this.customInit();
        this.prmtLoanCompany.setSelector((KDPromptSelector)F7SelectorFactory.getSelectCompany((IUIObject)this, null, null, (boolean)true));
    }

    public void clear() {
        super.clear();
        this.customInit();
    }

    private void customInit() {
        this.initDate();
        this.byLoanCompany.setSelected(true);
        this.prmtLoanCompany.setValue(null);
        this.prmtCurrency.setValue(null);
        this.chkIncludeZero.setSelected(false);
        FMClientHelper.setSelectObject((KDComboBox)this.comboUnit, (Object)((Object)LoanStatisticalUnitEnum.TEN_THOUSAND));
    }

    private void initDate() {
        this.dpEndDate.setValue((Object)DateUtil.getDayBegin());
    }

    public Object getParam() {
        RptChloanDetailFilterParam filterParam = new RptChloanDetailFilterParam();
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            filterParam.setCompanyIdSet(this.getCompanyIdSet());
        }
        filterParam.setEndDate(this.dpEndDate.getSqlDate());
        filterParam.setCurrencyIDs(AccessHelper.getF7Ids((KDBizPromptBox)this.prmtCurrency));
        filterParam.setLoanCompanyIDs(AccessHelper.getF7Ids((KDBizPromptBox)this.prmtLoanCompany));
        filterParam.setLoanStatisticalUnitEnum((LoanStatisticalUnitEnum)((Object)this.comboUnit.getSelectedItem()));
        filterParam.setIsIncludeZero(this.chkIncludeZero.isSelected());
        if (this.byLoanCompany.isSelected()) {
            filterParam.setQueryType("by_company");
        } else if (this.byLoanProducts.isSelected()) {
            filterParam.setQueryType("by_loanProduct");
        } else if (this.byCurrency.isSelected()) {
            filterParam.setQueryType("by_currency");
        }
        return filterParam;
    }

    public void setParam(Object param) {
        RptChloanDetailFilterParam filterParam = (RptChloanDetailFilterParam)((Object)param);
        this.setCompanyIdSet(filterParam.getCompanyIdSet());
        this.dpEndDate.setValue((Object)filterParam.getEndDate());
        try {
            this.prmtLoanCompany.setValue((Object)this.getBaseInfoFromIdSet(FMHelper.asSet((String[])filterParam.getLoanCompanyIDs())));
            this.prmtCurrency.setValue((Object)this.getBaseInfoFromIdSet(FMHelper.asSet((String[])filterParam.getCurrencyIDs())));
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        this.chkIncludeZero.setSelected(filterParam.getIsIncludeZero());
        if (filterParam.getLoanStatisticalUnitEnum() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboUnit, (Object)((Object)filterParam.getLoanStatisticalUnitEnum()));
        }
        if ("by_company".equals(filterParam.getQueryType())) {
            this.byLoanCompany.setSelected(true);
        } else if ("by_loanProduct".equals(filterParam.getQueryType())) {
            this.byLoanProducts.setSelected(true);
        } else {
            this.byCurrency.setSelected(true);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.dpEndDate.setSupportedEmpty(false);
    }

    public boolean verify() {
        if (this.comboUnit.getSelectedItem() == null) {
            this.comboUnit.setSelectedItem((Object)LoanStatisticalUnitEnum.TEN_THOUSAND);
        }
        return super.verify();
    }

    protected Class getParamClass() {
        return RptChloanDetailFilterParam.class;
    }
}

