/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.IFMDetailRptHandler;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.ivt.EarnTypeEnum;
import com.kingdee.eas.fm.ivt.FinancingAccountFactory;
import com.kingdee.eas.fm.ivt.FinancingAccountInfo;
import com.kingdee.eas.fm.ivt.FinancingRedeemCollection;
import com.kingdee.eas.fm.ivt.FinancingRedeemFactory;
import com.kingdee.eas.fm.ivt.FinancingRedeemInfo;
import com.kingdee.eas.fm.ivt.FinancingStateEnum;
import com.kingdee.eas.fm.ivt.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.ivt.RptFinancingInterestFilterParam;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class RptFinancingInterestHandler
implements IFMDetailRptHandler {
    protected KDTable kdtable;
    private RptFinancingInterestFilterParam param;
    private Date begindate;
    private Date enddate;
    private BigDecimal exchangeRate = Constants.ONE;
    private int persion;
    private BigDecimal bdUnit;
    private static String yes = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"Yes");
    private static String no = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"No");
    protected static final String IVT_RES = "com.kingdee.eas.fm.ivt.IVTFINANCINGResource";

    protected RptFinancingInterestHandler(KDTable kdtable, RptFinancingInterestFilterParam filterParam) {
        this.kdtable = kdtable;
        this.param = filterParam;
    }

    public void initHeader() {
        this.initFirstHeader();
        IColumn colRate = this.kdtable.addColumn();
        colRate.setKey("rate");
        RptFinancingInterestHandler.initDecimalCell(colRate);
        IColumn colNumber = this.kdtable.addColumn();
        colNumber.setKey("number");
        IColumn colAmount = this.kdtable.addColumn();
        colAmount.setKey("amount");
        RptFinancingInterestHandler.initDecimalCell(colAmount);
        IColumn colfinanceLocAmount = this.kdtable.addColumn();
        colfinanceLocAmount.setKey("financeLocAmount");
        RptFinancingInterestHandler.initDecimalCell(colfinanceLocAmount);
        IColumn colbalance = this.kdtable.addColumn();
        colbalance.setKey("balance");
        RptFinancingInterestHandler.initDecimalCell(colbalance);
        IColumn colstate = this.kdtable.addColumn();
        colstate.setKey("state");
        IColumn colbeginDate = this.kdtable.addColumn();
        colbeginDate.setKey("beginDate");
        IColumn colendDate = this.kdtable.addColumn();
        colendDate.setKey("endDate");
        IColumn colterm = this.kdtable.addColumn();
        colterm.setKey("term");
        IColumn colpredictYield = this.kdtable.addColumn();
        colpredictYield.setKey("predictYield");
        RptFinancingInterestHandler.initDecimalCell(colpredictYield);
        IColumn colintRateTypeExpression = this.kdtable.addColumn();
        colintRateTypeExpression.setKey("intRateTypeExpression");
        IColumn coldays = this.kdtable.addColumn();
        coldays.setKey("days");
        IColumn colDatefrom = this.kdtable.addColumn();
        colDatefrom.setKey("Datefrom");
        IColumn colDateto = this.kdtable.addColumn();
        colDateto.setKey("Dateto");
        IColumn colintersteDays = this.kdtable.addColumn();
        colintersteDays.setKey("intersteDays");
        IColumn colintersteAmount = this.kdtable.addColumn();
        colintersteAmount.setKey("intersteAmount");
        RptFinancingInterestHandler.initDecimalCell(colintersteAmount);
        IColumn colintersteLocAmount = this.kdtable.addColumn();
        colintersteLocAmount.setKey("intersteLocAmount");
        RptFinancingInterestHandler.initDecimalCell(colintersteLocAmount);
        IColumn colisNoOut = this.kdtable.addColumn();
        colisNoOut.setKey("isNoOut");
        IColumn colearnType = this.kdtable.addColumn();
        colearnType.setKey("earnType");
        this.formatHeadRow();
    }

    private void initFirstHeader() {
        switch (this.param.getDimType()) {
            case 1: {
                this.setComapnyPanel();
                break;
            }
            case 2: {
                this.setBankPanel();
                break;
            }
            case 3: {
                this.setFinanceFinancingPanel();
                break;
            }
            case 4: {
                this.setCurrencyPanel();
                break;
            }
            case 5: {
                this.setaccountPanel();
                break;
            }
            default: {
                this.setComapnyPanel();
            }
        }
    }

    private void setaccountPanel() {
        IColumn colaccountNumber = this.kdtable.addColumn();
        colaccountNumber.setKey("accountBank");
        colaccountNumber.setMergeable(true);
        colaccountNumber.setGroup(true);
        IColumn colCompany = this.kdtable.addColumn();
        colCompany.setKey("company");
        IColumn colBank = this.kdtable.addColumn();
        colBank.setKey("bank");
        IColumn colFinanceFinancing = this.kdtable.addColumn();
        colFinanceFinancing.setKey("financeFinancing");
        IColumn colCurrency = this.kdtable.addColumn();
        colCurrency.setKey("currency");
    }

    private void setCurrencyPanel() {
        IColumn colCurrency = this.kdtable.addColumn();
        colCurrency.setKey("currency");
        colCurrency.setMergeable(true);
        colCurrency.setGroup(true);
        IColumn colCompany = this.kdtable.addColumn();
        colCompany.setKey("company");
        IColumn colBank = this.kdtable.addColumn();
        colBank.setKey("bank");
        IColumn colaccountNumber = this.kdtable.addColumn();
        colaccountNumber.setKey("accountBank");
        IColumn colFinanceFinancing = this.kdtable.addColumn();
        colFinanceFinancing.setKey("financeFinancing");
    }

    private void setFinanceFinancingPanel() {
        IColumn colFinanceFinancing = this.kdtable.addColumn();
        colFinanceFinancing.setKey("financeFinancing");
        colFinanceFinancing.setMergeable(true);
        colFinanceFinancing.setGroup(true);
        IColumn colCompany = this.kdtable.addColumn();
        colCompany.setKey("company");
        IColumn colBank = this.kdtable.addColumn();
        colBank.setKey("bank");
        IColumn colaccountNumber = this.kdtable.addColumn();
        colaccountNumber.setKey("accountBank");
        IColumn colCurrency = this.kdtable.addColumn();
        colCurrency.setKey("currency");
    }

    private void setBankPanel() {
        IColumn colBank = this.kdtable.addColumn();
        colBank.setKey("bank");
        colBank.setMergeable(true);
        colBank.setGroup(true);
        IColumn colCompany = this.kdtable.addColumn();
        colCompany.setKey("company");
        IColumn colaccountNumber = this.kdtable.addColumn();
        colaccountNumber.setKey("accountBank");
        IColumn colFinanceFinancing = this.kdtable.addColumn();
        colFinanceFinancing.setKey("financeFinancing");
        IColumn colCurrency = this.kdtable.addColumn();
        colCurrency.setKey("currency");
    }

    private void setComapnyPanel() {
        IColumn colCompany = this.kdtable.addColumn();
        colCompany.setKey("company");
        colCompany.setMergeable(true);
        colCompany.setGroup(true);
        IColumn colBank = this.kdtable.addColumn();
        colBank.setKey("bank");
        IColumn colaccountNumber = this.kdtable.addColumn();
        colaccountNumber.setKey("accountBank");
        IColumn colFinanceFinancing = this.kdtable.addColumn();
        colFinanceFinancing.setKey("financeFinancing");
        IColumn colCurrency = this.kdtable.addColumn();
        colCurrency.setKey("currency");
    }

    private void formatHeadRow() {
        IRow row = this.kdtable.addHeadRow();
        row.getCell("company").setValue((Object)EASResource.getString((String)IVT_RES, (String)"056_COMPANY"));
        row.getCell("bank").setValue((Object)EASResource.getString((String)IVT_RES, (String)"057_BANK"));
        row.getCell("accountBank").setValue((Object)EASResource.getString((String)IVT_RES, (String)"058_ACCOUNTBANK"));
        row.getCell("financeFinancing").setValue((Object)EASResource.getString((String)IVT_RES, (String)"059_FINANCEFINANCING"));
        row.getCell("currency").setValue((Object)EASResource.getString((String)IVT_RES, (String)"060_CURRENCY"));
        row.getCell("rate").setValue((Object)EASResource.getString((String)IVT_RES, (String)"061_RATE"));
        row.getCell("number").setValue((Object)EASResource.getString((String)IVT_RES, (String)"062_NUMBER"));
        row.getCell("amount").setValue((Object)EASResource.getString((String)IVT_RES, (String)"063_AMOUNT"));
        row.getCell("financeLocAmount").setValue((Object)EASResource.getString((String)IVT_RES, (String)"064_AMOUNTLOCAL"));
        row.getCell("balance").setValue((Object)EASResource.getString((String)IVT_RES, (String)"065_BALANCE"));
        row.getCell("state").setValue((Object)EASResource.getString((String)IVT_RES, (String)"066_STATE"));
        row.getCell("beginDate").setValue((Object)EASResource.getString((String)IVT_RES, (String)"067_BEGINDATE"));
        row.getCell("endDate").setValue((Object)EASResource.getString((String)IVT_RES, (String)"068_ENDDATE"));
        row.getCell("term").setValue((Object)EASResource.getString((String)IVT_RES, (String)"069_TERM"));
        row.getCell("predictYield").setValue((Object)EASResource.getString((String)IVT_RES, (String)"070_PREDICTYIELD"));
        row.getCell("intRateTypeExpression").setValue((Object)EASResource.getString((String)IVT_RES, (String)"071_INTRATE"));
        row.getCell("days").setValue((Object)EASResource.getString((String)IVT_RES, (String)"072_DAYS"));
        row.getCell("Datefrom").setValue((Object)EASResource.getString((String)IVT_RES, (String)"073_DATEFROM"));
        row.getCell("Dateto").setValue((Object)EASResource.getString((String)IVT_RES, (String)"074_DATETO"));
        row.getCell("intersteDays").setValue((Object)EASResource.getString((String)IVT_RES, (String)"075_INTERESTEDAYS"));
        row.getCell("intersteAmount").setValue((Object)EASResource.getString((String)IVT_RES, (String)"076_INTERESTEAMOUNT"));
        row.getCell("intersteLocAmount").setValue((Object)EASResource.getString((String)IVT_RES, (String)"077_INTERESTELOCALAMOUNT"));
        row.getCell("isNoOut").setValue((Object)EASResource.getString((String)IVT_RES, (String)"078_ISNOOUT"));
        row.getCell("earnType").setValue((Object)EASResource.getString((String)IVT_RES, (String)"079_EARNTYPE"));
    }

    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        while (rs.next()) {
            IRow row = this.kdtable.addRow();
            row.getCell("company").setValue((Object)rs.getString("company.name"));
            row.getCell("bank").setValue((Object)rs.getString("bank.name"));
            row.getCell("accountBank").setValue((Object)rs.getString("accountBank.name"));
            if (rs.getString("financeAmount") != null) {
                row.getCell("amount").setValue((Object)new BigDecimal(rs.getString("financeAmount")).divide(this.bdUnit));
            } else {
                row.getCell("amount").setValue((Object)Constants.ZERO);
            }
            row.getCell("financeFinancing").setValue((Object)rs.getString("financeFinancing.name"));
            row.getCell("currency").setValue((Object)rs.getString("currency.name"));
            row.getCell("rate").setValue((Object)rs.getString("exchangeRate"));
            if (rs.getString("exchangeRate") != null) {
                this.exchangeRate = new BigDecimal(rs.getString("exchangeRate"));
            }
            row.getCell("number").setValue((Object)rs.getString("number"));
            if (rs.getString("financeLocAmount") != null) {
                row.getCell("financeLocAmount").setValue((Object)new BigDecimal(rs.getString("financeLocAmount")).divide(this.bdUnit));
            } else {
                row.getCell("financeLocAmount").setValue((Object)Constants.ZERO);
            }
            if (rs.getString("balance") != null) {
                row.getCell("balance").setValue((Object)new BigDecimal(rs.getString("balance")).divide(this.bdUnit));
            } else {
                row.getCell("balance").setValue((Object)Constants.ZERO);
            }
            row.getCell("state").setValue((Object)FinancingStateEnum.getEnum(Integer.parseInt(rs.getString("state"))));
            row.getCell("beginDate").setValue((Object)rs.getString("beginDate"));
            this.setEndate(row, rs.getString("enddate"));
            row.getCell("term").setValue((Object)rs.getString("term"));
            row.getCell("predictYield").setValue((Object)rs.getString("predictYield"));
            row.getCell("intRateTypeExpression").setValue((Object)IntRateTypeExpressionEnum.getEnum(rs.getString("intRateTypeExpression")));
            row.getCell("days").setValue((Object)rs.getString("days"));
            row.getCell("isNoOut").setValue((Object)(rs.getBoolean("isNoOut") ? yes : no));
            row.getCell("earnType").setValue((Object)EarnTypeEnum.getEnum(Integer.parseInt(rs.getString("earnType"))));
            row.getCell("Dateto").setValue((Object)this.param.getDateTo());
            String finaccid = rs.getString("id");
            this.setPersion(rs.getString("currency.id"));
            this.getintersteAmount(finaccid, row);
        }
    }

    private void setEndate(IRow row, String strendate) throws SQLException {
        if (strendate == null) {
            this.enddate = this.enddate = this.param.getDateTo();
        } else {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date endatemat = format.parse(strendate);
                this.enddate = endatemat.after(this.enddate) ? this.param.getDateTo() : endatemat;
                row.getCell("endDate").setValue((Object)endatemat);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    private void setPersion(String id) throws EASBizException, BOSException {
        CurrencyInfo currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(id));
        this.persion = currencyInfo.getPrecision();
    }

    private void getintersteAmount(String finaccid, IRow row) throws EASBizException, BOSException {
        FinancingAccountInfo info = FinancingAccountFactory.getRemoteInstance().getFinancingAccountInfo((IObjectPK)new ObjectUuidPK(finaccid));
        info.getCreator().getName();
        BigDecimal amount = info.getFinanceAmount();
        if (this.begindate == null) {
            this.begindate = info.getBeginDate();
        }
        amount = this.getNowAmount(info);
        BigDecimal days = new BigDecimal(info.getDays());
        BigDecimal chaer = Constants.ZERO;
        BigDecimal zonghe = Constants.ZERO;
        BigDecimal tests = Constants.ZERO;
        zonghe = this.getzonghezouyi(amount, info, this.enddate, this.begindate, row);
        FinancingRedeemCollection redeemCollection = this.getRedeem(this.begindate, this.enddate, finaccid);
        for (int i = 0; i < redeemCollection.size(); ++i) {
            FinancingRedeemInfo redeemInfo = redeemCollection.get(i);
            chaer = chaer.add(this.getdiffAmount(redeemInfo, this.enddate, days));
        }
        row.getCell("intersteAmount").setValue((Object)zonghe.subtract(chaer).setScale(this.persion, 4).divide(this.bdUnit));
        row.getCell("intersteLocAmount").setValue((Object)zonghe.subtract(chaer).multiply(this.exchangeRate).setScale(this.persion, 4).divide(this.bdUnit));
    }

    private BigDecimal getNowAmount(FinancingAccountInfo info) throws EASBizException, BOSException {
        FinancingRedeemCollection redeemCollection = this.getRedeem(this.begindate, null, info.getId().toString());
        BigDecimal Sumredemount = Constants.ZERO;
        for (int i = 0; i < redeemCollection.size(); ++i) {
            FinancingRedeemInfo redeemInfo = redeemCollection.get(i);
            Sumredemount = Sumredemount.add(redeemInfo.getRedeemAmount());
        }
        return info.getFinanceAmount().subtract(Sumredemount);
    }

    private BigDecimal getzonghezouyi(BigDecimal amount, FinancingAccountInfo info, Date endate, Date begindate, IRow row) {
        BigDecimal tianshu = Constants.ZERO;
        BigDecimal zonghe = Constants.ZERO;
        BigDecimal days = new BigDecimal(info.getDays());
        if (info.getBeginDate().after(begindate)) {
            tianshu = new BigDecimal(DateUtil.getDiffDays((Date)info.getBeginDate(), (Date)endate) - 1);
            row.getCell("Datefrom").setValue((Object)info.getBeginDate());
            row.getCell("intersteDays").setValue((Object)tianshu);
        } else {
            tianshu = new BigDecimal(DateUtil.getDiffDays((Date)begindate, (Date)endate) - 1);
            row.getCell("Datefrom").setValue((Object)begindate);
            row.getCell("intersteDays").setValue((Object)tianshu);
        }
        try {
            zonghe = info.getIntRateTypeExpression() == IntRateTypeExpressionEnum.YEAR ? FinHelper.calcBigDecimalExprs((String)"{0}*({1}/{2})/{3}*{4}", (BigDecimal[])new BigDecimal[]{amount, info.getPredictYield(), new BigDecimal("100"), days, tianshu}) : FinHelper.calcBigDecimalExprs((String)"{0}*({1}/{2})/{3}*{4}", (BigDecimal[])new BigDecimal[]{amount, info.getPredictYield(), new BigDecimal("1000"), days, tianshu});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return zonghe;
    }

    private BigDecimal getdiffAmount(FinancingRedeemInfo redeemInfo, Date endate, BigDecimal days) {
        BigDecimal chaer = Constants.ZERO;
        BigDecimal amount = redeemInfo.getRedeemAmount();
        Date redeeDate = redeemInfo.getRedeemDate();
        BigDecimal tianshu = Constants.ZERO;
        tianshu = new BigDecimal(DateUtil.getDiffDays((Date)redeeDate, (Date)endate) - 1);
        try {
            chaer = redeemInfo.getIntRateTypeExpression() == IntRateTypeExpressionEnum.YEAR ? FinHelper.calcBigDecimalExprs((String)"{0}*({1}/{2})/{3}*{4}", (BigDecimal[])new BigDecimal[]{amount, redeemInfo.getPredictYield(), new BigDecimal("100"), days, tianshu}) : FinHelper.calcBigDecimalExprs((String)"{0}*({1}/{2})/{3}*{4}", (BigDecimal[])new BigDecimal[]{amount, redeemInfo.getPredictYield(), new BigDecimal("1000"), days, tianshu});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return chaer;
    }

    private FinancingRedeemCollection getRedeem(Date bigdate, Date endate, String finaccid) throws EASBizException, BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)finaccid, CompareType.EQUALS));
        if (endate != null) {
            filter.getFilterItems().add(new FilterItemInfo("redeemDate", (Object)DateTimeUtils.truncateDate((Date)DateUtil.getNextDay((Date)bigdate)), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("redeemDate", (Object)DateTimeUtils.truncateDate((Date)DateUtil.getNextDay((Date)endate)), CompareType.LESS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("redeemDate", (Object)DateTimeUtils.truncateDate((Date)DateUtil.getNextDay((Date)bigdate)), CompareType.LESS));
            SorterItemCollection sc = new SorterItemCollection();
            SorterItemInfo sorterItem = new SorterItemInfo("redeemDate");
            sorterItem.setSortType(SortType.ASCEND);
            entityViewInfo.setSorter(sc);
        }
        entityViewInfo.setFilter(filter);
        FinancingRedeemCollection redeemCollection = FinancingRedeemFactory.getRemoteInstance().getFinancingRedeemCollection(entityViewInfo);
        return redeemCollection;
    }

    public void setTableStateRow() {
        switch (this.param.getDimType()) {
            case 1: {
                this.setCompanyTableStateRow();
                break;
            }
            case 2: {
                this.setBankTableStateRow();
                break;
            }
            case 3: {
                this.setFinTableStateRow();
                break;
            }
            case 4: {
                this.setCurrencyTableStateRow();
                break;
            }
            case 5: {
                this.setaccountNumberTableStateRow();
                break;
            }
            default: {
                this.setCompanyTableStateRow();
            }
        }
    }

    private void setaccountNumberTableStateRow() {
        this.kdtable.getColumn("accountBank").setStat(true);
        this.kdtable.getGroupManager().setTotalize(true);
        IRow rowLongTotal = this.kdtable.getGroupManager().getStatRowTemplate(-1);
        rowLongTotal.getCell("amount").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("amount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingInterestHandler.initDecimalCell(rowLongTotal.getCell("amount"));
        RptFinancingInterestHandler.initDecimalCell(rowLongTotal.getCell("rate"));
        rowLongTotal.getCell("accountBank").setValue((Object)EASResource.getString((String)IVT_RES, (String)"080_TOTAL"));
        IRow rowTotal = this.kdtable.getGroupManager().getStatRowTemplate(0);
        rowTotal.getCell("amount").setExpressions("SUM");
        rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowTotal.getCell("amount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingInterestHandler.initDecimalCell(rowTotal.getCell("amount"));
        rowTotal.getCell("accountBank").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"313_LoanEditUI"));
    }

    private void setCurrencyTableStateRow() {
        this.kdtable.getColumn("currency").setStat(true);
        this.kdtable.getGroupManager().setTotalize(true);
        IRow rowLongTotal = this.kdtable.getGroupManager().getStatRowTemplate(-1);
        rowLongTotal.getCell("amount").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("amount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingInterestHandler.initDecimalCell(rowLongTotal.getCell("amount"));
        RptFinancingInterestHandler.initDecimalCell(rowLongTotal.getCell("rate"));
        rowLongTotal.getCell("currency").setValue((Object)EASResource.getString((String)IVT_RES, (String)"080_TOTAL"));
        IRow rowTotal = this.kdtable.getGroupManager().getStatRowTemplate(0);
        rowTotal.getCell("amount").setExpressions("SUM");
        rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowTotal.getCell("amount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingInterestHandler.initDecimalCell(rowTotal.getCell("amount"));
        rowTotal.getCell("currency").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"313_LoanEditUI"));
    }

    private void setFinTableStateRow() {
        this.kdtable.getColumn("financeFinancing").setStat(true);
        this.kdtable.getGroupManager().setTotalize(true);
        IRow rowLongTotal = this.kdtable.getGroupManager().getStatRowTemplate(-1);
        rowLongTotal.getCell("amount").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("amount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingInterestHandler.initDecimalCell(rowLongTotal.getCell("amount"));
        RptFinancingInterestHandler.initDecimalCell(rowLongTotal.getCell("rate"));
        rowLongTotal.getCell("financeFinancing").setValue((Object)EASResource.getString((String)IVT_RES, (String)"080_TOTAL"));
        IRow rowTotal = this.kdtable.getGroupManager().getStatRowTemplate(0);
        rowTotal.getCell("amount").setExpressions("SUM");
        rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowTotal.getCell("amount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingInterestHandler.initDecimalCell(rowTotal.getCell("amount"));
        rowTotal.getCell("financeFinancing").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"313_LoanEditUI"));
    }

    private void setBankTableStateRow() {
        this.kdtable.getColumn("bank").setStat(true);
        this.kdtable.getGroupManager().setTotalize(true);
        IRow rowLongTotal = this.kdtable.getGroupManager().getStatRowTemplate(-1);
        rowLongTotal.getCell("amount").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("amount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingInterestHandler.initDecimalCell(rowLongTotal.getCell("amount"));
        RptFinancingInterestHandler.initDecimalCell(rowLongTotal.getCell("rate"));
        rowLongTotal.getCell("bank").setValue((Object)EASResource.getString((String)IVT_RES, (String)"080_TOTAL"));
        IRow rowTotal = this.kdtable.getGroupManager().getStatRowTemplate(0);
        rowTotal.getCell("amount").setExpressions("SUM");
        rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowTotal.getCell("amount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingInterestHandler.initDecimalCell(rowTotal.getCell("amount"));
        rowTotal.getCell("bank").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"313_LoanEditUI"));
    }

    private void setCompanyTableStateRow() {
        this.kdtable.getColumn("company").setStat(true);
        this.kdtable.getGroupManager().setTotalize(true);
        IRow rowLongTotal = this.kdtable.getGroupManager().getStatRowTemplate(-1);
        rowLongTotal.getCell("amount").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("amount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingInterestHandler.initDecimalCell(rowLongTotal.getCell("amount"));
        RptFinancingInterestHandler.initDecimalCell(rowLongTotal.getCell("rate"));
        rowLongTotal.getCell("company").setValue((Object)EASResource.getString((String)IVT_RES, (String)"080_TOTAL"));
        IRow rowTotal = this.kdtable.getGroupManager().getStatRowTemplate(0);
        rowTotal.getCell("amount").setExpressions("SUM");
        rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowTotal.getCell("amount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingInterestHandler.initDecimalCell(rowTotal.getCell("amount"));
        rowTotal.getCell("company").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"313_LoanEditUI"));
    }

    public void endDataFill() {
        this.kdtable.setRefresh(true);
        this.kdtable.repaint();
        this.kdtable.getGroupManager().group();
        this.kdtable.getGroupManager().setGroup(false);
    }

    public IRowSet getRowSet() throws BOSException {
        this.begindate = this.param.getDateFrom();
        this.enddate = this.param.getDateTo();
        int intUnit = this.param.getUnit().getValue();
        this.bdUnit = new BigDecimal(String.valueOf(intUnit));
        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.ivt.app.FinancingAccountQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(this.param.getFilter());
        entityViewInfo.setSorter(this.param.getSorterItems());
        exec.setObjectView(entityViewInfo);
        return exec.executeQuery();
    }

    protected static void initDecimalCell(IColumn col) {
        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        col.getStyleAttributes().setNumberFormat("##,###,###,###,###,##0.00");
    }

    protected static void initDecimalCell(ICell cell) {
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        cell.getStyleAttributes().setNumberFormat("##,###,###,###,###,##0.00");
    }
}

