/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.CapitalReservesFactory;
import com.kingdee.eas.fm.liquid.CapitalReservesInfo;
import com.kingdee.eas.fm.liquid.LiquidBaseHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CapitalReservesDataImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)CapitalReservesDataImport.class.getName());
    private HashMap map;

    private Object getData(Hashtable hsData, String fieldName) {
        Object data = null;
        if (hsData.get(fieldName) != null) {
            data = ((DataToken)hsData.get((Object)fieldName)).data;
        }
        return data;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        BigDecimal amount;
        String resMessage;
        String resMessage2;
        CurrencyInfo currency;
        CompanyOrgUnitInfo company;
        CapitalReservesInfo info = new CapitalReservesInfo();
        Object data = null;
        data = this.getData(hsData, "FCompany_number");
        if (data != null && data.toString().trim().length() > 0) {
            company = LiquidBaseHelper.getCompanyByNumber(ctx, data.toString());
            if (company == null) {
                String resMessage3 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"companyNotExit", (Locale)ctx.getLocale());
                throw new TaskExternalException(MessageFormat.format(resMessage3, data.toString()));
            }
            String companyId = company.getId().toString();
            if (this.map == null) {
                try {
                    this.map = LiquidBaseHelper.getAuthorizedOrgViewIDs(ctx, true, (IObjectPK)new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId()), OrgViewType.COMPANY, null, null, null);
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            Object[] ids = this.map.keySet().toArray();
            boolean hasExit = false;
            for (int i = 0; i < ids.length; ++i) {
                String id = ids[i].toString();
                if (!companyId.equals(id)) continue;
                hasExit = true;
            }
            if (!hasExit) {
                String resMessage4 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"hasNoPermission", (Locale)ctx.getLocale());
                throw new TaskExternalException(MessageFormat.format(resMessage4, data.toString(), ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getName()));
            }
        } else {
            String resMessage5 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"companyMust", (Locale)ctx.getLocale());
            throw new TaskExternalException(resMessage5);
        }
        info.setCompany(company);
        data = this.getData(hsData, "FCurrency_number");
        if (data != null && data.toString().trim().length() > 0) {
            currency = LiquidBaseHelper.getCurrencyByNumber(ctx, data.toString());
            if (currency == null) {
                resMessage2 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"currenyNotExit", (Locale)ctx.getLocale());
                throw new TaskExternalException(MessageFormat.format(resMessage2, data.toString()));
            }
        } else {
            resMessage = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"currencyNull", (Locale)ctx.getLocale());
            throw new TaskExternalException(resMessage);
        }
        info.setCurrency(currency);
        data = this.getData(hsData, "FEffectiveDate");
        if (data == null || data.toString().trim().length() <= 0) {
            resMessage = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"effectDateNotNull", (Locale)ctx.getLocale());
            throw new TaskExternalException(resMessage);
        }
        info.setEffectiveDate(TypeConversionUtils.objToDate((Object)data));
        data = this.getData(hsData, "FAmount");
        if (data != null && data.toString().trim().length() > 0) {
            amount = TypeConversionUtils.objToBigDecimal((Object)data);
            if (amount.compareTo(BigDecimal.ZERO) <= 0 || amount.compareTo(new BigDecimal("10000000000000")) >= 0) {
                resMessage2 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"amoutError", (Locale)ctx.getLocale());
                throw new TaskExternalException(resMessage2);
            }
        } else {
            resMessage = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"amountMust", (Locale)ctx.getLocale());
            throw new TaskExternalException(resMessage);
        }
        info.setAmount(amount);
        data = this.getData(hsData, "FRemarks");
        if (data != null && data.toString().trim().length() > 0) {
            info.setRemarks(data.toString());
        }
        return info;
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return CapitalReservesFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }
}

