/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.util.RptFmClientUtil;
import com.kingdee.eas.fm.liquid.client.AbstractCapitalReservesFilterUI;
import com.kingdee.eas.fm.liquid.client.CapitalReservesFilterParam;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class CapitalReservesFilterUI
extends AbstractCapitalReservesFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CapitalReservesFilterUI.class);

    public void init() throws Exception {
        super.init();
        this.btnCompanySelect.setEnabled(false);
        this.btnCompanySelect.setVisible(false);
        NewCompanyF7 selector = F7SelectorFactory.getSelectCompany((IUIObject)this, null, null, (boolean)false);
        selector.setMultiSelect(true);
        selector.setUsePerm(true);
        this.prmtCompany.setSelector((KDPromptSelector)selector);
        this.pkEffectiveDate.setValue((Object)DateUtil.getFirstDayOfCurYear());
        this.pkExpiratedDate.setValue((Object)DateUtil.getDayEnd());
        this.prmtCompany.setValue(null);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public Object getParam() {
        CapitalReservesFilterParam param = new CapitalReservesFilterParam();
        param.setEffectiveDate((Date)this.pkEffectiveDate.getValue());
        param.setExpiratedDate((Date)this.pkExpiratedDate.getValue());
        param.setCompanyIdSet(AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtCompany)));
        return param;
    }

    public void setParam(Object param) {
        CapitalReservesFilterParam para = (CapitalReservesFilterParam)param;
        if (para == null) {
            return;
        }
        this.pkEffectiveDate.setValue((Object)para.getEffectiveDate());
        this.pkExpiratedDate.setValue((Object)para.getExpiratedDate());
        Set companyIdSet = para.getCompanyIdSet();
        CoreBaseInfo[] c = null;
        try {
            c = RptFmClientUtil.getBaseInfoFromIdSet((Set)companyIdSet);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        this.prmtCompany.setData((Object)c);
    }

    protected Class getParamClass() {
        return CapitalReservesFilterParam.class;
    }

    public boolean verify() {
        Date startDate = (Date)this.pkEffectiveDate.getValue();
        Date endDate = (Date)this.pkExpiratedDate.getValue();
        if (startDate != null && endDate != null && startDate.after(endDate)) {
            MsgBox.showWarning(null, (String)EASResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"endBeforeStart"));
            SysUtil.abort();
        }
        return super.verify();
    }
}

