/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMBillBaseListUI;
import com.kingdee.eas.fm.common.client.FMDefaultQueryProcessor;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.liquid.LiquidBaseHelper;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ExternalQueryProcessor
extends FMDefaultQueryProcessor {
    private static Logger logger = Logger.getLogger((String)ExternalQueryProcessor.class.getName());
    protected IUIObject owner;
    protected FMFilterBaseUI filter;
    private HashMap map;

    public ExternalQueryProcessor(IUIObject owner) {
        this.owner = owner;
        FMBillBaseListUI ui = (FMBillBaseListUI)owner;
        try {
            this.filter = ui.getFilterUI();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            logger.error((Object)e);
        }
    }

    public ExternalQueryProcessor() {
    }

    public void process() throws Exception {
        super.process();
        String field = this.getField();
        Object editor = this.getEditor();
        if (editor instanceof KDBizPromptBox) {
            KDBizPromptBox prmtBox = (KDBizPromptBox)editor;
            String query = prmtBox.getQueryInfo();
            if (FMHelper.isEmpty((String)query)) {
                return;
            }
            if (field.equalsIgnoreCase("accountView.id")) {
                this.setAccountView(prmtBox);
            }
        }
    }

    private void setAccountView(KDBizPromptBox prmtAccountView) throws EASBizException, BOSException {
        prmtAccountView.getQueryAgent().resetRuntimeEntityView();
        FilterInfo filter = new FilterInfo();
        if (this.map == null) {
            try {
                this.map = LiquidBaseHelper.getAuthorizedOrgViewIDs(null, true, (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), OrgViewType.COMPANY, null, null, null);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        if (this.map != null) {
            Object[] ids = this.map.keySet().toArray();
            StringBuffer strFilter = new StringBuffer("");
            for (int i = 0; i < ids.length; ++i) {
                String id = ids[i].toString();
                if (i > 0) {
                    strFilter.append(",");
                }
                strFilter.append(id);
            }
            filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)strFilter.toString(), CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("isCash", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Boolean.FALSE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        prmtAccountView.setEntityViewInfo(evi);
    }
}

