/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.util.RptFmClientUtil;
import com.kingdee.eas.fm.liquid.LiquidBaseHelper;
import com.kingdee.eas.fm.liquid.client.AbstractExternalTransDetailFilterUI;
import com.kingdee.eas.fm.liquid.client.ExternalTransDetailFilterParam;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class ExternalTransDetailFilterUI
extends AbstractExternalTransDetailFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ExternalTransDetailFilterUI.class);

    public void init() throws Exception {
        super.init();
        this.btnCompanySelect.setEnabled(false);
        this.btnCompanySelect.setVisible(false);
        NewCompanyF7 selector = F7SelectorFactory.getSelectCompany((IUIObject)this, null, null, (boolean)false);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("unit.partFI.isBizUnit", (Object)Boolean.TRUE));
        selector.setOuterFilterInfo(filter);
        selector.setMultiSelect(false);
        selector.setUsePerm(true);
        this.prmtCompany.setSelector((KDPromptSelector)selector);
        this.pkStartTime.setValue((Object)DateUtil.getDayBegin());
        this.pkEndTime.setValue((Object)DateUtil.getDayEnd());
        if (!LiquidBaseHelper.isCompanyUnion(this.currentCompany)) {
            this.prmtCompany.setValue((Object)this.currentCompany);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public Object getParam() {
        ExternalTransDetailFilterParam param = new ExternalTransDetailFilterParam();
        param.setStartTime((Date)this.pkStartTime.getValue());
        param.setEndTime((Date)this.pkEndTime.getValue());
        param.setCompanyIdSet(AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtCompany)));
        param.setCurrencyIdSet(AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtCurrency)));
        param.setAccountBankIdSet(AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtAccountBank)));
        return param;
    }

    public void setParam(Object param) {
        ExternalTransDetailFilterParam para = (ExternalTransDetailFilterParam)param;
        if (para == null) {
            return;
        }
        this.pkStartTime.setValue((Object)para.getStartTime());
        this.pkEndTime.setValue((Object)para.getEndTime());
        Set companyIdSet = para.getCompanyIdSet();
        CoreBaseInfo[] c = null;
        try {
            c = RptFmClientUtil.getBaseInfoFromIdSet((Set)companyIdSet);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        this.prmtCompany.setData((Object)c);
        Set currencyIdSet = para.getCurrencyIdSet();
        CoreBaseInfo[] cc = null;
        try {
            cc = RptFmClientUtil.getBaseInfoFromIdSet((Set)currencyIdSet);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        this.prmtCurrency.setData((Object)cc);
        Set accountBankIdSet = para.getAccountBankIdSet();
        CoreBaseInfo[] ccc = null;
        try {
            ccc = RptFmClientUtil.getBaseInfoFromIdSet((Set)accountBankIdSet);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        this.prmtAccountBank.setData((Object)ccc);
    }

    @Override
    protected void prmtAccountBank_willShow(SelectorEvent e) throws Exception {
        String companyid;
        FilterInfo filter = new FilterInfo();
        if (this.prmtCompany.getValue() != null && (companyid = ((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString()) != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtAccountBank.setEntityViewInfo(evi);
        this.prmtAccountBank.getQueryAgent().resetRuntimeEntityView();
    }

    public boolean verify() {
        if (this.prmtCompany.getValue() == null) {
            MsgBox.showWarning(null, (String)EASResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"companyNotNull"));
            SysUtil.abort();
        }
        Date startDate = (Date)this.pkStartTime.getValue();
        Date endDate = (Date)this.pkEndTime.getValue();
        if (startDate != null && endDate != null && startDate.after(endDate)) {
            MsgBox.showWarning(null, (String)EASResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"dateVerify"));
            SysUtil.abort();
        }
        return super.verify();
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCompany_dataChanged(e);
        if (e.getNewValue() != null && e.getOldValue() != null && !e.getNewValue().equals(e.getOldValue()) || e.getOldValue() == null && e.getNewValue() != null || e.getNewValue() == null) {
            this.prmtAccountBank.setValue(null);
        }
    }
}

