/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalFlowItemCollection;
import com.kingdee.eas.fi.cas.JournalFlowItemInfo;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.liquid.client.AbstractJournalFlowItemEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class JournalFlowItemEditUI
extends AbstractJournalFlowItemEditUI {
    private static final String LIQUID_RESOURCE = "com.kingdee.eas.fm.liquid.LiquidResource";
    private static final Logger logger = CoreUIObject.getLogger(JournalFlowItemEditUI.class);
    private JournalCollection journalColl = null;
    private HashMap journalMap = null;
    private HashMap journalOldMap = new HashMap();
    private JournalFlowItemCollection fundFlowColl = null;
    private List idList = null;
    private String ACCOUNTNUMBER = "accountBank.number";
    private String ACCOUNTNAME = "accountBank.name";
    private String ACCOUNTBANKNUMBER = "accountBank.bankAccountNumber";
    private String CREATEDATE = "createDate";
    private String BILLTYPE = "billType";
    private String BILLNUMBER = "billNumber";
    private String OPPUNIT = "oppUnit";
    private String DESCRIPTION = "description";
    private String CURRENCY = "currency.name";
    private String DEBITAMOUNT = "debitAmount";
    private String CREDITAMOUNT = "creditAmount";
    private String ID = "id";
    private String FUNDFLOWITEM = "fundFlowItem";
    private String AMOUNT = "amount";
    private String FUNDFLOWID = "fundFlowItem.id";
    private boolean isAddorDel = false;
    private boolean isModify = false;
    private boolean isFirstLoad = true;

    public JournalFlowItemEditUI() throws Exception {
        this.btnAddLines.setText(null);
        this.btnAddLines.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveLines.setText(null);
        this.btnRemoveLines.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    public JournalCollection getResultColl() {
        return this.journalColl;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public static IUIWindow showDialogWindows(IUIObject ui, IIDList idList) throws UIException {
        if (idList == null || idList.size() == 0) {
            return null;
        }
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"IDList", (Object)idList);
        uiContext.put((Object)"ID", (Object)idList.getID(0));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(JournalFlowItemEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        return uiWindow;
    }

    protected KDTable getDetailTable() {
        return null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUIPro();
        this.fetchInitData();
        this.loadFields();
        this.btnAuditResult.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.btnAttachment.setVisible(false);
    }

    protected void fetchInitData() throws Exception {
        Map ctx = this.getUIContext();
        this.idList = new ArrayList();
        IIDList iidList = (IIDList)ctx.get("IDList");
        int size = iidList.size();
        for (int i = 0; i < size; ++i) {
            this.idList.add(iidList.getID(i));
        }
        this.journalColl = this.getJournalColl(this.idList);
        this.journalMap = this.buildJournalMap(this.journalColl);
    }

    private HashMap buildJournalMap(JournalCollection coll) {
        HashMap<String, JournalInfo> map = new HashMap<String, JournalInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            JournalInfo info = coll.get(i);
            map.put(info.getId().toString(), info);
        }
        return map;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        sic.add("flowItemEntries.*");
        sic.add("flowItemEntries.fundFlowItem.*");
        sic.add("accountBank.number");
        sic.add("accountBank.name");
        sic.add("accountBank.bankAccountNumber");
        sic.add("currency.name");
        sic.add("accountView.number");
        sic.add("accountView.name");
        return sic;
    }

    private JournalCollection getJournalColl(List list) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("flowItemEntries.*");
        sic.add("flowItemEntries.fundFlowItem.*");
        sic.add("accountBank.number");
        sic.add("accountBank.name");
        sic.add("accountBank.bankAccountNumber");
        sic.add("currency.name");
        sic.add("accountView.number");
        sic.add("accountView.name");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(list), CompareType.INCLUDE));
        evi.setSelector(sic);
        evi.setFilter(filter);
        JournalCollection coll = null;
        try {
            coll = JournalFactory.getRemoteInstance().getJournalCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return coll;
    }

    protected void initUIPro() {
        this.tblJournal.checkParsed();
        this.tblFundflow.checkParsed();
        this.tblJournal.getStyleAttributes().setLocked(true);
        this.tblJournal.getSelectManager().setSelectMode(2);
        KDFormattedTextField txtCreditAmt = new KDFormattedTextField();
        txtCreditAmt.setDataType(1);
        txtCreditAmt.setPrecision(2);
        this.tblJournal.getColumn(this.CREDITAMOUNT).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtCreditAmt));
        KDFormattedTextField txtDebitAmt = new KDFormattedTextField();
        txtDebitAmt.setDataType(1);
        txtDebitAmt.setPrecision(2);
        this.tblJournal.getColumn(this.DEBITAMOUNT).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtDebitAmt));
        FMClientHelper.setNumberFormat((KDTable)this.tblJournal, (String)this.CREDITAMOUNT, null);
        FMClientHelper.setNumberFormat((KDTable)this.tblJournal, (String)this.DEBITAMOUNT, null);
        KDFormattedTextField txtAmt = new KDFormattedTextField();
        txtAmt.setDataType(1);
        txtAmt.setPrecision(2);
        txtAmt.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                JournalFlowItemEditUI.this.amountChanged(e);
            }
        });
        StyleAttributes styleAttributes = this.tblFundflow.getColumn(this.AMOUNT).getStyleAttributes();
        String numberFormat = "%r-[ ]{###,###,##0.00}15.2n";
        styleAttributes.setNumberFormat(numberFormat);
        styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblFundflow.getColumn(this.AMOUNT).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtAmt));
        KDBizPromptBox prmtFundflow = RecPayHelper.getF7FundFlowItemUi((IUIObject)this, null);
        prmtFundflow.setQueryInfo("com.kingdee.eas.fi.cas.F7FundFlowItemQuery");
        prmtFundflow.setVisible(true);
        prmtFundflow.setEditable(true);
        prmtFundflow.setDisplayFormat("$name$");
        prmtFundflow.setEditFormat("$number:name$");
        prmtFundflow.setCommitFormat("$number$");
        prmtFundflow.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                JournalFlowItemEditUI.this.fundFlowChanged(e);
            }
        });
        this.tblFundflow.getColumn(this.FUNDFLOWITEM).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtFundflow));
    }

    private void fundFlowChanged(DataChangeEvent e) {
        this.isModify = true;
        if (e.getNewValue() != null && e.getOldValue() != null && (e.getOldValue().equals(e.getNewValue()) || ((FundFlowItemInfo)e.getOldValue()).getDirection().equals((Object)((FundFlowItemInfo)e.getNewValue()).getDirection())) || e.getNewValue() == null) {
            return;
        }
        FundFlowItemInfo itemInfo = (FundFlowItemInfo)e.getNewValue();
        this.reCalcTotal(null, itemInfo);
    }

    private void amountChanged(DataChangeEvent e) {
        if (e.getNewValue() != null && e.getOldValue() != null && e.getOldValue().equals(e.getNewValue()) || e.getNewValue() == null) {
            return;
        }
        BigDecimal newValue = FMConstants.ZERO;
        if (e.getNewValue() != null) {
            newValue = (BigDecimal)e.getNewValue();
        }
        this.reCalcTotal(newValue, null);
        this.isModify = true;
    }

    private JournalInfo fillJournalTable(JournalCollection journalColl) {
        JournalInfo info = null;
        JournalInfo firstInfo = journalColl.get(0);
        this.tblJournal.checkParsed();
        for (int i = 0; i < journalColl.size(); ++i) {
            info = journalColl.get(i);
            IRow row = this.tblJournal.addRow();
            AccountBankInfo accountBankInfo = info.getAccountBank();
            AccountViewInfo accountViewInfo = info.getAccountView();
            if (!EmptyUtil.isEmpty((CoreBaseInfo)accountBankInfo)) {
                row.getCell(this.ACCOUNTNUMBER).setValue((Object)accountBankInfo.getNumber());
                row.getCell(this.ACCOUNTNAME).setValue((Object)accountBankInfo.getName());
                row.getCell(this.ACCOUNTBANKNUMBER).setValue((Object)accountBankInfo.getBankAccountNumber());
            } else if (!EmptyUtil.isEmpty((CoreBaseInfo)accountViewInfo)) {
                row.getCell(this.ACCOUNTNUMBER).setValue((Object)accountViewInfo.getNumber());
                row.getCell(this.ACCOUNTNAME).setValue((Object)accountViewInfo.getName());
            }
            row.getCell(this.CREATEDATE).setValue((Object)info.getCreateDate());
            row.getCell(this.BILLTYPE).setValue((Object)info.getBillType());
            row.getCell(this.BILLNUMBER).setValue((Object)info.getBillNumber());
            row.getCell(this.OPPUNIT).setValue((Object)info.getOppUnit());
            row.getCell(this.CURRENCY).setValue((Object)info.getCurrency().getName());
            row.getCell(this.DESCRIPTION).setValue((Object)info.getDescription());
            row.getCell(this.DEBITAMOUNT).setValue((Object)info.getDebitAmount());
            row.getCell(this.CREDITAMOUNT).setValue((Object)info.getCreditAmount());
            row.getCell(this.ID).setValue((Object)info.getId().toString());
        }
        this.tblJournal.getSelectManager().select(0, 0);
        return firstInfo;
    }

    private void fillFundFlowTable() {
        this.tblFundflow.removeRows();
        int rowNum = this.tblJournal.getSelectManager().get().getTop();
        if (rowNum == -1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)LIQUID_RESOURCE, (String)"hasMergedOrSplit"));
            SysUtil.abort();
        }
        String journalId = this.tblJournal.getRow(rowNum).getCell(this.ID).getValue().toString();
        BigDecimal creditAmount = (BigDecimal)this.tblJournal.getRow(rowNum).getCell(this.CREDITAMOUNT).getValue();
        creditAmount = creditAmount.setScale(2, RoundingMode.HALF_UP);
        BigDecimal debitAmount = (BigDecimal)this.tblJournal.getRow(rowNum).getCell(this.DEBITAMOUNT).getValue();
        debitAmount = debitAmount.setScale(2, RoundingMode.HALF_UP);
        boolean isCredit = creditAmount.compareTo(FMConstants.ZERO) != 0;
        BigDecimal total = FMConstants.ZERO;
        if (this.journalMap != null && this.journalMap.size() > 0 && this.journalMap.containsKey(journalId)) {
            JournalInfo journalInfo = (JournalInfo)this.journalMap.get(journalId);
            JournalFlowItemCollection coll = new JournalFlowItemCollection();
            if (this.journalOldMap.containsKey(journalInfo.getId().toString())) {
                coll = (JournalFlowItemCollection)this.journalOldMap.get(journalInfo.getId().toString());
            } else if (journalInfo.getFlowItemEntries() != null) {
                coll = journalInfo.getFlowItemEntries();
            }
            BigDecimal totalIn = FMConstants.ZERO;
            BigDecimal totalOut = FMConstants.ZERO;
            if (coll != null && coll.size() > 0) {
                for (int i = 0; i < coll.size(); ++i) {
                    JournalFlowItemInfo info = coll.get(i);
                    IRow row = this.tblFundflow.addRow();
                    row.getCell(this.FUNDFLOWITEM).setValue((Object)info.getFundFlowItem());
                    row.getCell(this.AMOUNT).setValue((Object)info.getAmount());
                    BigDecimal amount = FMConstants.ZERO;
                    if (info.getAmount() != null) {
                        amount = info.getAmount();
                    }
                    if (info.getFundFlowItem() != null && info.getFundFlowItem().getDirection().equals((Object)FundFlowDirection.IN) || info.getFundFlowItem() == null && !isCredit) {
                        totalIn = totalIn.add(amount);
                        continue;
                    }
                    if ((info.getFundFlowItem() == null || !info.getFundFlowItem().getDirection().equals((Object)FundFlowDirection.OUT)) && (info.getFundFlowItem() != null || !isCredit)) continue;
                    totalOut = totalOut.add(amount);
                }
            }
            total = isCredit ? total.add(totalOut).subtract(totalIn) : total.add(totalIn).subtract(totalOut);
        }
        this.appendFootRows(this.tblFundflow, total);
    }

    private void appendFootRows(KDTable table, BigDecimal total) {
        IRow row = table.addRow();
        row.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        row.getStyleAttributes().setLocked(true);
        row.getCell(this.AMOUNT).setValue((Object)total);
        String heji = EASResource.getString((String)LIQUID_RESOURCE, (String)"HEJI");
        row.getCell(this.FUNDFLOWITEM).setValue((Object)heji);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.journalColl == null) {
            return;
        }
        JournalInfo firstInfo = this.fillJournalTable(this.journalColl);
        this.fillFundFlowTable();
        this.isFirstLoad = false;
    }

    private boolean checkIsMergedByBatchNo(String id, boolean isAbort) {
        boolean isMergedByBatchNo = false;
        String journalId = id;
        if (journalId == null) {
            int selectedRow = KDTableUtil.getSelectedRow((KDTable)this.tblJournal);
            if (selectedRow != -1) {
                journalId = this.tblJournal.getRow(selectedRow).getCell(this.ID).getValue().toString();
            } else {
                return false;
            }
        }
        try {
            isMergedByBatchNo = JournalFactory.getRemoteInstance().isMergedByBatchNo(journalId.toString());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (isMergedByBatchNo) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)LIQUID_RESOURCE, (String)"hasMergedByBatchNo"));
            if (isAbort) {
                SysUtil.abort();
            }
        }
        return isMergedByBatchNo;
    }

    @Override
    public void actionAddLines_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsMergedByBatchNo(null, true);
        this.isAddorDel = true;
        IRow row = this.tblFundflow.addRow(this.tblFundflow.getRowCount() - 1);
        row.getCell(this.FUNDFLOWITEM).setValue(null);
        row.getCell(this.AMOUNT).setValue((Object)BigDecimal.ZERO);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void tblJournal_tableSelectChanged(KDTSelectEvent e) throws Exception {
        boolean isReload;
        block11: {
            block12: {
                if (e.getPrevSelectBlock() == null) {
                    return;
                }
                isReload = false;
                KDTSelectBlock preSelect = e.getPrevSelectBlock();
                int preRowCount = e.getPrevSelectBlock().getBeginRow();
                if (!this.isModify && !this.isAddorDel) break block12;
                String confirmSave = EASResource.getString((String)LIQUID_RESOURCE, (String)"CONFIRMSAVE");
                int result = MsgBox.showConfirm3((Component)((Object)this), (String)confirmSave);
                if (MsgBox.isYes((int)result)) {
                    String journalId = this.tblJournal.getRow(preRowCount).getCell(this.ID).getValue().toString();
                    if (this.checkIsMergedByBatchNo(journalId, false)) {
                        this.setPreSelectBlock(preSelect);
                        return;
                    }
                    this.verifyEntries(preSelect);
                    if (this.journalMap != null && this.journalMap.size() > 0 && this.journalMap.containsKey(journalId)) {
                        JournalInfo journalInfo = (JournalInfo)this.journalMap.get(journalId);
                        JournalFlowItemCollection oldEntryColl = journalInfo.getFlowItemEntries();
                        JournalFlowItemCollection entryColl = this.createFundFlow(journalInfo);
                        journalInfo.getFlowItemEntries().clear();
                        journalInfo.getFlowItemEntries().addCollection(entryColl);
                        try {
                            JournalFactory.getRemoteInstance().submit((CoreBaseInfo)journalInfo);
                            this.showAppointSuccess();
                            this.isModify = false;
                            this.isAddorDel = false;
                            isReload = true;
                        }
                        catch (EASBizException ee) {
                            ee.printStackTrace();
                            this.setPreSelectBlock(preSelect);
                            this.journalOldMap.put(journalInfo.getId().toString(), oldEntryColl);
                            MsgBox.showWarning((Component)((Object)this), (String)ee.getMessage());
                            SysUtil.abort();
                        }
                    }
                    break block11;
                } else if (MsgBox.isNo((int)result)) {
                    this.isModify = false;
                    this.isAddorDel = false;
                    isReload = true;
                    break block11;
                } else if (!MsgBox.isCancel((int)result)) {
                    // empty if block
                }
                break block11;
            }
            isReload = true;
        }
        if (!this.isFirstLoad && isReload) {
            this.fillFundFlowTable();
        }
    }

    private JournalFlowItemCollection createFundFlow(JournalInfo journalInfo) {
        JournalFlowItemCollection coll = new JournalFlowItemCollection();
        int count = this.tblFundflow.getRowCount() - 1;
        for (int i = 0; i < count; ++i) {
            JournalFlowItemInfo info = new JournalFlowItemInfo();
            if (this.tblFundflow.getRow(i).getCell(this.FUNDFLOWID).getValue() != null) {
                info.setId(BOSUuid.read((String)this.tblFundflow.getRow(i).getCell(this.FUNDFLOWID).getValue().toString()));
            }
            FundFlowItemInfo itemInfo = (FundFlowItemInfo)this.tblFundflow.getRow(i).getCell(this.FUNDFLOWITEM).getValue();
            info.setFundFlowItem(itemInfo);
            info.setAmount((BigDecimal)this.tblFundflow.getRow(i).getCell(this.AMOUNT).getValue());
            info.setParent(journalInfo);
            coll.add(info);
        }
        return coll;
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                int lastRow = table.getRowCount() - 1;
                if (lastRow - bottom <= 0) {
                    String notRemoveHEJI = EASResource.getString((String)LIQUID_RESOURCE, (String)"NOTREMOVEHEJI");
                    MsgBox.showInfo((Component)((Object)this), (String)notRemoveHEJI);
                    return;
                }
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr == null) {
                return;
            }
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int index;
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
                table.removeRow(rowIndex);
                IObjectCollection collection = (IObjectCollection)table.getUserObject();
                if (collection == null) {
                    logger.error((Object)"collection not be binded to table");
                    continue;
                }
                if (detailData == null || (index = this.getCollectionIndex(collection, detailData)) < 0 || collection.size() <= index) continue;
                collection.removeObject(index);
            }
            if (table.getRow(0) != null) {
                table.getSelectManager().select(0, 0);
            }
        }
    }

    private int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    @Override
    public void actionRemoveLines_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsMergedByBatchNo(null, true);
        super.actionRemoveLine_actionPerformed(e);
        this.removeLine(this.tblFundflow);
        this.reCalcTotal(null, null);
        this.isAddorDel = true;
    }

    private void reCalcTotal(BigDecimal newValue, FundFlowItemInfo itemInfo) {
        BigDecimal total = BigDecimal.ZERO;
        int rowNum = this.tblJournal.getSelectManager().get().getTop();
        BigDecimal creditAmount = (BigDecimal)this.tblJournal.getRow(rowNum).getCell(this.CREDITAMOUNT).getValue();
        creditAmount = creditAmount.setScale(2, RoundingMode.HALF_UP);
        BigDecimal debitAmount = (BigDecimal)this.tblJournal.getRow(rowNum).getCell(this.DEBITAMOUNT).getValue();
        debitAmount = debitAmount.setScale(2, RoundingMode.HALF_UP);
        boolean isCredit = creditAmount.compareTo(FMConstants.ZERO) != 0;
        int count = this.tblFundflow.getRowCount() - 1;
        BigDecimal totalIn = FMConstants.ZERO;
        BigDecimal totalOut = FMConstants.ZERO;
        int selectRow = this.tblFundflow.getSelectManager().get().getTop();
        for (int ii = 0; ii < count; ++ii) {
            IRow currow = this.tblFundflow.getRow(ii);
            ICell amountCell = currow.getCell(this.AMOUNT);
            BigDecimal amount = FMConstants.ZERO;
            if (!FMHelper.isEmpty((Object)amountCell) && !FMHelper.isEmpty((Object)amountCell.getValue()) || newValue != null) {
                amount = selectRow == ii && newValue != null ? newValue : (BigDecimal)amountCell.getValue();
            }
            ICell flowItemCell = currow.getCell(this.FUNDFLOWITEM);
            FundFlowItemInfo flowItemInfo = null;
            if (!FMHelper.isEmpty((Object)flowItemCell) && flowItemCell.getValue() != null || itemInfo != null) {
                flowItemInfo = selectRow == ii && itemInfo != null ? itemInfo : (FundFlowItemInfo)flowItemCell.getValue();
            }
            if (flowItemInfo != null && flowItemInfo.getDirection().equals((Object)FundFlowDirection.IN) || flowItemInfo == null && !isCredit) {
                totalIn = totalIn.add(amount);
                continue;
            }
            if ((flowItemInfo == null || !flowItemInfo.getDirection().equals((Object)FundFlowDirection.OUT)) && (flowItemInfo != null || !isCredit)) continue;
            totalOut = totalOut.add(amount);
        }
        total = !isCredit ? totalIn.subtract(totalOut) : totalOut.subtract(totalIn);
        this.tblFundflow.getRow(count).getCell(this.AMOUNT).setValue((Object)total);
    }

    private void setPreSelectBlock(KDTSelectBlock selectBlock) {
        if (selectBlock != null) {
            this.tblJournal.getSelectManager().select(selectBlock, false);
        }
    }

    protected void verifyEntries(KDTSelectBlock selectBlock) {
        int rowNum = 0;
        rowNum = selectBlock == null ? this.tblJournal.getSelectManager().get().getTop() : selectBlock.getBeginRow();
        BigDecimal creditAmount = (BigDecimal)this.tblJournal.getRow(rowNum).getCell(this.CREDITAMOUNT).getValue();
        creditAmount = creditAmount.setScale(2, RoundingMode.HALF_UP);
        BigDecimal debitAmount = (BigDecimal)this.tblJournal.getRow(rowNum).getCell(this.DEBITAMOUNT).getValue();
        debitAmount = debitAmount.setScale(2, RoundingMode.HALF_UP);
        BigDecimal totalAmount = creditAmount.compareTo(FMConstants.ZERO) == 0 ? debitAmount : creditAmount;
        int count = this.tblFundflow.getRowCount() - 1;
        BigDecimal totalIn = FMConstants.ZERO;
        BigDecimal totalOut = FMConstants.ZERO;
        for (int ii = 0; ii < count; ++ii) {
            FundFlowItemInfo flowItemInfo;
            ICell amountCell;
            IRow currow = this.tblFundflow.getRow(ii);
            if (FMHelper.isEmpty((Object)currow.getCell(this.FUNDFLOWITEM).getValue())) {
                this.setPreSelectBlock(selectBlock);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)LIQUID_RESOURCE, (String)"flowItemNotNull"));
                SysUtil.abort();
            }
            if (FMHelper.isEmpty((Object)(amountCell = currow.getCell(this.AMOUNT))) || ((BigDecimal)amountCell.getValue()).compareTo(FMConstants.ZERO) == 0) {
                this.setPreSelectBlock(selectBlock);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)LIQUID_RESOURCE, (String)"amountNotNull"));
                SysUtil.abort();
            }
            if ((flowItemInfo = (FundFlowItemInfo)currow.getCell(this.FUNDFLOWITEM).getValue()).getDirection().equals((Object)FundFlowDirection.IN)) {
                totalIn = totalIn.add((BigDecimal)amountCell.getValue());
                continue;
            }
            totalOut = totalOut.add((BigDecimal)amountCell.getValue());
        }
        BigDecimal total = FMConstants.ZERO;
        total = debitAmount.compareTo(FMConstants.ZERO) != 0 ? totalIn.subtract(totalOut) : totalOut.subtract(totalIn);
        if (total.compareTo(totalAmount) != 0) {
            this.setPreSelectBlock(selectBlock);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)LIQUID_RESOURCE, (String)"amountNotFit"));
            SysUtil.abort();
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.isModify || this.isAddorDel) {
            this.checkIsMergedByBatchNo(null, true);
            String confirmSave = EASResource.getString((String)LIQUID_RESOURCE, (String)"CONFIRMSAVE");
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)confirmSave);
            if (MsgBox.isYes((int)result)) {
                this.verifyEntries(null);
                int rowCount = this.tblJournal.getSelectManager().get().getTop();
                String journalId = this.tblJournal.getRow(rowCount).getCell(this.ID).getValue().toString();
                if (this.journalMap != null && this.journalMap.size() > 0 && this.journalMap.containsKey(journalId)) {
                    JournalInfo journalInfo = (JournalInfo)this.journalMap.get(journalId);
                    JournalFlowItemCollection oldEntryColl = journalInfo.getFlowItemEntries();
                    JournalFlowItemCollection entryColl = this.createFundFlow(journalInfo);
                    journalInfo.getFlowItemEntries().clear();
                    journalInfo.getFlowItemEntries().addCollection(entryColl);
                    try {
                        JournalFactory.getRemoteInstance().submit((CoreBaseInfo)journalInfo);
                        this.showAppointSuccess();
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                        this.journalOldMap.put(journalInfo.getId().toString(), oldEntryColl);
                        MsgBox.showWarning((Component)((Object)this), (String)ee.getMessage());
                        SysUtil.abort();
                    }
                }
            } else if (MsgBox.isNo((int)result)) {
                this.fillFundFlowTable();
            }
        }
        this.isModify = false;
        this.isAddorDel = false;
    }

    protected void showAppointSuccess() {
        String appointSuccess = EASResource.getString((String)LIQUID_RESOURCE, (String)"APPOINTSUCCESS");
        MsgBox.showInfo((String)appointSuccess);
    }

    public boolean checkBeforeWindowClosing() {
        boolean canClose = super.checkBeforeWindowClosing();
        if (this.isModify || this.isAddorDel) {
            String confirmSave = EASResource.getString((String)LIQUID_RESOURCE, (String)"CONFIRMSAVE");
            int result = MsgBox.showConfirm2((Component)((Object)this), (String)confirmSave);
            if (MsgBox.isYes((int)result)) {
                if (this.checkIsMergedByBatchNo(null, false)) {
                    return true;
                }
                this.verifyEntries(null);
                int rowCount = this.tblJournal.getSelectManager().get().getTop();
                String journalId = this.tblJournal.getRow(rowCount).getCell(this.ID).getValue().toString();
                if (this.journalMap != null && this.journalMap.size() > 0 && this.journalMap.containsKey(journalId)) {
                    JournalInfo journalInfo = (JournalInfo)this.journalMap.get(journalId);
                    JournalFlowItemCollection oldEntryColl = journalInfo.getFlowItemEntries();
                    JournalFlowItemCollection entryColl = this.createFundFlow(journalInfo);
                    journalInfo.getFlowItemEntries().clear();
                    journalInfo.getFlowItemEntries().addCollection(entryColl);
                    try {
                        JournalFactory.getRemoteInstance().submit((CoreBaseInfo)journalInfo);
                        this.showAppointSuccess();
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                        this.journalOldMap.put(journalInfo.getId().toString(), oldEntryColl);
                        canClose = false;
                        MsgBox.showWarning((Component)((Object)this), (String)ee.getMessage());
                        SysUtil.abort();
                    }
                }
            } else if (MsgBox.isNo((int)result)) {
                // empty if block
            }
        }
        return canClose;
    }
}

