/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.client.BankJournalUIHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.liquid.client.AbstractJournalFlowItemsListUI;
import com.kingdee.eas.fm.liquid.client.JournalFlowItemEditUI;
import com.kingdee.eas.fm.liquid.client.JournalFlowItemsFilterUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class JournalFlowItemsListUI
extends AbstractJournalFlowItemsListUI {
    private static final String RPT_LINK_QUERY_REGEX = "0xx1xx";
    private static final Logger logger = CoreUIObject.getLogger(JournalFlowItemsListUI.class);
    JournalFlowItemsFilterUI filterUI;
    private boolean isRptLinkQuery;
    private String rptLinkQueryParam;

    private void initIsRptLinkQuery() {
        String[] params;
        this.isRptLinkQuery = false;
        Object idList = this.getUIContext().get("IDList");
        if (idList != null && idList instanceof String[] && (params = (String[])idList).length == 1 && params[0].startsWith(RPT_LINK_QUERY_REGEX)) {
            this.isRptLinkQuery = true;
            this.rptLinkQueryParam = ((String[])idList)[0];
            this.rptLinkQueryParam = this.rptLinkQueryParam.replaceFirst(RPT_LINK_QUERY_REGEX, "");
            this.getUIContext().put("IDList", null);
        }
    }

    protected boolean isDirectShow() {
        return this.isRptLinkQuery ? this.isRptLinkQuery : super.isDirectShow();
    }

    public void onLoad() throws Exception {
        this.initIsRptLinkQuery();
        super.onLoad();
        this.actionAuditResult.setEnabled(false);
        this.actionAuditResult.setVisible(false);
        this.actionAttachment.setEnabled(false);
        this.actionAttachment.setVisible(false);
        String numberFormat = "%r-[ ]{###,###,##0.00}15.2n";
        StyleAttributes styleAttributes = this.tblMain.getColumn("debitAmount").getStyleAttributes();
        styleAttributes.setNumberFormat(numberFormat);
        styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        StyleAttributes styleAttributes1 = this.tblMain.getColumn("creditAmount").getStyleAttributes();
        styleAttributes1.setNumberFormat(numberFormat);
        styleAttributes1.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        StyleAttributes styleAttributes2 = this.tblMain.getColumn("flowItemEntries.amount").getStyleAttributes();
        styleAttributes2.setNumberFormat(numberFormat);
        styleAttributes2.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.checkFlowItem();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAppoint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sendword"));
        this.actionCheck.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_check"));
    }

    protected ICoreBase getBizInterface() throws Exception {
        return JournalFactory.getRemoteInstance();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new JournalFlowItemsFilterUI();
        }
        return this.filterUI;
    }

    private void initRptLinkQueryFilter() {
        if (this.isRptLinkQuery) {
            String[] params = this.rptLinkQueryParam.split(RPT_LINK_QUERY_REGEX);
            String companyId = params[0];
            String flowItemId = params[1];
            String currencyId = params[2];
            Date beginDate = DateUtil.stringToDate((String)params[3]);
            Date endDate = DateUtil.stringToDate((String)params[4]);
            FilterInfo filterInfo = new FilterInfo();
            FilterItemCollection filterItems = filterInfo.getFilterItems();
            filterItems.add(new FilterItemInfo("company.id", (Object)companyId));
            if (!EmptyUtil.isEmpty((String)currencyId)) {
                filterItems.add(new FilterItemInfo("currency.id", (Object)currencyId));
            }
            if (!EmptyUtil.isEmpty((String)flowItemId)) {
                filterItems.add(new FilterItemInfo("fundFlowItem.id", (Object)flowItemId));
            }
            filterItems.add(new FilterItemInfo("createDate", (Object)beginDate, CompareType.GREATER_EQUALS));
            filterItems.add(new FilterItemInfo("createDate", (Object)endDate, CompareType.LESS_EQUALS));
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            try {
                if (this.mainQuery.getFilter() == null) {
                    this.mainQuery.setFilter(filterInfo);
                } else {
                    this.mainQuery.getFilter().mergeFilter(filterInfo, "AND");
                }
                logger.info((Object)("RptLinkQueryFilter: " + this.mainQuery.getFilter()));
                System.out.println("RptLinkQueryFilter: " + this.mainQuery.getFilter());
            }
            catch (BOSException e) {
                SysUtil.abort();
            }
        }
    }

    protected void execQuery() {
        this.initRptLinkQueryFilter();
        super.execQuery();
    }

    @Override
    public void actionAppoint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList selectIdList = this.getSelectedIdValues();
        RealModeIDList idList = new RealModeIDList();
        int size = selectIdList.size();
        for (int i = 0; i < size; ++i) {
            idList.add((String)selectIdList.get(i));
        }
        String id = this.getSelectedKeyValue();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        JournalInfo info = JournalFactory.getRemoteInstance().getJournalInfo((IObjectPK)new ObjectUuidPK(id), sic);
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        iPermission.checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), "JournalFlowItem_appoint");
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"IDList", (Object)idList);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        iMutex.batchRequestObjIDForUpdate((List)selectIdList);
        IUIWindow uiWindow = JournalFlowItemEditUI.showDialogWindows((IUIObject)this, (IIDList)idList);
        JournalFlowItemEditUI editUI = (JournalFlowItemEditUI)uiWindow.getUIObject();
        iMutex.batchReleaseObjIDForUpdate((List)selectIdList);
        if (editUI.getResultColl() != null && !editUI.getResultColl().isEmpty()) {
            this.refreshList();
        }
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"id", "company.name", "accountBank.number", "accountBank.name", "accountBank.bankAccountNumber", "createDate", "billType", "billNumber", "oppUnit", "description", "currency.name", "debitAmount", "creditAmount"};
    }

    protected boolean isReturnSelectedData() {
        return true;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.checkFlowItem();
    }

    private void checkFlowItem() {
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        StringBuffer errorInfo = new StringBuffer();
        boolean hasError = false;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            if (!FMHelper.isEmpty((Object)this.tblMain.getRow(i).getCell("fundFlowItem.name").getValue()) || FMHelper.isEmpty((Object)this.tblMain.getRow(i).getCell("flowItemEntries.amount").getValue())) continue;
            hasError = true;
            String flowItemNullInfo = EASResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"FLOWITEMNULL");
            errorInfo.append(MessageFormat.format(flowItemNullInfo, i + 1 + "")).append("\n");
        }
        if (hasError) {
            String result = EASResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"FLOWITEMVERIFY");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)(result + ""), (String)(errorInfo.toString() + ""), (int)1);
        }
    }

    @Override
    public void actionCheck_actionPerformed(ActionEvent e) throws Exception {
        String resourcePath = "com.kingdee.eas.fi.cas.client.CashMgtResource";
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null) {
            return;
        }
        int rowIndex = selectBlock.getTop();
        String id = (String)this.tblMain.getRow(rowIndex).getCell("id").getValue();
        if (id == null) {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"SelectValidRecord"));
            return;
        }
        String id1 = this.getSelectedKeyValue();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        JournalInfo info = JournalFactory.getRemoteInstance().getJournalInfo((IObjectPK)new ObjectUuidPK(id1), sic);
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        iPermission.checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), "JournalFlowItem_check");
        BankJournalUIHelper.showBillByJournalId((CoreUIObject)this, (String)id);
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.refresh(e);
    }
}

