/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.liquid.LiquidBaseHelper;
import com.kingdee.eas.fm.liquid.LiquidException;
import com.kingdee.eas.fm.liquid.RestrictedAccountFactory;
import com.kingdee.eas.fm.liquid.RestrictedAccountInfo;
import com.kingdee.eas.fm.liquid.RestrictedTypeEnum;
import com.kingdee.eas.fm.liquid.client.AbstractRestrictedAccountEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.client.context.f7.IF7ContextChange;
import com.kingdee.eas.framework.client.context.f7.IF7Register;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class RestrictedAccountEditUI
extends AbstractRestrictedAccountEditUI
implements IMultiOrgSupport {
    private static final Logger logger = CoreUIObject.getLogger(RestrictedAccountEditUI.class);
    private CompanyOrgUnitInfo currentCompany;
    private CurrencyInfo baseCurrency;
    private EntityViewInfo viewInfo;
    private HashMap map;
    private UserInfo currentUser = ContextHelperFactory.getRemoteInstance().getCurrentUser();

    public RestrictedAccountEditUI() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.baseCurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.currentCompany);
        this.baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.baseCurrency.getId().toString()));
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        try {
            FMClientHelper.initComboCurrency((KDComboBox)this.kDComboBoxCurrency, (boolean)true, (String)this.getOprtState());
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if ("ADDNEW".equals(this.getOprtState())) {
            CompanyOrgUnitInfo selectCom;
            CompanyOrgUnitInfo companyUnit = selectCom = (CompanyOrgUnitInfo)this.getUIContext().get("ParentNode");
            CompanyOrgUnitCollection companyColl = null;
            if (selectCom != null && !selectCom.isIsBizUnit()) {
                if (this.viewInfo == null) {
                    this.viewInfo = this.getViewInfoByOrange();
                }
                if (this.viewInfo != null) {
                    this.viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("parent.id", (Object)selectCom.getId().toString()));
                    try {
                        companyColl = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(this.viewInfo);
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                    if (companyColl != null && companyColl.size() > 0) {
                        companyUnit = companyColl.get(0);
                    }
                }
            }
            this.editData.setAccBankCompany(companyUnit);
            this.editData.setCurrency(companyUnit.getBaseCurrency());
        }
    }

    private EntityViewInfo getViewInfoByOrange() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        try {
            String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            if (this.map == null) {
                this.map = LiquidBaseHelper.getAuthorizedOrgViewIDs(null, true, (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), OrgViewType.COMPANY, null, null, null);
            }
            if (this.map != null) {
                Object[] ids = this.map.keySet().toArray();
                StringBuffer strFilter = new StringBuffer("");
                for (int i = 0; i < ids.length; ++i) {
                    String id = ids[i].toString();
                    if (i > 0) {
                        strFilter.append(",");
                    }
                    strFilter.append(id);
                }
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)strFilter.toString(), CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Boolean.TRUE));
                filter.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)Boolean.FALSE));
                view.setFilter(filter);
                SorterItemCollection sorter = new SorterItemCollection();
                sorter.add(new SorterItemInfo("number"));
                view.setSorter(sorter);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return view;
    }

    protected void initUIProp() throws Exception {
        super.initUIProp();
        this.txtAmount.setRemoveingZeroInDispaly(false);
        this.txtAmount.setHorizontalAlignment(4);
        this.txtAmount.setMinimumValue((Comparable)Constants.ZERO);
        this.txtAmount.setMaximumValue((Comparable)new BigDecimal("9999999999999"));
        this.txtRemarks.setMaxLength(200);
        this.txtAmount.setEnabled(false);
    }

    protected void updateButtonStatus() {
        super.updateButtonStatus();
        this.btnAuditResult.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.chkMenuItemSubmitAndAddNew.setSelected(true);
        this.chkMenuItemSubmitAndAddNew.setVisible(true);
    }

    protected IObjectValue createNewData() {
        RestrictedAccountInfo info = new RestrictedAccountInfo();
        info.setCompany(this.currentCompany);
        info.setCurrency(this.baseCurrency);
        info.setAccBankCompany(this.currentCompany);
        info.setRestrictedType(RestrictedTypeEnum.FULL);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RestrictedAccountFactory.getRemoteInstance();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        int precision = FMHelper.getPrecOfCurrency(null, (String)this.editData.getCurrency().getId().toString());
        this.txtAmount.setPrecision(precision);
        this.txtAmount.setValue((Object)this.editData.getAmount());
        this.prmtCompany.setValue((Object)this.editData.getAccBankCompany());
        FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)this.editData.getCurrency());
        FMClientHelper.setSelectObject((KDComboBox)this.comboRestrictedType, (Object)((Object)this.editData.getRestrictedType()));
        this.prmtAccountBank.setValue((Object)this.editData.getAccountBank());
        this.pkStartDate.setValue((Object)this.editData.getStartDate());
        this.pkEndDate.setValue((Object)this.editData.getEndDate());
        this.txtRemarks.setText(this.editData.getRemarks());
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setAccBankCompany((CompanyOrgUnitInfo)this.prmtCompany.getValue());
        this.editData.setCurrency((CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem());
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        this.verify();
    }

    private void verify() throws Exception {
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        if (this.txtAmount.getValue() != null) {
            FMClientHelper.verifyMoreThanZero((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
        }
        if (this.pkStartDate.getValue() != null && this.pkEndDate.getValue() != null) {
            Date startDate = (Date)this.pkStartDate.getValue();
            Date endDate = (Date)this.pkEndDate.getValue();
            if (endDate.before(startDate)) {
                throw new LiquidException(LiquidException.MUSTBIG);
            }
        }
        AccountBankInfo accountbank = (AccountBankInfo)this.prmtAccountBank.getValue();
        CurrencyInfo currency = (CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem();
        if (accountbank.getCurrency() != null && currency != null && !accountbank.getCurrency().getId().toString().equals(currency.getId().toString())) {
            throw new LiquidException(LiquidException.ACCOUNTCURRENCY);
        }
    }

    @Override
    protected void prmtAccountBank_willShow(SelectorEvent e) throws Exception {
        super.prmtAccountBank_willShow(e);
        FilterInfo filter = new FilterInfo();
        if (this.prmtCompany.getValue() != null) {
            String companyid = ((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString();
            if (companyid != null) {
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
            }
        } else {
            filter.getFilterItems().add(new FilterItemInfo("company.id", null));
        }
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        FilterInfo currFilter = new FilterInfo();
        currFilter.getFilterItems().add(new FilterItemInfo("isByCurrency", (Object)Boolean.TRUE));
        currFilter.getFilterItems().add(new FilterItemInfo("currency.deletedStatus", (Object)2, CompareType.NOTEQUALS));
        currFilter.getFilterItems().add(new FilterItemInfo("isByCurrency", (Object)Boolean.FALSE));
        currFilter.setMaskString("(#0 and #1) or #2");
        filter.mergeFilter(currFilter, "AND");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtAccountBank.setEntityViewInfo(evi);
        this.prmtAccountBank.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtAccountBank_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtAccountBank_dataChanged(e);
        if (this.prmtAccountBank.getValue() != null) {
            AccountBankInfo info = (AccountBankInfo)this.prmtAccountBank.getValue();
            if (info.isIsByCurrency()) {
                FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)info.getCurrency());
                this.kDComboBoxCurrency.setEnabled(false);
            } else {
                FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)this.baseCurrency);
                this.kDComboBoxCurrency.setEnabled(true);
            }
        }
    }

    @Override
    protected void comboRestrictedType_itemStateChanged(ItemEvent e) throws Exception {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            return;
        }
        super.comboRestrictedType_itemStateChanged(e);
        RestrictedTypeEnum type = (RestrictedTypeEnum)((Object)this.comboRestrictedType.getSelectedItem());
        if (type.equals((Object)RestrictedTypeEnum.FULL)) {
            this.txtAmount.setValue(null);
            this.txtAmount.setEnabled(false);
            this.txtAmount.setRequired(false);
        } else {
            this.txtAmount.setEnabled(true);
            this.txtAmount.setRequired(true);
        }
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCompany_dataChanged(e);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            return;
        }
        if (e.getNewValue() != null && e.getOldValue() != null && !e.getNewValue().equals(e.getOldValue()) || e.getOldValue() == null && e.getNewValue() != null) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)e.getNewValue();
            this.prmtAccountBank.setValue(null);
            if (company != null && company.getBaseCurrency() != null) {
                CurrencyInfo currencyWithName = LiquidBaseHelper.getCurrencyById(company.getBaseCurrency().getId().toString());
                this.kDComboBoxCurrency.setSelectedItem((Object)currencyWithName);
            } else {
                FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)this.baseCurrency);
            }
        }
        if (e.getNewValue() == null) {
            FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)this.baseCurrency);
        }
        this.kDComboBoxCurrency.setEnabled(true);
    }

    @Override
    protected void kDComboBoxCurrency_itemStateChanged(ItemEvent e) throws Exception {
        super.kDComboBoxCurrency_itemStateChanged(e);
        CurrencyInfo currency = (CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem();
        if (currency == null) {
            return;
        }
        this.txtAmount.setPrecision(currency.getPrecision());
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        return sic;
    }

    protected boolean isContinueAddNew() {
        return false;
    }

    public OrgType getMainOrgType() {
        return OrgType.Company;
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmtCompany;
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
    }

    public String getPermissionItem() {
        return null;
    }

    public IF7ContextChange getF7ContextManager() {
        return null;
    }

    public IF7Register getF7Register() {
        return null;
    }

    public String getMainOrgKeyForCustomerParams(OrgType orgType) {
        return null;
    }

    public boolean isSupportVirturalOrgs() {
        return false;
    }

    public boolean isSupportMultiOrgs() {
        return false;
    }
}

