/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountBankPropertyEnum;
import com.kingdee.eas.basedata.assistant.SharedAcctType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.common.CapitalHelper;
import com.kingdee.eas.fm.mobile.util.CapitalBalanceVo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CapitalStoreHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.liquid.common.CapitalStoreHelper");

    public Map getStoreInitData(Context ctx, java.util.Date dealDate, int unit) throws BOSException, EASBizException {
        Map<String, Set<String>> result = new HashMap<String, Object>();
        ArrayList<CapitalBalanceVo> detail = new ArrayList<CapitalBalanceVo>();
        Set<String> idSet = CapitalHelper.getPermissionOrgSet(ctx, "CAPITAL_STORE_USE");
        if (idSet.size() == 0) {
            result.put("error", (Set<String>)1);
            result.put("errorMsg", (Set<String>)((Object)"\u8be5\u7528\u6237\u65e0\u4efb\u4f55\u8d22\u52a1\u7ec4\u7ec7\u7684\u8d44\u91d1\u5b58\u91cf\u53ca\u6d41\u6c34\u67e5\u8be2\u6743\u9650"));
            return result;
        }
        List<CompanyOrgUnitInfo> companyList = CapitalHelper.getTopLevelCompanySet(ctx, idSet);
        String currencyId = "";
        String orgIds = CapitalHelper.ListToString(companyList);
        if (companyList.size() == 1) {
            currencyId = companyList.get(0).getBaseCurrency().getId().toString();
            result = this.getOrgCapitalData(ctx, companyList.get(0).getId().toString(), currencyId, dealDate, unit, orgIds, false);
            result.put("currencyId", (Set<String>)((Object)currencyId));
            result.put("idSet", idSet);
        } else {
            result.put("idSet", idSet);
            String acctBankIds = null;
            boolean zjdc001 = Boolean.valueOf(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue(null, "Zjdc001"));
            if (zjdc001) {
                result.put("orgIds", (Set<String>)((Object)orgIds));
                Set acctBankIdSet = CapitalHelper.getInGroupAcctBankIds(ctx, idSet);
                if (acctBankIdSet != null) {
                    acctBankIds = CapitalHelper.setToString(acctBankIdSet);
                }
            }
            Map<String, BigDecimal> comBalance = null;
            boolean zjdc002 = Boolean.valueOf(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue(null, "Zjdc002"));
            if (zjdc002) {
                result.put("orgIds", (Set<String>)((Object)orgIds));
                comBalance = this.getComBalance(ctx, idSet, companyList.get(0).getBaseCurrency().getId().toString(), dealDate);
            }
            Map<String, BigDecimal> acctComBalance = null;
            boolean zjdc003 = Boolean.valueOf(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue(null, "Zjdc003"));
            if (zjdc003) {
                result.put("orgIds", (Set<String>)((Object)orgIds));
                acctComBalance = this.getAcctComBalance(ctx, idSet, companyList.get(0).getBaseCurrency().getId().toString(), dealDate);
            }
            for (int i = 0; i < companyList.size(); ++i) {
                CompanyOrgUnitInfo companyInfo = companyList.get(i);
                if (i == 0) {
                    currencyId = companyInfo.getBaseCurrency().getId().toString();
                    result.put("currencyId", (Set<String>)((Object)currencyId));
                }
                StringBuilder sb = new StringBuilder();
                sb.append(" select sum(t0.fbalance) balance from T_ORG_COMPANY main ");
                sb.append(" left join T_LI_CapitalData t0 on main.fid=t0.forgid ");
                sb.append(" where ( main.flongnumber like ? or main.fid = ? )");
                sb.append(" and t0.FCurrencyID=? and t0.FBizDate=? and main.fISFREEZE=0 and main.fIsSealUp=0");
                if (acctBankIds != null) {
                    sb.append(" and t0.FACCID not in (" + acctBankIds + ")");
                }
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{companyInfo.getLongNumber() + "!%", companyInfo.getId().toString(), currencyId, new Timestamp(dealDate.getTime())});
                try {
                    while (rs.next()) {
                        BigDecimal topComBalance;
                        String companyId;
                        BigDecimal balance = rs.getBigDecimal("balance") == null ? BigDecimal.ZERO : rs.getBigDecimal("balance");
                        CapitalBalanceVo vo = new CapitalBalanceVo();
                        vo.setUnit(unit);
                        vo.setObjID(companyInfo.getId().toString());
                        vo.setObjName(companyInfo.getName());
                        vo.setType("org");
                        vo.setBalance(balance);
                        detail.add(vo);
                        if (comBalance != null) {
                            if (companyInfo.isIsLeaf()) {
                                companyId = companyInfo.getId().toString();
                                BigDecimal innerBalance = comBalance.get(companyId) == null ? BigDecimal.ZERO : comBalance.get(companyId);
                                vo.setBalance(balance.subtract(innerBalance));
                            } else {
                                topComBalance = this.getTopComBalance(ctx, comBalance, companyInfo.getLongNumber());
                                vo.setBalance(balance.subtract(topComBalance));
                            }
                        }
                        if (acctComBalance == null) continue;
                        if (companyInfo.isIsLeaf()) {
                            companyId = companyInfo.getId().toString();
                            BigDecimal comAcctBalance = acctComBalance.get(companyId) == null ? BigDecimal.ZERO : acctComBalance.get(companyId);
                            vo.setBalance(balance.add(comAcctBalance));
                            continue;
                        }
                        topComBalance = this.getTopComBalance(ctx, acctComBalance, companyInfo.getLongNumber());
                        vo.setBalance(balance.add(topComBalance));
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            Collections.sort(detail, (Comparator)new Comparator<CapitalBalanceVo>(){

                @Override
                public int compare(CapitalBalanceVo o1, CapitalBalanceVo o2) {
                    return o2.getBalance().compareTo(o1.getBalance());
                }
            });
            result.put("detail", (Set<String>)((Object)detail));
            result.put("detailType", (Set<String>)((Object)"org"));
        }
        return result;
    }

    public Map getOrgCapitalData(Context ctx, String queryId, String currencyId, java.util.Date dealDate, int unit, String orgIds, boolean isF7Query) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            CompanyOrgUnitInfo orgInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(queryId));
            String acctBankIds = null;
            boolean zjdc001 = Boolean.valueOf(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue(null, "Zjdc001"));
            if (zjdc001) {
                if (isF7Query) {
                    acctBankIds = CapitalHelper.getInGroupAcctBankIds(ctx, orgInfo.getLongNumber());
                    result.put("orgIds", queryId);
                } else {
                    acctBankIds = CapitalHelper.getAcctBankIds(ctx, orgIds);
                    result.put("orgIds", orgIds);
                }
            }
            Map<String, BigDecimal> comBalance = null;
            boolean zjdc002 = Boolean.valueOf(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue(null, "Zjdc002"));
            if (zjdc002) {
                if (isF7Query) {
                    orgIds = queryId;
                }
                result.put("orgIds", orgIds);
                Set companyIdSet = CapitalHelper.getCompanySet(ctx, orgIds);
                if (companyIdSet != null) {
                    comBalance = this.getComBalance(ctx, companyIdSet, currencyId, dealDate);
                }
            }
            Set<String> userAcctIdSet = null;
            Map<String, BigDecimal> shareAcctBalance = null;
            Map<String, BigDecimal> acctComBalance = null;
            boolean zjdc003 = Boolean.valueOf(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue(null, "Zjdc003"));
            if (zjdc003) {
                Set companyIdSet;
                if (isF7Query) {
                    orgIds = queryId;
                }
                if ((companyIdSet = CapitalHelper.getCompanySet(ctx, orgIds)) != null && companyIdSet.size() > 1) {
                    userAcctIdSet = CapitalHelper.getUserAcctBankIds(ctx, companyIdSet);
                    Map<String, BigDecimal> userAcctBalMap = this.getUserAcctBankBalance(ctx, companyIdSet, currencyId, dealDate);
                    shareAcctBalance = this.getShareAcctBankBalance(ctx, companyIdSet, userAcctBalMap);
                    acctComBalance = this.getAcctComBalance(ctx, (Set<String>)companyIdSet, userAcctBalMap, shareAcctBalance);
                }
                result.put("orgIds", orgIds);
            }
            this.fillSumData(ctx, orgInfo, currencyId, result, dealDate, unit, acctBankIds, comBalance, acctComBalance);
            if (orgInfo.isIsLeaf()) {
                this.fillAcctBankAndCashData(ctx, orgInfo, currencyId, result, dealDate, unit, acctBankIds, comBalance, userAcctIdSet, shareAcctBalance);
            } else {
                this.fillChildrenOrgData(ctx, orgInfo, currencyId, result, dealDate, unit, acctBankIds, comBalance, acctComBalance);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf>>\u5f02\u5e38\u63d0\u793a");
            logger.error((Object)e);
            result.put("error", 1);
            result.put("errorMsg", e.getMessage());
        }
        return result;
    }

    protected void fillSumData(Context ctx, CompanyOrgUnitInfo orgInfo, String currencyId, Map result, java.util.Date date, int unit, String acctBankIds, Map<String, BigDecimal> comBalance, Map<String, BigDecimal> acctComBalance) throws BOSException, EASBizException {
        String orgId = orgInfo.getId().toString();
        StringBuilder sb = new StringBuilder();
        sb.append(" select sum(t0.fbalance) balance from T_ORG_COMPANY main ");
        sb.append(" left join T_LI_CapitalData t0 on main.fid=t0.forgid ");
        sb.append(" where ( main.flongnumber like ? or main.fid = ? ) ");
        sb.append(" and t0.FCurrencyID=? and t0.FBizDate=? and main.fISFREEZE=0 and main.fIsSealUp=0");
        if (acctBankIds != null) {
            sb.append(" and t0.FACCID not in (" + acctBankIds + ")");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{orgInfo.getLongNumber() + "!%", orgId, currencyId, new Timestamp(date.getTime())});
        try {
            while (rs.next()) {
                BigDecimal topComBalance;
                BigDecimal sum = rs.getBigDecimal("balance") == null ? BigDecimal.ZERO : rs.getBigDecimal("balance");
                CapitalBalanceVo vo = new CapitalBalanceVo();
                vo.setUnit(unit);
                vo.setObjID(orgId);
                vo.setObjName(orgInfo.getName());
                vo.setType("org");
                vo.setBalance(sum);
                result.put("sum", vo);
                if (comBalance != null) {
                    topComBalance = this.getTopComBalance(ctx, comBalance, orgInfo.getLongNumber());
                    vo.setBalance(sum.subtract(topComBalance));
                }
                if (acctComBalance == null) continue;
                topComBalance = this.getTopComBalance(ctx, acctComBalance, orgInfo.getLongNumber());
                vo.setBalance(sum.add(topComBalance));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void fillAcctBankAndCashData(Context ctx, CompanyOrgUnitInfo orgInfo, String currencyId, Map result, java.util.Date date, int unit, String acctBankIds, Map<String, BigDecimal> comBalance, Set<String> userAcctIdSet, Map<String, BigDecimal> shareAcctBalance) throws BOSException, EASBizException {
        BigDecimal balance;
        ArrayList<CapitalBalanceVo> detail = new ArrayList<CapitalBalanceVo>();
        String orgId = orgInfo.getId().toString();
        String sqlForAcctBank = "select main.fbalance balance,main.faccid accId,t0.fname_l2 name,t0.FBANKACCOUNTNUMBER number from T_LI_CapitalData main left join T_BD_ACCOUNTBANKS t0  on main.FAccID=t0.fid  where main.FOrgID = ? and main.FCurrencyID=? and main.FBizDate=? and main.FCashOrBank=2 and t0.fisclosed=0 ";
        if (acctBankIds != null) {
            sqlForAcctBank = sqlForAcctBank + " and main.FACCID not in (" + acctBankIds + ")";
        }
        IRowSet rsAcctBank = DbUtil.executeQuery((Context)ctx, (String)sqlForAcctBank, (Object[])new Object[]{orgId, currencyId, new Timestamp(date.getTime())});
        try {
            while (rsAcctBank.next()) {
                BigDecimal balance2 = rsAcctBank.getBigDecimal("balance") == null ? BigDecimal.ZERO : rsAcctBank.getBigDecimal("balance");
                String name = rsAcctBank.getString("name");
                String id = rsAcctBank.getString("accId");
                if (userAcctIdSet != null && userAcctIdSet.contains(id)) continue;
                if (shareAcctBalance != null && shareAcctBalance.keySet().contains(id)) {
                    balance2 = balance2.add(shareAcctBalance.get(id));
                }
                String number = rsAcctBank.getString("number");
                CapitalBalanceVo vo = new CapitalBalanceVo();
                vo.setUnit(unit);
                vo.setObjID(id);
                vo.setObjName(name);
                vo.setObjNumber(number);
                vo.setType("acctBank");
                vo.setBalance(balance2);
                detail.add(vo);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        Collections.sort(detail, (Comparator)new Comparator<CapitalBalanceVo>(){

            @Override
            public int compare(CapitalBalanceVo o1, CapitalBalanceVo o2) {
                return o2.getBalance().compareTo(o1.getBalance());
            }
        });
        String sqlForCash = "select main.FBalance balance,t0.fname_l2 name,main.FAccID accId  from T_LI_CapitalData main  left join T_BD_AccountView t0 on main.FAccID=t0.fid  where main.FOrgID=? and main.FCurrencyID=? and main.FBizDate=? and main.FCashOrBank=1  order by main.FBalance desc ";
        IRowSet rsCash = DbUtil.executeQuery((Context)ctx, (String)sqlForCash, (Object[])new Object[]{orgId, currencyId, new Timestamp(date.getTime())});
        try {
            while (rsCash.next()) {
                balance = rsCash.getBigDecimal("balance") == null ? BigDecimal.ZERO : rsCash.getBigDecimal("balance");
                String name = rsCash.getString("name");
                String id = rsCash.getString("accId");
                CapitalBalanceVo vo = new CapitalBalanceVo();
                vo.setUnit(unit);
                vo.setObjID(id);
                vo.setObjName(name);
                vo.setObjNumber("\u73b0\u91d1\u79d1\u76ee");
                vo.setType("cash");
                vo.setBalance(balance);
                detail.add(vo);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (comBalance != null && (balance = comBalance.get(orgId)) != null && balance.compareTo(BigDecimal.ZERO) != 0) {
            CapitalBalanceVo vo = new CapitalBalanceVo();
            vo.setUnit(unit);
            vo.setObjID("1");
            vo.setObjName("\u5185\u90e8\u5b58\u6b3e");
            vo.setObjNumber(" ");
            vo.setType("cash");
            vo.setBalance(balance.negate());
            detail.add(vo);
        }
        String accFilter = " company.id = '" + orgId + "' and isclosed=0 ";
        result.put("accFilter", accFilter);
        result.put("detail", detail);
        result.put("detailType", "acctBank");
    }

    protected void fillChildrenOrgData(Context ctx, CompanyOrgUnitInfo orgInfo, String currencyId, Map result, java.util.Date date, int unit, String acctBankIds, Map<String, BigDecimal> comBalance, Map<String, BigDecimal> acctComBalance) throws BOSException, EASBizException {
        ArrayList<CapitalBalanceVo> detail = new ArrayList<CapitalBalanceVo>();
        String orgId = orgInfo.getId().toString();
        String sqlForChildren = " SELECT flongnumber,fid,fname_l2 name,fIsLeaf FROM T_ORG_COMPANY where FPARENTID = ? and fISFREEZE=0 and fIsSealUp=0 ";
        IRowSet rsChild = DbUtil.executeQuery((Context)ctx, (String)sqlForChildren, (Object[])new Object[]{orgId});
        try {
            while (rsChild.next()) {
                String name = rsChild.getString("name");
                String id = rsChild.getString("fid");
                String flongnumber = rsChild.getString("flongnumber");
                String sql = "SELECT sum(t0.fbalance) balance FROM T_ORG_COMPANY main left join T_LI_CapitalData t0 on  main.fid=t0.forgid where ( main.flongnumber like ? or main.fid = ? ) and t0.FBizDate= ? and t0.FCurrencyID=? and main.fISFREEZE=0 and main.fIsSealUp=0 ";
                if (acctBankIds != null) {
                    sql = sql + " and t0.FACCID not in (" + acctBankIds + ")";
                }
                IRowSet rsChildSum = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{flongnumber + "!%", id, new Timestamp(date.getTime()), currencyId});
                while (rsChildSum.next()) {
                    BigDecimal topComBalance;
                    BigDecimal balance;
                    BigDecimal sum = rsChildSum.getBigDecimal("balance") == null ? BigDecimal.ZERO : rsChildSum.getBigDecimal("balance");
                    CapitalBalanceVo vo = new CapitalBalanceVo();
                    vo.setUnit(unit);
                    vo.setObjID(id);
                    vo.setObjName(name);
                    vo.setType("org");
                    vo.setBalance(sum);
                    detail.add(vo);
                    if (comBalance != null) {
                        if (rsChild.getInt("fIsLeaf") == 1) {
                            balance = comBalance.get(id) == null ? BigDecimal.ZERO : comBalance.get(id);
                            vo.setBalance(sum.subtract(balance));
                        } else {
                            topComBalance = this.getTopComBalance(ctx, comBalance, flongnumber);
                            vo.setBalance(sum.subtract(topComBalance));
                        }
                    }
                    if (acctComBalance == null) continue;
                    if (rsChild.getInt("fIsLeaf") == 1) {
                        balance = acctComBalance.get(id) == null ? BigDecimal.ZERO : acctComBalance.get(id);
                        vo.setBalance(sum.add(balance));
                        continue;
                    }
                    topComBalance = this.getTopComBalance(ctx, acctComBalance, flongnumber);
                    vo.setBalance(sum.add(topComBalance));
                }
            }
            Collections.sort(detail, (Comparator)new Comparator<CapitalBalanceVo>(){

                @Override
                public int compare(CapitalBalanceVo o1, CapitalBalanceVo o2) {
                    return o2.getBalance().compareTo(o1.getBalance());
                }
            });
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        result.put("detail", detail);
        result.put("detailType", "org");
    }

    public Map queryAcctBankStoreDataByAccId(Context ctx, String acctBankId, String currencyId, java.util.Date dealDate, int unit) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<CapitalBalanceVo> detail = new ArrayList<CapitalBalanceVo>();
        String sqlForAcctBank = "select main.fbalance balance,main.faccid accId,t0.fname_l2 name,t0.FBANKACCOUNTNUMBER number from T_LI_CapitalData main left join T_BD_ACCOUNTBANKS t0  on main.FAccID=t0.fid  where main.FAccID = ? and main.FCurrencyID=? and main.FBizDate=? and main.FCashOrBank=2 and t0.fisclosed=0 ";
        IRowSet rsAcctBank = DbUtil.executeQuery((Context)ctx, (String)sqlForAcctBank, (Object[])new Object[]{acctBankId, currencyId, new Timestamp(dealDate.getTime())});
        try {
            while (rsAcctBank.next()) {
                BigDecimal balance = rsAcctBank.getBigDecimal("balance") == null ? BigDecimal.ZERO : rsAcctBank.getBigDecimal("balance");
                String name = rsAcctBank.getString("name");
                String id = rsAcctBank.getString("accId");
                String number = rsAcctBank.getString("number");
                CapitalBalanceVo vo = new CapitalBalanceVo();
                vo.setUnit(unit);
                vo.setObjID(id);
                vo.setObjName(name);
                vo.setObjNumber(number);
                vo.setType("acctBank");
                vo.setBalance(balance);
                detail.add(vo);
            }
            result.put("detail", detail);
            result.put("detailType", "acctBank");
        }
        catch (Exception e) {
            logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf>>\u5f02\u5e38\u63d0\u793a");
            logger.error((Object)e);
            result.put("error", 1);
            result.put("errorMsg", e.getMessage());
        }
        return result;
    }

    public Map getHomePageData(Context ctx, java.util.Date dealDate, int unit) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("companyCount", 0);
        result.put("current", 0);
        result.put("fixed", 0);
        result.put("loan", 0);
        result.put("inAmount", BigDecimal.ZERO);
        result.put("outAmount", BigDecimal.ZERO);
        result.put("balance", BigDecimal.ZERO);
        result.put("currencyId", "dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC");
        try {
            Set<String> idSet = CapitalHelper.getPermissionOrgSet(ctx, "CAPITAL_STORE_USE");
            if (idSet.size() != 0) {
                boolean zjdc004;
                Set companyIdSet;
                boolean zjdc002;
                String sql = "select fbizdate from T_LI_LoginLog where fuserid=? ";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{ctx.getCaller().toString()});
                while (rs.next()) {
                    Date lastLoginDate = rs.getDate("fbizdate");
                    String lastLoginTime = rs.getTimestamp("fbizdate").toString();
                    result.put("lastLoginDate", lastLoginDate);
                    result.put("lastLoginTime", lastLoginTime);
                }
                String deleteSql = "delete from T_LI_LoginLog where fuserid=? ";
                String insertSql = "INSERT INTO T_LI_LoginLog (Fbizdate,fuserId ) VALUES (?,? )";
                DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])new Object[]{ctx.getCaller().toString()});
                DbUtil.execute((Context)ctx, (String)insertSql, (Object[])new Object[]{new Timestamp(new java.util.Date().getTime()), ctx.getCaller().toString()});
                List<CompanyOrgUnitInfo> companyList = CapitalHelper.getTopLevelCompanySet(ctx, idSet);
                String currencyId = "";
                for (int i = 0; i < companyList.size(); ++i) {
                    CompanyOrgUnitInfo companyInfo = companyList.get(i);
                    if (i == 0) {
                        currencyId = companyInfo.getBaseCurrency().getId().toString();
                        result.put("currencyId", currencyId);
                    }
                    this.putCompanyDetail(ctx, companyInfo.getId().toString(), currencyId, dealDate, unit, result);
                }
                boolean zjdc001 = Boolean.valueOf(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue(null, "Zjdc001"));
                if (zjdc001) {
                    BigDecimal balance = (BigDecimal)result.get("balance");
                    Set companyIdSet2 = CapitalHelper.getCompanyIdSet(ctx, companyList);
                    BigDecimal acctBalance = this.getIngroupBalance(ctx, companyIdSet2, currencyId, dealDate);
                    result.put("balance", balance.subtract(acctBalance));
                }
                if (zjdc002 = Boolean.valueOf(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue(null, "Zjdc002")).booleanValue()) {
                    BigDecimal balance = (BigDecimal)result.get("balance");
                    companyIdSet = CapitalHelper.getCompanyIdSet(ctx, companyList);
                    BigDecimal totalBalance = this.getTotalClearingHouseBalance(ctx, companyIdSet, currencyId, dealDate);
                    result.put("balance", balance.subtract(totalBalance));
                }
                if (!(zjdc004 = Boolean.valueOf(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue(null, "Zjdc004")).booleanValue())) {
                    companyIdSet = CapitalHelper.getCompanyIdSet(ctx, companyList);
                    this.removeIngroupAcctBank(ctx, companyIdSet, result);
                }
            }
            String formatInAmount = new DecimalFormat("###,##0.00").format(((BigDecimal)result.get("inAmount")).divide(new BigDecimal(unit)));
            String formatOutAmount = new DecimalFormat("###,##0.00").format(((BigDecimal)result.get("outAmount")).divide(new BigDecimal(unit)));
            String formatBalance = new DecimalFormat("###,##0.00").format(((BigDecimal)result.get("balance")).divide(new BigDecimal(unit)));
            result.put("formatInAmount", formatInAmount);
            result.put("formatOutAmount", formatOutAmount);
            result.put("formatBalance", formatBalance);
            this.finHomePageData(ctx, result, unit);
        }
        catch (Exception e) {
            result.put("error", 1);
            result.put("errorMsg", e.getMessage());
            logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf>>\u5f02\u5e38\u63d0\u793a");
            logger.error((Object)e);
        }
        return result;
    }

    protected void putCompanyDetail(Context ctx, String queryId, String currencyId, java.util.Date dealDate, int unit, Map result) throws BOSException, EASBizException {
        String sqlForCompany = " select count(*) companyCount from T_ORG_COMPANY where ( flongnumber like ( select CONCAT(flongnumber,'!%') from T_ORG_COMPANY where fid=? ) or fid=? ) and fISFREEZE=0 and fIsSealUp=0 ";
        IRowSet rsCompany = DbUtil.executeQuery((Context)ctx, (String)sqlForCompany, (Object[])new Object[]{queryId, queryId});
        String sqlForAcctBank = " select count(t0.Fproperty) num ,t0.Fproperty acctBankType from T_BD_AccountBanks main  left join T_BD_AccountProperty t0 on main.Fpropertyid=t0.fid  left join T_ORG_COMPANY t1 on main.FcompanyId=t1.fid  where ( t1.flongnumber like ( select CONCAT(flongnumber,'!%') from T_ORG_COMPANY where fid=? ) or t1.fid=? )  and main.fisclosed = 0  and t1.fISFREEZE=0 and t1.fIsSealUp=0  group by t0.Fproperty ";
        IRowSet rsAcctBank = DbUtil.executeQuery((Context)ctx, (String)sqlForAcctBank, (Object[])new Object[]{queryId, queryId});
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.setTime(dealDate);
        cale.add(2, 0);
        cale.set(5, 1);
        java.util.Date firstDay = cale.getTime();
        cale = Calendar.getInstance();
        cale.setTime(dealDate);
        cale.add(2, 1);
        cale.set(5, 0);
        java.util.Date lastday = cale.getTime();
        StringBuilder sb = new StringBuilder();
        sb.append(" select sum(t0.finAmount) inAmount,sum(t0.foutAmount) outAmount ");
        sb.append(" from T_ORG_COMPANY main ");
        sb.append(" left join T_LI_CapitalData t0 on main.fid=t0.forgid ");
        sb.append(" where ( main.flongnumber like ( select CONCAT(flongnumber,'!%') from T_ORG_COMPANY where fid=? ) or main.fid=? ) ");
        sb.append(" and t0.FCurrencyID=? and t0.FBizDate>=? and t0.FBizDate<=? and main.fISFREEZE=0 and main.fIsSealUp=0 ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{queryId, queryId, currencyId, new Timestamp(firstDay.getTime()), new Timestamp(lastday.getTime())});
        StringBuilder sbBalance = new StringBuilder();
        sbBalance.append(" select sum(t0.fbalance) balance ");
        sbBalance.append(" from T_ORG_COMPANY main ");
        sbBalance.append(" left join T_LI_CapitalData t0 on main.fid=t0.forgid ");
        sbBalance.append(" where ( main.flongnumber like ( select CONCAT(flongnumber,'!%') from T_ORG_COMPANY where fid=? ) or main.fid=? ) ");
        sbBalance.append(" and t0.FCurrencyID=? and t0.FBizDate=? and main.fISFREEZE=0 and main.fIsSealUp=0 ");
        IRowSet rsBalance = DbUtil.executeQuery((Context)ctx, (String)sbBalance.toString(), (Object[])new Object[]{queryId, queryId, currencyId, new Timestamp(dealDate.getTime())});
        try {
            while (rsCompany.next()) {
                int companyCount = rsCompany.getInt("companyCount");
                int used = (Integer)result.get("companyCount");
                int all = companyCount + used;
                result.put("companyCount", all);
            }
            while (rsAcctBank.next()) {
                int used;
                int num = rsAcctBank.getInt("num");
                int acctBankType = rsAcctBank.getInt("acctBankType");
                if (1 == acctBankType) {
                    used = (Integer)result.get("current");
                    result.put("current", used + num);
                    continue;
                }
                if (2 == acctBankType) {
                    used = (Integer)result.get("fixed");
                    result.put("fixed", used + num);
                    continue;
                }
                if (3 != acctBankType) continue;
                used = (Integer)result.get("loan");
                result.put("loan", used + num);
            }
            while (rs.next()) {
                BigDecimal inAmount = rs.getBigDecimal("inAmount") == null ? BigDecimal.ZERO : rs.getBigDecimal("inAmount");
                BigDecimal outAmount = rs.getBigDecimal("outAmount") == null ? BigDecimal.ZERO : rs.getBigDecimal("outAmount");
                BigDecimal usedIn = (BigDecimal)result.get("inAmount");
                BigDecimal usedOut = (BigDecimal)result.get("outAmount");
                result.put("inAmount", usedIn.add(inAmount));
                result.put("outAmount", usedOut.add(outAmount));
            }
            while (rsBalance.next()) {
                BigDecimal balance = rsBalance.getBigDecimal("balance") == null ? BigDecimal.ZERO : rsBalance.getBigDecimal("balance");
                BigDecimal used = (BigDecimal)result.get("balance");
                result.put("balance", used.add(balance));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf>>\u5f02\u5e38\u63d0\u793a");
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public BigDecimal getIngroupBalance(Context ctx, Set companyIdSet, String currencyId, java.util.Date dealDate) throws BOSException {
        BigDecimal acctBalance = BigDecimal.ZERO;
        Set acctBankIdSet = CapitalHelper.getInGroupAcctBankIds(ctx, companyIdSet);
        if (acctBankIdSet == null) {
            return acctBalance;
        }
        String acctBankIds = CapitalHelper.setToString(acctBankIdSet);
        String sql = "SELECT sum(FBALANCE) balance FROM T_LI_CapitalData where  FCURRENCYID =? and FBizDate=? and FACCID in (" + acctBankIds + ") ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{currencyId, new Timestamp(dealDate.getTime())});
        try {
            while (rs.next()) {
                acctBalance = rs.getBigDecimal("balance") == null ? BigDecimal.ZERO : rs.getBigDecimal("balance");
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf>>sql\u6c47\u603b\u5185\u90e8\u94f6\u884c\u8d26\u6237\u7684\u4f59\u989d\u548c\u62a5\u9519");
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return acctBalance;
    }

    public BigDecimal getTotalClearingHouseBalance(Context ctx, Set companyIdSet, String currencyId, java.util.Date dealDate) throws BOSException {
        BigDecimal totalBalance = BigDecimal.ZERO;
        Set bankIdSet = CapitalHelper.getClearingHouseIds(ctx, companyIdSet);
        if (bankIdSet == null) {
            return totalBalance;
        }
        String bankIds = CapitalHelper.setToString(bankIdSet);
        String orgIds = CapitalHelper.setToString(companyIdSet);
        String sql = "SELECT sum(FBalance) balance FROM T_LI_InnerAcctBalance where  FCurrencyID =? and FBizDate=? and FBankID in (" + bankIds + ")  and FOrgID in (" + orgIds + ") ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{currencyId, new Timestamp(dealDate.getTime())});
        try {
            while (rs.next()) {
                totalBalance = rs.getBigDecimal("balance") == null ? BigDecimal.ZERO : rs.getBigDecimal("balance");
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf>>sql\u6c47\u603b\u6240\u6709\u516c\u53f8\u5185\u90e8\u8d26\u6237\u660e\u7ec6\u8d26\u7684\u4f59\u989d\u548c\u62a5\u9519");
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return totalBalance;
    }

    public Map<String, BigDecimal> getComBalance(Context ctx, Set companyIdSet, String currencyId, java.util.Date dealDate) throws BOSException {
        HashMap<String, BigDecimal> comBalMap = new HashMap<String, BigDecimal>();
        Set bankIdSet = CapitalHelper.getClearingHouseIds(ctx, companyIdSet);
        if (bankIdSet == null) {
            return null;
        }
        String bankIds = CapitalHelper.setToString(bankIdSet);
        String orgIds = CapitalHelper.setToString(companyIdSet);
        String sql = "SELECT FCompanyID, FBalance FROM T_LI_InnerAcctBalance where  FCurrencyID =? and FBizDate=? and FBankID in (" + bankIds + ")  and FOrgID in (" + orgIds + ") ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{currencyId, new Timestamp(dealDate.getTime())});
        try {
            while (rs.next()) {
                String companyId = rs.getString("FCompanyID");
                BigDecimal balance = rs.getBigDecimal("FBalance") == null ? BigDecimal.ZERO : rs.getBigDecimal("FBalance");
                BigDecimal comBalance = comBalMap.get(companyId) == null ? BigDecimal.ZERO : (BigDecimal)comBalMap.get(companyId);
                comBalMap.put(companyId, comBalance.add(balance));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf>>sql\u83b7\u53d6\u7ed3\u7b97\u4e2d\u5fc3\u7ec4\u7ec7\u5728\u67e5\u8be2\u7684\u7ec4\u7ec7\u4e2d\u7684\u5185\u90e8\u8d26\u6237\u4f59\u989d\u62a5\u9519");
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return comBalMap;
    }

    public BigDecimal getTopComBalance(Context ctx, Map<String, BigDecimal> comBalance, String topCompanyLongnumber) throws BOSException {
        BigDecimal topComBalance = BigDecimal.ZERO;
        Set companyIdSet = CapitalHelper.getCompanyIdSet(ctx, topCompanyLongnumber);
        for (String companyId : companyIdSet) {
            BigDecimal balance = comBalance.get(companyId) == null ? BigDecimal.ZERO : comBalance.get(companyId);
            topComBalance = topComBalance.add(balance);
        }
        return topComBalance;
    }

    public Map<String, BigDecimal> getUserAcctBankBalance(Context ctx, Set<String> companyIdSet, String currencyId, java.util.Date dealDate) throws BOSException {
        HashMap<String, BigDecimal> acctBalMap = new HashMap<String, BigDecimal>();
        Set<String> acctBankIdSet = CapitalHelper.getUserAcctBankIds(ctx, companyIdSet);
        if (acctBankIdSet == null) {
            return null;
        }
        String acctBankIds = CapitalHelper.setToString(acctBankIdSet);
        String orgIds = CapitalHelper.setToString(companyIdSet);
        String sql = "select FAccId, FBalance FROM T_LI_CapitalData where FCurrencyId =? and FBizDate=? and FAccId in (" + acctBankIds + ")  and FOrgID in (" + orgIds + ") ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{currencyId, new Timestamp(dealDate.getTime())});
        try {
            while (rs.next()) {
                String acctBankId = rs.getString("FAccId");
                BigDecimal balance = rs.getBigDecimal("FBalance") == null ? BigDecimal.ZERO : rs.getBigDecimal("FBalance");
                BigDecimal acctBankBalance = acctBalMap.get(acctBankId) == null ? BigDecimal.ZERO : (BigDecimal)acctBalMap.get(acctBankId);
                acctBalMap.put(acctBankId, acctBankBalance.add(balance));
            }
        }
        catch (SQLException e) {
            logger.error((Object)("\u8d44\u91d1\u6d1e\u5bdf>>sql\u67e5\u8be2\u516c\u53f8\u4e0b\u975e\u94f6\u4f01\u5171\u4eab\u8d26\u6237\u5173\u8054\u7684\u7684\u4f7f\u7528\u6743\u8d26\u6237\u7684\u4f59\u989d\u62a5\u9519 \u2014" + sql));
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return acctBalMap;
    }

    public Map<String, BigDecimal> getShareAcctBankBalance(Context ctx, Set<String> companyIdSet, String currencyId, java.util.Date dealDate) throws BOSException {
        Map<String, BigDecimal> userAcctBalMap = this.getUserAcctBankBalance(ctx, companyIdSet, currencyId, dealDate);
        Map<String, BigDecimal> shareAcctBalMap = this.getShareAcctBankBalance(ctx, companyIdSet, userAcctBalMap);
        return shareAcctBalMap;
    }

    public Map<String, BigDecimal> getAcctComBalance(Context ctx, Set<String> companyIdSet, String currencyId, java.util.Date dealDate) throws BOSException {
        Map<String, BigDecimal> userAcctBalMap = this.getUserAcctBankBalance(ctx, companyIdSet, currencyId, dealDate);
        Map<String, BigDecimal> shareAcctBalMap = this.getShareAcctBankBalance(ctx, companyIdSet, userAcctBalMap);
        Map<String, BigDecimal> comBalMap = this.getAcctComBalance(ctx, companyIdSet, userAcctBalMap, shareAcctBalMap);
        return comBalMap;
    }

    public Map<String, BigDecimal> getAcctComBalance(Context ctx, Set<String> companyIdSet, Map<String, BigDecimal> userAcctBalMap, Map<String, BigDecimal> shareAcctBalMap) throws BOSException {
        if (userAcctBalMap == null || shareAcctBalMap == null) {
            return null;
        }
        HashMap<String, BigDecimal> comBalMap = new HashMap<String, BigDecimal>();
        HashSet<String> acctBankIdSet = new HashSet<String>();
        acctBankIdSet.addAll(userAcctBalMap.keySet());
        acctBankIdSet.addAll(shareAcctBalMap.keySet());
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("company.id");
        view.getSelector().add("shareType");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", acctBankIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        AccountBankCollection acctBankcoll = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
        for (int i = 0; i < acctBankcoll.size(); ++i) {
            BigDecimal comBalance;
            AccountBankInfo acctBank = acctBankcoll.get(i);
            String companyId = acctBank.getCompany().getId().toString();
            BigDecimal bigDecimal = comBalance = comBalMap.get(companyId) == null ? BigDecimal.ZERO : (BigDecimal)comBalMap.get(companyId);
            if (acctBank.getShareType() == SharedAcctType.shared) {
                BigDecimal shareAcctBalance = shareAcctBalMap.get(acctBank.getId().toString());
                comBalance = comBalance.add(shareAcctBalance);
            } else {
                BigDecimal userAcctBalance = userAcctBalMap.get(acctBank.getId().toString());
                comBalance = comBalance.subtract(userAcctBalance);
            }
            comBalMap.put(companyId, comBalance);
        }
        return comBalMap;
    }

    public Map<String, BigDecimal> getShareAcctBankBalance(Context ctx, Set<String> companyIdSet, Map<String, BigDecimal> userAcctBalMap) throws BOSException {
        HashMap<String, BigDecimal> shareAcctBalMap = new HashMap<String, BigDecimal>();
        Map<String, List<String>> share_UserMap = CapitalHelper.getShare_UserMap(ctx, companyIdSet);
        if (userAcctBalMap == null || share_UserMap == null) {
            return null;
        }
        for (String shareAcctBankId : share_UserMap.keySet()) {
            BigDecimal shareAcctBalance = BigDecimal.ZERO;
            List<String> userAcctBankIds = share_UserMap.get(shareAcctBankId);
            if (userAcctBankIds != null) {
                for (int i = 0; i < userAcctBankIds.size(); ++i) {
                    String userAcctBankId = userAcctBankIds.get(i);
                    BigDecimal userAcctBalance = userAcctBalMap.get(userAcctBankId) == null ? BigDecimal.ZERO : userAcctBalMap.get(userAcctBankId);
                    shareAcctBalance = shareAcctBalance.add(userAcctBalance);
                }
            }
            shareAcctBalMap.put(shareAcctBankId, shareAcctBalance);
        }
        return shareAcctBalMap;
    }

    public void finHomePageData(Context ctx, Map<String, Object> result, int unit) throws BOSException, EASBizException {
        result.put("loanBalance", BigDecimal.ZERO);
        result.put("financingBalance", BigDecimal.ZERO);
        result.put("payNtBalance", BigDecimal.ZERO);
        result.put("recNtBalance", BigDecimal.ZERO);
        try {
            Set<String> idSet = CapitalHelper.getPermissionOrgSet(ctx, "FIN_STORE_USE");
            if (idSet.size() != 0) {
                List<CompanyOrgUnitInfo> companyList = CapitalHelper.getTopLevelCompanySet(ctx, idSet);
                String currencyId = "";
                CompanyOrgUnitInfo companyInfo = companyList.get(0);
                currencyId = companyInfo.getBaseCurrency().getId().toString();
                result.put("currencyId", currencyId);
                this.getLoanBalance(ctx, companyInfo.getId().toString(), currencyId, result);
                this.getFinancingBalance(ctx, companyInfo.getId().toString(), currencyId, result);
                this.getNtBalance(ctx, companyInfo.getId().toString(), result);
            }
            String formatLoanBalance = new DecimalFormat("###,##0.00").format(((BigDecimal)result.get("loanBalance")).divide(new BigDecimal(unit)));
            String formatFinancingBalance = new DecimalFormat("###,##0.00").format(((BigDecimal)result.get("financingBalance")).divide(new BigDecimal(unit)));
            String formatPayNtBalance = new DecimalFormat("###,##0.00").format(((BigDecimal)result.get("payNtBalance")).divide(new BigDecimal(unit)));
            String formatRecNtBalance = new DecimalFormat("###,##0.00").format(((BigDecimal)result.get("recNtBalance")).divide(new BigDecimal(unit)));
            result.put("formatLoanBalance", formatLoanBalance);
            result.put("formatFinancingBalance", formatFinancingBalance);
            result.put("formatPayNtBalance", formatPayNtBalance);
            result.put("formatRecNtBalance", formatRecNtBalance);
        }
        catch (Exception e) {
            result.put("error", 1);
            result.put("errorMsg", e.getMessage());
            logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf>>\u6295\u878d\u8d44finHomePageData\u9996\u9875\u5f02\u5e38\u63d0\u793a");
            logger.error((Object)e);
        }
    }

    protected void getLoanBalance(Context ctx, String companyId, String currencyId, Map result) throws BOSException, EASBizException {
        StringBuilder sbBalance = new StringBuilder();
        sbBalance.append(" select sum(t0.FBalance) balance ");
        sbBalance.append(" from T_ORG_COMPANY com ");
        sbBalance.append(" left join T_LI_LoanBalance t0 on com.FID=t0.FCompanyID ");
        sbBalance.append(" where ( com.flongnumber like ( select CONCAT(flongnumber,'!%') from T_ORG_COMPANY where FID=? ) or com.FID=? ) ");
        sbBalance.append(" and t0.FCurrencyID=? and com.fISFREEZE=0 and com.fIsSealUp=0 ");
        IRowSet rsBalance = DbUtil.executeQuery((Context)ctx, (String)sbBalance.toString(), (Object[])new Object[]{companyId, companyId, currencyId});
        try {
            while (rsBalance.next()) {
                BigDecimal balance = rsBalance.getBigDecimal("balance") == null ? BigDecimal.ZERO : rsBalance.getBigDecimal("balance");
                BigDecimal loanBalance = (BigDecimal)result.get("loanBalance");
                result.put("loanBalance", loanBalance.add(balance));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf>>\u8d44\u91d1\u6d1e\u5bdf\u9996\u9875 \u501f\u6b3e\u53d6\u6570\u5f02\u5e38\u63d0\u793a");
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected void getFinancingBalance(Context ctx, String companyId, String currencyId, Map result) throws BOSException, EASBizException {
        StringBuilder sbBalance = new StringBuilder();
        sbBalance.append(" select sum(t0.FBalance) balance ");
        sbBalance.append(" from T_ORG_COMPANY com ");
        sbBalance.append(" left join T_LI_FinancingBalance t0 on com.FID=t0.FCompanyID ");
        sbBalance.append(" where ( com.flongnumber like ( select CONCAT(flongnumber,'!%') from T_ORG_COMPANY where FID=? ) or com.FID=? ) ");
        sbBalance.append(" and t0.FCurrencyID=? and com.fISFREEZE=0 and com.fIsSealUp=0 ");
        IRowSet rsBalance = DbUtil.executeQuery((Context)ctx, (String)sbBalance.toString(), (Object[])new Object[]{companyId, companyId, currencyId});
        try {
            while (rsBalance.next()) {
                BigDecimal balance = rsBalance.getBigDecimal("balance") == null ? BigDecimal.ZERO : rsBalance.getBigDecimal("balance");
                BigDecimal financingBalance = (BigDecimal)result.get("financingBalance");
                result.put("financingBalance", financingBalance.add(balance));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf>>\u8d44\u91d1\u6d1e\u5bdf\u9996\u9875 \u6295\u8d44\u53d6\u6570\u5f02\u5e38\u63d0\u793a");
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected void getNtBalance(Context ctx, String companyId, Map result) throws BOSException, EASBizException {
        StringBuilder sbBalance = new StringBuilder();
        sbBalance.append(" select sum(t0.FPayBillAmt) payBillAmt, sum(t0.FRecBillAmt) recBillAmt ");
        sbBalance.append(" from T_ORG_COMPANY com ");
        sbBalance.append(" left join T_LI_NtBalance t0 on com.FID=t0.FCompanyID ");
        sbBalance.append(" where ( com.flongnumber like ( select CONCAT(flongnumber,'!%') from T_ORG_COMPANY where FID=? ) or com.FID=? ) ");
        sbBalance.append(" and com.fISFREEZE=0 and com.fIsSealUp=0 ");
        IRowSet rsBalance = DbUtil.executeQuery((Context)ctx, (String)sbBalance.toString(), (Object[])new Object[]{companyId, companyId});
        try {
            while (rsBalance.next()) {
                BigDecimal payBillAmt = rsBalance.getBigDecimal("payBillAmt") == null ? BigDecimal.ZERO : rsBalance.getBigDecimal("payBillAmt");
                BigDecimal payNtBalance = (BigDecimal)result.get("payNtBalance");
                result.put("payNtBalance", payNtBalance.add(payBillAmt));
                BigDecimal recBillAmt = rsBalance.getBigDecimal("recBillAmt") == null ? BigDecimal.ZERO : rsBalance.getBigDecimal("recBillAmt");
                BigDecimal recNtBalance = (BigDecimal)result.get("recNtBalance");
                result.put("recNtBalance", recNtBalance.add(recBillAmt));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf>>\u8d44\u91d1\u6d1e\u5bdf\u9996\u9875 \u7968\u636e\u53d6\u6570\u5f02\u5e38\u63d0\u793a");
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public void removeIngroupAcctBank(Context ctx, Set companyIdSet, Map<String, Object> result) throws BOSException {
        Set acctBankIdSet = CapitalHelper.getAllInGroupAcctBankIds(ctx, companyIdSet);
        if (acctBankIdSet == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)acctBankIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("property.*");
        view.setSelector(selector);
        AccountBankCollection acctBankcoll = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
        block5: for (int i = 0; i < acctBankcoll.size(); ++i) {
            AccountBankInfo acctBank = acctBankcoll.get(i);
            AccountBankPropertyEnum property = acctBank.getProperty().getProperty();
            switch (property.getValue()) {
                case 1: {
                    result.put("current", (Integer)result.get("current") - 1);
                    continue block5;
                }
                case 2: {
                    result.put("fixed", (Integer)result.get("fixed") - 1);
                    continue block5;
                }
                case 3: {
                    result.put("loan", (Integer)result.get("loan") - 1);
                }
            }
        }
    }
}

