/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.common.CapitalHelper;
import com.kingdee.eas.fm.mobile.util.CapitalTrendVo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CapitalTrendHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.liquid.common.CapitalTrendHelper");

    public Map getInitData(Context ctx) throws BOSException, EASBizException {
        Map<String, Object> result = new HashMap<String, Object>();
        Set<String> idSet = CapitalHelper.getPermissionOrgSet(ctx, "CAPITAL_STORE_USE");
        if (idSet.size() == 0) {
            result.put("error", 1);
            result.put("errorMsg", "\u8be5\u7528\u6237\u65e0\u4efb\u4f55\u8d22\u52a1\u7ec4\u7ec7\u7684\u8d44\u91d1\u5b58\u91cf\u53ca\u6d41\u6c34\u67e5\u8be2\u6743\u9650");
        } else {
            List<CompanyOrgUnitInfo> companyList = CapitalHelper.getTopLevelCompanySet(ctx, idSet);
            CompanyOrgUnitInfo company = null;
            if (companyList.size() == 1) {
                company = companyList.get(0);
            }
            if (companyList.size() > 1) {
                company = CapitalHelper.getDefaultCompany(ctx, companyList);
            }
            if (company != null) {
                String companyId = company.getId().toString();
                String currencyId = company.getBaseCurrency().getId().toString();
                result = this.getDataByFilter(ctx, companyId, currencyId);
            }
            result.put("idSet", idSet);
        }
        return result;
    }

    public Map getDataByFilter(Context ctx, String companyIds, String currencyId) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] companyList = companyIds.split(",");
        if (companyList.length > 5) {
            result.put("error", 1);
            result.put("errorMsg", "\u6700\u591a\u53ea\u5141\u8bb8\u9009\u62e9\u4e94\u4e2a\u516c\u53f8");
            return result;
        }
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
        result.put("unit", "\u4e07\u5143");
        result.put("currency", currency);
        ArrayList<CapitalTrendVo> yearList = new ArrayList<CapitalTrendVo>();
        ArrayList<CapitalTrendVo> monthList = new ArrayList<CapitalTrendVo>();
        ArrayList<CapitalTrendVo> dayList = new ArrayList<CapitalTrendVo>();
        boolean zjdc001 = Boolean.valueOf(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue(null, "Zjdc001"));
        String acctBankIds = null;
        if (zjdc001) {
            acctBankIds = CapitalHelper.getAcctBankIds(ctx, companyIds);
        }
        for (int i = 0; i < companyList.length; ++i) {
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyList[i]));
            CapitalTrendVo yearVo = this.getYearData(ctx, company, currencyId, acctBankIds);
            yearList.add(yearVo);
            CapitalTrendVo monthVo = this.getMonthData(ctx, company, currencyId, acctBankIds);
            monthList.add(monthVo);
            CapitalTrendVo dayVo = this.getDayData(ctx, company, currencyId, acctBankIds);
            dayList.add(dayVo);
        }
        result.put("yearList", yearList);
        result.put("monthList", monthList);
        result.put("dayList", dayList);
        return result;
    }

    private CapitalTrendVo getYearData(Context ctx, CompanyOrgUnitInfo company, String currencyId, String acctBankIds) throws BOSException, EASBizException {
        ArrayList<String> yearXData = new ArrayList<String>();
        ArrayList<BigDecimal> yearYData = new ArrayList<BigDecimal>();
        for (int j = 4; j >= 0; --j) {
            Calendar yearBefore = Calendar.getInstance();
            yearBefore.set(yearBefore.get(1) - j, 0, 1, 0, 0, 0);
            yearBefore.set(14, 0);
            yearXData.add(String.valueOf(yearBefore.get(1)));
            Calendar yearAfter = Calendar.getInstance();
            yearAfter.set(yearAfter.get(1) + 1 - j, 0, 1, 0, 0, 0);
            yearAfter.set(14, 0);
            StringBuilder sb = new StringBuilder();
            sb.append(" SELECT sum(t0.fbalance)/count(distinct t0.fbizdate) balance ");
            sb.append(" FROM T_ORG_COMPANY main ");
            sb.append(" left join T_LI_CapitalData t0 on main.fid=t0.forgid ");
            sb.append(" where ( main.flongnumber LIKE ? or main.fid=? ) and t0.fcurrencyid=? and t0.fbizdate>=? and t0.fbizdate<? ");
            sb.append(" and main.fISFREEZE=0 and main.fIsSealUp=0 ");
            if (acctBankIds != null) {
                sb.append(" and t0.FACCID not in (" + acctBankIds + ")");
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{company.getLongNumber() + "!%", company.getId().toString(), currencyId, new Timestamp(yearBefore.getTime().getTime()), new Timestamp(yearAfter.getTime().getTime())});
            try {
                while (rs.next()) {
                    BigDecimal balance = rs.getBigDecimal("balance") == null ? BigDecimal.ZERO : rs.getBigDecimal("balance");
                    yearYData.add(balance.divide(new BigDecimal("10000")).setScale(2, RoundingMode.HALF_UP));
                }
                continue;
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        CapitalTrendVo vo = new CapitalTrendVo();
        vo.setCompanyId(company.getId().toString());
        vo.setCompanyName(company.getName());
        vo.setType("year");
        vo.setxData(yearXData);
        vo.setyData(yearYData);
        return vo;
    }

    private CapitalTrendVo getMonthData(Context ctx, CompanyOrgUnitInfo company, String currencyId, String acctBankIds) throws BOSException, EASBizException {
        ArrayList<String> monthXData = new ArrayList<String>();
        ArrayList<BigDecimal> monthYData = new ArrayList<BigDecimal>();
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM");
        for (int j = 11; j >= 0; --j) {
            Calendar monthBefore = Calendar.getInstance();
            monthBefore.set(monthBefore.get(1), monthBefore.get(2) - j, 1, 0, 0, 0);
            monthBefore.set(14, 0);
            monthXData.add(f.format(monthBefore.getTime()));
            Calendar monthAfter = Calendar.getInstance();
            monthAfter.set(monthAfter.get(1), monthAfter.get(2) - j + 1, 1, 0, 0, 0);
            monthAfter.set(14, 0);
            StringBuilder sb = new StringBuilder();
            sb.append(" SELECT sum(t0.fbalance)/count(distinct t0.fbizdate) balance ");
            sb.append(" FROM T_ORG_COMPANY main ");
            sb.append(" left join T_LI_CapitalData t0 on main.fid=t0.forgid ");
            sb.append(" where ( main.flongnumber LIKE ? or main.fid=? ) and t0.fcurrencyid=? and t0.fbizdate>=? and t0.fbizdate<? ");
            sb.append(" and main.fISFREEZE=0 and main.fIsSealUp=0 ");
            if (acctBankIds != null) {
                sb.append(" and t0.FACCID not in (" + acctBankIds + ")");
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{company.getLongNumber() + "!%", company.getId().toString(), currencyId, new Timestamp(monthBefore.getTime().getTime()), new Timestamp(monthAfter.getTime().getTime())});
            try {
                while (rs.next()) {
                    BigDecimal balance = rs.getBigDecimal("balance") == null ? BigDecimal.ZERO : rs.getBigDecimal("balance");
                    monthYData.add(balance.divide(new BigDecimal("10000")).setScale(2, RoundingMode.HALF_UP));
                }
                continue;
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        CapitalTrendVo vo = new CapitalTrendVo();
        vo.setCompanyId(company.getId().toString());
        vo.setCompanyName(company.getName());
        vo.setType("month");
        vo.setxData(monthXData);
        vo.setyData(monthYData);
        return vo;
    }

    protected CapitalTrendVo getDayData(Context ctx, CompanyOrgUnitInfo company, String currencyId, String acctBankIds) throws BOSException, EASBizException {
        ArrayList<String> dayXData = new ArrayList<String>();
        ArrayList<BigDecimal> dayYData = new ArrayList<BigDecimal>();
        SimpleDateFormat dayFormat = new SimpleDateFormat("MM-dd");
        for (int j = 30; j >= 0; --j) {
            Calendar day = Calendar.getInstance();
            day.add(5, -j);
            day.set(11, 0);
            day.set(12, 0);
            day.set(13, 0);
            day.set(14, 0);
            dayXData.add(dayFormat.format(day.getTime()));
            StringBuilder sb = new StringBuilder();
            sb.append(" SELECT sum(t0.fbalance) balance ");
            sb.append(" FROM T_ORG_COMPANY main ");
            sb.append(" left join T_LI_CapitalData t0 on main.fid=t0.forgid ");
            sb.append(" where ( main.flongnumber LIKE ? or main.fid=? ) and t0.fcurrencyid=? and t0.fbizdate=?  ");
            sb.append(" and main.fISFREEZE=0 and main.fIsSealUp=0 ");
            if (acctBankIds != null) {
                sb.append(" and t0.FACCID not in (" + acctBankIds + ")");
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{company.getLongNumber() + "!%", company.getId().toString(), currencyId, new Timestamp(day.getTime().getTime())});
            try {
                while (rs.next()) {
                    BigDecimal balance = rs.getBigDecimal("balance") == null ? BigDecimal.ZERO : rs.getBigDecimal("balance");
                    dayYData.add(balance.divide(new BigDecimal("10000")).setScale(2, RoundingMode.HALF_UP));
                }
                continue;
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        CapitalTrendVo vo = new CapitalTrendVo();
        vo.setCompanyId(company.getId().toString());
        vo.setCompanyName(company.getName());
        vo.setType("day");
        vo.setxData(dayXData);
        vo.setyData(dayYData);
        return vo;
    }
}

