/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.common.CapitalHelper;
import com.kingdee.eas.fm.mobile.util.CapitalDistributionVo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FinancingDistributionHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.liquid.common.FinancingDistributionHelper");

    public Map getInitData(Context ctx) throws BOSException, EASBizException {
        Map<String, Object> result = new HashMap<String, Object>();
        Set<String> idSet = CapitalHelper.getPermissionOrgSet(ctx, "FIN_STORE_USE");
        if (idSet.size() == 0) {
            result.put("error", 1);
            result.put("errorMsg", "\u8be5\u7528\u6237\u65e0\u4efb\u4f55\u8d22\u52a1\u7ec4\u7ec7\u6295\u878d\u8d44\u53ca\u7968\u636e\u5b58\u91cf\u67e5\u8be2\u6743\u9650");
        } else {
            List<CompanyOrgUnitInfo> companyList = CapitalHelper.getTopLevelCompanySet(ctx, idSet);
            CompanyOrgUnitInfo company = null;
            if (companyList.size() == 1) {
                company = companyList.get(0);
            }
            if (companyList.size() > 1) {
                company = CapitalHelper.getDefaultCompany(ctx, companyList);
            }
            if (company != null) {
                String companyId = company.getId().toString();
                String currencyId = company.getBaseCurrency().getId().toString();
                result = this.getDataByFilter(ctx, companyId, currencyId, 10000);
            }
            result.put("idSet", idSet);
        }
        return result;
    }

    protected void dealCompanyData(Context ctx, Map result, CompanyOrgUnitInfo company, CurrencyInfo currency, int unitValue) throws BOSException, EASBizException {
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal sumBal = BigDecimal.ZERO;
        ArrayList<CapitalDistributionVo> detail = new ArrayList<CapitalDistributionVo>();
        if (company.isIsLeaf()) {
            StringBuilder sb = new StringBuilder();
            sb.append(" select sum(t0.FFinanceAmount) amount, sum(t0.FBalance) balance from T_ORG_COMPANY com ");
            sb.append(" left join T_LI_FinancingBalance t0 on com.FID=t0.FCompanyID ");
            sb.append(" where com.FID = ? and t0.FCurrencyID=?");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{company.getId().toString(), currency.getId().toString()});
            try {
                while (rs.next()) {
                    BigDecimal amount = rs.getBigDecimal("amount") == null ? BigDecimal.ZERO : rs.getBigDecimal("amount");
                    BigDecimal balance = rs.getBigDecimal("balance") == null ? BigDecimal.ZERO : rs.getBigDecimal("balance");
                    sumAmt = sumAmt.add(amount);
                    sumBal = sumBal.add(balance);
                    CapitalDistributionVo vo = new CapitalDistributionVo();
                    vo.setType("company");
                    vo.setUnitValue(unitValue);
                    vo.setCompanyId(company.getId().toString());
                    vo.setCurrencyId(currency.getId().toString());
                    vo.setSign(currency.getSign());
                    vo.setName(company.getName());
                    vo.setObjId(company.getId().toString());
                    vo.setValue(balance);
                    vo.setValue2(amount);
                    detail.add(vo);
                }
            }
            catch (SQLException e) {
                logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf>> \u6295\u8d44dealCompanyData\u5355\u4e2a\u516c\u53f8\u6570\u636e\u5c55\u793a\u5f02\u5e38 ");
                logger.error((Object)e);
            }
        } else {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("isFreeze", (Object)false));
            filterInfo.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)false));
            filterInfo.getFilterItems().add(new FilterItemInfo("parent", (Object)company.getId().toString()));
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(filterInfo);
            CompanyOrgUnitCollection companyCol = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(entityViewInfo);
            for (int i = 0; i < companyCol.size(); ++i) {
                CompanyOrgUnitInfo companyInfo = companyCol.get(i);
                StringBuilder sb = new StringBuilder();
                sb.append(" SELECT sum(t0.FFinanceAmount) amount, sum(t0.FBalance) balance from T_ORG_COMPANY com ");
                sb.append(" left join T_LI_FinancingBalance t0 on com.FID=t0.FCompanyID ");
                sb.append(" where ( com.flongnumber like ? or com.FID=? ) and t0.FCurrencyID=? ");
                sb.append(" and com.fISFREEZE=0 and com.fIsSealUp=0 ");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{companyInfo.getLongNumber() + "!%", companyInfo.getId().toString(), currency.getId().toString()});
                try {
                    while (rs.next()) {
                        BigDecimal amount = rs.getBigDecimal("amount") == null ? BigDecimal.ZERO : rs.getBigDecimal("amount");
                        BigDecimal balance = rs.getBigDecimal("balance") == null ? BigDecimal.ZERO : rs.getBigDecimal("balance");
                        sumAmt = sumAmt.add(amount);
                        sumBal = sumBal.add(balance);
                        CapitalDistributionVo vo = new CapitalDistributionVo();
                        vo.setType("company");
                        vo.setUnitValue(unitValue);
                        vo.setCompanyId(company.getId().toString());
                        vo.setCurrencyId(currency.getId().toString());
                        vo.setSign(currency.getSign());
                        vo.setName(companyInfo.getName());
                        vo.setObjId(companyInfo.getId().toString());
                        vo.setValue(balance);
                        vo.setValue2(amount);
                        detail.add(vo);
                    }
                    continue;
                }
                catch (SQLException e) {
                    logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf>> \u6295\u8d44dealCompanyData\u591a\u4e2a\u516c\u53f8\u6570\u636e\u5c55\u793a\u5f02\u5e38");
                    logger.error((Object)e);
                }
            }
        }
        result.put("CompanySumTitle", company.getName());
        this.sortAndShow("company", detail, result, sumAmt, sumBal, company, currency, unitValue);
    }

    protected void dealBankData(Context ctx, Map result, CompanyOrgUnitInfo company, CurrencyInfo currency, int unitValue) throws BOSException, EASBizException {
        ArrayList<CapitalDistributionVo> detail = new ArrayList<CapitalDistributionVo>();
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal sumBal = BigDecimal.ZERO;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("level", (Object)1));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        BankCollection bankCol = BankFactory.getLocalInstance((Context)ctx).getBankCollection(entityViewInfo);
        for (int i = 0; i < bankCol.size(); ++i) {
            BankInfo bankInfo = bankCol.get(i);
            String longNumber = bankInfo.getLongNumber();
            StringBuilder sb = new StringBuilder();
            sb.append(" SELECT sum(t2.FFinanceAmount) amount, sum(t2.FBalance) balance FROM T_BD_Bank b ");
            sb.append(" left join T_LI_FinancingBalance t2 on t2.FBankID = b.FID ");
            sb.append(" left join T_ORG_COMPANY t3 on t3.FID=t2.FCompanyID ");
            sb.append(" where ( b.FLONGNUMBER LIKE ? or b.FLONGNUMBER=? ) ");
            sb.append(" and ( t3.flongnumber like ? or t3.fid = ? ) ");
            sb.append(" and t2.FCurrencyID=? and t3.fISFREEZE=0 and t3.fIsSealUp=0 ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{longNumber + "!%", longNumber, company.getLongNumber() + "!%", company.getId().toString(), currency.getId().toString()});
            try {
                while (rs.next()) {
                    BigDecimal balance = rs.getBigDecimal("balance") == null ? BigDecimal.ZERO : rs.getBigDecimal("balance");
                    BigDecimal amount = rs.getBigDecimal("amount") == null ? BigDecimal.ZERO : rs.getBigDecimal("amount");
                    sumBal = sumBal.add(balance);
                    sumAmt = sumAmt.add(amount);
                    CapitalDistributionVo vo = new CapitalDistributionVo();
                    vo.setType("bank");
                    vo.setUnitValue(unitValue);
                    vo.setCompanyId(company.getId().toString());
                    vo.setCurrencyId(currency.getId().toString());
                    vo.setSign(currency.getSign());
                    vo.setName(bankInfo.getName());
                    vo.setObjId(bankInfo.getId().toString());
                    vo.setValue(balance);
                    vo.setValue2(amount);
                    detail.add(vo);
                }
                continue;
            }
            catch (SQLException e) {
                logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf>> \u6295\u8d44dealBankData\u91d1\u878d\u673a\u6784\u6570\u636e\u5c55\u793a\u5f02\u5e38 ");
                logger.error((Object)e);
            }
        }
        this.sortAndShow("bank", detail, result, sumAmt, sumBal, company, currency, unitValue);
    }

    protected void dealFinanceData(Context ctx, Map result, CompanyOrgUnitInfo company, CurrencyInfo currency, int unitValue) throws BOSException, EASBizException {
        ArrayList<CapitalDistributionVo> detail = new ArrayList<CapitalDistributionVo>();
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal sumBal = BigDecimal.ZERO;
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT t2.FFinanceFinancingID financeId, max(finance.FNAME_L2) financeName, sum(t2.FFinanceAmount) amount, sum(t2.FBalance) balance FROM T_IVT_FinanceFinancing finance ");
        sb.append(" left join T_LI_FinancingBalance t2 on t2.FFinanceFinancingID = finance.FID ");
        sb.append(" left join T_ORG_COMPANY t3 on t3.FID=t2.FCompanyID ");
        sb.append(" where ( t3.flongnumber like ? or t3.fid=? ) ");
        sb.append(" and t2.FCurrencyID=? and t3.fISFREEZE=0 and t3.fIsSealUp=0 ");
        sb.append(" group by t2.FFinanceFinancingID");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{company.getLongNumber() + "!%", company.getId().toString(), currency.getId().toString()});
        try {
            while (rs.next()) {
                BigDecimal balance = rs.getBigDecimal("balance") == null ? BigDecimal.ZERO : rs.getBigDecimal("balance");
                BigDecimal amount = rs.getBigDecimal("amount") == null ? BigDecimal.ZERO : rs.getBigDecimal("amount");
                sumBal = sumBal.add(balance);
                sumAmt = sumAmt.add(amount);
                CapitalDistributionVo vo = new CapitalDistributionVo();
                vo.setType("finance");
                vo.setUnitValue(unitValue);
                vo.setCompanyId(company.getId().toString());
                vo.setCurrencyId(currency.getId().toString());
                vo.setSign(currency.getSign());
                vo.setName(rs.getString("financeName"));
                vo.setObjId(rs.getString("financeId"));
                vo.setValue(balance);
                vo.setValue2(amount);
                detail.add(vo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf>> \u6295\u8d44dealFinanceData\u6295\u8d44\u54c1\u79cd\u7406\u8d22\u5355\u6570\u636e\u5c55\u793a\u5f02\u5e38 ");
            logger.error((Object)e);
        }
        this.sortAndShow("finance", detail, result, sumAmt, sumBal, company, currency, unitValue);
    }

    private void sortAndShow(String typeName, List<CapitalDistributionVo> detail, Map result, BigDecimal sumAmt, BigDecimal sumBal, CompanyOrgUnitInfo company, CurrencyInfo currency, int unitValue) {
        Collections.sort(detail, (Comparator)new Comparator<CapitalDistributionVo>(){

            @Override
            public int compare(CapitalDistributionVo o1, CapitalDistributionVo o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        result.put(typeName + "SumAmt", new DecimalFormat("###,##0.00").format(sumAmt.divide(new BigDecimal(String.valueOf(unitValue)))));
        result.put(typeName + "SumBal", new DecimalFormat("###,##0.00").format(sumBal.divide(new BigDecimal(String.valueOf(unitValue)))));
        ArrayList<String> legend = new ArrayList<String>();
        if (detail.size() <= 10) {
            for (int i = 0; i < detail.size(); ++i) {
                CapitalDistributionVo vo = detail.get(i);
                legend.add(vo.getName());
            }
            result.put("legendDataFor" + typeName, legend);
            result.put("detailDataFor" + typeName, detail);
        } else {
            BigDecimal elseAmt = sumAmt;
            BigDecimal elseBal = sumBal;
            ArrayList<CapitalDistributionVo> realDetail = new ArrayList<CapitalDistributionVo>();
            for (int i = 0; i < 10; ++i) {
                CapitalDistributionVo vo = detail.get(i);
                legend.add(vo.getName());
                realDetail.add(vo);
                elseBal = elseBal.subtract(vo.getValue());
                elseAmt = elseAmt.subtract(vo.getValue2());
            }
            CapitalDistributionVo vo = new CapitalDistributionVo();
            vo.setType(typeName);
            vo.setUnitValue(unitValue);
            vo.setCompanyId(company.getId().toString());
            vo.setCurrencyId(currency.getId().toString());
            vo.setSign(currency.getSign());
            vo.setName("\u5176\u4ed6");
            vo.setObjId("");
            vo.setValue(elseBal);
            vo.setValue2(elseAmt);
            realDetail.add(vo);
            legend.add("\u5176\u4ed6");
            result.put("legendDataFor" + typeName, legend);
            result.put("detailDataFor" + typeName, realDetail);
        }
    }

    public Map getDataByFilter(Context ctx, String companyId, String currencyId, int unitValue) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        result.put("currencyId", currencyId);
        result.put("currency", (String)currency);
        result.put("company", (String)company);
        switch (unitValue) {
            case 10000: {
                result.put("unit", "\u4e07\u5143");
                break;
            }
            case 1000000: {
                result.put("unit", "\u767e\u4e07\u5143");
                break;
            }
            case 10000000: {
                result.put("unit", "\u5343\u4e07\u5143");
                break;
            }
            case 100000000: {
                result.put("unit", "\u4ebf\u5143");
            }
        }
        this.dealCompanyData(ctx, result, company, currency, unitValue);
        this.dealBankData(ctx, result, company, currency, unitValue);
        this.dealFinanceData(ctx, result, company, currency, unitValue);
        return result;
    }

    public Map getCompanySubData(Context ctx, String companyId, String currencyId, int unitValue) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        this.dealCompanyData(ctx, result, company, currency, unitValue);
        return result;
    }
}

