/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.FilterParam;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

public class ImportCapitalFlowDetailFilterParam
implements FilterParam {
    private static final long serialVersionUID = 3360995837548179785L;
    private Set companyIdSet;
    private Set bankIdSet;
    private Set currencyIdSet;
    private Date dateFrom;
    private Date dateTo;
    private int unitValue;
    private BigDecimal txtAmtFrom;
    private BigDecimal txtAmtTo;
    private String remark;
    private int orderType;
    private CurrencyInfo rateCurrencyInfo;

    public CurrencyInfo getRateCurrencyInfo() {
        return this.rateCurrencyInfo;
    }

    public void setRateCurrencyInfo(CurrencyInfo rateCurrencyInfo) {
        this.rateCurrencyInfo = rateCurrencyInfo;
    }

    public FilterInfo getFilter() {
        BigDecimal bdUnit;
        int intUnit;
        FilterInfo filterAmount;
        CompanyOrgUnitInfo companyif;
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterCollection = filter.getFilterItems();
        if (this.getBankIdSet() != null && this.getBankIdSet().size() > 0) {
            filterCollection.add(new FilterItemInfo("accountBank.bank.id", (Object)this.getBankIdSet(), CompareType.INCLUDE));
        }
        if (this.getCurrencyIdSet() != null && this.getCurrencyIdSet().size() > 0) {
            filterCollection.add(new FilterItemInfo("currency.id", (Object)this.getCurrencyIdSet(), CompareType.INCLUDE));
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)(companyif = ContextHelperFactory.getRemoteInstance().getCurrentCompany())) && companyif != null && this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            filterCollection.add(new FilterItemInfo("company.id", (Object)this.getCompanyIdSet(), CompareType.INCLUDE));
        } else if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            filterCollection.add(new FilterItemInfo("company.id", (Object)companyif.getId().toString(), CompareType.EQUALS));
        }
        if (this.getDateFrom() != null) {
            filterCollection.add(new FilterItemInfo("createDate", (Object)this.getDateFrom(), CompareType.GREATER_EQUALS));
        }
        if (this.getDateTo() != null) {
            filterCollection.add(new FilterItemInfo("createDate", (Object)this.getDateTo(), CompareType.LESS_EQUALS));
        }
        if (this.getRemark() != null && this.getRemark().length() >= 1) {
            filterCollection.add(new FilterItemInfo("description", (Object)("%" + this.getRemark() + "%"), CompareType.LIKE));
        }
        if (this.getTxtAmtFrom() != null && this.getTxtAmtTo() == null) {
            filterAmount = new FilterInfo();
            intUnit = this.getUnit().getValue();
            bdUnit = new BigDecimal(String.valueOf(intUnit));
            filterAmount.getFilterItems().add(new FilterItemInfo("isdebit", (Object)"1", CompareType.EQUALS));
            filterAmount.getFilterItems().add(new FilterItemInfo("debitAmount", (Object)this.getTxtAmtFrom().multiply(bdUnit), CompareType.GREATER_EQUALS));
            filterAmount.getFilterItems().add(new FilterItemInfo("isdebit", (Object)"0", CompareType.EQUALS));
            filterAmount.getFilterItems().add(new FilterItemInfo("creditAmount", (Object)this.getTxtAmtFrom().multiply(bdUnit), CompareType.GREATER_EQUALS));
            filterAmount.setMaskString("(#0 and #1) or (#2 and #3)");
            try {
                filter.mergeFilter(filterAmount, "AND");
            }
            catch (BOSException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getTxtAmtFrom() == null && this.getTxtAmtTo() != null) {
            filterAmount = new FilterInfo();
            intUnit = this.getUnit().getValue();
            bdUnit = new BigDecimal(String.valueOf(intUnit));
            filterAmount.getFilterItems().add(new FilterItemInfo("isdebit", (Object)"1", CompareType.EQUALS));
            filterAmount.getFilterItems().add(new FilterItemInfo("debitAmount", (Object)this.getTxtAmtTo().multiply(bdUnit), CompareType.LESS_EQUALS));
            filterAmount.getFilterItems().add(new FilterItemInfo("isdebit", (Object)"0", CompareType.EQUALS));
            filterAmount.getFilterItems().add(new FilterItemInfo("creditAmount", (Object)this.getTxtAmtTo().multiply(bdUnit), CompareType.LESS_EQUALS));
            filterAmount.setMaskString("(#0 and #1) or (#2 and #3)");
            try {
                filter.mergeFilter(filterAmount, "AND");
            }
            catch (BOSException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getTxtAmtFrom() != null && this.getTxtAmtTo() != null) {
            filterAmount = new FilterInfo();
            intUnit = this.getUnit().getValue();
            bdUnit = new BigDecimal(String.valueOf(intUnit));
            filterAmount.getFilterItems().add(new FilterItemInfo("isdebit", (Object)"1", CompareType.EQUALS));
            filterAmount.getFilterItems().add(new FilterItemInfo("debitAmount", (Object)this.getTxtAmtFrom().multiply(bdUnit), CompareType.GREATER_EQUALS));
            filterAmount.getFilterItems().add(new FilterItemInfo("debitAmount", (Object)this.getTxtAmtTo().multiply(bdUnit), CompareType.LESS_EQUALS));
            filterAmount.getFilterItems().add(new FilterItemInfo("isdebit", (Object)"0", CompareType.EQUALS));
            filterAmount.getFilterItems().add(new FilterItemInfo("creditAmount", (Object)this.getTxtAmtFrom().multiply(bdUnit), CompareType.GREATER_EQUALS));
            filterAmount.getFilterItems().add(new FilterItemInfo("creditAmount", (Object)this.getTxtAmtTo().multiply(bdUnit), CompareType.LESS_EQUALS));
            filterAmount.setMaskString("(#0 and #1 and #2) or (#3 and #4 and #5)");
            try {
                filter.mergeFilter(filterAmount, "AND");
            }
            catch (BOSException e) {
                throw new RuntimeException(e);
            }
        }
        return filter;
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo isDebitSorter = new SorterItemInfo("isDebit");
        isDebitSorter.setSortType(SortType.DESCEND);
        sorter.add(isDebitSorter);
        switch (this.getOrderType()) {
            case 1: {
                sorter.add(new SorterItemInfo("company.id"));
                sorter.add(new SorterItemInfo("accountBank.bank.id"));
                sorter.add(new SorterItemInfo("createDate"));
                break;
            }
            case 2: {
                sorter.add(new SorterItemInfo("accountBank.bank.id"));
                sorter.add(new SorterItemInfo("company.id"));
                sorter.add(new SorterItemInfo("createDate"));
                break;
            }
            case 3: {
                sorter.add(new SorterItemInfo("currency.id"));
                sorter.add(new SorterItemInfo("createDate"));
                sorter.add(new SorterItemInfo("company.id"));
                sorter.add(new SorterItemInfo("accountBank.bank.id"));
                break;
            }
            default: {
                throw new IllegalArgumentException("invalidate getOrderType");
            }
        }
        return sorter;
    }

    public BigDecimal getTxtAmtFrom() {
        return this.txtAmtFrom;
    }

    public void setTxtAmtFrom(BigDecimal txtAmtFrom) {
        this.txtAmtFrom = txtAmtFrom;
    }

    public BigDecimal getTxtAmtTo() {
        return this.txtAmtTo;
    }

    public void setTxtAmtTo(BigDecimal txtAmtTo) {
        this.txtAmtTo = txtAmtTo;
    }

    public Set getBankIdSet() {
        return this.bankIdSet;
    }

    public void setBankIdSet(Set bankIdSet) {
        this.bankIdSet = bankIdSet;
    }

    public Set getCompanyIdSet() {
        return this.companyIdSet;
    }

    public void setCompanyIdSet(Set companyIdSet) {
        this.companyIdSet = companyIdSet;
    }

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    public Date getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }

    public int getOrderType() {
        return this.orderType;
    }

    public void setOrderType(int orderType) {
        this.orderType = orderType;
    }

    public AmountUnitEnum getUnit() {
        return AmountUnitEnum.getEnum((int)this.unitValue);
    }

    public void setUnit(AmountUnitEnum unit) {
        this.unitValue = unit == null ? -1 : unit.getValue();
    }

    public Set getCurrencyIdSet() {
        return this.currencyIdSet;
    }

    public void setCurrencyIdSet(Set currencyIdSet) {
        this.currencyIdSet = currencyIdSet;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}

