/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.im.CycleTypeEnum;
import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;

public class RptFBFlowDetailFilterParam
implements FilterParam {
    private static final long serialVersionUID = 1811566675597445610L;
    private Set companyIdSet = null;
    private Set typeSet = null;
    private Set currencySet = null;
    private int unitValue;
    private BigDecimal amount = null;
    private CycleTypeEnum timeLimitType = null;
    private Integer timeLimit = null;
    private int dimType = 0;

    public FilterInfo getFilter() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterCollection = filter.getFilterItems();
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            filterCollection.add(new FilterItemInfo("company.id", (Object)this.getCompanyIdSet(), CompareType.INCLUDE));
        }
        if (this.getCurrencySet() != null && this.getCurrencySet().size() > 0) {
            filterCollection.add(new FilterItemInfo("Currency.id", (Object)this.getCurrencySet(), CompareType.INCLUDE));
        }
        if (this.getTypeSet() != null && this.getTypeSet().size() > 0) {
            filterCollection.add(new FilterItemInfo("BlockFlowType.id", (Object)this.getTypeSet(), CompareType.INCLUDE));
        }
        int addNumber = this.getTimeLimit();
        GregorianCalendar currentCalendar = new GregorianCalendar();
        GregorianCalendar endCalendar = new GregorianCalendar();
        if (this.getTimeLimitType().getName().equals(CycleTypeEnum.YEAR.getName())) {
            endCalendar.add(1, 1);
        }
        if (this.getTimeLimitType().getName().equals(CycleTypeEnum.QUARTER.getName())) {
            endCalendar.add(2, 3 * addNumber);
        }
        if (this.getTimeLimitType().getName().equals(CycleTypeEnum.MONTH.getName())) {
            endCalendar.add(2, addNumber);
        }
        Date currentDate = DateUtil.getDayBegin((Date)currentCalendar.getTime());
        Date endDate = DateUtil.getDayBegin((Date)endCalendar.getTime());
        filterCollection.add(new FilterItemInfo("ExpectedDate", (Object)endDate, CompareType.LESS));
        filterCollection.add(new FilterItemInfo("ExpectedDate", (Object)currentDate, CompareType.GREATER_EQUALS));
        if (this.getAmount() != null) {
            int intUnit = this.getUnit().getValue();
            BigDecimal bdUnit = new BigDecimal(String.valueOf(intUnit));
            filterCollection.add(new FilterItemInfo("Amount", (Object)this.getAmount().multiply(bdUnit), CompareType.GREATER_EQUALS));
        }
        return filter;
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection sorter = new SorterItemCollection();
        switch (this.getDimType()) {
            case 1: {
                sorter.add(new SorterItemInfo("company.id"));
                break;
            }
            case 2: {
                sorter.add(new SorterItemInfo("Currency.id"));
                break;
            }
            case 3: {
                sorter.add(new SorterItemInfo("BlockFlowType.id"));
                break;
            }
            default: {
                throw new IllegalArgumentException("invalidate getOrderType");
            }
        }
        return sorter;
    }

    public Set getCompanyIdSet() {
        return this.companyIdSet;
    }

    public void setCompanyIdSet(Set companyIdSet) {
        this.companyIdSet = companyIdSet;
    }

    public Set getTypeSet() {
        return this.typeSet;
    }

    public void setTypetSet(Set typeSet) {
        this.typeSet = typeSet;
    }

    public Set getCurrencySet() {
        return this.currencySet;
    }

    public void setCurrencySet(Set currencySet) {
        this.currencySet = currencySet;
    }

    public AmountUnitEnum getUnit() {
        return AmountUnitEnum.getEnum((int)this.unitValue);
    }

    public void setUnit(AmountUnitEnum unit) {
        this.unitValue = unit == null ? -1 : unit.getValue();
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public CycleTypeEnum getTimeLimitType() {
        return this.timeLimitType;
    }

    public void setTimeLimitType(CycleTypeEnum timeLimitType) {
        this.timeLimitType = timeLimitType;
    }

    public Integer getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimt(Integer timeLimt) {
        this.timeLimit = timeLimt;
    }

    public int getDimType() {
        return this.dimType;
    }

    public void setDimType(int dimType) {
        this.dimType = dimType;
    }
}

