/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.mnt.CashInventoryFactory;
import com.kingdee.eas.fm.mnt.CashInventoryInfo;
import com.kingdee.eas.fm.mnt.client.AbstractCashInventoryEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.SwingUtilities;

public class CashInventoryEditUI
extends AbstractCashInventoryEditUI {
    private CompanyOrgUnitInfo company = null;
    private static final String RESOURCE = "com.kingdee.eas.fm.mnt.client.MntResource";

    public CashInventoryEditUI() throws Exception {
        if (this.company == null) {
            this.company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        }
        FinUtils.initCurrencyComboBox((KDComboBox)this.comboCurrency);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.comboCurrency.requestFocusInWindow();
    }

    @Override
    public void loadFields() {
        this.txtlocalAmount.setPrecision(FMClientHelper.getPrecOfCurrency((BOSUuid)this.company.getBaseCurrency().getId()));
        super.loadFields();
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        this.txtexRate.setValue((Object)this.editData.getExRate());
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public void storeFields() {
        this.editData.setCurrency((CurrencyInfo)this.comboCurrency.getSelectedItem());
        super.storeFields();
        this.txtexRate.setValue((Object)this.editData.getExRate());
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CashInventoryFactory.getRemoteInstance();
    }

    @Override
    protected KDTable getDetailTable() {
        return null;
    }

    @Override
    protected IObjectValue createNewData() {
        CashInventoryInfo info = new CashInventoryInfo();
        info.setCompany(this.company);
        info.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        info.setExRate(Constants.ONE);
        IContextHelper ctxHelper = ContextHelperFactory.getRemoteInstance();
        try {
            info.setCurrency(ctxHelper.getCompanyBaseCurrency(this.company));
        }
        catch (EASBizException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        return info;
    }

    public void onLoad() throws Exception {
        FMClientHelper.checkOnlyUnion((String)this.getOprtState());
        super.onLoad();
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtamount);
        this.txtexRate.setHorizontalAlignment(4);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtlocalAmount);
        this.actionAttachment.setVisible(false);
        this.txtamount.setMinimumValue((Comparable)Constants.ZERO);
        this.txtexRate.setMinimumValue((Comparable)Constants.ZERO);
    }

    @Override
    protected void comboCurrency_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 2) {
            return;
        }
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        CurrencyInfo baseCurr = this.company.getBaseCurrency();
        try {
            FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtexRate, (CompanyOrgUnitInfo)this.company, (CurrencyInfo)currency, (CurrencyInfo)baseCurr, (Date)DateUtil.getDayBegin(), null);
        }
        catch (FinBizException fe) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"NotRate"));
            FinUtils.initCurrencyComboBox((KDComboBox)this.comboCurrency);
        }
        this.txtamount.setPrecision(FMClientHelper.getPrecOfCurrency((BOSUuid)currency.getId()));
    }

    @Override
    protected void txtamount_dataChanged(DataChangeEvent e) throws Exception {
        this.calcLocalAmount();
    }

    private void calcLocalAmount() {
        BigDecimal amount = this.txtamount.getBigDecimalValue();
        BigDecimal exRate = this.txtexRate.getBigDecimalValue();
        if (amount != null && exRate != null) {
            this.txtlocalAmount.setValue((Object)amount.multiply(exRate));
        } else {
            this.txtlocalAmount.setValue((Object)Constants.ZERO);
        }
    }

    @Override
    protected void txtexRate_dataChanged(DataChangeEvent e) throws Exception {
        this.calcLocalAmount();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyEmptyAndNoZero((CoreUIObject)this, (KDFormattedTextField)this.txtamount);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            CashInventoryFactory.getRemoteInstance().checkCanAddNew(currency.getId().toString());
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.actionAttachment.setVisible(false);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected void afterSubmitAddNew() {
        super.afterSubmitAddNew();
    }

    protected void checkAddNewCurrency() {
    }

    protected void afterSubmitEdit(IObjectPK pk) {
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData != null && !StringUtils.isEmpty((String)this.editData.getString("id"))) {
            idList.add(this.editData.getString("id"));
        }
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData != null && !StringUtils.isEmpty((String)this.editData.getString("id"))) {
            idList.add(this.editData.getString("id"));
        }
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    protected String getTDFileName() {
        return "/bim/fm/nt/ReceivableBill";
    }

    @Override
    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.nt.app.ReceivableBillQuery");
    }
}

