/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.mnt.DepositInControlFactory;
import com.kingdee.eas.fm.mnt.DepositInControlInfo;
import com.kingdee.eas.fm.mnt.client.AbstractDepositInControlEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.Date;

public class DepositInControlEditUI
extends AbstractDepositInControlEditUI {
    private CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();

    public DepositInControlEditUI() throws Exception {
        FinUtils.initCurrencyComboBox((KDComboBox)this.comboCurrency);
        EntityViewInfo eviprmtBankAcct = new EntityViewInfo();
        FilterInfo filterprmtBankAcct = new FilterInfo();
        if (this.company != null) {
            filterprmtBankAcct.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.company.getId().toString()));
            filterprmtBankAcct.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Constants.FALSE));
        }
        eviprmtBankAcct.setFilter(filterprmtBankAcct);
        this.prmtBankAcct.setEntityViewInfo(eviprmtBankAcct);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (currency != null) {
            this.txtAmount.setPrecision(currency.getPrecision());
            this.txtLocalAmount.setPrecision(currency.getPrecision());
            this.txtExchageRate.setPrecision(currency.getPrecision());
        }
        this.txtExchageRate.setValue((Object)this.editData.getExchageRate());
        this.txtAmount.setValue((Object)this.editData.getAmount());
        this.txtLocalAmount.setValue((Object)this.editData.getLocalAmount());
        this.prmtBank.setData((Object)this.editData.getBank());
        if (this.editData.getBank() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboRegion, (Object)this.editData.getBank().getBankAreaType());
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DepositInControlFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        DepositInControlInfo objectValue = new DepositInControlInfo();
        objectValue.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        objectValue.setCurrency(this.company.getBaseCurrency());
        objectValue.setBeginDate(DateUtil.getDayBegin());
        objectValue.setEndDate(DateUtil.getDayEnd());
        objectValue.setCompany(this.company);
        objectValue.setBizDate(DateUtil.getDayBegin());
        objectValue.setExchageRate(Constants.ONE);
        FMClientHelper.initNumber((CoreBaseInfo)objectValue, (KDTextField)this.txtNumber, (String)objectValue.getCompany().getId().toString());
        return objectValue;
    }

    private void calcExRate() throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (currency != null && this.getDataObject() != null) {
            DepositInControlInfo info = (DepositInControlInfo)this.getDataObject();
            FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtExchageRate, (CompanyOrgUnitInfo)company, (CurrencyInfo)currency, (CurrencyInfo)company.getBaseCurrency(), (Date)info.getBizDate(), null);
        }
    }

    private void calcLocalAmount() {
        BigDecimal bdAmount = this.txtAmount.getBigDecimalValue();
        BigDecimal bdExRate = this.txtExchageRate.getBigDecimalValue();
        if (bdAmount != null && bdExRate != null) {
            this.txtLocalAmount.setValue((Object)bdAmount.multiply(bdExRate));
        }
    }

    private SelectorItemCollection getBankAcctSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bank.id"));
        sic.add(new SelectorItemInfo("bank.number"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("bank.bankAreaType"));
        return sic;
    }

    @Override
    protected void prmtBankAcct_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBankAcct_dataChanged(e);
        AccountBankInfo info = (AccountBankInfo)this.prmtBankAcct.getData();
        if (info != null) {
            info = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(info.getId()), this.getBankAcctSelectors());
            this.prmtBank.setValue((Object)info.getBank());
            FMClientHelper.setSelectObject((KDComboBox)this.comboRegion, (Object)info.getBank().getBankAreaType());
        }
    }

    @Override
    protected void comboCurrency_itemStateChanged(ItemEvent e) throws Exception {
        CurrencyInfo currency;
        super.comboCurrency_itemStateChanged(e);
        if (e.getStateChange() == 1 && (currency = (CurrencyInfo)this.comboCurrency.getSelectedItem()) != null) {
            this.txtAmount.setPrecision(currency.getPrecision());
            this.txtLocalAmount.setPrecision(currency.getPrecision());
            this.txtExchageRate.setPrecision(currency.getPrecision());
            try {
                this.calcExRate();
            }
            catch (EASBizException e1) {
                this.comboCurrency.setSelectedItem(null);
                throw e1;
            }
        }
    }

    @Override
    protected void txtAmount_dataChanged(DataChangeEvent e) throws Exception {
        super.txtAmount_dataChanged(e);
        this.calcLocalAmount();
    }

    @Override
    protected void txtExchageRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtExchageRate_dataChanged(e);
        this.calcLocalAmount();
    }

    public void onLoad() throws Exception {
        if (this.company != null && "ADDNEW".equals(this.oprtState)) {
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(this.company.getId()), "mnt_DepositInControl_addnew");
        }
        FMClientHelper.checkOnlyUnion((String)this.oprtState);
        FMClientHelper.updateUITitle((CoreUIObject)this, (String)this.resHelper.getString("this.title"));
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtLocalAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtExchageRate);
        super.onLoad();
        this.pkBeginDate.setSupportedEmpty(false);
        this.pkEndDate.setSupportedEmpty(false);
        this.txtNumber.requestFocusInWindow();
        FMClientHelper.setFirstFocus((Component[])this.getComponents());
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.txtNumber.isEnabled()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.comboCurrency);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkBeginDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkEndDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtBankAcct);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtBank);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.comboRegion);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtExchageRate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtLocalAmount);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextArea)this.txtRestriction);
        FMClientHelper.verifyMoreThanZero((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
        if (!DateTimeUtils.truncateDate((Date)this.pkEndDate.getSqlDate()).after(DateTimeUtils.truncateDate((Date)this.pkBeginDate.getSqlDate()))) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.mnt.MntResource", (String)"DICEndDateMustBeforeBeginDate"));
            this.pkEndDate.requestFocus();
            this.abort();
        }
        AccountBankInfo acctInfo = (AccountBankInfo)this.prmtBankAcct.getData();
        FMClientVerifyHelper.verifyRelateAccountBankAsCurrency((CoreUIObject)this, (AccountBankInfo)acctInfo, (CurrencyInfo)((CurrencyInfo)this.comboCurrency.getSelectedItem()));
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("CU.id"));
        return sic;
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.txtNumber.isEnabled()) {
            this.txtNumber.requestFocusInWindow();
        } else {
            this.comboCurrency.requestFocusInWindow();
        }
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
    }
}

