/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.mnt.client.AbstractDepositInControlFilterUI;
import com.kingdee.eas.fm.mnt.client.DepositInControlFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Date;
import org.apache.log4j.Logger;

public class DepositInControlFilterUI
extends AbstractDepositInControlFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(DepositInControlFilterUI.class);

    public Object getParam() {
        DepositInControlFilterParam param = new DepositInControlFilterParam();
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            param.setCompanyIdSet(this.getCompanyIdSet());
        }
        if (this.kDComboBoxCurrency.getSelectedItem() != null && this.kDComboBoxCurrency.getSelectedItem() instanceof CurrencyInfo) {
            CurrencyInfo cur = (CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem();
            param.setCurrencyId(cur.getId().toString());
        }
        if (this.prmtBank.getData() != null) {
            param.setBankSet(this.getIdSetFromF7(this.prmtBank));
        }
        if (this.dpBeginDate.getSqlDate() != null) {
            param.setBeginDate(this.dpBeginDate.getSqlDate());
        }
        if (this.dpEndDate.getSqlDate() != null) {
            param.setEndDate(this.dpEndDate.getSqlDate());
        }
        return param;
    }

    public void clear() {
        super.clear();
        this.kDComboBoxCurrency.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.dpBeginDate.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.dpEndDate.setValue((Object)DateUtil.getLastDayOfCurMonth());
        this.prmtBank.setData(null);
    }

    public void setParam(Object param) {
        DepositInControlFilterParam dpParam = (DepositInControlFilterParam)((Object)param);
        this.setCompanyIdSet(dpParam.getCompanyIdSet());
        try {
            if (dpParam.getCurrencyId() != null) {
                CurrencyInfo cur = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(dpParam.getCurrencyId()));
                FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)cur);
            } else {
                FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        try {
            this.prmtBank.setData((Object)this.getBaseInfoFromIdSet(dpParam.getBankSet()));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.dpBeginDate.setValue((Object)dpParam.getBeginDate());
        this.dpEndDate.setValue((Object)dpParam.getEndDate());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        FMClientHelper.initComboCurrency((KDComboBox)this.kDComboBoxCurrency, (boolean)true);
        this.kDComboBoxCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.kDComboBoxCurrency.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.dpBeginDate.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.dpEndDate.setValue((Object)DateUtil.getLastDayOfCurMonth());
    }

    public boolean verify() {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.dpBeginDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.dpEndDate);
        Date dateFrom = this.dpBeginDate.getSqlDate();
        Date dateTo = this.dpEndDate.getSqlDate();
        if (dateFrom.after(dateTo)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.FMResource", (String)"beginDateNotGreaterEndDate"));
            SysUtil.abort();
        }
        return super.verify();
    }

    protected Class getParamClass() {
        return DepositInControlFilterParam.class;
    }
}

