/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.SumBillEnum;
import com.kingdee.eas.fm.common.SumFiledsInfo;
import com.kingdee.eas.fm.common.client.DefaultKDTCurrencyProvider;
import com.kingdee.eas.fm.common.client.DefaultKDTablePrecisionFormater;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.IKDTPrecisionProvider;
import com.kingdee.eas.fm.common.client.IKDTablePrecisionFormater;
import com.kingdee.eas.fm.mnt.DepositInControlFactory;
import com.kingdee.eas.fm.mnt.client.AbstractDepositInControlListUI;
import com.kingdee.eas.fm.mnt.client.DepositInControlEditUI;
import com.kingdee.eas.fm.mnt.client.DepositInControlFilterParam;
import com.kingdee.eas.fm.mnt.client.DepositInControlFilterUI;
import com.kingdee.eas.framework.ICoreBase;
import org.apache.log4j.Logger;

public class DepositInControlListUI
extends AbstractDepositInControlListUI {
    private static final Logger logger = CoreUIObject.getLogger(DepositInControlListUI.class);
    private DepositInControlFilterUI filterUI = null;
    private IKDTablePrecisionFormater precFormater = new DefaultKDTablePrecisionFormater();
    private IKDTPrecisionProvider currencyProvider = null;

    public DepositInControlListUI() throws Exception {
        this.precFormater.setPrecProvider((IKDTPrecisionProvider)new DefaultKDTCurrencyProvider(this.getCurrencyIdColName()));
    }

    public void onLoad() throws Exception {
        this.precFormater.init(this.getMainTable(), this.getPrecColName());
        super.onLoad();
        this.btnAttachment.setVisible(false);
        this.checkBizUnit();
        if (!"FINDVIEW".equalsIgnoreCase(this.getOprtState())) {
            FMClientHelper.hideIfBizUnitCompany((KDTable)this.tblMain, (String)"Company");
        }
        this.tblMain.getColumn("BeginDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("EndDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    @Override
    protected String getEditUIName() {
        return DepositInControlEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DepositInControlFactory.getRemoteInstance();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new DepositInControlFilterUI();
        }
        return this.filterUI;
    }

    protected void checkBizUnit() throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (ContextHelperFactory.getRemoteInstance().isOnlyUnion(company)) {
            this.btnAddNew.setVisible(false);
            this.menuItemAddNew.setVisible(false);
            this.btnEdit.setVisible(false);
            this.menuItemEdit.setVisible(false);
            this.btnRemove.setVisible(false);
            this.menuItemRemove.setVisible(false);
        }
    }

    public String[] getMergeColumnKeys() {
        return new String[0];
    }

    protected String getCurrencyIdColName() {
        return "CurrencyId";
    }

    protected String[] getPrecColName() {
        return new String[]{"Amount", "localAmount"};
    }

    private void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            DepositInControlFilterParam param = (DepositInControlFilterParam)((Object)this.getFilterUI().getParam());
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrencyId() == null ? company.getBaseCurrency().getId().toString() : param.getCurrencyId();
            String[] columns = new SumFiledsInfo(SumBillEnum.FinLoanInt).getSumFileds();
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    @Override
    protected boolean isFootVisible() {
        return true;
    }

    protected void execQuery() {
        super.execQuery();
        this.formatFootRow();
    }
}

