/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.BankAreaTypeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fs.client.CurrencyUtil;
import com.kingdee.eas.fm.mnt.ForecastedBlockingFlowFactory;
import com.kingdee.eas.fm.mnt.ForecastedBlockingFlowInfo;
import com.kingdee.eas.fm.mnt.SourceTypeEnum;
import com.kingdee.eas.fm.mnt.client.AbstractForecastedBlockingFlowEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.Date;
import javax.swing.JComponent;

public class ForecastedBlockingFlowEditUI
extends AbstractForecastedBlockingFlowEditUI {
    private static final String Resource = "com.kingdee.eas.fm.mnt.MntResource";
    private final CompanyOrgUnitInfo currentCompany;
    protected CurrencyInfo baseCurrency;

    public ForecastedBlockingFlowEditUI() throws Exception {
        FMClientHelper.initComboCurrency((KDComboBox)this.comboCurrency, (boolean)true);
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.baseCurrency = this.currentCompany.getBaseCurrency();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData.getCurrency() == null) {
            this.editData.setCurrency(this.baseCurrency);
        }
        int precision = FMHelper.getPrecOfCurrency(null, (String)this.editData.getCurrency().getId().toString());
        this.txtAmount.setPrecision(precision);
        this.txtLocalAmount.setPrecision(precision);
        this.kDRadioBtnOutGroup.setSelected(!this.editData.isIsInsider());
        this.kDRadioBtnInGroup.setSelected(this.editData.isIsInsider());
        this.switchCounterPart(this.editData.isIsInsider());
        this.prmtCounterPart.setValue((Object)this.editData.getCounterPartID());
        this.txtCounterPartName.setText(this.editData.getCounterPart());
        this.comboInOutFlow.setSelectedIndex(this.editData.isIsInFlow() ? 0 : 1);
        this.setBlockFlowTypeF7(this.editData.isIsInFlow());
        this.txtExchangeRate.setValue((Object)this.editData.getExchangeRate());
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        this.prmtBlockFlowType.setData((Object)this.editData.getBlockFlowType());
        this.txtExchangeRate.setValue((Object)this.editData.getExchangeRate());
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setIsInsider(this.kDRadioBtnInGroup.isSelected());
        this.editData.setIsInFlow(this.comboInOutFlow.getSelectedIndex() == 0);
    }

    private void setBlockFlowTypeF7(boolean isIn) {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("IsInFlow"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("IsInFlow", (Object)(isIn ? Constants.TRUE : Constants.FALSE)));
        this.prmtBlockFlowType.setEntityViewInfo(evi);
    }

    private void switchCounterPart(boolean isIn) {
        if (isIn) {
            this.txtCounterPartName.setVisible(false);
            this.prmtCounterPart.setVisible(true);
            this.txtCounterPartName.setEditable(false);
            this.prmtCounterPart.setEditable(true);
            this.prmtCounterPart.setRequired(true);
            this.txtCounterPartName.setRequired(false);
        } else {
            this.prmtCounterPart.setVisible(false);
            this.txtCounterPartName.setVisible(true);
            this.prmtCounterPart.setEditable(false);
            this.txtCounterPartName.setEditable(true);
            this.prmtCounterPart.setRequired(false);
            this.txtCounterPartName.setRequired(true);
        }
    }

    @Override
    protected void prmtCounterPart_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCounterPart_dataChanged(e);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCounterPart.getData();
        String companyId = company == null ? null : company.getName();
        this.prmtCounterPart.setValue(this.prmtCounterPart.getData());
        this.txtCounterPartName.setText(companyId);
    }

    @Override
    protected void comboCurrency_itemStateChanged(ItemEvent e) throws Exception {
        super.comboCurrency_itemStateChanged(e);
        if (e.getStateChange() == 2) {
            return;
        }
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (currency == null) {
            return;
        }
        int precision = currency.getPrecision();
        this.txtAmount.setPrecision(precision);
        this.txtLocalAmount.setPrecision(precision);
        try {
            ForecastedBlockingFlowInfo info = (ForecastedBlockingFlowInfo)this.getDataObject();
            if (info != null) {
                FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtExchangeRate, (CompanyOrgUnitInfo)this.currentCompany, (CurrencyInfo)currency, (CurrencyInfo)this.currentCompany.getBaseCurrency(), (Date)info.getBizDate(), null);
            }
        }
        catch (EASBizException e1) {
            this.comboCurrency.setSelectedItem(null);
            throw e1;
        }
        BigDecimal bdExRate = this.txtExchangeRate.getBigDecimalValue();
        BigDecimal bdAmount = this.txtAmount.getBigDecimalValue();
        if (bdExRate != null && bdAmount != null) {
            this.txtLocalAmount.setValue((Object)bdExRate.multiply(bdAmount));
        }
    }

    @Override
    protected void kDRadioBtnInGroup_actionPerformed(ActionEvent e) throws Exception {
        super.kDRadioBtnInGroup_actionPerformed(e);
        this.switchCounterPart(true);
        this.prmtCounterPart.setData(null);
        this.txtCounterPartName.setText(null);
    }

    @Override
    protected void kDRadioBtnOutGroup_actionPerformed(ActionEvent e) throws Exception {
        super.kDRadioBtnOutGroup_actionPerformed(e);
        this.switchCounterPart(false);
        this.prmtCounterPart.setData(null);
        this.txtCounterPartName.setText(null);
    }

    @Override
    protected void comboInOutFlow_itemStateChanged(ItemEvent e) throws Exception {
        super.comboInOutFlow_itemStateChanged(e);
        if (e.getStateChange() == 2) {
            return;
        }
        this.prmtBlockFlowType.setData(null);
        this.setBlockFlowTypeF7(this.comboInOutFlow.getSelectedIndex() == 0);
    }

    private BigDecimal calcLocalAmount() {
        BigDecimal bdAmount = this.txtAmount.getBigDecimalValue();
        BigDecimal bdExRate = this.txtExchangeRate.getBigDecimalValue();
        if (bdAmount != null && bdExRate != null) {
            return bdAmount.multiply(bdExRate);
        }
        return null;
    }

    @Override
    protected void txtAmount_dataChanged(DataChangeEvent e) throws Exception {
        super.txtAmount_dataChanged(e);
        this.txtLocalAmount.setValue((Object)this.calcLocalAmount());
    }

    @Override
    protected void txtExchangeRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtExchangeRate_dataChanged(e);
        this.txtLocalAmount.setValue((Object)this.calcLocalAmount());
    }

    public void onLoad() throws Exception {
        if (this.oprtState.equals("FINDVIEW")) {
            this.lockUIForViewStatus();
        }
        if (this.currentCompany != null && ContextHelperFactory.getRemoteInstance().isOnlyUnion(this.currentCompany)) {
            this.actionAddNew.setVisible(false);
            this.actionSubmit.setVisible(false);
        }
        FMClientHelper.checkOnlyUnion((String)this.oprtState);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtLocalAmount);
        FMClientHelper.initDecimalField((BasicFormattedTextField)this.txtExchangeRate);
        this.txtExchangeRate.setPrecision(4);
        super.onLoad();
        FMClientHelper.updateUITitle((CoreUIObject)this, (String)this.resHelper.getString("this.title"));
        this.btnAttachment.setVisible(false);
        this.prmtCounterPart.setEntityViewInfo(this.getCounterPartF7Filter());
        this.pkExpectedDate.setSupportedEmpty(false);
        this.contRemark.setVisible(false);
        this.kDTextAreaRemark.setVisible(false);
    }

    private EntityViewInfo getCounterPartF7Filter() {
        EntityViewInfo eviprmtCounterPart = new EntityViewInfo();
        FilterInfo filterprmtCounterPart = new FilterInfo();
        if (ContextHelperFactory.getRemoteInstance().getCurrentCompany() != null) {
            filterprmtCounterPart.getFilterItems().add(new FilterItemInfo("IsBizUnit", (Object)Constants.TRUE));
        }
        eviprmtCounterPart.setFilter(filterprmtCounterPart);
        return eviprmtCounterPart;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.txtNumber.isEnabled()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkExpectedDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.comboInOutFlow);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtBlockFlowType);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.comboRegion);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.comboCurrency);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtCounterPartName);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtExchangeRate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextArea)this.kDTextAreaDesc, (String)EASResource.getString((String)Resource, (String)"desc"));
        if (!DateTimeUtils.truncateDate((Date)this.pkExpectedDate.getSqlDate()).after(DateTimeUtils.truncateDate((Date)DateUtil.getDayBegin()))) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)Resource, (String)"ExpectedDateMustAfterNow"));
            this.pkExpectedDate.requestFocus();
            this.abort();
        }
        FMClientHelper.verifyMoreThanZero((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ForecastedBlockingFlowFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        ForecastedBlockingFlowInfo objectValue = new ForecastedBlockingFlowInfo();
        objectValue.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        objectValue.setCompany(this.currentCompany);
        objectValue.setExpectedDate(DateUtil.getDayBegin());
        objectValue.setBizDate(DateUtil.getDayBegin());
        try {
            objectValue.setCurrency(CurrencyUtil.getLocalCurrency());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        objectValue.setSourceType(SourceTypeEnum.manual);
        objectValue.setIsInsider(true);
        objectValue.setRegion(BankAreaTypeEnum.In);
        objectValue.setExchangeRate(Constants.ONE);
        this.switchCounterPart(true);
        FMClientHelper.initNumber((CoreBaseInfo)objectValue, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        return objectValue;
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        if ("ADDNEW".equals(this.oprtState) || "EDIT".equals(this.oprtState)) {
            FMClientHelper.setEditable((JComponent)this.pkExpectedDate, (boolean)true);
        } else if ("VIEW".equals(this.oprtState)) {
            FMClientHelper.setEditable((JComponent)this.pkExpectedDate, (boolean)false);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("IsInsider"));
        sic.add(new SelectorItemInfo("IsInFlow"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("Currency.id"));
        sic.add(new SelectorItemInfo("Currency.number"));
        sic.add(new SelectorItemInfo("Currency.name"));
        sic.add(new SelectorItemInfo("Currency.name"));
        sic.add(new SelectorItemInfo("CompanyOrgUnit"));
        sic.add(new SelectorItemInfo("CounterPart"));
        return sic;
    }

    protected void initDataStatus() {
        if (this.editData != null) {
            super.initDataStatus();
        }
        this.txtLocalAmount.setEnabled(false);
        String oprtState = this.getOprtState();
        if (oprtState.equals(OprtState.VIEW) || oprtState.endsWith("FINDVIEW")) {
            this.actionSubmit.setEnabled(false);
            this.actionSave.setEnabled(false);
            this.kDRadioBtnInGroup.setEnabled(false);
            this.kDRadioBtnOutGroup.setEnabled(false);
            this.comboInOutFlow.setEnabled(false);
            this.prmtBlockFlowType.setEnabled(false);
            this.comboCurrency.setEnabled(false);
            this.prmtCounterPart.setEnabled(false);
            this.txtCounterPartName.setEnabled(false);
            this.txtAmount.setEnabled(false);
            this.txtLocalAmount.setEnabled(false);
            this.kDTextAreaDesc.setEnabled(false);
        } else if (oprtState.equals(OprtState.ADDNEW)) {
            this.kDRadioBtnInGroup.setEnabled(true);
            this.kDRadioBtnOutGroup.setEnabled(true);
            this.comboInOutFlow.setEnabled(true);
            this.prmtBlockFlowType.setEnabled(true);
            this.comboCurrency.setEnabled(true);
            this.prmtCounterPart.setEnabled(true);
            this.txtCounterPartName.setEnabled(true);
            this.txtAmount.setEnabled(true);
            this.kDTextAreaDesc.setEnabled(true);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        FMClientHelper.setFirstFocus((Component[])new Component[]{this.txtNumber, this.pkExpectedDate, this.comboInOutFlow});
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
    }
}

