/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.BoolTextValueProvider;
import com.kingdee.eas.fm.common.client.ColumnUserCellDisplayParser;
import com.kingdee.eas.fm.common.client.DefaultKDTCurrencyProvider;
import com.kingdee.eas.fm.common.client.DefaultKDTablePrecisionFormater;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.IKDTPrecisionProvider;
import com.kingdee.eas.fm.common.client.IKDTablePrecisionFormater;
import com.kingdee.eas.fm.common.client.IValueProvider;
import com.kingdee.eas.fm.mnt.ForecastedBlockingFlowFactory;
import com.kingdee.eas.fm.mnt.ForecastedBlockingFlowInfo;
import com.kingdee.eas.fm.mnt.MNTException;
import com.kingdee.eas.fm.mnt.SourceTypeEnum;
import com.kingdee.eas.fm.mnt.client.AbstractForecastedBlockingFlowListUI;
import com.kingdee.eas.fm.mnt.client.ForecastBlockFlowFilterUI;
import com.kingdee.eas.fm.mnt.client.ForecastedBlockingFlowEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class ForecastedBlockingFlowListUI
extends AbstractForecastedBlockingFlowListUI {
    private static final Logger logger = CoreUIObject.getLogger(ForecastedBlockingFlowListUI.class);
    private ForecastBlockFlowFilterUI filterUI = null;
    private IKDTablePrecisionFormater precFormater = new DefaultKDTablePrecisionFormater();
    private IKDTPrecisionProvider currencyProvider = null;

    public ForecastedBlockingFlowListUI() throws Exception {
        this.precFormater.setPrecProvider((IKDTPrecisionProvider)new DefaultKDTCurrencyProvider(this.getCurrencyIdColName()));
        ColumnUserCellDisplayParser displayParser = new ColumnUserCellDisplayParser(this.tblMain);
        BoolTextValueProvider isInFlowProvider = new BoolTextValueProvider(this.getResString("FlowIn"), this.getResString("FlowOut"));
        displayParser.addValueProvider("IsInFlow", (IValueProvider)isInFlowProvider);
        BoolTextValueProvider isInsiderProvider = new BoolTextValueProvider(this.getResString("GroupInsider"), this.getResString("GroupOutsider"));
        displayParser.addValueProvider("IsInsider", (IValueProvider)isInsiderProvider);
    }

    private String getResString(String string) {
        return EASResource.getString((String)"com.kingdee.eas.fm.mnt.client.MNTClientResource", (String)string);
    }

    @Override
    protected String getEditUIName() {
        return ForecastedBlockingFlowEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ForecastedBlockingFlowFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.precFormater.init(this.getMainTable(), this.getPrecColName());
        super.onLoad();
        this.CheckBizUnit();
        if (!"FINDVIEW".equalsIgnoreCase(this.getOprtState())) {
            FMClientHelper.hideIfBizUnitCompany((KDTable)this.tblMain, (String)"companyName");
        }
        this.btnMultiapprove.setVisible(false);
        this.btnNextPerson.setVisible(false);
        this.menuItemMultiapprove.setVisible(false);
        this.menuItemNextPerson.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.tblMain.getColumn("Remark").getStyleAttributes().setHided(true);
        String dformat = CtrlFormatUtilities.getDateFormatString();
        this.tblMain.getColumn("ExpectedDate").getStyleAttributes().setNumberFormat(dformat);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new ForecastBlockFlowFilterUI();
        }
        return this.filterUI;
    }

    private void verifyCanRemove() throws EASBizException, BOSException {
        ForecastedBlockingFlowInfo info = this.getForecastInfo();
        if (info.getSourceType().equals((Object)SourceTypeEnum.system)) {
            throw new MNTException(MNTException.FORECASTREMOVEINVALID);
        }
    }

    private void verifyCanEdit() throws EASBizException, BOSException {
        ForecastedBlockingFlowInfo info = this.getForecastInfo();
        if (info.getSourceType().equals((Object)SourceTypeEnum.system)) {
            throw new MNTException(MNTException.FORECASTEDITINVALID);
        }
    }

    private ForecastedBlockingFlowInfo getForecastInfo() throws BOSException, EASBizException {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ForecastedBlockingFlowInfo info = ForecastedBlockingFlowFactory.getRemoteInstance().getForecastedBlockingFlowInfo((IObjectPK)new ObjectUuidPK(id));
        return info;
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyCanEdit();
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.verifyCanRemove();
        super.actionRemove_actionPerformed(e);
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected void CheckBizUnit() throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (ContextHelperFactory.getRemoteInstance().isOnlyUnion(company)) {
            this.btnAddNew.setVisible(false);
            this.menuItemAddNew.setVisible(false);
            this.btnEdit.setVisible(false);
            this.menuItemEdit.setVisible(false);
            this.btnRemove.setVisible(false);
            this.menuItemRemove.setVisible(false);
        }
    }

    protected void execQuery() {
        this.mainQuery.getFilter().getFilterItems().add(new FilterItemInfo("Amount", (Object)Constants.ZERO, CompareType.GREATER));
        super.execQuery();
    }

    public String[] getMergeColumnKeys() {
        return new String[0];
    }

    protected String getCurrencyIdColName() {
        return "CurrencyId";
    }

    protected String[] getPrecColName() {
        return new String[]{"Amount", "ExchangeRate"};
    }
}

