/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.fi.cas.FundFlowItemFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.mnt.BizBype;
import com.kingdee.eas.fm.mnt.client.AbstractFundFlowDayReportFilterUI;
import com.kingdee.eas.fm.mnt.client.FundFlowDayReportFilterParam;
import java.awt.Component;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class FundFlowDayReportFilterUI
extends AbstractFundFlowDayReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(FundFlowDayReportFilterUI.class);
    private String status;

    public FundFlowDayReportFilterUI() throws Exception {
    }

    public FundFlowDayReportFilterUI(String status) throws Exception {
        this.status = status;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.combBizType.insertItemAt((Object)FMSysDefinedEnum.ALL_ITEMS, 0);
        this.combBizType.setSelectedIndex(0);
        this.initPrmtAcctBank();
        if ("DOWNLOAD".equals(this.status)) {
            this.contFundFlowItem.setVisible(false);
            this.contBizType.setVisible(false);
        }
    }

    protected void companyValueChange(Object object) throws Exception {
        super.companyValueChange(object);
        this.initPrmtAcctBank();
    }

    private void initPrmtAcctBank() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = null;
        if (this.currentCompany.isIsBizUnit()) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString(), CompareType.EQUALS));
        } else if (this.getSelectedCompanyIds().length > 0) {
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < this.getSelectedCompanyIds().length; ++i) {
                idSet.add(this.getSelectedCompanyIds()[i]);
            }
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", idSet, CompareType.INCLUDE));
        } else {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)"NE", CompareType.EQUALS));
        }
        view.setFilter(filter);
        this.prmtAcctBank.setEntityViewInfo(view);
    }

    public boolean verify() {
        FMClientHelper.compBeginDateAndEndDate((Component)((Object)this), (Date)((Date)this.dpDateFrom.getValue()), (Date)((Date)this.dpDateTo.getValue()));
        return super.verify();
    }

    public Object getParam() {
        FundFlowDayReportFilterParam param = new FundFlowDayReportFilterParam();
        Object selectedItem = this.combBizType.getSelectedItem();
        if (selectedItem instanceof FMSysDefinedEnum) {
            param.setBizType("-1");
        } else if (selectedItem instanceof BizBype) {
            param.setBizType(((BizBype)((Object)selectedItem)).getValue());
        }
        param.setDateFrom((Date)this.dpDateFrom.getValue());
        param.setDateTo((Date)this.dpDateTo.getValue());
        param.setCompanyIdSet(this.getCompanyIdSet());
        param.setAcctBankIdSet(this.getIdSetFromF7(this.prmtAcctBank));
        param.setCurrencyIdSet(this.getIdSetFromF7(this.prmtCurrency));
        param.setFundFlowItemIdSet(this.getIdSetFromF7(this.prmtFundFlowItem));
        return param;
    }

    public void setParam(Object param) {
        FilterInfo filter;
        EntityViewInfo ev;
        FundFlowDayReportFilterParam paramNew = (FundFlowDayReportFilterParam)((Object)param);
        if ("-1".equals(paramNew.getBizType())) {
            this.combBizType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.combBizType.setSelectedItem((Object)BizBype.getEnum(paramNew.getBizType()));
        }
        this.dpDateFrom.setValue((Object)paramNew.getDateFrom());
        this.dpDateTo.setValue((Object)paramNew.getDateTo());
        this.setCompanyIdSet(paramNew.getCompanyIdSet());
        if (!FMHelper.isEmpty((Collection)paramNew.getAcctBankIdSet())) {
            ev = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)paramNew.getAcctBankIdSet(), CompareType.INCLUDE));
            ev.setFilter(filter);
            try {
                this.prmtAcctBank.setValue((Object)AccountBankFactory.getRemoteInstance().getCollection(ev).toArray());
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else {
            this.prmtAcctBank.setValue(null);
        }
        if (!FMHelper.isEmpty((Collection)paramNew.getCurrencyIdSet())) {
            ev = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)paramNew.getCurrencyIdSet(), CompareType.INCLUDE));
            ev.setFilter(filter);
            try {
                this.prmtCurrency.setValue((Object)CurrencyFactory.getRemoteInstance().getCollection(ev).toArray());
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else {
            this.prmtCurrency.setValue(null);
        }
        if (!FMHelper.isEmpty((Collection)paramNew.getFundFlowItemIdSet())) {
            ev = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)paramNew.getFundFlowItemIdSet(), CompareType.INCLUDE));
            ev.setFilter(filter);
            try {
                this.prmtFundFlowItem.setValue((Object)FundFlowItemFactory.getRemoteInstance().getCollection(ev).toArray());
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else {
            this.prmtFundFlowItem.setValue(null);
        }
    }

    protected Class getParamClass() {
        return FundFlowDayReportFilterParam.class;
    }
}

