/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.common.client.CommonUtil;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.mnt.DataSourceSettingCollection;
import com.kingdee.eas.fm.mnt.DataSourceSettingFactory;
import com.kingdee.eas.fm.mnt.FundDateReportFacadeFactory;
import com.kingdee.eas.fm.mnt.FundFlowDayReportCollection;
import com.kingdee.eas.fm.mnt.FundFlowDayReportFactory;
import com.kingdee.eas.fm.mnt.IFundFlowDayReport;
import com.kingdee.eas.fm.mnt.MNTException;
import com.kingdee.eas.fm.mnt.MerageUnitTreeFactory;
import com.kingdee.eas.fm.mnt.client.AbstractFundFlowDayReportListUI;
import com.kingdee.eas.fm.mnt.client.BatchFillEditUI;
import com.kingdee.eas.fm.mnt.client.FundFlowDayReportFilterParam;
import com.kingdee.eas.fm.mnt.client.FundFlowDayReportFilterUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class FundFlowDayReportListUI
extends AbstractFundFlowDayReportListUI {
    private static final Logger logger = CoreUIObject.getLogger(FundFlowDayReportListUI.class);
    private FMFilterBaseUI filterUI;
    private FMFilterBaseUI downLoadFilterUI;
    private CommonQueryDialog downLoadDlg;
    private FilterParam defaultDownLoadParam;
    private EntityViewInfo defaultDownLoadEntityView;
    private String RESOURCE = "com.kingdee.eas.fm.mnt.ReportResource";

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            boolean isBOTP = false;
            if (this.getBOTPViewStatus() == 1) {
                isBOTP = true;
            }
            this.filterUI = new FundFlowDayReportFilterUI();
        }
        return this.filterUI;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.batchFillAction.setEnabled(true);
        this.actionDataSourceSetting.setEnabled(true);
        this.actionDownLoad.setEnabled(true);
        this.actionImportData.setVisible(false);
        this.actionExportData.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionRemove.setVisible(false);
        String baseCurrencyID = this.baseCurrencyCommon.getId().toString();
        if (EmptyUtil.isEmpty((String)baseCurrencyID)) {
            baseCurrencyID = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getBaseCurrency().getId().toString();
        }
        FMClientHelper.setNumberFormat((KDTable)this.tblMain, (String)"debitAmt", (String)baseCurrencyID);
        this.tblMain.getColumn("debitAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        FMClientHelper.setNumberFormat((KDTable)this.tblMain, (String)"creditAmt", (String)baseCurrencyID);
        this.tblMain.getColumn("creditAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    @Override
    public void batchFillAction_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add("dcDirection");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        view.setSelector(sel);
        view.setFilter(filter);
        FundFlowDayReportCollection col = ((IFundFlowDayReport)this.getBizInterface()).getFundFlowDayReportCollection(view);
        boolean hasDebit = false;
        boolean hasCredit = false;
        boolean isSameDirection = false;
        for (int i = 0; i < col.size(); ++i) {
            if ("0".equals(col.get(i).getDcDirection().getValue())) {
                hasDebit = true;
                continue;
            }
            if (!"1".equals(col.get(i).getDcDirection().getValue())) continue;
            hasCredit = true;
        }
        String direc = "all";
        if (hasDebit && !hasCredit) {
            isSameDirection = true;
            direc = "0";
        } else if (!hasDebit && hasCredit) {
            isSameDirection = true;
            direc = "1";
        }
        if (!isSameDirection) {
            MsgBox.showInfo((String)EASResource.getString((String)this.RESOURCE, (String)"DirectionSameCanModified"));
            return;
        }
        Map map = this.getUIContext();
        map.put("isSameDirection", isSameDirection);
        map.put("direc", direc);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create("com.kingdee.eas.fm.mnt.client.BatchFillEditUI", map, null);
        CtrlSwingUtilities.centerWindow((Window)((UIModelDialog)window));
        BatchFillEditUI batchEditUI = (BatchFillEditUI)window.getUIObject();
        window.show();
        if (!batchEditUI.isCancel()) {
            FundFlowItemInfo fundFlowInfo = (FundFlowItemInfo)batchEditUI.getF7Value();
            if (fundFlowInfo != null) {
                CoreBaseCollection colls = new CoreBaseCollection();
                for (int i = 0; i < col.size(); ++i) {
                    col.get(i).setFundFlowItem(fundFlowInfo);
                    colls.addObject((IObjectValue)col.get(i));
                }
                this.getBizInterface().updateBatchData(colls);
                FundFlowDayReportFactory.getRemoteInstance().backUpFlowItem(idList);
            }
            this.refreshList();
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (this.confirmRemove()) {
            this.saveCurrentLocation();
            this.refresh(e);
            this.restoreCurrentLocation();
            Map map = ((IFundFlowDayReport)this.getBizInterface()).batchDelete(idList);
            String errorDetail = (String)map.get("errorDetail");
            this.refresh(e);
            if (errorDetail.length() > 1) {
                if (idList.size() > 1) {
                    String error = EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"585_FundFlowItemMapRuleListUI");
                    Component component = (Component)e.getSource();
                    MsgBox.showDetailAndOK((Component)component, (String)error, (String)errorDetail, (int)1);
                } else {
                    Component component = (Component)e.getSource();
                    this.showFailMessageBox((CoreUI)this, component);
                }
            } else {
                Component component = (Component)e.getSource();
                FMClientHelper.showSuccessMessageBox((CoreUI)this, (Component)component);
            }
        }
    }

    private void showFailMessageBox(CoreUI ui, Component component) {
        String text = null;
        if (component instanceof AbstractButton) {
            text = ((AbstractButton)component).getText();
            if (FMHelper.isEmpty((String)text)) {
                text = ((AbstractButton)component).getToolTipText();
            }
        } else if (component instanceof KDMenuItem && FMHelper.isEmpty((String)(text = ((KDMenuItem)component).getText()))) {
            text = ((KDMenuItem)component).getToolTipText();
        }
        String msgStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"591_FundFlowDayReportListUI"), text);
        MsgBox.showInfo((Component)((Object)this), (String)msgStr);
    }

    @Override
    public void actionDataSourceSetting_actionPerformed(ActionEvent e) throws Exception {
        Map map = this.getUIContext();
        HashMap newMap = new HashMap();
        Iterator it = map.entrySet().iterator();
        Map.Entry entry = null;
        while (it.hasNext()) {
            entry = it.next();
            newMap.put(entry.getKey(), entry.getValue());
        }
        CtrlUnitInfo curCu = ContextHelperFactory.getRemoteInstance().getCurrentCtrlUnit();
        CtrlUnitInfo topCu = MerageUnitTreeFactory.getRemoteInstance().getTopCtrlUnitInfo(curCu);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)topCu.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        DataSourceSettingCollection dssCol = DataSourceSettingFactory.getRemoteInstance().getDataSourceSettingCollection(view);
        if (dssCol.size() > 0) {
            newMap.put("dataSourceSettingInfo", dssCol.get(0));
        }
        newMap.put("oprtState", "ADDNEW");
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create("com.kingdee.eas.fm.mnt.client.DataSourceSettingEditUI", newMap, null);
        CtrlSwingUtilities.centerWindow((Window)((UIModelDialog)window));
        window.show();
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        DatataskCaller task = new DatataskCaller();
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.fm.mnt.fundFlowDayReport";
        param.alias = EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"586_FundFlowDayReportControllerBean");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        task.setParentComponent((Component)((Object)this));
        task.invoke(paramList, 0, false);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        DatataskCaller task = new DatataskCaller();
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.fm.mnt.fundFlowDayReport";
        param.alias = EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"586_FundFlowDayReportControllerBean");
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        task.setParentComponent((Component)((Object)this));
        task.invoke(paramList, 1, false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionDataSourceSetting.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_readin"));
        this.batchFillAction.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_editbatch"));
        this.actionDownLoad.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_returnticket"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionDownLoad_actionPerformed(ActionEvent e) throws Exception {
        if (0 != this.showComfirm("FundFlowDayReport_ConfirmReload")) return;
        super.actionQuery_actionPerformed(e);
        FundFlowDayReportFilterUI downloadfilterUI = (FundFlowDayReportFilterUI)this.getFilterUI();
        FundFlowDayReportFilterParam downloadParam = (FundFlowDayReportFilterParam)((Object)downloadfilterUI.getParam());
        Date startDate = downloadParam.getDateFrom();
        Date endDate = downloadParam.getDateTo();
        StringBuffer sql = new StringBuffer();
        sql.append(" select def.FhandlerWrapper from T_JOB_DEF def ");
        sql.append(" LEFT OUTER JOIN T_JOB_TRIGGER tri on tri.fjobDefID = def.fjobdefid ");
        sql.append(" where def.Fmutex like 'G::FundDateReportFacade' and tri.Fisvalid = 'Y' ");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        if (rs != null && rs.next()) {
            String paramStr = rs.getString("FhandlerWrapper");
            if (paramStr != null && paramStr.indexOf("intervalDays") != -1) {
                String xmlStr = paramStr.substring(paramStr.indexOf(";") + 1);
                xmlStr = xmlStr.replaceAll("\r\n\t", "");
                Document document = DocumentHelper.parseText((String)xmlStr);
                Element element = document.getRootElement();
                List content = element.content();
                String intervalDays = null;
                for (Element ele : content) {
                    if (!"intervalDays".equals(ele.attribute("name").getValue())) continue;
                    intervalDays = ele.attributeValue("value");
                }
                String rex = "^\\+?[1-9][0-9]*$";
                Pattern pt = Pattern.compile(rex);
                Matcher m = pt.matcher(intervalDays);
                if (!m.find()) {
                    MsgBox.showWarning((String)"\u95f4\u9694\u5929\u6570\u53ea\u80fd\u4e3a\u6b63\u6574\u6570\uff01");
                    return;
                }
                Date endDateStandBy = DateTimeUtils.truncateDate((Date)new Date());
                Date beginDateStandBy = DateHelper.getNextDay((Date)endDate, (int)(0 - Integer.valueOf(intervalDays)));
                beginDateStandBy = DateTimeUtils.truncateDate((Date)beginDateStandBy);
                endDateStandBy = DateTimeUtils.truncateDate((Date)endDateStandBy);
                startDate = DateTimeUtils.truncateDate((Date)startDate);
                endDate = DateTimeUtils.truncateDate((Date)endDate);
                if (startDate.compareTo(beginDateStandBy) < 0 || endDate.compareTo(endDateStandBy) > 0) {
                    MsgBox.showWarning((String)EASResource.getString((String)this.RESOURCE, (String)"DateOutOfRange"));
                    return;
                }
                try {
                    FundDateReportFacadeFactory.getRemoteInstance().getData4UI(startDate, endDate);
                    MsgBox.showInfo((String)EASResource.getString((String)this.RESOURCE, (String)"DataDownloadSuccess"));
                }
                catch (MNTException excep) {
                    MsgBox.showWarning((String)excep.getMessage());
                }
                catch (BOSException exce2) {
                    throw new BOSException((Throwable)exce2);
                }
                super.execQuery();
                return;
            }
            MsgBox.showWarning((String)EASResource.getString((String)this.RESOURCE, (String)"SetScheduleParam"));
            return;
        }
        MsgBox.showWarning((String)EASResource.getString((String)this.RESOURCE, (String)"SetScheduleEnable"));
    }

    protected CommonQueryDialog getDownLoadDlg() throws Exception {
        if (this.downLoadDlg != null) {
            return this.downLoadDlg;
        }
        FMFilterBaseUI filterUI = this.getDefaultDownLoadFilterUI();
        filterUI.setListUI((IUIObject)this);
        filterUI.setActionListOnLoad((ItemAction)this.actionOnLoad);
        this.downLoadDlg = this.initCommonQueryDialog();
        EntityViewInfo view = new EntityViewInfo();
        this.downLoadDlg.setEntityViewInfo(view);
        this.downLoadDlg.setOwner((Component)this.getUIContext().get("Owner"));
        this.downLoadDlg.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.downLoadDlg.setQueryObjectPK(this.mainQueryPK);
        this.downLoadDlg.setHeight(300);
        this.downLoadDlg.setWidth(400);
        this.downLoadDlg.setTitle(filterUI.getUITitle());
        this.downLoadDlg.addUserPanel((KDPanel)filterUI);
        this.downLoadDlg.setProcessor((IProcessor)this.getQueryProcessor());
        this.downLoadDlg.setShowFilter(false);
        this.downLoadDlg.setShowSorter(false);
        return this.downLoadDlg;
    }

    public FilterParam getDefaultDownLoadParam() {
        try {
            FMFilterBaseUI f = this.getDefaultDownLoadFilterUI();
            f.onLoad();
            return (FilterParam)f.getParam();
        }
        catch (AbortException e) {
            throw e;
        }
        catch (Exception exp) {
            logger.error((Object)exp.getMessage(), (Throwable)exp);
            return null;
        }
    }

    public FMFilterBaseUI getDefaultDownLoadFilterUI() throws Exception {
        if (this.downLoadFilterUI == null) {
            this.downLoadFilterUI = new FundFlowDayReportFilterUI("DOWNLOAD");
        }
        return this.downLoadFilterUI;
    }

    protected String getQueryUiName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void initDefaultDownLoadQuery(String queryName) throws Exception {
        if (this.defaultDownLoadParam != null) {
            return;
        }
        QuerySolutionInfo ds = null;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        ds = iQuery.getDefaultSolution(this.getQueryUiName(), queryName);
        if (ds != null) {
            if (!FMHelper.isEmpty((String)ds.getEntityViewInfo())) {
                this.defaultDownLoadEntityView = new EntityViewInfo(ds.getEntityViewInfo());
            } else {
                this.defaultDownLoadEntityView = new EntityViewInfo();
                this.defaultDownLoadEntityView.setFilter(new FilterInfo());
            }
            this.doDefaultSolution(iQuery, queryName);
            QueryPanelCollection queryPanelInfo = ds.getQueryPanelInfo();
            if (queryPanelInfo.size() > 0) {
                for (int i = 0; i < queryPanelInfo.size(); ++i) {
                    Object tempObject;
                    String filterUICName = this.getFilterUI().getMetaDataPK().getFullName();
                    if (!filterUICName.equals(queryPanelInfo.get(i).getPanelClassName())) continue;
                    queryPanelInfo.get(i).getCustomerParams();
                    CustomerParams cp = CustomerParams.getCustomerParams2((String)queryPanelInfo.get(i).getCustomerParams());
                    if (cp == null) {
                        return;
                    }
                    String paramValue = cp.getCustomerParam("fmcustomer");
                    if (FMHelper.isEmpty((String)paramValue)) {
                        return;
                    }
                    byte[] bytes = FMHelper.decode((byte[])paramValue.getBytes());
                    byte[] param = bytes;
                    if (param == null || param.length <= 0 || !((tempObject = CommonUtil.getObject((byte[])param)) instanceof FilterParam)) continue;
                    this.defaultDownLoadParam = (FilterParam)tempObject;
                }
            }
            if (this.defaultDownLoadParam == null) {
                this.defaultDownLoadParam = this.getDefaultDownLoadParam();
            }
        }
    }

    private int showComfirm(String key) {
        return MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE, (String)key));
    }
}

