/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.mnt.BizBype;
import com.kingdee.eas.fm.mnt.client.AbstractFundFlowItemMapRuleFilterUI;
import com.kingdee.eas.fm.mnt.client.FundFlowItemMapRuleFilterParam;
import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class FundFlowItemMapRuleFilterUI
extends AbstractFundFlowItemMapRuleFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(FundFlowItemMapRuleFilterUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.combBizType.insertItemAt((Object)FMSysDefinedEnum.ALL_ITEMS, 0);
        this.combBizType.setSelectedIndex(0);
        this.initPrmtAcctBank();
    }

    protected void companyValueChange(Object object) throws Exception {
        super.companyValueChange(object);
        this.initPrmtAcctBank();
    }

    private void initPrmtAcctBank() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = null;
        if (this.currentCompany.isIsBizUnit()) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString(), CompareType.EQUALS));
        } else if (this.getSelectedCompanyIds().length > 0) {
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < this.getSelectedCompanyIds().length; ++i) {
                idSet.add(this.getSelectedCompanyIds()[i]);
            }
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", idSet, CompareType.INCLUDE));
        } else {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)"NE", CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0), CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtAcctBank.setEntityViewInfo(view);
    }

    public Object getParam() {
        FundFlowItemMapRuleFilterParam param = new FundFlowItemMapRuleFilterParam();
        param.setCompanyIdSet(this.getCompanyIdSet());
        param.setAcctBankIDSet(this.getIdSetFromF7(this.prmtAcctBank));
        Object selectedItem = this.combBizType.getSelectedItem();
        if (selectedItem instanceof FMSysDefinedEnum) {
            param.setBizType("-1");
        } else if (selectedItem instanceof BizBype) {
            param.setBizType(((BizBype)((Object)selectedItem)).getValue());
        }
        param.setInnerCusOrSup(this.cksIsCusOrSup.isSelected());
        return param;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        FundFlowItemMapRuleFilterParam paramNew = (FundFlowItemMapRuleFilterParam)((Object)param);
        this.setCompanyIdSet(paramNew.getCompanyIdSet());
        if ("-1".equals(paramNew.getBizType())) {
            this.combBizType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.combBizType.setSelectedItem((Object)BizBype.getEnum(paramNew.getBizType()));
        }
        this.cksIsCusOrSup.setSelected(paramNew.isInnerCusOrSup());
        if (!FMHelper.isEmpty((Collection)paramNew.getAcctBankIDSet())) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)paramNew.getAcctBankIDSet(), CompareType.INCLUDE));
            ev.setFilter(filter);
            try {
                this.prmtAcctBank.setValue((Object)AccountBankFactory.getRemoteInstance().getCollection(ev).toArray());
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else {
            this.prmtAcctBank.setValue(null);
        }
    }

    protected Class getParamClass() {
        return FundFlowItemMapRuleFilterParam.class;
    }
}

