/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.mnt.FundFlowItemMapRuleInfo;
import com.kingdee.eas.fm.mnt.IFundFlowItemMapRule;
import com.kingdee.eas.fm.mnt.MNTException;
import com.kingdee.eas.fm.mnt.client.AbstractFundFlowItemMapRuleListUI;
import com.kingdee.eas.fm.mnt.client.FundFlowItemMapRuleFilterUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.AbstractButton;
import org.apache.log4j.Logger;

public class FundFlowItemMapRuleListUI
extends AbstractFundFlowItemMapRuleListUI {
    private static final Logger logger = CoreUIObject.getLogger(FundFlowItemMapRuleListUI.class);
    private FMFilterBaseUI filterUI;

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            boolean isBOTP = false;
            if (this.getBOTPViewStatus() == 1) {
                isBOTP = true;
            }
            this.filterUI = new FundFlowItemMapRuleFilterUI();
        }
        return this.filterUI;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        CompanyOrgUnitInfo curCom = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (!curCom.isIsBizUnit()) {
            this.actionAddNew.setEnabled(false);
        }
        this.btnEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnDisable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.actionAuditResult.setVisible(false);
    }

    @Override
    public void actionEnable_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        Map map = ((IFundFlowItemMapRule)this.getBizInterface()).batchEnable(idList);
        String errorDetail = (String)map.get("errorDetail");
        this.refresh(e);
        if (errorDetail.length() > 1) {
            if (idList.size() > 1) {
                String error = EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"585_FundFlowItemMapRuleListUI");
                Component component = (Component)e.getSource();
                MsgBox.showDetailAndOK((Component)component, (String)error, (String)errorDetail, (int)1);
            } else {
                Component component = (Component)e.getSource();
                this.showFailMessageBox((CoreUI)this, component);
            }
        } else {
            Component component = (Component)e.getSource();
            FMClientHelper.showSuccessMessageBox((CoreUI)this, (Component)component);
        }
    }

    private void showFailMessageBox(CoreUI ui, Component component) {
        String text = null;
        if (component instanceof AbstractButton) {
            text = ((AbstractButton)component).getText();
            if (FMHelper.isEmpty((String)text)) {
                text = ((AbstractButton)component).getToolTipText();
            }
        } else if (component instanceof KDMenuItem && FMHelper.isEmpty((String)(text = ((KDMenuItem)component).getText()))) {
            text = ((KDMenuItem)component).getToolTipText();
        }
        String msgStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"591_FundFlowDayReportListUI"), text);
        MsgBox.showInfo((Component)((Object)this), (String)msgStr);
    }

    @Override
    public void actionDisable_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        Map map = ((IFundFlowItemMapRule)this.getBizInterface()).batchDisable(idList);
        String errorDetail = (String)map.get("errorDetail");
        this.refresh(e);
        if (errorDetail.length() > 1) {
            if (idList.size() > 1) {
                String error = EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"585_FundFlowItemMapRuleListUI");
                Component component = (Component)e.getSource();
                MsgBox.showDetailAndOK((Component)component, (String)error, (String)errorDetail, (int)1);
            } else {
                Component component = (Component)e.getSource();
                this.showFailMessageBox((CoreUI)this, component);
            }
        } else {
            Component component = (Component)e.getSource();
            FMClientHelper.showSuccessMessageBox((CoreUI)this, (Component)component);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (this.confirmRemove()) {
            this.saveCurrentLocation();
            this.refresh(e);
            this.restoreCurrentLocation();
            Map map = ((IFundFlowItemMapRule)this.getBizInterface()).batchRemove(idList);
            String errorDetail = (String)map.get("errorDetail");
            this.refresh(e);
            if (errorDetail.length() > 1) {
                if (idList.size() > 1) {
                    String error = EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"585_FundFlowItemMapRuleListUI");
                    Component component = (Component)e.getSource();
                    MsgBox.showDetailAndOK((Component)component, (String)error, (String)errorDetail, (int)1);
                } else {
                    Component component = (Component)e.getSource();
                    this.showFailMessageBox((CoreUI)this, component);
                }
            } else {
                Component component = (Component)e.getSource();
                FMClientHelper.showSuccessMessageBox((CoreUI)this, (Component)component);
            }
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String selectedID = this.getSelectedKeyValue();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("isEnable");
        FundFlowItemMapRuleInfo info = ((IFundFlowItemMapRule)this.getBizInterface()).getFundFlowItemMapRuleInfo((IObjectPK)new ObjectUuidPK(selectedID), selector);
        if (info.isIsEnable()) {
            throw new MNTException(MNTException.FUNDFLOWMAPRULE_CANNOTEDIT_ENABLE);
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sel = super.getSelectors();
        sel.add("payeeAcctBankStr");
        sel.add("payerAcctBankStr");
        return sel;
    }

    protected void execQuery() {
        super.execQuery();
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String acctBankName = (String)this.tblMain.getCell(i, "payeeAcctBank.name").getValue();
            String acctBankNameStr = (String)this.tblMain.getCell(i, "payeeAcctBankStr").getValue();
            if (acctBankName == null && acctBankNameStr != null) {
                this.tblMain.getCell(i, "payeeAcctBank.name").setValue((Object)acctBankNameStr);
            }
            acctBankName = (String)this.tblMain.getCell(i, "payerAcctBank.name").getValue();
            acctBankNameStr = (String)this.tblMain.getCell(i, "payerAcctBankStr").getValue();
            if (acctBankName != null || acctBankNameStr == null) continue;
            this.tblMain.getCell(i, "payerAcctBank.name").setValue((Object)acctBankNameStr);
        }
    }
}

