/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.eas.fm.mnt.vo.NameExpandInfo;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashMap;

public class FundFlowItemTreeRender
implements IBasicRender {
    private int TABSIZE = 8;
    private int ICONSIZE = 10;
    private int margin = 2;
    protected SimpleTextRender simpleRender = new SimpleTextRender();
    protected HashMap<String, Rectangle> fpItemIdToPos = new HashMap();

    protected void drawExpanded(Graphics g, int x, int y) {
        g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
        int lineSize = this.ICONSIZE - 2 * this.margin;
        g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
    }

    protected void drawCollapsed(Graphics g, int x, int y) {
        g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
        int lineSize = this.ICONSIZE - 2 * this.margin;
        g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
        g.drawLine(x + this.ICONSIZE / 2, y + this.margin, x + this.ICONSIZE / 2, y + this.margin + lineSize);
    }

    protected void drawLeaf(Graphics g, int x, int y) {
        int lineSize = this.ICONSIZE - 2 * this.margin;
    }

    public boolean inRect(NameExpandInfo numberExpandInfo, int x, int y) {
        String fpItemId = numberExpandInfo.getFpItemId();
        Rectangle rec = this.fpItemIdToPos.get(fpItemId);
        if (rec != null) {
            return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
        }
        return false;
    }

    public void draw(Graphics graphics, Shape clip, Object obj, Style style) {
        if (obj instanceof NameExpandInfo) {
            NameExpandInfo numberExpandInfo = (NameExpandInfo)obj;
            int ident = numberExpandInfo.getLevel() * this.TABSIZE;
            Rectangle rect = clip.getBounds();
            int x = rect.x + ident;
            int y = rect.y + (rect.height - this.ICONSIZE) / 2;
            Rectangle iconRect = new Rectangle(x, y, this.ICONSIZE, this.ICONSIZE);
            this.fpItemIdToPos.put(numberExpandInfo.getFpItemId(), iconRect);
            this.simpleRender.draw(graphics, (Shape)new Rectangle(x + this.ICONSIZE + this.TABSIZE, rect.y, rect.width - x - this.ICONSIZE - this.TABSIZE, rect.height), numberExpandInfo.getName(), style);
            this.paintIcon(graphics, numberExpandInfo, iconRect);
        } else if (obj != null) {
            this.simpleRender.draw(graphics, clip, obj.toString(), style);
        }
    }

    private void paintIcon(Graphics graphics, NameExpandInfo numberExpandInfo, Rectangle iconRect) {
        if (numberExpandInfo.isLeaf()) {
            this.drawLeaf(graphics, iconRect.x, iconRect.y);
        } else if (numberExpandInfo.isExpandStatus()) {
            this.drawExpanded(graphics, iconRect.x, iconRect.y);
        } else if (!numberExpandInfo.isExpandStatus()) {
            this.drawCollapsed(graphics, iconRect.x, iconRect.y);
        }
    }
}

