/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.mnt.ImportCapitalFlowDetailFilterParam;
import com.kingdee.eas.fm.mnt.client.ImportCapitalFlowDetailHandlerBase;
import java.awt.Color;

public class ImportCapitalFlowDetailByBankHandler
extends ImportCapitalFlowDetailHandlerBase {
    public ImportCapitalFlowDetailByBankHandler(ImportCapitalFlowDetailFilterParam param, KDTable kdt, AmountUnitEnum uni) {
        super(param, kdt, uni);
    }

    @Override
    public void initHeader() {
        super.initHeader();
        IColumn colIsDebit = this.kdt.addColumn();
        colIsDebit.setKey("isDebit");
        colIsDebit.getStyleAttributes().setHided(true);
        colIsDebit.setMergeable(true);
        colIsDebit.setGroup(true);
        IColumn colBank = this.kdt.addColumn();
        colBank.setKey("bank");
        colBank.setMergeable(true);
        colBank.setGroup(true);
        IColumn colDate = this.kdt.addColumn();
        colDate.setKey("date");
        IColumn colCompany = this.kdt.addColumn();
        colCompany.setKey("company");
        IColumn colDesc = this.kdt.addColumn();
        colDesc.setKey("desc");
        IColumn colCurrency = this.kdt.addColumn();
        colCurrency.setKey("currency");
        IColumn colAmount = this.kdt.addColumn();
        colAmount.setKey("amount");
        colAmount.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        colAmount.getStyleAttributes().setNumberFormat("%r{#,###.00}f");
        IColumn colAmountLocal = this.kdt.addColumn();
        colAmountLocal.setKey("amountLocal");
        colAmountLocal.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        colAmountLocal.getStyleAttributes().setNumberFormat("%r{#,###.00}f");
        this.initHeadRows();
    }

    @Override
    public void setTableStateRow() {
        this.kdt.getColumn("bank").setStat(true);
        this.kdt.getColumn("isDebit").setStat(true);
        this.kdt.getColumn("bank").setGroup(true);
        this.kdt.getColumn("isDebit").setGroup(true);
        IRow rowIsDebit = this.kdt.getGroupManager().getStatRowTemplate(0);
        rowIsDebit.getCell("amountLocal").setExpressions("SUM");
        rowIsDebit.getStyleAttributes().setBackground(new Color(16119270));
        rowIsDebit.getCell("amountLocal").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)2));
        rowIsDebit.getCell("amountLocal").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        IRow rowBank = this.kdt.getGroupManager().getStatRowTemplate(1);
        rowBank.getCell("amountLocal").setExpressions("SUM");
        rowBank.getStyleAttributes().setBackground(new Color(16119270));
        rowBank.getCell("amountLocal").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)2));
        rowBank.getCell("amountLocal").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        String companySum = this.getResString("SubTotalLocalAmount");
        rowBank.getCell("company").setValue((Object)companySum);
        String debitIn = this.getResString("TotalIn");
        String debitOut = this.getResString("TotalOut");
        rowIsDebit.getCell("bank").setExpressions("=if(cell(ROW_INDEX-1,1).getValue()," + FMHelper.quotedString((String)debitIn) + "," + FMHelper.quotedString((String)debitOut) + ")");
    }
}

