/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.mnt.ImportCapitalFlowDetailFilterParam;
import com.kingdee.eas.fm.mnt.client.ImportCapitalFlowDetailHandlerBase;
import java.awt.Color;

public class ImportCapitalFlowDetailByCompanyHandler
extends ImportCapitalFlowDetailHandlerBase {
    public ImportCapitalFlowDetailByCompanyHandler(ImportCapitalFlowDetailFilterParam param, KDTable kdt, AmountUnitEnum uni) {
        super(param, kdt, uni);
    }

    @Override
    public void initHeader() {
        super.initHeader();
        IColumn colIsDebit = this.kdt.addColumn();
        colIsDebit.setKey("isDebit");
        colIsDebit.getStyleAttributes().setHided(true);
        colIsDebit.setMergeable(true);
        colIsDebit.setGroup(true);
        IColumn colCompany = this.kdt.addColumn();
        colCompany.setKey("company");
        colCompany.setMergeable(true);
        colCompany.setGroup(true);
        IColumn colBank = this.kdt.addColumn();
        colBank.setKey("bank");
        IColumn colDate = this.kdt.addColumn();
        colDate.setKey("date");
        IColumn colDesc = this.kdt.addColumn();
        colDesc.setKey("desc");
        IColumn colCurrency = this.kdt.addColumn();
        colCurrency.setKey("currency");
        IColumn colAmount = this.kdt.addColumn();
        colAmount.setKey("amount");
        colAmount.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        colAmount.getStyleAttributes().setNumberFormat("%r{#,###.00}f");
        IColumn colAmountLocal = this.kdt.addColumn();
        colAmountLocal.setKey("amountLocal");
        colAmountLocal.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        colAmountLocal.getStyleAttributes().setNumberFormat("%r{#,###.00}f");
        this.initHeadRows();
    }

    @Override
    public void setTableStateRow() {
        this.kdt.getColumn("company").setStat(true);
        this.kdt.getColumn("isDebit").setStat(true);
        this.kdt.getColumn("company").setGroup(true);
        this.kdt.getColumn("isDebit").setGroup(true);
        IRow rowCompany = this.kdt.getGroupManager().getStatRowTemplate(1);
        rowCompany.getCell("amountLocal").setExpressions("SUM");
        rowCompany.getStyleAttributes().setBackground(new Color(16119270));
        String companySum = this.getResString("SubTotalLocalAmount");
        rowCompany.getCell("bank").setValue((Object)companySum);
        rowCompany.getCell("amountLocal").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)2));
        rowCompany.getCell("amountLocal").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        IRow stateRowIsDebit = this.kdt.getGroupManager().getStatRowTemplate(0);
        stateRowIsDebit.getCell("amountLocal").setExpressions("SUM");
        stateRowIsDebit.getStyleAttributes().setBackground(new Color(16119270));
        stateRowIsDebit.getCell("amountLocal").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)2));
        stateRowIsDebit.getCell("amountLocal").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        String debitIn = this.getResString("TotalIn");
        String debitOut = this.getResString("TotalOut");
        stateRowIsDebit.getCell("company").setExpressions("=if(cell(ROW_INDEX-1,1).getValue()," + FMHelper.quotedString((String)debitIn) + "," + FMHelper.quotedString((String)debitOut) + ")");
    }
}

