/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.mnt.ImportCapitalFlowDetailFilterParam;
import com.kingdee.eas.fm.mnt.client.ImportCapitalFlowDetailHandlerBase;
import java.awt.Color;

public class ImportCapitalFlowDetailByCurrencyHandler
extends ImportCapitalFlowDetailHandlerBase {
    public ImportCapitalFlowDetailByCurrencyHandler(ImportCapitalFlowDetailFilterParam param, KDTable kdt, AmountUnitEnum uni) {
        super(param, kdt, uni);
    }

    @Override
    public void initHeader() {
        super.initHeader();
        IColumn colIsDebit = this.kdt.addColumn();
        colIsDebit.setKey("isDebit");
        colIsDebit.getStyleAttributes().setHided(true);
        colIsDebit.setMergeable(true);
        colIsDebit.setGroup(true);
        IColumn colCurrency = this.kdt.addColumn();
        colCurrency.setKey("currency");
        colCurrency.setMergeable(true);
        colCurrency.setGroup(true);
        IColumn colDate = this.kdt.addColumn();
        colDate.setKey("date");
        IColumn colCompany = this.kdt.addColumn();
        colCompany.setKey("company");
        IColumn colBank = this.kdt.addColumn();
        colBank.setKey("bank");
        IColumn colDesc = this.kdt.addColumn();
        colDesc.setKey("desc");
        IColumn colAmount = this.kdt.addColumn();
        colAmount.setKey("amount");
        colAmount.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        colAmount.getStyleAttributes().setNumberFormat("%r{#,###.00}f");
        IColumn colAmountLocal = this.kdt.addColumn();
        colAmountLocal.setKey("amountLocal");
        colAmountLocal.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        colAmountLocal.getStyleAttributes().setNumberFormat("%r{#,###.00}f");
        this.initHeadRows();
    }

    @Override
    public void setTableStateRow() {
        this.kdt.getDataRequestManager().setDataRequestMode(0);
        this.kdt.getColumn("currency").setStat(true);
        this.kdt.getColumn("isDebit").setStat(true);
        this.kdt.getColumn("currency").setGroup(true);
        this.kdt.getColumn("isDebit").setGroup(true);
        IRow rowIsDebit = this.kdt.getGroupManager().getStatRowTemplate(0);
        rowIsDebit.getCell("amountLocal").setExpressions("SUM");
        rowIsDebit.getStyleAttributes().setBackground(new Color(16119270));
        rowIsDebit.getCell("amountLocal").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)2));
        rowIsDebit.getCell("amountLocal").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        IRow rowCurrency = this.kdt.getGroupManager().getStatRowTemplate(1);
        rowCurrency.getCell("amountLocal").setExpressions("SUM");
        rowCurrency.getStyleAttributes().setBackground(new Color(16119270));
        rowCurrency.getCell("amountLocal").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)2));
        rowCurrency.getCell("amountLocal").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        String companySum = this.getResString("SubTotalLocalAmount");
        rowCurrency.getCell("company").setValue((Object)companySum);
        String debitIn = this.getResString("TotalIn");
        String debitOut = this.getResString("TotalOut");
        rowIsDebit.getCell("currency").setExpressions("=if(cell(ROW_INDEX-1,1).getValue()," + FMHelper.quotedString((String)debitIn) + "," + FMHelper.quotedString((String)debitOut) + ")");
    }
}

