/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.mnt.ImportCapitalFlowDetailFilterParam;
import com.kingdee.eas.fm.mnt.client.AbstractImportCapitalFlowDetailFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import java.util.GregorianCalendar;

public class ImportCapitalFlowDetailFilterUI
extends AbstractImportCapitalFlowDetailFilterUI {
    private static String path = "com.kingdee.eas.fm.common.FMResource";

    public ImportCapitalFlowDetailFilterUI() throws Exception {
        F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)this.f7Bank);
    }

    public Object getParam() {
        ImportCapitalFlowDetailFilterParam param = new ImportCapitalFlowDetailFilterParam();
        param.setCompanyIdSet(this.getCompanyIdSet());
        param.setBankIdSet(this.getIdSetFromF7(this.f7Bank));
        param.setCurrencyIdSet(this.getIdSetFromF7(this.prmtCurrency));
        param.setDateFrom(DateUtil.getDayBegin((Date)this.dtpDateFrom.getSqlDate()));
        param.setDateTo(DateUtil.getDayBegin((Date)this.dtpDateTo.getSqlDate()));
        param.setTxtAmtFrom(this.txtAmtFrom.getBigDecimalValue());
        param.setTxtAmtTo(this.txtAmtTo.getBigDecimalValue());
        param.setRemark(this.remark.getText());
        param.setUnit((AmountUnitEnum)this.cboUnit.getSelectedItem());
        int orderType = 0;
        if (this.rbtByCompany.isSelected()) {
            orderType = 1;
        } else if (this.rbtByBank.isSelected()) {
            orderType = 2;
        } else if (this.rbtByCurrency.isSelected()) {
            orderType = 3;
        }
        param.setOrderType(orderType);
        return param;
    }

    public void setParam(Object param) {
        ImportCapitalFlowDetailFilterParam newparam = (ImportCapitalFlowDetailFilterParam)param;
        this.setCompanyIdSet(newparam.getCompanyIdSet());
        try {
            this.f7Bank.setData((Object)this.getBaseInfoFromIdSet(newparam.getBankIdSet()));
            this.prmtCurrency.setData((Object)this.getBaseInfoFromIdSet(newparam.getCurrencyIdSet()));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.dtpDateFrom.setValue((Object)newparam.getDateFrom());
        this.dtpDateTo.setValue((Object)newparam.getDateTo());
        this.txtAmtFrom.setValue((Object)newparam.getTxtAmtFrom());
        this.txtAmtTo.setValue((Object)newparam.getTxtAmtTo());
        this.remark.setText(newparam.getRemark());
        if (newparam.getUnit() == null) {
            FMClientHelper.setSelectObject((KDComboBox)this.cboUnit, (Object)AmountUnitEnum.wan_yuan);
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.cboUnit, (Object)newparam.getUnit());
        }
        switch (newparam.getOrderType()) {
            case 1: {
                this.rbtByCompany.setSelected(true);
                break;
            }
            case 2: {
                this.rbtByBank.setSelected(true);
                break;
            }
            case 3: {
                this.rbtByCurrency.setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalidate status!");
            }
        }
    }

    protected void init() throws Exception {
        super.init();
        this.initControl();
    }

    private void initControl() {
        this.f7Bank.setData(null);
        this.f7Bank.setEditable(true);
        this.prmtCurrency.setData(null);
        this.f7Bank.setDisplayFormat("$name$");
        this.f7Bank.setEditFormat("$number$");
        this.prmtCurrency.setEditable(true);
        this.dtpDateFrom.setValue((Object)DateUtil.getDayBegin());
        this.dtpDateTo.setValue((Object)DateUtil.getLastDayOfCurMonth());
        FMClientHelper.setSelectObject((KDComboBox)this.cboUnit, (Object)AmountUnitEnum.wan_yuan);
        this.rbtByCompany.setSelected(true);
        this.txtAmtFrom.setSupportedEmpty(true);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmtFrom);
        this.txtAmtFrom.setPrecision(2);
        this.txtAmtFrom.setValue(null);
        this.txtAmtTo.setSupportedEmpty(true);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmtTo);
        this.txtAmtTo.setPrecision(2);
        this.txtAmtTo.setValue(null);
        this.remark.setText("");
    }

    private void getLastDayOfMonth(KDDatePicker kdDate) {
        Date date = new Date();
        GregorianCalendar lastDay = new GregorianCalendar();
        lastDay.add(2, 1);
        lastDay.add(5, -date.getDate());
        kdDate.setValue((Object)lastDay.getTime());
    }

    public void clear() {
        super.clear();
        this.initControl();
    }

    public boolean verify() {
        CompanyOrgUnitInfo currentCompany;
        if (this.cboUnit.getSelectedItem() == null) {
            this.cboUnit.setSelectedItem((Object)AmountUnitEnum.wan_yuan);
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)(currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany())) && this.getCompanyIdSet().size() <= 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)path, (String)"noCompany"));
            SysUtil.abort();
            return false;
        }
        if (this.txtAmtFrom.getValue() != null && this.txtAmtTo.getValue() != null && this.txtAmtFrom.getBigDecimalValue().compareTo(this.txtAmtTo.getBigDecimalValue()) > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"435_ImportCapitalFlowDetailFilterUI"));
            SysUtil.abort();
        }
        if (this.dtpDateFrom.getValue() == null || this.dtpDateTo.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"501_RptFinancingCostInteAnalyseFilterUI"));
            SysUtil.abort();
        }
        Date from = (Date)this.dtpDateFrom.getValue();
        Date to = (Date)this.dtpDateTo.getValue();
        if (to.before(from)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"477_RptBlockFundFlowGGFilterUI"));
            this.dtpDateFrom.requestFocus();
            return false;
        }
        return super.verify();
    }

    protected Class getParamClass() {
        return ImportCapitalFlowDetailFilterParam.class;
    }
}

