/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.mnt.ImportCapitalFlowDetailFilterParam;
import com.kingdee.eas.fm.mnt.client.IImportCapitalFlowDetialHandler;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class ImportCapitalFlowDetailHandlerBase
implements IImportCapitalFlowDetialHandler {
    public static final String resourcePath = "com.kingdee.eas.fm.mnt.client.ImportCapitalFlowResource";
    protected ImportCapitalFlowDetailFilterParam filterParam = null;
    protected KDTable kdt = null;
    protected BigDecimal amountUnit = null;
    protected BigDecimal bdNeatAmountLocal = SysConstant.BIGZERO;
    Map rateCache = new HashMap();

    public ImportCapitalFlowDetailHandlerBase(ImportCapitalFlowDetailFilterParam param, KDTable kdt, AmountUnitEnum uni) {
        this.filterParam = param;
        this.kdt = kdt;
        this.amountUnit = new BigDecimal(String.valueOf(uni.getValue()));
    }

    @Override
    public void initHeader() {
        this.kdt.removeRows();
        this.kdt.removeHeadRows();
        this.kdt.removeColumns();
        this.kdt.getGroupManager().removeGroup();
        this.kdt.setEditable(false);
        this.kdt.getGroupManager().setGroup(true);
        this.kdt.getGroupManager().setOrientation(1);
    }

    protected String getResString(String key) {
        return EASResource.getString((String)resourcePath, (String)key);
    }

    @Override
    public IRowSet getRowSet() throws BOSException {
        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.mnt.ImportCapitalFlowDetailQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(this.filterParam.getFilter());
        ev.getSorter().addObjectCollection((IObjectCollection)this.filterParam.getSorterItems());
        exec.setObjectView(ev);
        return exec.executeQuery();
    }

    protected BigDecimal getLocalAmount(IRowSet rs) throws BOSException, EASBizException, SQLException, FinBizException {
        String companyId = rs.getString("company.id");
        String currencyId = rs.getString("currency.id");
        BigDecimal rst = this.getCurrentRate(companyId, currencyId);
        BigDecimal bdAmount = null;
        bdAmount = rs.getBigDecimal("creditAmount").signum() == 0 ? rs.getBigDecimal("debitAmount") : rs.getBigDecimal("creditAmount");
        return bdAmount.multiply(rst);
    }

    private BigDecimal getCurrentRate(String companyId, String currencyId) throws BOSException, EASBizException, FinBizException {
        String key = companyId + currencyId;
        BigDecimal value = (BigDecimal)this.rateCache.get(key);
        if (value != null) {
            return value;
        }
        Date createData = null;
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        BigDecimal rate = null;
        CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
        CurrencyInfo currencyLocal = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        if (currency.getId().equals((Object)currencyLocal.getId())) {
            rate = Constants.ONE;
            this.rateCache.put(key, rate);
            return rate;
        }
        ExchangeRateInfo exRateInfo = FinUtils.getCurrencyExRateInfo(null, (CompanyOrgUnitInfo)company, (CurrencyInfo)currency, (CurrencyInfo)currencyLocal, createData);
        if (exRateInfo == null) {
            rate = Constants.ZERO;
            this.rateCache.put(key, rate);
            return rate;
        }
        rate = exRateInfo.getConvertRate();
        this.rateCache.put(key, rate);
        return rate;
    }

    protected void initHeadRows() {
        IRow headRow = this.kdt.addHeadRow();
        headRow.getCell("company").setValue((Object)this.getResString("company"));
        headRow.getCell("bank").setValue((Object)this.getResString("bank"));
        headRow.getCell("date").setValue((Object)this.getResString("date"));
        headRow.getCell("desc").setValue((Object)this.getResString("desc"));
        headRow.getCell("currency").setValue((Object)this.getResString("currency"));
        headRow.getCell("amount").setValue((Object)this.getResString("amount"));
        headRow.getCell("amountLocal").setValue((Object)this.getResString("amountLocal"));
    }

    @Override
    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        this.bdNeatAmountLocal = SysConstant.BIGZERO;
        this.kdt.setRefresh(false);
        while (rs.next()) {
            IRow row = this.kdt.addRow();
            boolean isDebit = rs.getBoolean("isDebit");
            BigDecimal amountLocal = this.getLocalAmount(rs);
            this.bdNeatAmountLocal = isDebit ? this.bdNeatAmountLocal.add(amountLocal) : this.bdNeatAmountLocal.subtract(amountLocal);
            row.getCell("isDebit").setValue((Object)isDebit);
            row.getCell("bank").setValue((Object)rs.getString("bank.name"));
            row.getCell("date").setValue((Object)rs.getDate("createDate"));
            row.getCell("company").setValue((Object)rs.getString("company.name"));
            row.getCell("desc").setValue((Object)rs.getString("description"));
            row.getCell("currency").setValue((Object)rs.getString("currency.name"));
            row.getCell("date").getStyleAttributes().setNumberFormat(FMHelper.getDateFormatString());
            row.getCell("amount").setValue((Object)rs.getBigDecimal("creditAmount").add(rs.getBigDecimal("debitAmount")).divide(this.amountUnit, 10, 4));
            row.getCell("amountLocal").setValue((Object)amountLocal.divide(this.amountUnit, 10, 4));
            row.getCell("amount").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)2));
            row.getCell("amountLocal").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)2));
        }
        this.kdt.setRefresh(true);
        this.kdt.repaint();
        this.kdt.getGroupManager().group();
        this.kdt.getGroupManager().setGroup(false);
    }

    @Override
    public void insertAbsractFlowRow() {
        String text = this.getResString("NeatAmountLocal");
        IRow row = this.kdt.addRow();
        row.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        BigDecimal realFlow = this.bdNeatAmountLocal.divide(this.amountUnit, 10, 4);
        row.getCell("amountLocal").setValue((Object)realFlow);
        row.getCell("company").setValue((Object)text);
        BigDecimal amount = row.getCell("amount").getValue() == null ? Constants.ZERO : new BigDecimal(row.getCell("amount").getValue().toString());
        row.getCell("amount").setValue((Object)amount);
        row.getCell("amount").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)2));
        BigDecimal amountLocal = row.getCell("amountLocal").getValue() == null ? Constants.ZERO : new BigDecimal(row.getCell("amountLocal").getValue().toString());
        row.getCell("amountLocal").setValue((Object)amountLocal);
        row.getCell("amountLocal").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)2));
    }
}

