/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.resource.KDResourceManager;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.util.RptFmClientUtil;
import com.kingdee.eas.fm.mnt.client.AbstractRptAcceptanceStruAnalyseFilterUI;
import com.kingdee.eas.fm.nt.NTTypeCollection;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.sql.Date;
import java.sql.SQLException;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class RptAcceptanceStruAnalyseFilterUI
extends AbstractRptAcceptanceStruAnalyseFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptAcceptanceStruAnalyseFilterUI.class);
    private Set bankIdSet = null;
    private Set currencyIdSet = null;
    public Set typeIdSet = null;

    public RptParams getCustomCondition() {
        RptConditionManager rcm = new RptConditionManager();
        rcm.recordAllStatus((Container)((Object)this));
        rcm.setProperty("companyIdSet", (Object)this.companyIdSet);
        this.bankIdSet = this.getBankCompanyIdSet();
        rcm.setProperty("bankIdSet", (Object)this.bankIdSet);
        rcm.setProperty("childBankTree", (Object)this.selectedNode);
        this.typeIdSet = this.getTypeIdSet();
        rcm.setProperty("typeIdSet", (Object)this.typeIdSet);
        this.currencyIdSet = this.getIdSetFromF7(this.kDCurrency);
        rcm.setProperty("currencyIdSet", (Object)this.currencyIdSet);
        return rcm.toRptParams();
    }

    public void setCustomCondition(RptParams params) {
        Set names;
        RptConditionManager rcm = new RptConditionManager(params);
        rcm.restoreAllStatus((Container)((Object)this));
        this.companyIdSet = (Set)params.getObject("companyIdSet");
        this.bankIdSet = (Set)params.getObject("bankIdSet");
        this.selectedNode = this.getBankTreeNodeFromByIdSet(this.bankIdSet);
        this.typeIdSet = this.getTypeIdSet();
        this.currencyIdSet = (Set)params.getObject("currencyIdSet");
        super.setCustomCondition(params);
        if (this.kDUnit.getSelectedItem() == null) {
            this.kDUnit.setSelectedItem((Object)AmountUnitEnum.wan_yuan);
        }
        if ((names = this.getNameSetFromByBankTreeNode(this.selectedNode)) != null) {
            this.kDTextField1.setText(names.toString());
        }
    }

    public void onInit(RptParams initParams) throws Exception {
        super.onInit(initParams);
        this.kDTextField1.setEnabled(false);
        Image icon_off = KDResourceManager.getImageOfRapid((String)"prompt_off.gif");
        this.kDBank.setIcon((Icon)new ImageIcon(icon_off));
        this.kDCurrency.setData(null);
        this.kDCheckBoxInculdeComm.setSelected(false);
        this.kDUnit.setSelectedItem((Object)AmountUnitEnum.wan_yuan);
        this.getFirstDayOfMonth(this.kDDateFrom);
        this.getLastDayOfMonth(this.kDDateTo);
        this.kDRadioButtonCompany.setSelected(true);
        this.kDCompany.setText(ContextHelperFactory.getRemoteInstance().getCurrentCompany().toString());
    }

    private void getFirstDayOfMonth(KDDatePicker kdDate) {
        java.util.Date date = new java.util.Date();
        GregorianCalendar firstDay = new GregorianCalendar();
        firstDay.add(5, -(date.getDate() - 1));
        kdDate.setValue((Object)firstDay.getTime());
    }

    private void getLastDayOfMonth(KDDatePicker kdDate) {
        java.util.Date date = new java.util.Date();
        GregorianCalendar lastDay = new GregorianCalendar();
        lastDay.add(2, 1);
        lastDay.add(5, -date.getDate());
        kdDate.setValue((Object)lastDay.getTime());
    }

    protected Set getBankCompanyIdSet() {
        Set selectIdSet = this.getIdSetFromByBankTreeNode(this.selectedNode);
        Set bankIdSet = selectIdSet == null || selectIdSet.size() < 1 ? this.getF7Bank() : this.getIdSetFromByBankTreeNode(this.selectedNode);
        return bankIdSet;
    }

    private Set getF7Bank() {
        String sql = " SELECT DISTINCT \"INSTITUTION\".FID AS \"INSTITUTION.ID\" FROM T_NT_PayableBill AS \"COMMERCIALDRAFT\" INNER JOIN T_BD_Bank AS \"INSTITUTION\" ON \"COMMERCIALDRAFT\".FInstitutionId = \"INSTITUTION\".FID";
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = null;
        try {
            rs = exec.executeSQL();
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        HashSet<String> companyIdSetToBankIdSet = new HashSet<String>();
        try {
            while (rs.next()) {
                companyIdSetToBankIdSet.add(rs.getString("Institution.id"));
            }
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
        return companyIdSetToBankIdSet;
    }

    private Set getTypeIdSet() {
        HashSet<Integer> typeSet = new HashSet<Integer>();
        if (this.kDCheckBoxInculdeComm.isSelected()) {
            typeSet.add(51);
            typeSet.add(52);
            return this.getNtTypeIdSet(typeSet);
        }
        typeSet.add(51);
        return this.getNtTypeIdSet(typeSet);
    }

    private Set getNtTypeIdSet(Set type) {
        HashSet<String> typeIdSet = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("group", (Object)type, CompareType.INCLUDE));
        try {
            NTTypeCollection colls = NTTypeFactory.getRemoteInstance().getNTTypeCollection(view);
            for (int index = 0; index < colls.size(); ++index) {
                typeIdSet.add(colls.get(index).getId().toString());
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return typeIdSet;
    }

    public boolean verify() {
        Date kdDateFrom = this.kDDateFrom.getSqlDate();
        Date kdDateTo = this.kDDateTo.getSqlDate();
        if (this.kDRadioButtonFinRes.isSelected()) {
            if (kdDateTo == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"436_RptAcceptanceStruAnalyseFilterUI"));
                SysUtil.abort();
            }
        } else {
            if (kdDateFrom == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"437_RptAcceptanceStruAnalyseFilterUI"));
                SysUtil.abort();
            }
            if (kdDateTo == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"436_RptAcceptanceStruAnalyseFilterUI"));
                SysUtil.abort();
            }
            if (kdDateFrom.compareTo(kdDateTo) > 0) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"438_RptAcceptanceStruAnalyseFilterUI"));
                SysUtil.abort();
            }
        }
        return super.verify();
    }

    @Override
    protected void kDRadioButtonBank_actionPerformed(ActionEvent e) throws Exception {
        super.kDRadioButtonBank_actionPerformed(e);
        this.kDCheckBoxInculdeComm.setSelected(false);
        this.kDCheckBoxInculdeComm.setEnabled(false);
        if (this.kDDateFrom.getValue() == null) {
            this.getFirstDayOfMonth(this.kDDateFrom);
        }
        this.kDDateFrom.setEnabled(true);
    }

    @Override
    protected void kDRadioButtonCompany_actionPerformed(ActionEvent e) throws Exception {
        super.kDRadioButtonCompany_actionPerformed(e);
        if (!this.kDCheckBoxInculdeComm.isEnabled()) {
            this.kDCheckBoxInculdeComm.setSelected(false);
            this.kDCheckBoxInculdeComm.setEnabled(true);
        }
        if (this.kDDateFrom.getValue() == null) {
            this.getFirstDayOfMonth(this.kDDateFrom);
        }
        this.kDDateFrom.setEnabled(true);
    }

    @Override
    protected void kDRadioButtonCurrency_actionPerformed(ActionEvent e) throws Exception {
        super.kDRadioButtonCurrency_actionPerformed(e);
        if (!this.kDCheckBoxInculdeComm.isEnabled()) {
            this.kDCheckBoxInculdeComm.setSelected(false);
            this.kDCheckBoxInculdeComm.setEnabled(true);
        }
        if (this.kDDateFrom.getValue() == null) {
            this.getFirstDayOfMonth(this.kDDateFrom);
        }
        this.kDDateFrom.setEnabled(true);
    }

    @Override
    protected void kDRadioButtonFinRes_actionPerformed(ActionEvent arg0) throws Exception {
        super.kDRadioButtonFinRes_actionPerformed(arg0);
        this.kDCheckBoxInculdeComm.setSelected(true);
        this.kDCheckBoxInculdeComm.setEnabled(false);
        this.kDDateFrom.setValue(null);
        this.kDDateFrom.setEnabled(false);
    }

    @Override
    protected void kDRadioButtonGT_actionPerformed(ActionEvent arg0) throws Exception {
        super.kDRadioButtonGT_actionPerformed(arg0);
        if (!this.kDCheckBoxInculdeComm.isEnabled()) {
            this.kDCheckBoxInculdeComm.setSelected(false);
            this.kDCheckBoxInculdeComm.setEnabled(true);
        }
        if (this.kDDateFrom.getValue() == null) {
            this.getFirstDayOfMonth(this.kDDateFrom);
        }
        this.kDDateFrom.setEnabled(true);
    }

    @Override
    protected void kDBank_actionPerformed(ActionEvent e) throws Exception {
        if (this.bankSelectDlg == null) {
            this.bankSelectDlg = RptFmClientUtil.selectBank((RptFmClientUtil.SelectBankListener)this, (Component)((Object)this));
        }
        this.bankSelectDlg.show();
        Set names = this.getNameSetFromByBankTreeNode(this.selectedNode);
        if (names != null) {
            this.kDTextField1.setText(names.toString());
        }
        super.kDBank_actionPerformed(e);
    }
}

