/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.util.RptFmClientUtil;
import com.kingdee.eas.fm.mnt.client.AbstractRptBlockFundFlowGGFilterUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import org.apache.log4j.Logger;

public class RptBlockFundFlowGGFilterUI
extends AbstractRptBlockFundFlowGGFilterUI
implements RptFmClientUtil.SelectCompanyListener {
    private static final Logger logger = CoreUIObject.getLogger(RptBlockFundFlowGGFilterUI.class);
    private Set bankIdSet = null;

    public RptBlockFundFlowGGFilterUI() throws Exception {
        ButtonGroup bg = new ButtonGroup();
        bg.add((AbstractButton)this.jrbBank);
        bg.add((AbstractButton)this.jrbCompany);
        bg.add((AbstractButton)this.jrbCurrency);
        this.jrbCompany.setSelected(true);
        this.setSize(376, 238);
        F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)this.jbpBank);
    }

    public boolean verify() {
        if (this.jtAmountUnit.getSelectedItem() == null) {
            this.jtAmountUnit.setSelectedItem((Object)AmountUnitEnum.wan_yuan);
        }
        if (!super.verify()) {
            return false;
        }
        if (this.jdFrom.getValue() == null || this.jdTo.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"501_RptFinancingCostInteAnalyseFilterUI"));
            SysUtil.abort();
        }
        Date from = (Date)this.jdFrom.getValue();
        Date to = (Date)this.jdTo.getValue();
        if (to.before(from)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"477_RptBlockFundFlowGGFilterUI"));
            this.jdFrom.requestFocus();
            return false;
        }
        return true;
    }

    public void onInit(RptParams initParams) throws Exception {
        super.onInit(initParams);
        this.jtAmountUnit.setSelectedItem((Object)AmountUnitEnum.wan_yuan);
        this.jbpBank.setDisplayFormat("$name$");
        this.jbpBank.setEditFormat("$number$");
        this.jbpBank.setEnabledMultiSelection(true);
        this.jbpBank.setEditable(true);
        this.jbpBank.setCommitFormat("$number$");
        this.jbpBank.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7BankQuery");
        this.jbpBank.setData(null);
        this.jdFrom.setValue((Object)DateUtil.getDayBegin());
        this.jdTo.setValue((Object)DateUtil.getEndDayOfCurMonth());
        this.jrbCompany.setSelected(true);
    }

    private void getLastDayOfMonth(KDDatePicker kdDate) {
        Date date = new Date();
        GregorianCalendar lastDay = new GregorianCalendar();
        lastDay.add(2, 1);
        lastDay.add(5, -date.getDate());
        kdDate.setValue((Object)lastDay.getTime());
    }

    public RptParams getCustomCondition() {
        RptConditionManager rm = new RptConditionManager();
        rm.recordAllStatus((Container)((Object)this));
        rm.setProperty("companyIdSet", (Object)this.companyIdSet);
        this.bankIdSet = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.jbpBank));
        rm.setProperty("bankIdSet", (Object)this.bankIdSet);
        rm.setProperty("RateCurrencySet", (Object)this.getIdSetFromF7(this.prmtCurrency));
        return rm.toRptParams();
    }

    public void setCustomCondition(RptParams params) {
        RptConditionManager rm = new RptConditionManager(params);
        rm.restoreAllStatus((Container)((Object)this));
        this.companyIdSet = (Set)params.getObject("companyIdSet");
        try {
            this.bankIdSet = (Set)params.getObject("bankIdSet");
            CoreBaseInfo[] c = RptFmClientUtil.getBaseInfoFromIdSet((Set)this.bankIdSet);
            this.jbpBank.setData((Object)c);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    protected void kdtHistory_itemStateChanged(ItemEvent e) throws Exception {
        if (this.kdtHistory.isSelected()) {
            this.prmtCurrency.setEnabled(false);
            this.prmtCurrency.setData(null);
        }
    }

    @Override
    protected void kdtCurrent_itemStateChanged(ItemEvent e) throws Exception {
        if (this.kdtCurrent.isSelected()) {
            this.prmtCurrency.setEnabled(true);
            BOSUuid id = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getBaseCurrency().getId();
            CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(id));
            this.prmtCurrency.setData((Object)currency);
        }
    }
}

