/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.chart.ChartType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.mnt.ImportCapitalFlowDetailFilterParam;
import com.kingdee.eas.fm.mnt.RptBlockFundFlowGGFacadeFactory;
import com.kingdee.eas.fm.mnt.client.AbstractRptBlockFundFlowGGMainUI;
import com.kingdee.eas.fm.mnt.client.ImportCapitalFlowDetailUI;
import com.kingdee.eas.fm.mnt.client.RptBlockFundFlowGGFilterUI;
import com.kingdee.eas.framework.bireport.IBireportBaseFacade;
import com.kingdee.eas.framework.bireport.client.BireportBaseFilterUI;
import com.kingdee.eas.framework.bireport.util.FormatUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptBlockFundFlowGGMainUI
extends AbstractRptBlockFundFlowGGMainUI {
    private static final Logger logger = CoreUIObject.getLogger(RptBlockFundFlowGGMainUI.class);

    @Override
    public void actionJoinQueryGD_actionPerformed(ActionEvent e) throws Exception {
        this.doJoinQueryGD();
    }

    protected IBireportBaseFacade getRemoteInstance() throws BOSException {
        return RptBlockFundFlowGGFacadeFactory.getRemoteInstance();
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected BireportBaseFilterUI getQueryDialogUserPanel() throws Exception {
        return new RptBlockFundFlowGGFilterUI();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnJoinQueryGD.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewlist"));
        this.menuJoinQueryGD.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewlist"));
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(RptBlockFundFlowGGMainUI.getRes((String)"print_label_datetime")).append("&[DateTime]&|").append(RptBlockFundFlowGGMainUI.getRes((String)"print_label_amountunit")).append("&[AmountUnit]&| ").append(RptBlockFundFlowGGMainUI.getRes((String)"print_label_company")).append("&[Company]");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Company", SysContext.getSysContext().getCurrentFIUnit().getName());
        map.put("AmountUnit", this.jlAmountUnit.getText());
        map.put("DateTime", this.jlDateRange.getText());
        return map;
    }

    protected KDTable getTableForPrintSetting() {
        return this.kDTable1;
    }

    protected void afterModelChanged() throws Exception {
        super.afterModelChanged();
        if (this.params.getObjectElement("prmtCurrency.value") != null) {
            int headRowCount = this.kDTable1.getHeadRowCount();
            int columnCount = this.kDTable1.getColumnCount();
            for (int i = 0; i < headRowCount; ++i) {
                IRow headRow = this.kDTable1.getHeadRow(i);
                for (int j = 0; j < columnCount; ++j) {
                    Object headValue = headRow.getCell(j).getValue();
                    if (headValue == null || headValue.toString().indexOf("(\u672c\u4f4d\u5e01)") <= 0) continue;
                    String replace = headValue.toString().replace("(\u672c\u4f4d\u5e01)", "(\u6298\u67e5\u8be2\u5e01\u522b)");
                    headRow.getCell(j).setValue((Object)replace);
                }
            }
        }
    }

    protected RptParams getParamsForRequest() {
        this.params.setString("cuId", SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        return this.params;
    }

    protected void onBeforeQuery() throws Exception {
        this.setShowDefaultChart(false);
        this.jlAmountUnit.setText(this.params.getObjectElement("jtAmountUnit.value").toString());
        this.jlDateRange.setText(FormatUtil.formatDateTitle((Date)((Date)this.params.getObjectElement("jdFrom.value")), (Date)((Date)this.params.getObjectElement("jdTo.value"))));
        this.setMeasurePrecision(2);
        if (this.params.getObjectElement("prmtCurrency.value") != null) {
            this.kDLabel2.setVisible(true);
            this.kDLabel3.setVisible(true);
            this.kDLabel3.setText(this.params.getObjectElement("prmtCurrency.value").toString());
        } else {
            this.kDLabel3.setVisible(false);
            this.kDLabel2.setVisible(false);
        }
    }

    protected void onAfterQuery() throws Exception {
        boolean forCompany = (Boolean)this.params.getObjectElement("jrbCompany.value");
        boolean forBank = (Boolean)this.params.getObjectElement("jrbBank.value");
        if (forCompany) {
            this.addChart().setTitle(EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"478_RptBlockFundFlowGGMainUI")).setChartType(ChartType.CT_COLUMNCLUSTERED).addNotShowMember("Currency", EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"441_RptAcceptanceStruAnalyseMainUI")).addNotShowMember("Company", EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"441_RptAcceptanceStruAnalyseMainUI")).addOnlyLeafVisibleHandler("Company").finishDataSet();
        } else if (forBank) {
            this.addChart().setTitle(EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"478_RptBlockFundFlowGGMainUI")).setChartType(ChartType.CT_COLUMNCLUSTERED).addNotShowMember("Bank", EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"441_RptAcceptanceStruAnalyseMainUI")).addNotShowMember("Currency", EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"441_RptAcceptanceStruAnalyseMainUI")).addOnlyLeafVisibleHandler("Bank").finishDataSet();
        } else {
            this.addChart().setTitle(EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"478_RptBlockFundFlowGGMainUI")).setChartType(ChartType.CT_COLUMNCLUSTERED).addNotShowMember("Currency", EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"441_RptAcceptanceStruAnalyseMainUI")).finishDataSet();
        }
    }

    protected void onTableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    protected void onTableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.doJoinQueryGD();
        }
    }

    protected void onTableKeyPressed(KeyEvent e) throws Exception {
        if (e.getKeyCode() == 10) {
            this.doJoinQueryGD();
        }
    }

    private void doJoinQueryGD() throws Exception {
        ImportCapitalFlowDetailFilterParam pp = new ImportCapitalFlowDetailFilterParam();
        pp.setBankIdSet((Set)this.params.getObject("bankIdSet"));
        pp.setCompanyIdSet((Set)this.params.getObject("companyIdSet"));
        pp.setDateFrom((Date)this.params.getObjectElement("jdFrom.value"));
        pp.setDateTo((Date)this.params.getObjectElement("jdTo.value"));
        pp.setUnit((AmountUnitEnum)this.params.getObjectElement("jtAmountUnit.value"));
        boolean forCompany = (Boolean)this.params.getObjectElement("jrbCompany.value");
        boolean forBank = (Boolean)this.params.getObjectElement("jrbBank.value");
        int orderType = -1;
        orderType = forCompany ? 1 : (forBank ? 2 : 3);
        pp.setOrderType(orderType);
        if (this.params.getObjectElement("prmtCurrency.value") != null) {
            pp.setRateCurrencyInfo((CurrencyInfo)this.params.getObjectElement("prmtCurrency.value"));
        }
        HashSet companySet = new HashSet();
        HashSet<Object> bankSet = new HashSet<Object>();
        HashSet currencySet = new HashSet();
        Member[] ms = this.getSelectedDataCellItemInfo();
        if (ms != null) {
            for (Member m : ms) {
                HashSet<Object> set;
                if (!m.isLeaf()) continue;
                String dimName = m.getDimension().getLabel();
                if ("Bank".equals(dimName)) {
                    set = bankSet;
                } else if ("Currency".equals(dimName)) {
                    set = currencySet;
                } else {
                    if (!"Company".equals(dimName)) continue;
                    set = companySet;
                }
                if (m.getKey() == null) continue;
                set.add(m.getKey());
            }
        }
        if (companySet.size() > 0) {
            pp.setCompanyIdSet(companySet);
        }
        if (bankSet.size() > 0) {
            pp.setBankIdSet(bankSet);
        }
        pp.setCurrencyIdSet(currencySet);
        ImportCapitalFlowDetailUI.showDialogWindows((IUIObject)this, pp);
    }
}

