/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.IRptHandler;
import com.kingdee.eas.fm.mnt.client.RptCashFlow4SingleFilterParam;
import com.kingdee.eas.fm.mnt.vo.FundFlowInfo;
import com.kingdee.eas.fm.mnt.vo.NameExpandInfo;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.util.List;

public class RptCashFlow4SingleListHandler
implements IRptHandler {
    protected KDTable kdt;
    protected RptCashFlow4SingleFilterParam filterParam;
    private static final String RES = "com.kingdee.eas.fm.mnt.ReportResource";

    public RptCashFlow4SingleListHandler(KDTable kdt, RptCashFlow4SingleFilterParam filterParam) {
        this.kdt = kdt;
        this.filterParam = filterParam;
    }

    public void initHeader() {
        this.kdt.checkParsed();
        this.kdt.removeRows();
        this.kdt.removeColumns();
        this.kdt.removeHeadRows();
        this.kdt.getStyleAttributes().setLocked(true);
        this.initColumn();
        this.initHead();
    }

    private void initHead() {
        IRow headRow = this.kdt.addHeadRow();
        headRow.getCell("fundFlowItem").setValue((Object)EASResource.getString((String)RES, (String)"FundFlowItemTitle"));
        headRow.getCell("actAmt").setValue((Object)this.filterParam.getCompany().getName());
    }

    private void initColumn() {
        IColumn colFundFlowItem = this.kdt.addColumn();
        colFundFlowItem.setKey("fundFlowItem");
        colFundFlowItem.setWidth(520);
        colFundFlowItem.getStyleAttributes().setBackground(new Color(16119270));
        IColumn colAmt = this.kdt.addColumn();
        colAmt.setKey("actAmt");
        colAmt.setWidth(220);
        this.setCurrencyColumnFmt(colAmt, this.filterParam.getCompany().getBaseCurrency().getId().toString());
    }

    private void setCurrencyColumnFmt(IColumn column, String currencyId) {
        String numberFtm = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)currencyId));
        column.getStyleAttributes().setNumberFormat(numberFtm);
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public void fillData(List<FundFlowInfo> lst) {
        for (FundFlowInfo info : lst) {
            IRow row = this.kdt.addRow();
            row.setUserObject((Object)info.getFundFlowItemID());
            this.setTreeDisplayStyle(row, info);
            row.getCell("actAmt").setValue((Object)info.getActAmt());
        }
    }

    private void setTreeDisplayStyle(IRow row, FundFlowInfo info) {
        String id = info.getFundFlowItemID();
        int level = info.getLevel();
        String longNumber = info.getLongNumber();
        NameExpandInfo fpItemNumberExpandInfo = new NameExpandInfo();
        fpItemNumberExpandInfo.setFpItemId(id);
        fpItemNumberExpandInfo.setLevel(level);
        fpItemNumberExpandInfo.setLeaf(info.isIsLeaf());
        fpItemNumberExpandInfo.setExpandStatus(true);
        fpItemNumberExpandInfo.setName(info.getNumber() + " " + info.getName());
        fpItemNumberExpandInfo.setLongNumber(longNumber.toString());
        row.getCell("fundFlowItem").setValue((Object)fpItemNumberExpandInfo);
    }

    public void endDataFill() {
        this.kdt.setRefresh(true);
        this.kdt.repaint();
        this.kdt.getGroupManager().group();
        this.kdt.getGroupManager().setGroup(false);
    }
}

