/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.mnt.RptCashFlowFacadeFactory;
import com.kingdee.eas.fm.mnt.client.AbstractRptCashFlow4SingleListUI;
import com.kingdee.eas.fm.mnt.client.FundFlowItemTreeRender;
import com.kingdee.eas.fm.mnt.client.RptCashFlow4SingleFilterParam;
import com.kingdee.eas.fm.mnt.client.RptCashFlow4SingleFilterUI;
import com.kingdee.eas.fm.mnt.client.RptCashFlow4SingleListHandler;
import com.kingdee.eas.fm.mnt.vo.NameExpandInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.exportexcel.ExportExcelHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import org.apache.log4j.Logger;

public class RptCashFlow4SingleListUI
extends AbstractRptCashFlow4SingleListUI {
    private static final long serialVersionUID = -5933601617385567726L;
    private static final Logger logger = CoreUIObject.getLogger(RptCashFlow4SingleListUI.class);
    private RptCashFlow4SingleFilterUI filterUI;
    private RptCashFlow4SingleListHandler handler;
    private FundFlowItemTreeRender treeRender;
    private CompanyOrgUnitInfo company;
    private static final String resourcePath = "com.kingdee.eas.fi.cas.CasResources";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtDateFrom.setText(this.filterUI.pkDateFrom.getText());
        this.txtDateTo.setText(this.filterUI.pkDateTo.getText());
        if (this.company == null) {
            this.company = (CompanyOrgUnitInfo)this.filterUI.prmtCompany.getValue();
        }
        CurrencyInfo baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.company.getBaseCurrency().getId().toString()));
        this.txtCurrency.setText(baseCurrency.getName());
        this.txtCompany.setText(this.company.getName());
        this.treeRender = new FundFlowItemTreeRender();
        this.tblMain.getColumn("fundFlowItem").setRenderer((IBasicRender)this.treeRender);
    }

    protected void execQuery() throws BOSException {
        this.initLableValue();
        RptCashFlow4SingleFilterParam filterParam = (RptCashFlow4SingleFilterParam)this.getFilterParam();
        if (filterParam == null) {
            return;
        }
        this.handler = new RptCashFlow4SingleListHandler(this.tblMain, filterParam);
        this.company = filterParam.getCompany();
        this.handler.initHeader();
        if (EmptyUtil.isEmpty((CoreBaseInfo)this.company.getBaseExchangeTable())) {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"NoExchangeTable"));
            SysUtil.abort();
        }
        try {
            List lst = RptCashFlowFacadeFactory.getRemoteInstance().getFundFlowInfoList(this.company, filterParam.getBizDateFrom(), filterParam.getBizDateTo());
            this.handler.fillData(lst);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            MsgBox.showInfo((String)e.getMessage());
            SysUtil.abort();
        }
        this.handler.endDataFill();
    }

    private void initLableValue() throws BOSException {
        this.txtDateFrom.setText(this.filterUI.pkDateFrom.getText());
        this.txtDateTo.setText(this.filterUI.pkDateTo.getText());
        if (this.company == null) {
            this.company = (CompanyOrgUnitInfo)this.filterUI.prmtCompany.getValue();
        }
        try {
            CurrencyInfo baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.company.getBaseCurrency().getId().toString()));
            this.txtCurrency.setText(baseCurrency.getName());
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        this.txtCompany.setText(this.company.getName());
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new RptCashFlow4SingleFilterUI();
        }
        return this.filterUI;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.tblMain.getColumn("fundFlowItem").setRenderer((IBasicRender)this.treeRender);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.initLableValue();
        this.tblMain.getColumn("fundFlowItem").setRenderer((IBasicRender)this.treeRender);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        KDTable kdt = new KDTable();
        this.initHead(kdt);
        this.nameExpandSerival(kdt);
        ExportExcelHelper helper = new ExportExcelHelper((CoreUI)this, kdt);
        helper.createExportConfigUI();
    }

    private void nameExpandSerival(KDTable kdt) {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = kdt.addRow();
            IRow srcRow = this.tblMain.getRow(i);
            for (int j = 0; j < this.tblMain.getColumnCount(); ++j) {
                Object v = srcRow.getCell(j).getValue();
                if (v instanceof NameExpandInfo) {
                    row.getCell(j).setValue((Object)((NameExpandInfo)v).getName());
                    continue;
                }
                row.getCell(j).setValue(v);
            }
        }
    }

    private void initHead(KDTable kdt) {
        for (int j = 0; j < this.tblMain.getColumnCount(); ++j) {
            IColumn srcColumn = this.tblMain.getColumn(j);
            IColumn headColumn = kdt.addColumn();
            headColumn.setKey(srcColumn.getKey());
            headColumn.setWidth(srcColumn.getWidth());
            headColumn.setStyleAttributes(srcColumn.getStyleAttributes());
        }
        for (int i = 0; i < this.tblMain.getHeadRowCount(); ++i) {
            IRow srcHead = this.tblMain.getHeadRow(i);
            IRow headRow = kdt.addHeadRow();
            for (int j = 0; j < this.tblMain.getColumnCount(); ++j) {
                headRow.getCell(j).setValue(srcHead.getCell(j).getValue());
            }
        }
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int start = e.getFirstRow();
                int end = e.getLastRow();
            }
        });
    }

    private void setTreeDisplayStyle(int start, int end) {
        int count = end;
        for (int i = start; i < count; ++i) {
            IRow row = this.tblMain.getRow(i);
            String id = (String)row.getCell("id").getValue();
            int level = (Integer)row.getCell("level").getValue();
            Object longNumber = row.getCell("longNumber").getValue();
            Object number = row.getCell("fundFlowItem").getValue();
            if (!(number instanceof String) || !(longNumber instanceof String)) {
                return;
            }
            boolean isFpItemLeaf = (Boolean)row.getCell("isLeaf").getValue();
            NameExpandInfo fpItemNumberExpandInfo = new NameExpandInfo();
            fpItemNumberExpandInfo.setFpItemId(id);
            fpItemNumberExpandInfo.setLevel(level);
            fpItemNumberExpandInfo.setLeaf(isFpItemLeaf);
            fpItemNumberExpandInfo.setExpandStatus(true);
            fpItemNumberExpandInfo.setName(number.toString());
            fpItemNumberExpandInfo.setLongNumber(longNumber.toString());
            row.getCell("fundFlowItem").setValue((Object)fpItemNumberExpandInfo);
        }
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        KDTable kdt = new KDTable();
        this.initHead(kdt);
        this.nameExpandSerival(kdt);
        this.preparePrintPage(kdt);
        Component component = (Component)e.getSource();
        kdt.getPrintManager().setParent(component);
        kdt.getPrintManager().print();
    }

    public void actionPrintPre_actionPerformed(ActionEvent e) throws Exception {
        KDTable kdt = new KDTable();
        this.initHead(kdt);
        this.nameExpandSerival(kdt);
        this.preparePrintPage(kdt);
        Component component = (Component)e.getSource();
        kdt.getPrintManager().setParent(component);
        kdt.getPrintManager().printPreview();
    }
}

