/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.mnt.MerageUnitTreeFactory;
import com.kingdee.eas.fm.mnt.MerageUnitTreeInfo;
import com.kingdee.eas.fm.mnt.client.AbstractRptCashFlowFilterUI;
import com.kingdee.eas.fm.mnt.client.RptCashFlowFilterParam;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import org.apache.log4j.Logger;

public class RptCashFlowFilterUI
extends AbstractRptCashFlowFilterUI {
    private static final long serialVersionUID = 4672300232202885878L;
    private static final Logger logger = CoreUIObject.getLogger(RptCashFlowFilterUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void init() throws Exception {
        super.init();
        this.btnCompanySelect.setVisible(false);
        this.dpBegin.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.dpEnd.setValue((Object)DateUtil.getDayBegin());
        this.chkIsQueryDetial.setSelected(false);
        this.prmtMergeScope.setValue(null);
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.companyIds = null;
        }
    }

    public void clear() {
        super.clear();
        try {
            this.init();
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.handUIException(e);
        }
    }

    public boolean verify() {
        super.verify();
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.dpBegin);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.dpEnd);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtMergeScope);
        Date dateFrom = DateTimeUtils.truncateDate((Date)((Date)this.dpBegin.getValue()));
        Date dateTo = DateTimeUtils.truncateDate((Date)((Date)this.dpEnd.getValue()));
        ClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (Date)dateFrom, (Date)dateTo);
        return true;
    }

    public Object getParam() {
        RptCashFlowFilterParam filterParam = new RptCashFlowFilterParam();
        filterParam.setStartDate(this.dpBegin.getSqlDate());
        filterParam.setEndDate(this.dpEnd.getSqlDate());
        filterParam.setMergeUnitTreeId(((MerageUnitTreeInfo)this.prmtMergeScope.getData()).getId().toString());
        filterParam.setQueryDetail(this.chkIsQueryDetial.isSelected());
        return filterParam;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        RptCashFlowFilterParam filterParam = (RptCashFlowFilterParam)((Object)param);
        this.dpBegin.setValue((Object)filterParam.getStartDate());
        this.dpEnd.setValue((Object)filterParam.getEndDate());
        if (filterParam.getMergeUnitTreeId() != null) {
            try {
                MerageUnitTreeInfo minfo = MerageUnitTreeFactory.getRemoteInstance().getMerageUnitTreeInfo((IObjectPK)new ObjectUuidPK(filterParam.getMergeUnitTreeId().toString()));
                this.prmtMergeScope.setValue((Object)minfo);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        this.chkIsQueryDetial.setSelected(filterParam.isQueryDetail());
    }

    protected Class getParamClass() {
        return RptCashFlowFilterParam.class;
    }
}

