/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMRptClientUtils;
import com.kingdee.eas.fm.common.client.IFMDetailRptHandler;
import com.kingdee.eas.fm.mnt.cashflowreport.dataset.CashReportJavaDataSet;
import com.kingdee.eas.fm.mnt.client.RptCashFlowFilterParam;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RptCashFlowHandler
implements IFMDetailRptHandler {
    protected KDTable kdt;
    protected int queryType;
    protected RptCashFlowFilterParam filterParam;
    protected IRowSet rowSet;
    private static final String[] hideColArr = new String[]{"fid", "pid", "gpid", "ggpid", "ggpname", "fdirection"};
    public static final String resourcePath = "com.kingdee.eas.fm.mnt.RptCashFlowResource";
    private static final String PNAME = "PNAME";
    private static final String GPNAME = "GPNAME";
    private static final String FNUMBER = "FNUMBER";
    private static final String FUNDNAME = "FUNDNAME";
    private List groupCol = new ArrayList();

    protected RptCashFlowHandler(KDTable kdt, RptCashFlowFilterParam filterParam) {
        this.kdt = kdt;
        this.filterParam = filterParam;
    }

    private void clearTableStruct() {
        this.kdt.removeRows();
        this.kdt.removeColumns();
        this.kdt.getGroupManager().removeGroup();
        this.kdt.getGroupManager().reInitialize();
        this.kdt.checkParsed(true);
        this.kdt.getSelectManager().setSelectMode(2);
        this.kdt.setEditable(false);
        this.kdt.getGroupManager().setGroup(true);
        this.kdt.setRefresh(false);
        this.kdt.getGroupManager().setOrientation(1);
    }

    public void initHeader() {
        this.clearTableStruct();
        IColumn col = null;
        if (this.rowSet != null) {
            try {
                int colCount = this.rowSet.getMetaData().getColumnCount();
                IRow headRow = this.kdt.addHeadRow();
                String colKey = null;
                int precisionLocalCurrency = 2;
                for (int i = 0; i < colCount; ++i) {
                    colKey = this.rowSet.getMetaData().getColumnName(i + 1);
                    col = this.kdt.addColumn();
                    col.setKey(colKey);
                    headRow.getCell(colKey).setValue((Object)this.rowSet.getMetaData().getColumnName(i + 1));
                    this.setGroupCol(colKey, col);
                    boolean isHideCol = this.setHideColAndWidth(colKey, col, 150);
                    this.formatterCol(headRow, colKey, col, isHideCol, precisionLocalCurrency);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void formatterCol(IRow headRow, String colKey, IColumn col, boolean isHideCol, int precisionLocalCurrency) {
        if (FNUMBER.equals(colKey) || FUNDNAME.equals(colKey) || PNAME.equals(colKey) || GPNAME.equals(colKey)) {
            headRow.getCell(colKey).setValue((Object)EASResource.getString((String)resourcePath, (String)("RptCashFlowHandler_" + colKey)));
        } else if (!isHideCol) {
            col.getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)precisionLocalCurrency));
            col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    private boolean setHideColAndWidth(String colKey, IColumn col, int colWidth) {
        boolean isHideCol = false;
        for (int j = 0; j < hideColArr.length; ++j) {
            if (!colKey.equalsIgnoreCase(hideColArr[j])) continue;
            isHideCol = true;
            break;
        }
        if (isHideCol) {
            col.getStyleAttributes().setHided(true);
        } else {
            col.setWidth(colWidth);
        }
        return isHideCol;
    }

    private void setGroupCol(String colKey, IColumn col) {
        boolean isGroup = true;
        for (int i = 0; i < hideColArr.length; ++i) {
            if (hideColArr[i].equalsIgnoreCase(colKey)) {
                isGroup = false;
                break;
            }
            if (!FNUMBER.equals(colKey) && !FUNDNAME.equals(colKey)) continue;
            isGroup = false;
            break;
        }
        if (isGroup) {
            col.setGroup(true);
            this.groupCol.add(colKey);
        } else {
            col.setGroup(false);
        }
    }

    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        String colName = null;
        while (rs.next()) {
            IRow row = this.kdt.addRow();
            row.setUserObject((Object)rs.getString("FId"));
            int colCount = rs.getMetaData().getColumnCount();
            for (int i = 0; i < colCount; ++i) {
                colName = rs.getMetaData().getColumnName(i + 1);
                row.getCell(colName).setValue(rs.getObject(colName));
            }
        }
    }

    public void setTableStateRow() {
        this.kdt.getColumn(GPNAME).setStat(true);
        this.kdt.getColumn(PNAME).setStat(true);
        this.kdt.getGroupManager().setTotalize(true);
        IRow rowPNAME = this.kdt.getGroupManager().getStatRowTemplate(1);
        for (int i = 0; i < this.groupCol.size(); ++i) {
            rowPNAME.getCell(this.groupCol.get(i).toString()).setExpressions("SUM");
        }
        rowPNAME.getStyleAttributes().setBackground(new Color(16119270));
        IRow rowGPNAME = this.kdt.getGroupManager().getStatRowTemplate(0);
        for (int i = 0; i < this.groupCol.size(); ++i) {
            rowGPNAME.getCell(this.groupCol.get(i).toString()).setExpressions("SUM");
        }
        rowGPNAME.getStyleAttributes().setBackground(new Color(16119270));
        IRow rowTotal = this.kdt.getGroupManager().getStatRowTemplate(-1);
        for (int i = 0; i < this.groupCol.size(); ++i) {
            rowTotal.getCell(this.groupCol.get(i).toString()).setExpressions("SUM");
        }
        rowTotal.getStyleAttributes().setBackground(new Color(16119270));
        rowPNAME.getCell(PNAME).setValue((Object)FMRptClientUtils.getSumTotalResString());
        rowGPNAME.getCell(GPNAME).setValue((Object)FMRptClientUtils.getTotalResString());
        rowGPNAME.getCell(PNAME).setValue((Object)"");
        rowTotal.getCell(GPNAME).setValue((Object)FMRptClientUtils.getTotalResString());
        rowTotal.getCell(PNAME).setValue((Object)"");
    }

    protected static void initDecimalCell(ICell cell) {
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        cell.getStyleAttributes().setNumberFormat("##,###,###,###,###,##0.00");
    }

    public void endDataFill() {
        this.kdt.setRefresh(true);
        this.kdt.repaint();
        this.kdt.getGroupManager().group();
        this.kdt.getGroupManager().setGroup(false);
    }

    public IRowSet getRowSet() throws BOSException {
        try {
            CashReportJavaDataSet dataSet = new CashReportJavaDataSet();
            HashMap<String, RptCashFlowFilterParam> filterParamMap = new HashMap<String, RptCashFlowFilterParam>();
            filterParamMap.put("filterParam", this.filterParam);
            dataSet.setFilterParam(filterParamMap);
            IRowSet[] rsArr = dataSet.getCustomRowSet(null, null);
            this.rowSet = rsArr[0];
            return rsArr[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

