/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.mnt.MerageUnitTreeFactory;
import com.kingdee.eas.fm.mnt.MerageUnitTreeInfo;
import com.kingdee.eas.fm.mnt.RptCashFlowFacadeFactory;
import com.kingdee.eas.fm.mnt.client.AbstractRptCashFlowListUI;
import com.kingdee.eas.fm.mnt.client.FundFlowItemTreeRender;
import com.kingdee.eas.fm.mnt.client.RptCashFlowFilterParam;
import com.kingdee.eas.fm.mnt.client.RptCashFlowFilterUI;
import com.kingdee.eas.fm.mnt.client.RptCashFlowListUIHandler;
import com.kingdee.eas.fm.mnt.utils.MNTUtils;
import com.kingdee.eas.fm.mnt.vo.NameExpandInfo;
import com.kingdee.eas.framework.bireport.util.BirtUtils;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.exportexcel.ExportExcelHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptCashFlowListUI
extends AbstractRptCashFlowListUI {
    private static final long serialVersionUID = -174059073139998834L;
    private static final Logger logger = CoreUIObject.getLogger(RptCashFlowListUI.class);
    private RptCashFlowFilterUI filterUI;
    private RptCashFlowListUIHandler handler = null;
    private FundFlowItemTreeRender treeRender;
    private MerageUnitTreeInfo treeInfo;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtDateFrom.setText(this.filterUI.dpBegin.getText());
        this.txtDateTo.setText(this.filterUI.dpEnd.getText());
        CurrencyInfo baseCurrency = null;
        if (this.treeInfo == null) {
            this.treeInfo = (MerageUnitTreeInfo)this.filterUI.prmtMergeScope.getValue();
            baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.treeInfo.getMergeCurrency().getId().toString()));
        } else {
            baseCurrency = this.treeInfo.getMergeCurrency();
        }
        this.txtCurrency.setText(baseCurrency.getName());
        this.txtMergeScope.setText(this.treeInfo.getName());
        this.treeRender = new FundFlowItemTreeRender();
        this.tblMain.getColumn("fundFlowItem").setRenderer((IBasicRender)this.treeRender);
        this.tblMain.getViewManager().freeze(-1, 1);
    }

    protected void execQuery() throws BOSException {
        RptCashFlowFilterParam filterParam = (RptCashFlowFilterParam)this.getFilterParam();
        if (filterParam == null) {
            return;
        }
        this.handler = new RptCashFlowListUIHandler(this.tblMain, filterParam);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("mergeCurrency.id"));
        sic.add(new SelectorItemInfo("mergeCurrency.name"));
        sic.add(new SelectorItemInfo("rptConvertExaTable.id"));
        CurrencyInfo baseCurrency = null;
        try {
            this.treeInfo = MerageUnitTreeFactory.getRemoteInstance().getMerageUnitTreeInfo((IObjectPK)new ObjectUuidPK(filterParam.getMergeUnitTreeId()), sic);
            baseCurrency = this.treeInfo.getMergeCurrency();
            this.txtDateFrom.setText(this.filterUI.dpBegin.getText());
            this.txtDateTo.setText(this.filterUI.dpEnd.getText());
            this.txtCurrency.setText(baseCurrency.getName());
            this.txtMergeScope.setText(this.treeInfo.getName());
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            this.handUIException(e);
        }
        String baseCurrencyID = this.treeInfo.getMergeCurrency().getId().toString();
        String orgIds = null;
        try {
            Set<String> idSet = MNTUtils.getMergeOrgID(null, filterParam.getMergeUnitTreeId(), null);
            orgIds = BirtUtils.idListToInClause(idSet);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            this.handUIException(e);
        }
        this.handler.initHeader(this.treeInfo, orgIds, baseCurrencyID);
        try {
            List lst = RptCashFlowFacadeFactory.getRemoteInstance().getMergeFundFlowList(this.treeInfo, orgIds, filterParam.getStartDate(), filterParam.getEndDate());
            this.handler.fillData(lst, orgIds);
        }
        catch (EASBizException e) {
            MsgBox.showInfo((String)e.getMessage());
            SysUtil.abort();
        }
        this.handler.endDataFill();
        this.tblMain.getViewManager().freeze(-1, 1);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new RptCashFlowFilterUI();
        }
        return this.filterUI;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.tblMain.getColumn("fundFlowItem").setRenderer((IBasicRender)this.treeRender);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.tblMain.getColumn("fundFlowItem").setRenderer((IBasicRender)this.treeRender);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        KDTable kdt = new KDTable();
        this.initHead(kdt);
        this.nameExpandSerival(kdt);
        ExportExcelHelper helper = new ExportExcelHelper((CoreUI)this, kdt);
        helper.createExportConfigUI();
    }

    private void initHead(KDTable kdt) {
        for (int j = 0; j < this.tblMain.getColumnCount(); ++j) {
            IColumn srcColumn = this.tblMain.getColumn(j);
            IColumn headColumn = kdt.addColumn();
            headColumn.setKey(srcColumn.getKey());
            headColumn.setWidth(srcColumn.getWidth());
            headColumn.setStyleAttributes(srcColumn.getStyleAttributes());
        }
        for (int i = 0; i < this.tblMain.getHeadRowCount(); ++i) {
            IRow srcHead = this.tblMain.getHeadRow(i);
            IRow headRow = kdt.addHeadRow();
            for (int j = 0; j < this.tblMain.getColumnCount(); ++j) {
                headRow.getCell(j).setValue(srcHead.getCell(j).getValue());
            }
        }
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        KDTable kdt = new KDTable();
        this.initHead(kdt);
        this.nameExpandSerival(kdt);
        this.preparePrintPage(kdt);
        Component component = (Component)e.getSource();
        kdt.getPrintManager().setParent(component);
        kdt.getPrintManager().print();
    }

    public void actionPrintPre_actionPerformed(ActionEvent e) throws Exception {
        KDTable kdt = new KDTable();
        this.initHead(kdt);
        this.nameExpandSerival(kdt);
        this.preparePrintPage(kdt);
        Component component = (Component)e.getSource();
        kdt.getPrintManager().setParent(component);
        kdt.getPrintManager().printPreview();
    }

    private void nameExpandSerival(KDTable kdt) {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = kdt.addRow();
            IRow srcRow = this.tblMain.getRow(i);
            for (int j = 0; j < this.tblMain.getColumnCount(); ++j) {
                Object v = srcRow.getCell(j).getValue();
                if (v instanceof NameExpandInfo) {
                    row.getCell(j).setValue((Object)((NameExpandInfo)v).getName());
                    continue;
                }
                row.getCell(j).setValue(v);
            }
        }
    }
}

