/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.IRptHandler;
import com.kingdee.eas.fm.mnt.MerageUnitTreeInfo;
import com.kingdee.eas.fm.mnt.client.RptCashFlowFilterParam;
import com.kingdee.eas.fm.mnt.vo.CompanyFundFlowInfo;
import com.kingdee.eas.fm.mnt.vo.MergeFundFlowInfo;
import com.kingdee.eas.fm.mnt.vo.NameExpandInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class RptCashFlowListUIHandler
implements IRptHandler {
    protected KDTable kdt;
    protected RptCashFlowFilterParam filterParam;
    private static final String RES = "com.kingdee.eas.fm.mnt.ReportResource";

    public RptCashFlowListUIHandler(KDTable kdt, RptCashFlowFilterParam filterParam) {
        this.kdt = kdt;
        this.filterParam = filterParam;
    }

    public void initHeader(MerageUnitTreeInfo treeInfo, String inClause, String baseCurrencyID) throws BOSException {
        this.kdt.checkParsed();
        this.kdt.removeRows();
        this.kdt.removeColumns();
        this.kdt.removeHeadRows();
        this.kdt.getStyleAttributes().setLocked(true);
        List<CompanyFundFlowInfo> nameLst = this.getCompanyNameMap(inClause);
        this.initColumn(this.kdt, baseCurrencyID, nameLst);
        this.initHead(this.kdt, nameLst);
    }

    private List<CompanyFundFlowInfo> getCompanyNameMap(String inClause) throws BOSException {
        ArrayList<CompanyFundFlowInfo> lst = new ArrayList<CompanyFundFlowInfo>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select FID, FName_l2 from T_Org_Company where FID IN (" + inClause + ") ");
        sql.append(" order by FLongNumber ");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        try {
            while (rs.next()) {
                CompanyFundFlowInfo info = new CompanyFundFlowInfo();
                info.setCompanyID(rs.getString("FID"));
                info.setCompanyName(rs.getString("FName_l2"));
                lst.add(info);
            }
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        return lst;
    }

    private void initHead(KDTable kdt, List<CompanyFundFlowInfo> nameLst) {
        IRow headRow = kdt.addHeadRow();
        headRow.getCell("fundFlowItem").setValue((Object)EASResource.getString((String)RES, (String)"FundFlowItemTitle"));
        headRow.getCell("summaryAmt").setValue((Object)EASResource.getString((String)RES, (String)"SummaryAmtTitle"));
        headRow.getCell("elimWithinAmt").setValue((Object)EASResource.getString((String)RES, (String)"ElimWithinAmtTitle"));
        headRow.getCell("withinSumAmt").setValue((Object)EASResource.getString((String)RES, (String)"WithinSumAmtTitle"));
        headRow.getCell("elimOutsideAmt").setValue((Object)EASResource.getString((String)RES, (String)"ElimOutsideAmtTitle"));
        headRow.getCell("outsideSumAmt").setValue((Object)EASResource.getString((String)RES, (String)"OutsideSumAmtTitle"));
        for (CompanyFundFlowInfo info : nameLst) {
            headRow.getCell(info.getCompanyID()).setValue((Object)info.getCompanyName());
        }
    }

    private void initColumn(KDTable kdt, String baseCurrencyId, List<CompanyFundFlowInfo> nameLst) {
        IColumn colFundFlowItem = kdt.addColumn();
        colFundFlowItem.setKey("fundFlowItem");
        colFundFlowItem.setWidth(520);
        colFundFlowItem.getStyleAttributes().setBackground(new Color(16119270));
        IColumn colSumAmt = kdt.addColumn();
        colSumAmt.setKey("summaryAmt");
        colSumAmt.setWidth(180);
        this.setCurrencyColumnFmt(colSumAmt, baseCurrencyId);
        IColumn colElimWithinAmt = kdt.addColumn();
        colElimWithinAmt.setKey("elimWithinAmt");
        colElimWithinAmt.setWidth(180);
        this.setCurrencyColumnFmt(colElimWithinAmt, baseCurrencyId);
        IColumn colWithinSumAmt = kdt.addColumn();
        colWithinSumAmt.setKey("withinSumAmt");
        colWithinSumAmt.setWidth(180);
        this.setCurrencyColumnFmt(colWithinSumAmt, baseCurrencyId);
        IColumn colElimOutsideAmt = kdt.addColumn();
        colElimOutsideAmt.setKey("elimOutsideAmt");
        colElimOutsideAmt.setWidth(180);
        this.setCurrencyColumnFmt(colElimOutsideAmt, baseCurrencyId);
        IColumn colOutsideSumAmt = kdt.addColumn();
        colOutsideSumAmt.setKey("outsideSumAmt");
        colOutsideSumAmt.setWidth(180);
        this.setCurrencyColumnFmt(colOutsideSumAmt, baseCurrencyId);
        for (CompanyFundFlowInfo info : nameLst) {
            IColumn colAmt = kdt.addColumn();
            colAmt.setKey(info.getCompanyID());
            this.setCurrencyColumnFmt(colAmt, baseCurrencyId);
            if (this.filterParam.isQueryDetail()) {
                colAmt.getStyleAttributes().setHided(false);
                continue;
            }
            colAmt.getStyleAttributes().setHided(true);
        }
    }

    private void setCurrencyColumnFmt(IColumn column, String currencyId) {
        String numberFtm = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)currencyId));
        column.getStyleAttributes().setNumberFormat(numberFtm);
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public void fillData(List<MergeFundFlowInfo> lst, String inClause) throws BOSException {
        HashSet<String> orgIdSet = new HashSet<String>();
        if (inClause != null && inClause.length() > 0) {
            String[] orgIds;
            for (String id : orgIds = inClause.replace("\b", "").replace("'", "").split(",")) {
                orgIdSet.add(id.trim());
            }
        }
        for (MergeFundFlowInfo info : lst) {
            IRow row = this.kdt.addRow();
            row.setUserObject((Object)info.getFundFlowItemID());
            this.setTreeDisplayStyle(row, info);
            if (info.getSummaryAmt() != null) {
                row.getCell("summaryAmt").setValue((Object)info.getSummaryAmt());
            } else {
                row.getCell("summaryAmt").setValue((Object)BigDecimal.ZERO);
            }
            if (info.getElimWithinAmt() != null) {
                row.getCell("elimWithinAmt").setValue((Object)info.getElimWithinAmt());
            } else {
                row.getCell("elimWithinAmt").setValue((Object)BigDecimal.ZERO);
            }
            if (info.getSummaryAmt() != null && info.getElimWithinAmt() != null) {
                row.getCell("withinSumAmt").setValue((Object)info.getSummaryAmt().subtract(info.getElimWithinAmt()));
            } else if (info.getSummaryAmt() == null && info.getElimWithinAmt() != null) {
                row.getCell("withinSumAmt").setValue((Object)BigDecimal.ZERO.subtract(info.getElimWithinAmt()));
            } else if (info.getSummaryAmt() != null && info.getElimWithinAmt() == null) {
                row.getCell("withinSumAmt").setValue((Object)info.getSummaryAmt());
            } else {
                row.getCell("withinSumAmt").setValue((Object)BigDecimal.ZERO);
            }
            if (info.getElimOutsideAmt() != null) {
                row.getCell("elimOutsideAmt").setValue((Object)info.getElimOutsideAmt());
            } else {
                row.getCell("elimOutsideAmt").setValue((Object)BigDecimal.ZERO);
            }
            BigDecimal summaryAmt = info.getSummaryAmt() != null ? info.getSummaryAmt() : BigDecimal.ZERO;
            BigDecimal elimOutsideAmt = info.getElimOutsideAmt() != null ? info.getElimOutsideAmt() : BigDecimal.ZERO;
            BigDecimal elimWithinAmt = info.getElimWithinAmt() != null ? info.getElimWithinAmt() : BigDecimal.ZERO;
            row.getCell("outsideSumAmt").setValue((Object)summaryAmt.subtract(elimWithinAmt).subtract(elimOutsideAmt));
            if (orgIdSet.size() <= 0) continue;
            HashMap<String, CompanyFundFlowInfo> comMap = new HashMap<String, CompanyFundFlowInfo>();
            if (info.getCompAmtList() != null) {
                for (CompanyFundFlowInfo cInfo : info.getCompAmtList()) {
                    comMap.put(cInfo.getCompanyID(), cInfo);
                }
            }
            for (String id : orgIdSet) {
                if (comMap.containsKey(id)) {
                    CompanyFundFlowInfo cInfo = (CompanyFundFlowInfo)comMap.get(id);
                    if (cInfo.getActAmt() != null) {
                        row.getCell(cInfo.getCompanyID()).setValue((Object)cInfo.getActAmt());
                        continue;
                    }
                    row.getCell(cInfo.getCompanyID()).setValue((Object)BigDecimal.ZERO);
                    continue;
                }
                row.getCell(id).setValue((Object)BigDecimal.ZERO);
            }
        }
    }

    private void setTreeDisplayStyle(IRow row, MergeFundFlowInfo info) {
        String id = info.getFundFlowItemID();
        int level = info.getLevel();
        String longNumber = info.getLongNumber();
        NameExpandInfo fpItemNumberExpandInfo = new NameExpandInfo();
        fpItemNumberExpandInfo.setFpItemId(id);
        fpItemNumberExpandInfo.setLevel(level);
        fpItemNumberExpandInfo.setLeaf(info.isIsLeaf());
        fpItemNumberExpandInfo.setExpandStatus(true);
        fpItemNumberExpandInfo.setName(info.getNumber() + " " + info.getName());
        fpItemNumberExpandInfo.setLongNumber(longNumber.toString());
        row.getCell("fundFlowItem").setValue((Object)fpItemNumberExpandInfo);
    }

    public void endDataFill() {
        this.kdt.setRefresh(true);
        this.kdt.repaint();
        this.kdt.getGroupManager().group();
        this.kdt.getGroupManager().setGroup(false);
    }
}

