/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.util.RptFmClientUtil;
import com.kingdee.eas.fm.mnt.client.AbstractRptCurrencyFundGGFilterUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JScrollBar;
import org.apache.log4j.Logger;

public class RptCurrencyFundGGFilterUI
extends AbstractRptCurrencyFundGGFilterUI
implements RptFmClientUtil.SelectCompanyListener {
    private static final Logger logger = CoreUIObject.getLogger(RptCurrencyFundGGFilterUI.class);
    private Set bankIdSet = null;

    public RptCurrencyFundGGFilterUI() throws Exception {
        ButtonGroup bg = new ButtonGroup();
        bg.add((AbstractButton)this.jrbBank);
        bg.add((AbstractButton)this.jrbCompany);
        this.jrbCompany.setSelected(true);
        this.tbl.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
        this.tbl.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        this.tbl.checkParsed();
        this.tbl.getColumn(1).getStyleAttributes().setLocked(true);
        this.tbl.getColumn(2).getStyleAttributes().setLocked(true);
        F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)this.jbpBank);
        this.txtAmtFrom.setPrecision(2);
        this.txtAmtFrom.setSupportedEmpty(true);
        this.txtAmtTo.setPrecision(2);
        this.txtAmtTo.setSupportedEmpty(true);
    }

    public boolean verify() {
        if (!super.verify()) {
            return false;
        }
        if (!((Boolean)this.tbl.getCell(0, 0).getValue()).booleanValue()) {
            MsgBox.showInfo((Component)this.tbl, (String)(EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"497_RptCurrencyFundGGFilterUI") + this.tbl.getCell(0, 1).getValue() + "\"" + EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"498_RptCurrencyFundGGFilterUI")));
            return false;
        }
        if (this.txtAmtFrom.getValue() != null && this.txtAmtTo.getValue() != null && this.txtAmtFrom.getBigDecimalValue().compareTo(this.txtAmtTo.getBigDecimalValue()) > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"435_ImportCapitalFlowDetailFilterUI"));
            SysUtil.abort();
        }
        if (this.jdDate.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"501_RptFinancingCostInteAnalyseFilterUI"));
            SysUtil.abort();
        }
        return true;
    }

    public void onInit(RptParams initParams) throws Exception {
        CurrencyInfo c;
        super.onInit(initParams);
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        this.jbpBank.setDisplayFormat("$name$");
        this.jbpBank.setEditFormat("$number$");
        this.jbpBank.setEnabledMultiSelection(true);
        this.jbpBank.setEditable(true);
        this.jbpBank.setCommitFormat("$number$");
        this.jbpBank.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7BankQuery");
        this.jbpBank.setData(null);
        this.jtAmountUnit.setSelectedItem((Object)AmountUnitEnum.wan_yuan);
        this.txtAmtFrom.setValue(null);
        this.txtAmtTo.setValue(null);
        String baseId = company.getBaseCurrency().getId().toString();
        CurrencyCollection cc = CurrencyFactory.getRemoteInstance().getCurrencyCollection(true);
        int n = cc.size();
        for (int i = 0; i < n; ++i) {
            c = cc.get(i);
            if (!c.getId().toString().equals(baseId)) continue;
            c.put("base", (Object)Boolean.TRUE);
            cc.removeObject(i);
            cc.addObject(0, (IObjectValue)c);
            break;
        }
        this.tbl.setRefresh(false);
        this.tbl.removeRows(false);
        int n2 = cc.size();
        for (int i = 0; i < n2; ++i) {
            c = cc.get(i);
            IRow row = this.tbl.addRow();
            row.getCell(0).setValue((Object)(c.get("base") == null ? Boolean.FALSE : Boolean.TRUE));
            row.getCell(1).setValue((Object)c);
            row.getCell(2).setValue((Object)c.getIsoCode());
        }
        this.tbl.setRefresh(true);
        this.jrbCompany.setSelected(true);
    }

    public RptParams getCustomCondition() {
        RptConditionManager rm = new RptConditionManager();
        rm.recordAllStatus((Container)((Object)this));
        rm.setProperty("companyIdSet", (Object)this.companyIdSet);
        this.bankIdSet = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.jbpBank));
        rm.setProperty("bankIdSet", (Object)this.bankIdSet);
        rm.setProperty("txtAmtFrom1", (Object)this.txtAmtFrom.getBigDecimalValue());
        rm.setProperty("txtAmtTo1", (Object)this.txtAmtTo.getBigDecimalValue());
        rm.setProperty("RateCurrencySet", (Object)this.getIdSetFromF7(this.prmtCurrency));
        return rm.toRptParams();
    }

    public void setCustomCondition(RptParams params) {
        RptConditionManager rm = new RptConditionManager(params);
        rm.restoreAllStatus((Container)((Object)this));
        this.companyIdSet = (Set)params.getObject("companyIdSet");
        try {
            this.bankIdSet = (Set)params.getObject("bankIdSet");
            CoreBaseInfo[] c = RptFmClientUtil.getBaseInfoFromIdSet((Set)this.bankIdSet);
            this.jbpBank.setData((Object)c);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (this.jtAmountUnit.getSelectedItem() == null) {
            this.jtAmountUnit.setSelectedItem((Object)AmountUnitEnum.wan_yuan);
        }
    }

    @Override
    protected void kdtHistory_itemStateChanged(ItemEvent e) throws Exception {
        if (this.kdtHistory.isSelected()) {
            this.prmtCurrency.setEnabled(false);
            this.prmtCurrency.setData(null);
        }
    }

    @Override
    protected void kdtCurrent_itemStateChanged(ItemEvent e) throws Exception {
        if (this.kdtCurrent.isSelected()) {
            this.prmtCurrency.setEnabled(true);
            BOSUuid id = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getBaseCurrency().getId();
            CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(id));
            this.prmtCurrency.setData((Object)currency);
        }
    }
}

