/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.client.FMDetailRptBaseHandler;
import com.kingdee.eas.fm.common.client.FMRptClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class RptFBFlowDetailBaseHandler
extends FMDetailRptBaseHandler {
    public static final String resourcePath = "com.kingdee.eas.fm.mnt.client.RptFBFlowResource";
    protected BigDecimal amountUnit = null;
    protected BigDecimal realFlow = null;

    protected String getResString(String key) {
        return EASResource.getString((String)resourcePath, (String)key);
    }

    public RptFBFlowDetailBaseHandler(FilterInfo filterInfo, KDTable kdt, AmountUnitEnum uni) {
        super(filterInfo, kdt);
        this.amountUnit = new BigDecimal(String.valueOf(uni.getValue()));
    }

    public RptFBFlowDetailBaseHandler(FilterInfo filterInfo, SorterItemCollection sorter, KDTable kdt, AmountUnitEnum uni) {
        super(filterInfo, sorter, kdt);
        this.amountUnit = new BigDecimal(String.valueOf(uni.getValue()));
    }

    protected String getQueryPath() {
        return "com.kingdee.eas.fm.mnt.app.RptFBFlowDetailQuery";
    }

    public void initHeader() {
        super.initHeader();
        this.insertHeadRow();
        this.formatHeadRow();
    }

    protected abstract void insertHeadRow();

    protected void formatHeadRow() {
        IRow headRow = this.kdt.addHeadRow();
        headRow.getCell("isInFlow").setValue((Object)this.getResString("isInFlow"));
        headRow.getCell("company").setValue((Object)this.getResString("company"));
        headRow.getCell("expectedDate").setValue((Object)this.getResString("expectedDate"));
        headRow.getCell("blockFlowType").setValue((Object)this.getResString("blockFlowType"));
        headRow.getCell("description").setValue((Object)this.getResString("description"));
        headRow.getCell("counterPart").setValue((Object)this.getResString("counterPart"));
        headRow.getCell("currency").setValue((Object)this.getResString("currency"));
        headRow.getCell("amount").setValue((Object)this.getResString("amount"));
        headRow.getCell("localAmount").setValue((Object)this.getResString("localAmount"));
    }

    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        this.realFlow = SysConstant.BIGZERO;
        while (rs.next()) {
            IRow row = this.kdt.addRow();
            String isInFlow = rs.getString("IsInFlow");
            BigDecimal localAmount = rs.getBigDecimal("localAmount");
            this.realFlow = isInFlow.equals("true") ? this.realFlow.add(localAmount) : this.realFlow.subtract(localAmount);
            row.getCell("isInFlow").setValue((Object)isInFlow);
            row.getCell("company").setValue((Object)rs.getString("company.name"));
            row.getCell("expectedDate").setValue((Object)rs.getString("ExpectedDate"));
            row.getCell("blockFlowType").setValue((Object)rs.getString("BlockFlowType.name"));
            row.getCell("description").setValue((Object)rs.getString("description"));
            row.getCell("counterPart").setValue((Object)rs.getString("CounterPart"));
            row.getCell("currency").setValue((Object)rs.getString("Currency.name"));
            row.getCell("amount").setValue((Object)rs.getBigDecimal("Amount").divide(this.amountUnit, 10, 4));
            row.getCell("localAmount").setValue((Object)localAmount.divide(this.amountUnit, 10, 4));
            row.setUserObject((Object)rs.getString("id"));
        }
    }

    public void endDataFill() {
        super.endDataFill();
        this.setTotalString();
        this.kdt.getSelectManager().setSelectMode(2);
    }

    private void setTotalString() {
        int n = this.kdt.getRowCount();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            IRow iRow = this.kdt.getRow(i);
            String s = null;
            if (iRow.getCell(0).getValue() != null || iRow.getCell(1).getValue() != null) continue;
            Object isInFlow1 = this.kdt.getRow(i - 1).getCell(0).getValue();
            Object oneCell = this.kdt.getRow(i - 1).getCell(1).getValue();
            if (isInFlow1 != null) {
                iRow.getCell(2).setValue((Object)FMRptClientUtils.getSumTotalResString());
            }
            if (isInFlow1 != null || oneCell != null) continue;
            Object isInFlow2 = this.kdt.getRow(i - 2).getCell(0).getValue();
            if (isInFlow2 != null && isInFlow2.equals("true")) {
                s = EASResource.getString((String)resourcePath, (String)"inFlowTotal");
                iRow.getCell(1).setValue((Object)s);
            }
            if (isInFlow2 == null || !isInFlow2.equals("false")) continue;
            s = EASResource.getString((String)resourcePath, (String)"outFlowTotal");
            iRow.getCell(1).setValue((Object)s);
        }
        IRow row = this.kdt.getRow(n - 1);
        row.getCell(1).setValue((Object)EASResource.getString((String)resourcePath, (String)"realFlowTotal"));
        this.realFlow = this.realFlow.divide(this.amountUnit, 10, 4);
        row.getCell("localAmount").setValue((Object)this.realFlow);
    }

    protected static void initDecimalCol(IColumn col) {
        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        col.getStyleAttributes().setNumberFormat("%r{#,###.00}f");
    }

    protected static void initDecimalCell(ICell cell) {
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        cell.getStyleAttributes().setNumberFormat("%r{#,###.00}f");
    }
}

