/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.mnt.BillTypeEnum;
import com.kingdee.eas.fm.mnt.RptFallInOperationWarnAnalyseFilterParam;
import com.kingdee.eas.fm.mnt.client.IRptFallInOperationWarnAnalyseHandler;
import com.kingdee.eas.framework.report.util.CellMatrix;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.StringEnum;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;

public abstract class RptFallInOperationWarnAnalyseHandlerBase
implements IRptFallInOperationWarnAnalyseHandler {
    public static final String resourcePath = "com.kingdee.eas.fm.mnt.client.FallInOperationWarnAnalyseResource";
    protected RptFallInOperationWarnAnalyseFilterParam filterParam = null;
    protected KDTable kdt = null;
    protected BigDecimal LocalBalanceAmountTotal = SysConstant.BIGZERO;
    protected int amountUnit;

    public RptFallInOperationWarnAnalyseHandlerBase(RptFallInOperationWarnAnalyseFilterParam param, KDTable kdt) {
        this.filterParam = param;
        this.kdt = kdt;
    }

    @Override
    public void initHeader() {
        this.kdt.removeRows();
        this.kdt.removeHeadRows();
        this.kdt.removeColumns();
        this.kdt.getGroupManager().removeGroup();
        this.kdt.setEditable(false);
        this.kdt.getGroupManager().setGroup(true);
        this.kdt.getGroupManager().setOrientation(1);
    }

    protected String getResString(String key) {
        return EASResource.getString((String)resourcePath, (String)key);
    }

    @Override
    public IRowSet getRowSet() throws BOSException {
        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.mnt.app.RptFallInOperationWarnAnalyseQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(this.filterParam.getFilter());
        ev.getSorter().addObjectCollection((IObjectCollection)this.filterParam.getSorterItems());
        exec.setObjectView(ev);
        return exec.executeQuery();
    }

    protected void initHeadRows() {
        IRow headRow = this.kdt.addHeadRow();
        headRow.getCell("TypeID").setValue((Object)this.getResString("TypeID"));
        headRow.getCell("BillName").setValue((Object)this.getResString("BillName"));
        headRow.getCell("BillType").setValue((Object)this.getResString("BillType"));
        headRow.getCell("BillNumber").setValue((Object)this.getResString("BillNumber"));
        headRow.getCell("ExpiredDate").setValue((Object)this.getResString("ExpiredDate"));
        headRow.getCell("ComName").setValue((Object)this.getResString("ComName"));
        headRow.getCell("BankName").setValue((Object)this.getResString("BankName"));
        headRow.getCell("BankAccount").setValue((Object)this.getResString("BankAccount"));
        headRow.getCell("CompanyName").setValue((Object)this.getResString("CompanyName"));
        headRow.getCell("Currency").setValue((Object)this.getResString("Currency"));
        headRow.getCell("BalanceAmount").setValue((Object)this.getResString("BalanceAmount"));
        headRow.getCell("LocalBalanceAmount").setValue((Object)this.getResString("LocalBalanceAmount"));
    }

    @Override
    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        this.amountUnit = this.filterParam.getUnit().getValue();
        this.LocalBalanceAmountTotal = SysConstant.BIGZERO;
        this.kdt.setRefresh(false);
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd");
        while (rs.next()) {
            IRow row = this.kdt.addRow();
            this.LocalBalanceAmountTotal = this.LocalBalanceAmountTotal.add(rs.getBigDecimal("LocalAmount").divide(new BigDecimal(String.valueOf(this.amountUnit)), 10, 4));
            row.getCell("TypeID").setValue((Object)rs.getString("FTypeID"));
            row.getCell("BillName").setValue((Object)BillTypeEnum.getEnum(this.wordsToNumber(rs.getString("BillName"))).getAlias(SysContext.getSysContext().getLocale()));
            String lgTypeName = rs.getString("LGTypeName");
            String lgTypeNames = "";
            lgTypeNames = "timedeposit".equals(lgTypeName) ? this.getResString("timedeposit") : ("timedeposit_outer".equals(lgTypeName) ? this.getResString("timedeposit_outer") : ("calldeposit".equals(lgTypeName) ? this.getResString("calldeposit") : ("calldeposit_outer".equals(lgTypeName) ? this.getResString("else") : rs.getString("LGTypeName"))));
            row.getCell("BillType").setValue((Object)lgTypeNames);
            row.getCell("BillNumber").setValue((Object)rs.getString("LGNumber"));
            try {
                row.getCell("ExpiredDate").setValue((Object)dtformat.format(dt.parse(rs.getString("ExpiredDate"))));
            }
            catch (ParseException e) {
                Logger.error((Throwable)e, (String)e.getMessage());
            }
            row.getCell("CompanyName").setValue((Object)rs.getString("CompanyName"));
            row.getCell("ComName").setValue((Object)rs.getString("ComName"));
            row.getCell("BankName").setValue((Object)rs.getString("InstitutionName"));
            row.getCell("BankAccount").setValue((Object)rs.getString("BankAccount"));
            row.getCell("Currency").setValue((Object)rs.getString("CurrencyName"));
            row.getCell("BalanceAmount").setValue((Object)rs.getBigDecimal("BalanceAmount").divide(new BigDecimal(String.valueOf(this.amountUnit)), 10, 4));
            row.getCell("LocalBalanceAmount").setValue((Object)rs.getBigDecimal("LocalAmount").divide(new BigDecimal(String.valueOf(this.amountUnit)), 10, 4));
            row.setUserObject((Object)rs.getString("LGID"));
        }
        this.kdt.setRefresh(true);
        this.kdt.repaint();
        this.kdt.getGroupManager().group();
        this.kdt.getGroupManager().setGroup(false);
    }

    @Override
    public void mergedFlowRow() {
        for (int i = 0; i < this.kdt.getRowCount(); ++i) {
            String GetCellValue;
            if (i < 1 || (GetCellValue = (String)this.kdt.getRow(i).getCell("TypeID").getValue()) != null) continue;
            if (this.kdt.getRow(i - 1).getCell("TypeID").getValue() != null && !((String)this.kdt.getRow(i).getCell("BankAccount").getValue()).equals(this.getResString("SubTotalLocalBalanceAmount"))) {
                this.kdt.getMergeManager().mergeBlock(i, 1, i, 8);
                this.kdt.getRow(i).getCell(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
                continue;
            }
            String CellBlValue = (String)this.kdt.getRow(i - 2).getCell("TypeID").getValue();
            if ("1".equals(CellBlValue)) {
                this.kdt.getMergeManager().mergeBlock(i, 1, i, 8);
                this.kdt.getRow(i).getCell("BillName").setValue((Object)this.getResString("SubTotalLocalBalanceAmount1"));
                this.kdt.getRow(i).getCell(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            }
            if ("2".equals(CellBlValue)) {
                this.kdt.getMergeManager().mergeBlock(i, 1, i, 8);
                this.kdt.getRow(i).getCell("BillName").setValue((Object)this.getResString("SubTotalLocalBalanceAmount2"));
                this.kdt.getRow(i).getCell(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            }
            if ("3".equals(CellBlValue)) {
                this.kdt.getMergeManager().mergeBlock(i, 1, i, 8);
                this.kdt.getRow(i).getCell("BillName").setValue((Object)this.getResString("SubTotalLocalBalanceAmount3"));
                this.kdt.getRow(i).getCell(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            }
            if ("4".equals(CellBlValue)) {
                this.kdt.getMergeManager().mergeBlock(i, 1, i, 8);
                this.kdt.getRow(i).getCell("BillName").setValue((Object)this.getResString("SubTotalLocalBalanceAmount4"));
                this.kdt.getRow(i).getCell(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            }
            if (!"5".equals(CellBlValue)) continue;
            this.kdt.getMergeManager().mergeBlock(i, 1, i, 8);
            this.kdt.getRow(i).getCell("BillName").setValue((Object)this.getResString("SubTotalLocalBalanceAmount5"));
            this.kdt.getRow(i).getCell(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        }
        this.kdt.setRefresh(true);
        this.kdt.repaint();
        Object[][] dd = new Object[][]{new Object[this.kdt.getRowCount()], new Object[this.kdt.getRowCount()]};
        int n = dd[0].length;
        for (int i = 0; i < n; ++i) {
            dd[0][i] = this.kdt.getCell(i, 1).getValue();
            dd[1][i] = this.kdt.getCell(i, 2).getValue();
        }
        List mergeList = CellMatrix.parseAutoMatchMergeRegion((Object[][])dd, (boolean)true, (boolean)false, (boolean)false);
        int n2 = mergeList.size();
        for (int i = 0; i < n2; ++i) {
            int[] r = (int[])mergeList.get(i);
            this.kdt.getMergeManager().mergeBlock(r[0], r[1] + 1, r[2], r[3] + 1);
        }
    }

    @Override
    public void insertAbsractFlowRow() {
        String text = this.getResString("AllBalanceAmountTotal");
        IRow row = this.kdt.addRow();
        row.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        row.getCell("LocalBalanceAmount").setValue((Object)this.LocalBalanceAmountTotal);
        int r = this.kdt.getRowCount() - 1;
        this.kdt.getMergeManager().mergeBlock(r, 0, r, 8);
        row.getCell(0).setValue((Object)text);
        row.getCell(0).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
    }

    private String wordsToNumber(String value) {
        List list = EnumUtils.getEnumList(BillTypeEnum.class);
        for (StringEnum _enum : list) {
            if (!_enum.getAlias().equals(value)) continue;
            return _enum.getValue();
        }
        return null;
    }
}

