/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.mnt.client.AbstractRptFinDailyFilterUI;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Container;
import java.sql.Date;
import java.util.Set;

public class RptFinDailyFilterUI
extends AbstractRptFinDailyFilterUI {
    private Set currencyIdSet = null;
    private Set bankIdSet = null;
    private Integer queryStat = null;
    private AmountUnitEnum kDUnitP = null;
    private java.util.Date kDDateFromP = null;
    private java.util.Date kDDateToP = null;
    private boolean isInflow = false;
    private boolean isOutflow = false;
    private boolean isBalance = false;
    private boolean forCompany = false;
    private boolean forBank = false;
    private String kDCompanyP = "";
    private CompanyOrgUnitInfo currentCompany = null;
    private boolean isIncludeCash = false;
    private boolean forCompanyAcct = false;
    private boolean forCompanyBankAcct = false;

    public RptParams getCustomCondition() {
        RptConditionManager rcm = new RptConditionManager();
        rcm.recordAllStatus((Container)((Object)this));
        this.kDUnitP = (AmountUnitEnum)this.kDUnit.getSelectedItem();
        rcm.setProperty("kDUnit.value", (Object)this.kDUnitP);
        this.kDDateFromP = this.kDDateFrom.getSqlDate();
        rcm.setProperty("kDDateFrom.value", (Object)this.kDDateFromP);
        this.kDDateToP = this.kDDateTo.getSqlDate();
        rcm.setProperty("kDDateTo.value", (Object)this.kDDateToP);
        this.isInflow = this.kDCheckBoxInflow.isSelected();
        rcm.setProperty("kDCheckBoxInflow.value", (Object)new Boolean(this.isInflow));
        this.isOutflow = this.kDCheckBoxOutflow.isSelected();
        rcm.setProperty("kDCheckBoxOutflow.value", (Object)new Boolean(this.isOutflow));
        this.isBalance = this.kDCheckBoxBalance.isSelected();
        rcm.setProperty("kDCheckBoxBalance.value", (Object)new Boolean(this.isBalance));
        this.forCompany = this.kDRadioButtonCompany.isSelected();
        rcm.setProperty("kDRadioButtonCompany.value", (Object)new Boolean(this.forCompany));
        this.forBank = this.kDRadioButtonBank.isSelected();
        rcm.setProperty("kDRadioButtonBank.value", (Object)new Boolean(this.forBank));
        this.forCompanyAcct = this.kDRadioCompanyAcct.isSelected();
        rcm.setProperty("kDRadioCompanyAcct.value", (Object)new Boolean(this.forCompanyAcct));
        this.forCompanyBankAcct = this.kDRadioCompanyBankAcct.isSelected();
        rcm.setProperty("kDRadioCompanyBankAcct.value", (Object)new Boolean(this.forCompanyBankAcct));
        this.isIncludeCash = this.chkIncludeCash.isSelected();
        rcm.setProperty("chkIncludeCash.value", (Object)new Boolean(this.isIncludeCash));
        this.kDCompanyP = this.kDCompany.getText();
        rcm.setProperty("kDCompany.value", (Object)this.kDCompanyP);
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        rcm.setProperty("currentCompany", (Object)this.currentCompany);
        rcm.setProperty("companyIdSet", (Object)this.companyIdSet);
        this.bankIdSet = this.getIdSetFromF7(this.kDBank);
        rcm.setProperty("bankIdSet", (Object)this.bankIdSet);
        this.currencyIdSet = this.getIdSetFromF7(this.kDCurrency);
        rcm.setProperty("currencyIdSet", (Object)this.currencyIdSet);
        this.queryStat = new Integer(this.getQureyContentTotal());
        rcm.setProperty("queryStat", (Object)this.queryStat);
        return rcm.toRptParams();
    }

    public void setCustomCondition(RptParams params) {
        RptConditionManager rcm = new RptConditionManager(params);
        rcm.restoreAllStatus((Container)((Object)this));
        this.kDUnitP = (AmountUnitEnum)params.getObject("kDUnit.value");
        this.kDDateFromP = (java.util.Date)params.getObject("kDDateFrom.value");
        this.kDDateToP = (java.util.Date)params.getObject("kDDateTo.value");
        this.isInflow = (Boolean)params.getObject("kDCheckBoxInflow.value");
        this.isOutflow = (Boolean)params.getObject("kDCheckBoxOutflow.value");
        this.isBalance = (Boolean)params.getObject("kDCheckBoxBalance.value");
        this.forCompany = (Boolean)params.getObject("kDRadioButtonCompany.value");
        this.forBank = (Boolean)params.getObject("kDRadioButtonBank.value");
        this.forCompanyAcct = (Boolean)params.getObject("kDRadioCompanyAcct.value");
        this.forCompanyBankAcct = (Boolean)params.getObject("kDRadioCompanyBankAcct.value");
        this.isIncludeCash = (Boolean)params.getObject("chkIncludeCash.value");
        this.kDCompanyP = (String)params.getObject("kDCompany.value");
        this.currentCompany = (CompanyOrgUnitInfo)params.getObject("currentCompany");
        this.companyIdSet = (Set)params.getObject("companyIdSet");
        this.bankIdSet = (Set)params.getObject("bankIdSet");
        this.currencyIdSet = (Set)params.getObject("currencyIdSet");
        this.queryStat = (Integer)params.getObject("queryStat");
        super.setCustomCondition(params);
    }

    public void onInit(RptParams initParams) throws Exception {
        super.onInit(initParams);
        this.kDDateFrom.setValue((Object)DateUtil.getDayBegin());
        this.kDDateTo.setValue((Object)DateUtil.getDayBegin());
        this.kDCurrency.setDisplayFormat("$name$");
        this.kDCurrency.setEditFormat("$number$");
        this.kDCurrency.setEditable(true);
        this.kDCurrency.setCommitFormat("$number$");
        CurrencyInfo currency = FMClientHelper.getBaseCurrency((CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        if (currency != null) {
            this.kDCurrency.setData((Object)CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId().toString())));
        }
        this.kDBank.setDisplayFormat("$name$");
        this.kDBank.setEditFormat("$number$");
        this.kDBank.setEnabledMultiSelection(true);
        this.kDBank.setEditable(true);
        this.kDBank.setCommitFormat("$number$");
        this.kDBank.setValue(null);
        FinUtils.initBankTree((IUIObject)this, (KDBizPromptBox)this.kDBank, null);
        this.chkIncludeCash.setSelected(false);
        this.kDCurrency.setEditable(true);
        this.kDUnit.setSelectedItem((Object)AmountUnitEnum.wan_yuan);
        this.kDCheckBoxInflow.setSelected(false);
        this.kDCheckBoxOutflow.setSelected(false);
        this.kDCheckBoxBalance.setSelected(true);
        this.kDRadioButtonCompany.setSelected(true);
        this.kDCompany.setText(ContextHelperFactory.getRemoteInstance().getCurrentCompany().toString());
    }

    public boolean verify() {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.kDDateFrom);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.kDDateTo);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.kDCurrency);
        Date kdDateFrom = this.kDDateFrom.getSqlDate();
        Date kdDateTo = this.kDDateTo.getSqlDate();
        if (kdDateFrom.after(kdDateTo)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"458_RptBankAcctTransformAnalyseFilterUI"));
            SysUtil.abort();
        }
        this.dateVerify();
        return super.verify();
    }

    public void dateVerify() {
        int n = this.getQureyContentTotal();
        if (n == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"505_RptFinDailyFilterUI"));
            SysUtil.abort();
        }
        long from = DateTimeUtils.truncateDate((java.util.Date)this.kDDateFrom.getSqlDate()).getTime();
        long to = DateTimeUtils.truncateDate((java.util.Date)this.kDDateTo.getSqlDate()).getTime();
        int betweenDays = Integer.parseInt(new Long((to - from) / 86400000L).toString());
        boolean dateVerify = false;
        if (n == 1 && betweenDays > 93) {
            dateVerify = true;
        }
        if (n == 2 && betweenDays > 46) {
            dateVerify = true;
        }
        if (n == 3 && betweenDays > 31) {
            dateVerify = true;
        }
        if (dateVerify) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"506_RptFinDailyFilterUI"));
            SysUtil.abort();
        }
    }

    private int getQureyContentTotal() {
        int n = 0;
        if (this.kDCheckBoxBalance.isSelected()) {
            ++n;
        }
        if (this.kDCheckBoxInflow.isSelected()) {
            ++n;
        }
        if (this.kDCheckBoxOutflow.isSelected()) {
            ++n;
        }
        return n;
    }
}

