/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.ctrl.swing.resource.KDResourceManager;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.util.RptFmClientUtil;
import com.kingdee.eas.fm.mnt.client.AbstractRptFinancingListFilterUI;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class RptFinancingListFilterUI
extends AbstractRptFinancingListFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptFinancingListFilterUI.class);
    private Set bankIdSet = null;
    private Set currencyIdSet = null;

    public void onInit(RptParams initParams) throws Exception {
        super.onInit(initParams);
        this.kDTextField1.setEnabled(false);
        Image icon_off = KDResourceManager.getImageOfRapid((String)"prompt_off.gif");
        this.kDBank.setIcon((Icon)new ImageIcon(icon_off));
        Calendar instance = Calendar.getInstance();
        int thisYear = instance.get(1);
        SpinnerNumberModel yModel = new SpinnerNumberModel(thisYear - 1, 1900, 2999, 1);
        this.yearFrom.setModel((SpinnerModel)yModel);
        SpinnerNumberModel yModel1 = new SpinnerNumberModel(thisYear, 1900, 2999, 1);
        this.yearTo.setModel((SpinnerModel)yModel1);
        this.kDUnit.setSelectedItem((Object)AmountUnitEnum.wan_yuan);
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.kDCompany.setText(currentCompany.toString());
        this.kDRadioButtonCompany.setSelected(true);
        this.kDCurrency.setData(null);
    }

    public boolean verify() {
        int endBegain;
        int yearBegain = (Integer)this.yearFrom.getValue();
        if (yearBegain > (endBegain = ((Integer)this.yearTo.getValue()).intValue())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"479_RptCreditLimitListFilterUI"));
            SysUtil.abort();
        }
        if (endBegain - yearBegain > 10) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"480_RptCreditLimitListFilterUI"));
            SysUtil.abort();
        }
        return super.verify();
    }

    public RptParams getCustomCondition() {
        RptConditionManager rcm = new RptConditionManager();
        rcm.recordAllStatus((Container)((Object)this));
        rcm.setProperty("companyIdSet", (Object)this.companyIdSet);
        rcm.setProperty("bankIdSet", (Object)this.getIdSetFromByBankTreeNode(this.selectedNode));
        rcm.setProperty("childBankTree", (Object)this.selectedNode);
        this.currencyIdSet = this.getIdSetFromF7(this.kDCurrency);
        rcm.setProperty("currencyIdSet", (Object)this.currencyIdSet);
        return rcm.toRptParams();
    }

    public void setCustomCondition(RptParams params) {
        RptConditionManager rcm = new RptConditionManager(params);
        rcm.restoreAllStatus((Container)((Object)this));
        this.companyIdSet = (Set)params.getObject("companyIdSet");
        this.bankIdSet = (Set)params.getObject("bankIdSet");
        this.selectedNode = this.getBankTreeNodeFromByIdSet(this.bankIdSet);
        this.currencyIdSet = (Set)params.getObject("currencyIdSet");
        super.setCustomCondition(params);
        Set names = this.getNameSetFromByBankTreeNode(this.selectedNode);
        if (names != null) {
            this.kDTextField1.setText(names.toString());
        }
    }

    @Override
    protected void kDBank_actionPerformed(ActionEvent e) throws Exception {
        if (this.bankSelectDlg == null) {
            this.bankSelectDlg = RptFmClientUtil.selectBank((RptFmClientUtil.SelectBankListener)this, (Component)((Object)this));
        }
        this.bankSelectDlg.show();
        Set names = this.getNameSetFromByBankTreeNode(this.selectedNode);
        if (names != null) {
            this.kDTextField1.setText(names.toString());
        }
        super.kDBank_actionPerformed(e);
    }
}

